import { IComponentApi, BackendComponentApiBase } from "@mendix/component-framework";
import { IDialogApi, IEditorApi, IMessageBoxApi } from "@mendix/ide-foundation";
import { MessageBus } from "@mendix/wef-transportation";
import { TFunction } from "i18next";
import { InitialData } from "../types/DtoTypes";
type StartWithMaiaApiEventMap = {
    dataLoaded: {
        data: InitialData;
    };
    onClosing: {};
    overviewPagesGenerated: {
        data: null;
    };
    overviewPagesGenerationFailed: {
        data: null;
    };
};
export interface IStartWithMaiaApi extends IComponentApi<StartWithMaiaApiEventMap> {
    _apiId: "mendix.StartWithMaiaApi";
    requestInitialData(): Promise<void>;
    closeDialog(step: string): Promise<void>;
    generateOverviewPages(): Promise<void>;
    runApp(): Promise<void>;
    showCancelDialog(): Promise<string>;
    showRetryDialog(): Promise<string>;
    openDomainModel(domainModelId: string): Promise<void>;
    showError(message: string): Promise<void>;
    resetToBlankApp(): Promise<void>;
}
export declare class StartWithMaiaApi extends BackendComponentApiBase<StartWithMaiaApiEventMap> implements IStartWithMaiaApi {
    readonly messageBus: MessageBus;
    readonly dialogApi: IDialogApi;
    readonly editorApi: IEditorApi;
    readonly messageBoxApi: IMessageBoxApi;
    readonly t: TFunction;
    get _apiId(): "mendix.StartWithMaiaApi";
    constructor(messageBus: MessageBus, dialogApi: IDialogApi, editorApi: IEditorApi, messageBoxApi: IMessageBoxApi, t: TFunction);
    requestInitialData(): Promise<void>;
    closeDialog(step: string): Promise<void>;
    runApp(): Promise<void>;
    openDomainModel(domainModelId: string): Promise<void>;
    showError(message: string): Promise<void>;
    showCancelDialog(): Promise<string>;
    resetToBlankApp(): Promise<void>;
    showRetryDialog(): Promise<string>;
    generateOverviewPages(): Promise<void>;
    handleMessageFromBackend: (command: string, data: unknown) => boolean;
}
export {};
