import { IComponentApi, ComponentApiBase } from "@mendix/component-framework";
import { IDialogApi } from "@mendix/ide-foundation";
import { TFunction } from "i18next";
import type { SprintrStatus, SprintrStory, SprintrApiResult } from "./types";
export type SprintrStoriesApiEventMap = {
    dataUpdated: {
        data: {
            stories: SprintrStory[];
            statuses: SprintrStatus[];
        };
    };
};
export interface ISprintrStoriesApi extends IComponentApi<SprintrStoriesApiEventMap> {
    _apiId: "mendix.SprintrStoriesApi";
    getStatuses(): Promise<SprintrApiResult<SprintrStatus[]>>;
    getStories(): Promise<SprintrApiResult<SprintrStory[]>>;
    selectStory(): Promise<SprintrStory | null>;
}
export declare class SprintrStoriesApi extends ComponentApiBase<SprintrStoriesApiEventMap> implements ISprintrStoriesApi {
    readonly dialogApi: IDialogApi;
    readonly t: TFunction;
    get _apiId(): "mendix.SprintrStoriesApi";
    constructor(dialogApi: IDialogApi, t: TFunction);
    getStatuses(): Promise<SprintrApiResult<SprintrStatus[]>>;
    getStories(): Promise<SprintrApiResult<SprintrStory[]>>;
    selectStory(): Promise<SprintrStory | null>;
}
