import { IComponentApi, BackendComponentApiBase } from "@mendix/component-framework";
import { Key } from "react";
import { RuntimeConsoleLogLine } from "../types/RuntimeConsoleDtoTypes";
type RuntimeConsoleApiEventMap = {
    loadRuntimeConsoleStore: {
        data: RuntimeConsoleLogLine[];
    };
    newRuntimeConsoleLogs: {
        data: RuntimeConsoleLogLine[];
    };
};
export interface IRuntimeConsoleApi extends IComponentApi<RuntimeConsoleApiEventMap> {
    _apiId: "mendix.RuntimeConsoleApi";
    refreshConsole(): Promise<void>;
    clearLogLines(): Promise<void>;
    exportLogLines(): Promise<void>;
    setLogLevels(): Promise<void>;
    startBuiltInDatabaseViewer(): Promise<void>;
    showRuntimeThreads(): Promise<void>;
    showContextMenu(id: Key): Promise<void>;
    showLogLineDetails(id: Key): Promise<void>;
}
export declare class RuntimeConsoleApi extends BackendComponentApiBase<RuntimeConsoleApiEventMap> implements IRuntimeConsoleApi {
    get _apiId(): "mendix.RuntimeConsoleApi";
    refreshConsole(): Promise<void>;
    clearLogLines(): Promise<void>;
    exportLogLines(): Promise<void>;
    setLogLevels(): Promise<void>;
    startBuiltInDatabaseViewer(): Promise<void>;
    showRuntimeThreads(): Promise<void>;
    protected handleMessageFromBackend: (command: string, data: unknown) => boolean;
    showContextMenu(id: string): Promise<void>;
    showLogLineDetails(id: Key): Promise<void>;
}
export {};
