import { IComponentApi, BackendComponentApiBase } from "@mendix/component-framework";
import { RuntimeFlags } from "../types/RuntimeConsoleDtoTypes";
type RuntimeApiEventMap = {
    runtimeFlagsUpdated: {
        data: RuntimeFlags;
    };
};
export interface IRuntimeApi extends IComponentApi<RuntimeApiEventMap> {
    _apiId: "mendix.RuntimeApi";
    refreshRuntimeFlags(): Promise<void>;
    startApp(): Promise<void>;
    stopApp(): Promise<void>;
    restartApp(): Promise<void>;
}
export declare class RuntimeApi extends BackendComponentApiBase<RuntimeApiEventMap> implements IRuntimeApi {
    get _apiId(): "mendix.RuntimeApi";
    _lockRuntimeFlags: boolean;
    refreshRuntimeFlags(): Promise<void>;
    stopApp(): Promise<void>;
    startApp(): Promise<void>;
    restartApp(): Promise<void>;
    protected handleMessageFromBackend: (command: string, data: unknown) => boolean;
    showContextMenu(id: string): Promise<void>;
}
export {};
