import { Primitives } from '@mendix/model-access';
import { Projects } from './Projects.gen';
export declare namespace Texts {
    interface TextCreationOptions {
        text: string;
        languageCode?: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/translatable-texts relevant section in reference guide}
     */
    interface Text extends Primitives.ElementBase {
        $Type: "Texts$Text";
        $CreationOptions?: TextCreationOptions;
        translations: Translation[];
        addTranslation(options: TranslationCreationOptions): Promise<Translation>;
    }
    interface TranslationCreationOptions {
        text: string;
        languageCode?: string;
    }
    interface Translation extends Primitives.ElementBase {
        $Type: "Texts$Translation";
        $CreationOptions?: TranslationCreationOptions;
        languageCode: string;
        text: string;
        getContainer(): Text;
        delete(): void;
    }
    interface SystemText extends Primitives.ElementBase {
        $Type: "Texts$SystemText";
        text: Text;
        key: string;
        getContainer(): SystemTextCollection;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/system-texts relevant section in reference guide}
     */
    interface SystemTextCollection extends Projects.ProjectDocument {
        $Type: "Texts$SystemTextCollection";
        systemTexts: SystemText[];
        addSystemText(): Promise<SystemText>;
    }
}
//# sourceMappingURL=Texts.gen.d.ts.map