import { Primitives } from '@mendix/model-access';
export declare namespace Projects {
    type FolderBase = Folder | Module;
    type ModuleDocument = ModuleSettings | Document;
    /**
     * See: {@link https://docs.mendix.com/refguide/project relevant section in reference guide}
     */
    interface Project extends Primitives.UnitBase {
        $Type: "Projects$Project";
        isSystemProject: boolean;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/project relevant section in reference guide}
     */
    interface ProjectDocument extends Primitives.UnitBase {
    }
    interface FolderBaseBase extends Primitives.UnitBase {
    }
    interface FolderCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/resources relevant section in reference guide}
     */
    interface Folder extends FolderBaseBase {
        $Type: "Projects$Folder";
        $CreationOptions?: FolderCreationOptions;
        name: string;
    }
    interface ModuleCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/modules relevant section in reference guide}
     */
    interface Module extends FolderBaseBase {
        $Type: "Projects$Module";
        $CreationOptions?: ModuleCreationOptions;
        sortIndex: number;
        name: string;
        fromAppStore: boolean;
        appStoreGuid: string;
        appStoreVersionGuid: string;
        appStoreVersion: string;
        appStorePackageIdString: string;
        isThemeModule: boolean;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/module-settings relevant section in reference guide}
     */
    interface ModuleSettings extends ModuleDocumentBase {
        $Type: "Projects$ModuleSettings";
        $Component: "mendix.ModuleSettingsApi";
        exportLevel: ModuleExportLevel;
        protectedModuleType: ProtectedModuleType;
        version: string;
        solutionIdentifier: string;
        extensionName: string;
        jarDependencies: JarDependency[];
        basedOnVersion: string;
        addJarDependency(): Promise<JarDependency>;
    }
    interface ModuleDocumentBase extends Primitives.UnitBase {
    }
    interface Document extends ModuleDocumentBase {
        name: string;
        documentation: string;
        excluded: boolean;
        exportLevel: ExportLevel;
    }
    interface OneTimeConversionMarkerCreationOptions {
        name: string;
    }
    interface OneTimeConversionMarker extends Primitives.ElementBase {
        $Type: "Projects$OneTimeConversionMarker";
        $CreationOptions?: OneTimeConversionMarkerCreationOptions;
        name: string;
        getContainer(): ProjectConversion;
        delete(): void;
    }
    interface ProjectConversion extends Primitives.UnitBase {
        $Type: "Projects$ProjectConversion";
        $Component: "mendix.ProjectConversionApi";
        markers: OneTimeConversionMarker[];
        addOneTimeConversionMarker(options: OneTimeConversionMarkerCreationOptions): Promise<OneTimeConversionMarker>;
        getOneTimeConversionMarker(name: string): OneTimeConversionMarker;
    }
    interface JarDependency extends Primitives.ElementBase {
        $Type: "Projects$JarDependency";
        groupId: string;
        artifactId: string;
        version: string;
        isIncluded: boolean;
        exclusions: JarDependencyExclusion[];
        getContainer(): ModuleSettings;
        delete(): void;
        addJarDependencyExclusion(): Promise<JarDependencyExclusion>;
    }
    interface JarDependencyExclusion extends Primitives.ElementBase {
        $Type: "Projects$JarDependencyExclusion";
        groupId: string;
        artifactId: string;
        getContainer(): JarDependency;
        delete(): void;
    }
    type ModuleExportLevel = "Source" | "Protected";
    type ExportLevel = "Hidden" | "API";
    type ProtectedModuleType = "AddOn" | "Solution";
}
//# sourceMappingURL=Projects.gen.d.ts.map