import { Primitives } from '@mendix/model-access';
import { DataTypes } from './DataTypes.gen';
import { DomainModels } from './DomainModels.gen';
import { Enumerations } from './Enumerations.gen';
import { Projects } from './Projects.gen';
import { Texts } from './Texts.gen';
import { Url } from './Url.gen';
export declare namespace Pages {
    /**
     * See: {@link https://docs.mendix.com/refguide/pages relevant section in reference guide}
     */
    type FormBase = Page | Layout | TemplateFormBase | Snippet;
    type LayoutContent = WebLayoutContent | NativeLayoutContent;
    /**
     * See: {@link https://docs.mendix.com/refguide/pages relevant section in reference guide}
     */
    type Widget = Placeholder | TemplatePlaceholder | LoginTextBox | ValidationMessage | ConditionallyVisibleWidget | Header | MenuWidget | ScrollContainer | SnippetCallWidget;
    type TemplateFormBase = BuildingBlock | PageTemplate;
    type TemplateType = RegularPageTemplateType | EditPageTemplateType | SelectPageTemplateType | WorkflowTemplateType;
    type ClientAction = NoClientAction | PageClientAction | MicroflowClientAction | CallNanoflowClientAction | SignOutClientAction | SaveChangesClientAction | CancelChangesClientAction | ClosePageClientAction | SyncClientAction | OpenLinkClientAction | DeleteClientAction | CreateObjectClientAction | CallWorkflowClientAction | OpenUserTaskClientAction | OpenWorkflowClientAction | SetTaskOutcomeClientAction;
    type AbstractDesignPropertyValue = OptionDesignPropertyValue | ToggleDesignPropertyValue | CustomDesignPropertyValue | CompoundDesignPropertyValue;
    type ConditionallyVisibleWidget = Label | StaticImageViewer | DivContainer | ConditionallyEditableWidget | Table | EntityWidget | Button | DynamicText | GroupBox | LayoutGrid | NavigationList | TabContainer | Title;
    type TextWidget = TextBox | TextArea;
    type AttributeWidget = CheckBox | RadioButtonGroup | AttributeWidgetWithPlaceholder | DropDown;
    type AttributeWidgetWithPlaceholder = DatePicker | TextWidget;
    type LoginTextBox = LoginIdTextBox | PasswordTextBox;
    /**
     * See: {@link https://docs.mendix.com/refguide/button-widgets relevant section in reference guide}
     */
    type Button = LoginButton | ActionButton | DropDownButton | SidebarToggleButton;
    type MemberWidget = AttributeWidget | AssociationWidget;
    type InputWidget = MemberWidget | FileManager | ImageUploader;
    type ConditionallyEditableWidget = InputWidget;
    type ConditionalSettings = ConditionalVisibilitySettings | ConditionalEditabilitySettings;
    /**
     * See: {@link https://docs.mendix.com/refguide/data-sources relevant section in reference guide}
     */
    type DataSource = EntityPathSource | MicroflowSource | NanoflowSource | ListenTargetSource;
    type EntityWidget = ListenTargetWidget | DataView | DynamicImageViewer;
    type EntityPathSource = AssociationSource | DataViewSource | SortableEntityPathSource | ImageViewerSource;
    type ControlBarItem = ControlBarButton | SearchField;
    type ListenTargetWidget = ListView | Grid;
    type SortableEntityPathSource = XPathSourceBase | GridBaseSource;
    type XPathSourceBase = ListViewXPathSource;
    type Grid = ColumnGrid | TemplateGrid;
    type SingleSearchField = ComparisonSearchField | DropDownSearchField;
    type GridBaseSource = GridXPathSource | ReferenceSetSource;
    type ColumnGrid = DataGrid | ReferenceSetSelector;
    type GridControlBarButton = DataGridAddButton | DataGridExportToCSVButton | DataGridExportToExcelButton | DataGridRemoveButton | GridActionButton | GridDeselectAllButton | GridNewButton | GridSearchButton | GridSelectAllButton | SelectButton;
    type ActionItem = DropDownButtonItem | NavigationListItem;
    /**
     * See: {@link https://docs.mendix.com/refguide/image relevant section in reference guide}
     */
    type Icon = GlyphIcon | ImageIcon | IconCollectionIcon;
    type ControlBar = GridControlBar | SearchBar;
    type ControlBarButton = GridControlBarButton;
    type AssociationWidget = InputReferenceSetSelector | ReferenceSelector;
    /**
     * See: {@link https://docs.mendix.com/refguide/menu-widgets relevant section in reference guide}
     */
    type MenuWidget = MenuBar | NavigationTree | SimpleMenuBar;
    type MenuSource = MenuDocumentSource | NavigationSource;
    type SearchField = RangeSearchField | SingleSearchField;
    type SelectorSource = SelectorXPathSource | SelectorMicroflowSource;
    type WorkflowTemplateType = UserTaskTemplateType | WorkflowOverviewTemplateType;
    /**
     * See: {@link https://docs.mendix.com/refguide/pages relevant section in reference guide}
     */
    interface FormBaseBase extends Projects.Document {
        canvasWidth: number;
        canvasHeight: number;
        name: string;
        documentation: string;
    }
    /**
     * Options for creating a Page.
     */
    interface PageCreationOptions {
        /**
         * The name of the page.
         */
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/page relevant section in reference guide}
     */
    interface Page extends FormBaseBase {
        $Type: "Pages$Page";
        $CreationOptions?: PageCreationOptions;
        parameter: string;
        parameters: PageParameter[];
        layoutCall: LayoutCall;
        title: Texts.Text;
        appearance: Appearance;
        allowedRoles: string[];
        popupCloseAction: string;
        popupWidth: number;
        popupHeight: number;
        popupResizable: boolean;
        markAsUsed: boolean;
        url: string;
        variables: LocalVariable[];
        addPageParameter(options: PageParameterCreationOptions): Promise<PageParameter>;
        getPageParameter(name: string): PageParameter;
        addLocalVariable(options: LocalVariableCreationOptions): Promise<LocalVariable>;
        getLocalVariable(name: string): LocalVariable;
    }
    interface ParameterAttributeUrlSegment extends Url.UrlSegmentBase {
        $Type: "Pages$ParameterAttributeUrlSegment";
        pageParameter: string;
        attribute: string;
    }
    interface ParameterIdUrlSegment extends Url.UrlSegmentBase {
        $Type: "Pages$ParameterIdUrlSegment";
        pageParameter: string;
    }
    interface PageParameterCreationOptions {
        name: string;
    }
    interface PageParameter extends Primitives.ElementBase {
        $Type: "Pages$PageParameter";
        $CreationOptions?: PageParameterCreationOptions;
        name: string;
        parameterType: DataTypes.DataType;
        getContainer(): Page;
        delete(): void;
    }
    interface LayoutCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/layout relevant section in reference guide}
     */
    interface Layout extends FormBaseBase {
        $Type: "Pages$Layout";
        $CreationOptions?: LayoutCreationOptions;
        parameters: LayoutParameter[];
        content: LayoutContent;
        appearance: Appearance;
        addLayoutParameter(options: LayoutParameterCreationOptions): Promise<LayoutParameter>;
        getLayoutParameter(name: string): LayoutParameter;
    }
    interface LayoutContentBase extends Primitives.ElementBase {
        getContainer(): Layout;
        delete(): void;
    }
    interface WebLayoutContent extends LayoutContentBase {
        $Type: "Pages$WebLayoutContent";
        layoutType: LayoutType;
        layoutCall: LayoutCall | null;
        widgets: Widget[];
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface NativeLayoutContent extends LayoutContentBase {
        $Type: "Pages$NativeLayoutContent";
        layoutType: NativeLayoutType;
        widgets: Widget[];
        rightHeaderPlaceholder: Placeholder | null;
        showBottomBar: boolean;
        sidebar: boolean;
        sidebarWidgets: Widget[];
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface LayoutCallCreationOptions {
        layout?: string;
    }
    interface LayoutCall extends Primitives.ElementBase {
        $Type: "Pages$LayoutCall";
        $CreationOptions?: LayoutCallCreationOptions;
        layout: string;
        arguments: LayoutCallArgument[];
        addLayoutCallArgument(options: LayoutCallArgumentCreationOptions): Promise<LayoutCallArgument>;
    }
    interface LayoutCallArgumentCreationOptions {
        parameter?: string;
    }
    interface LayoutCallArgument extends Primitives.ElementBase {
        $Type: "Pages$LayoutCallArgument";
        $CreationOptions?: LayoutCallArgumentCreationOptions;
        parameter: string;
        widgets: Widget[];
        getContainer(): LayoutCall;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface LayoutParameterCreationOptions {
        name: string;
    }
    interface LayoutParameter extends Primitives.ElementBase {
        $Type: "Pages$LayoutParameter";
        $CreationOptions?: LayoutParameterCreationOptions;
        name: string;
        getContainer(): Layout;
        delete(): void;
    }
    interface PlaceholderCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/placeholder relevant section in reference guide}
     */
    interface Placeholder extends WidgetBase {
        $Type: "Pages$Placeholder";
        $CreationOptions?: PlaceholderCreationOptions;
        getContainer(): NativeLayoutContent;
        delete(): void;
    }
    interface TemplateFormBaseBase extends FormBaseBase {
        displayName: string;
        documentationUrl: string;
        templateCategory: string;
        templateCategoryWeight: number;
        imageData: any;
    }
    /**
     * Options for creating a building block.
     */
    interface BuildingBlockCreationOptions {
        /**
         * The name of the building block.
         */
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/building-block relevant section in reference guide}
     */
    interface BuildingBlock extends TemplateFormBaseBase {
        $Type: "Pages$BuildingBlock";
        $CreationOptions?: BuildingBlockCreationOptions;
        widgets: Widget[];
        platform: SnippetType;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface TemplateTypeBase extends Primitives.ElementBase {
        getContainer(): PageTemplate;
        delete(): void;
    }
    interface RegularPageTemplateType extends TemplateTypeBase {
        $Type: "Pages$RegularPageTemplateType";
    }
    interface EditPageTemplateType extends TemplateTypeBase {
        $Type: "Pages$EditPageTemplateType";
    }
    interface SelectPageTemplateType extends TemplateTypeBase {
        $Type: "Pages$SelectPageTemplateType";
    }
    interface PageTemplateCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/page-templates relevant section in reference guide}
     */
    interface PageTemplate extends TemplateFormBaseBase {
        $Type: "Pages$PageTemplate";
        $CreationOptions?: PageTemplateCreationOptions;
        layoutCall: LayoutCall;
        appearance: Appearance;
        templateType: TemplateType;
    }
    interface TemplatePlaceholderCreationOptions {
        name: string;
    }
    interface TemplatePlaceholder extends WidgetBase {
        $Type: "Pages$TemplatePlaceholder";
        $CreationOptions?: TemplatePlaceholderCreationOptions;
        type: string;
    }
    interface ClientActionBase extends Primitives.ElementBase {
        disabledDuringExecution: boolean;
    }
    interface NoClientAction extends ClientActionBase {
        $Type: "Pages$NoClientAction";
    }
    interface PageClientAction extends ClientActionBase {
        $Type: "Pages$PageClientAction";
        pageSettings: PageSettings;
        pagesForSpecializations: PageForSpecialization[];
        numberOfPagesToClose2: string | null;
        addPageForSpecialization(): Promise<PageForSpecialization>;
    }
    interface MicroflowClientAction extends ClientActionBase {
        $Type: "Pages$MicroflowClientAction";
        microflowSettings: MicroflowSettings;
    }
    interface CallNanoflowClientAction extends ClientActionBase {
        $Type: "Pages$CallNanoflowClientAction";
        nanoflow: string | null;
        parameterMappings: NanoflowParameterMapping[];
        progressBar: ProgressBarType;
        progressMessage: Texts.Text | null;
        confirmationInfo: ConfirmationInfo | null;
        addNanoflowParameterMapping(): Promise<NanoflowParameterMapping>;
    }
    interface SignOutClientAction extends ClientActionBase {
        $Type: "Pages$SignOutClientAction";
    }
    interface SaveChangesClientAction extends ClientActionBase {
        $Type: "Pages$SaveChangesClientAction";
        syncAutomatically: boolean;
        closePage: boolean;
    }
    interface CancelChangesClientAction extends ClientActionBase {
        $Type: "Pages$CancelChangesClientAction";
        closePage: boolean;
    }
    interface ClosePageClientAction extends ClientActionBase {
        $Type: "Pages$ClosePageClientAction";
        numberOfPagesToClose: string | null;
    }
    interface SyncClientAction extends ClientActionBase {
        $Type: "Pages$SyncClientAction";
    }
    interface OpenLinkClientAction extends ClientActionBase {
        $Type: "Pages$OpenLinkClientAction";
        linkType: LinkType;
        address: StaticOrDynamicString;
    }
    interface DeleteClientAction extends ClientActionBase {
        $Type: "Pages$DeleteClientAction";
        closePage: boolean;
        sourceVariable: PageVariable | null;
    }
    interface CreateObjectClientAction extends ClientActionBase {
        $Type: "Pages$CreateObjectClientAction";
        entityRef: DomainModels.EntityRef | null;
        pageSettings: PageSettings;
        numberOfPagesToClose2: string | null;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/on-click-event relevant section in reference guide}
     */
    interface PageSettings extends Primitives.ElementBase {
        $Type: "Pages$PageSettings";
        page: string | null;
        parameterMappings: PageParameterMapping[];
        addPageParameterMapping(): Promise<PageParameterMapping>;
    }
    interface PageParameterMapping extends Primitives.ElementBase {
        $Type: "Pages$PageParameterMapping";
        parameter: string;
        variable: PageVariable;
        argument: string | null;
        getContainer(): PageSettings;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/on-click-event relevant section in reference guide}
     */
    interface MicroflowSettings extends Primitives.ElementBase {
        $Type: "Pages$MicroflowSettings";
        microflow: string | null;
        parameterMappings: MicroflowParameterMapping[];
        progressBar: ProgressBarType;
        progressMessage: Texts.Text | null;
        asynchronous: boolean;
        formValidations: FormValidations;
        confirmationInfo: ConfirmationInfo | null;
        addMicroflowParameterMapping(): Promise<MicroflowParameterMapping>;
    }
    interface MicroflowParameterMapping extends Primitives.ElementBase {
        $Type: "Pages$MicroflowParameterMapping";
        parameter: string;
        expression: string | null;
        variable: PageVariable | null;
        getContainer(): MicroflowSettings;
        delete(): void;
    }
    interface NanoflowParameterMapping extends Primitives.ElementBase {
        $Type: "Pages$NanoflowParameterMapping";
        parameter: string;
        expression: string | null;
        variable: PageVariable | null;
    }
    interface ConfirmationInfo extends Primitives.ElementBase {
        $Type: "Pages$ConfirmationInfo";
        question: Texts.Text;
        proceedButtonCaption: Texts.Text;
        cancelButtonCaption: Texts.Text;
    }
    interface PageVariable extends Primitives.ElementBase {
        $Type: "Pages$PageVariable";
        widget: string | null;
        pageParameter: string | null;
        snippetParameter: string | null;
        localVariable: string | null;
        useAllPages: boolean;
        subKey: string;
    }
    interface LocalVariableCreationOptions {
        name: string;
    }
    interface LocalVariable extends Primitives.ElementBase {
        $Type: "Pages$LocalVariable";
        $CreationOptions?: LocalVariableCreationOptions;
        name: string;
        variableType: DataTypes.DataType;
        defaultValue: string | null;
    }
    interface Appearance extends Primitives.ElementBase {
        $Type: "Pages$Appearance";
        class: string;
        style: string;
        designProperties: DesignPropertyValue[];
        dynamicClasses: string | null;
        addDesignPropertyValue(): Promise<DesignPropertyValue>;
    }
    interface DesignPropertyValue extends Primitives.ElementBase {
        $Type: "Pages$DesignPropertyValue";
        key: string;
        value: AbstractDesignPropertyValue | null;
    }
    interface AbstractDesignPropertyValueBase extends Primitives.ElementBase {
        getContainer(): DesignPropertyValue;
        delete(): void;
    }
    interface OptionDesignPropertyValue extends AbstractDesignPropertyValueBase {
        $Type: "Pages$OptionDesignPropertyValue";
        option: string;
    }
    interface ToggleDesignPropertyValue extends AbstractDesignPropertyValueBase {
        $Type: "Pages$ToggleDesignPropertyValue";
    }
    interface CustomDesignPropertyValue extends AbstractDesignPropertyValueBase {
        $Type: "Pages$CustomDesignPropertyValue";
        value: string;
    }
    interface CompoundDesignPropertyValue extends AbstractDesignPropertyValueBase {
        $Type: "Pages$CompoundDesignPropertyValue";
        properties: DesignPropertyValue[];
        addDesignPropertyValue(): Promise<DesignPropertyValue>;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/pages relevant section in reference guide}
     */
    interface WidgetBase extends Primitives.ElementBase {
        name: string;
        appearance: Appearance;
        tabIndex: number;
    }
    interface LabelCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/label relevant section in reference guide}
     */
    interface Label extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$Label";
        $CreationOptions?: LabelCreationOptions;
        caption: Texts.Text;
    }
    interface StaticImageViewerCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/image relevant section in reference guide}
     */
    interface StaticImageViewer extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$StaticImageViewer";
        $CreationOptions?: StaticImageViewerCreationOptions;
        image: string | null;
        widthUnit: ImageSizeUnit;
        heightUnit: ImageSizeUnit;
        width: number;
        height: number;
        clickAction: ClientAction;
        responsive: boolean;
        alternativeText: ClientTemplate;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface DivContainerCreationOptions {
        name: string;
        renderMode?: ContainerRenderMode;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/container relevant section in reference guide}
     */
    interface DivContainer extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$DivContainer";
        $CreationOptions?: DivContainerCreationOptions;
        widgets: Widget[];
        renderMode: ContainerRenderMode;
        onClickAction: ClientAction;
        screenReaderHidden: boolean;
        nativeAccessibilitySettings: AccessibilitySettings | null;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface TextBoxCreationOptions extends InputWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/text-box relevant section in reference guide}
     */
    interface TextBox extends TextWidgetBase {
        $Type: "Pages$TextBox";
        $CreationOptions?: TextBoxCreationOptions;
        inputMask: string;
        formattingInfo: FormattingInfo;
        isPasswordBox: boolean;
        keyboardType: KeyboardType;
        onEnterKeyPressAction: ClientAction;
        autocomplete: boolean;
        autocompletePurpose: AutocompletePurposeType;
        submitBehaviour: SubmitBehaviourType;
        submitOnInputDelay: number;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface TextAreaCreationOptions extends InputWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/text-area relevant section in reference guide}
     */
    interface TextArea extends TextWidgetBase {
        $Type: "Pages$TextArea";
        $CreationOptions?: TextAreaCreationOptions;
        numberOfLines: number;
        counterMessage: Texts.Text;
        textTooLongMessage: Texts.Text;
        autocomplete: boolean;
        submitBehaviour: SubmitBehaviourType;
        submitOnInputDelay: number;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface CheckBoxCreationOptions extends InputWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/check-box relevant section in reference guide}
     */
    interface CheckBox extends AttributeWidgetBase {
        $Type: "Pages$CheckBox";
        $CreationOptions?: CheckBoxCreationOptions;
        labelPosition: LabelPosition;
        nativeRenderMode: NativeRenderMode;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface RadioButtonGroupCreationOptions extends InputWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/radio-buttons relevant section in reference guide}
     */
    interface RadioButtonGroup extends AttributeWidgetBase {
        $Type: "Pages$RadioButtonGroup";
        $CreationOptions?: RadioButtonGroupCreationOptions;
        renderHorizontal: boolean;
    }
    interface DatePickerCreationOptions extends InputWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/date-picker relevant section in reference guide}
     */
    interface DatePicker extends AttributeWidgetWithPlaceholderBase {
        $Type: "Pages$DatePicker";
        $CreationOptions?: DatePickerCreationOptions;
        formattingInfo: FormattingInfo;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface LoginTextBoxBase extends WidgetBase {
        label: Texts.Text | null;
        labelWidth: number;
        placeholder: Texts.Text;
    }
    interface LoginIdTextBoxCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/login-id-text-box relevant section in reference guide}
     */
    interface LoginIdTextBox extends LoginTextBoxBase {
        $Type: "Pages$LoginIdTextBox";
        $CreationOptions?: LoginIdTextBoxCreationOptions;
    }
    interface PasswordTextBoxCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/password-text-box relevant section in reference guide}
     */
    interface PasswordTextBox extends LoginTextBoxBase {
        $Type: "Pages$PasswordTextBox";
        $CreationOptions?: PasswordTextBoxCreationOptions;
    }
    interface LoginButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/sign-in-button relevant section in reference guide}
     */
    interface LoginButton extends ButtonBase {
        $Type: "Pages$LoginButton";
        $CreationOptions?: LoginButtonCreationOptions;
        validationMessageWidget: string;
    }
    interface ValidationMessageCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/validation-message relevant section in reference guide}
     */
    interface ValidationMessage extends WidgetBase {
        $Type: "Pages$ValidationMessage";
        $CreationOptions?: ValidationMessageCreationOptions;
    }
    interface FormattingInfo extends Primitives.ElementBase {
        $Type: "Pages$FormattingInfo";
        decimalPrecision: number;
        groupDigits: boolean;
        enumFormat: EnumFormat;
        dateFormat: DateFormat;
        customDateFormat: string;
    }
    interface TextWidgetBase extends AttributeWidgetWithPlaceholderBase {
        maxLengthCode: number;
        autoFocus: boolean;
    }
    interface AttributeWidgetWithPlaceholderBase extends AttributeWidgetBase {
        placeholderTemplate: ClientTemplate;
    }
    interface AttributeWidgetBase extends MemberWidgetBase {
        validation: WidgetValidation;
        onChangeAction: ClientAction;
        onEnterAction: ClientAction;
        onLeaveAction: ClientAction;
        sourceVariable: PageVariable | null;
        ariaRequired: boolean;
    }
    interface WidgetValidation extends Primitives.ElementBase {
        $Type: "Pages$WidgetValidation";
        expression: string | null;
        message: Texts.Text;
    }
    interface MemberWidgetBase extends InputWidgetBase {
        attributeRef: DomainModels.AttributeRef | null;
        readOnlyStyle: ReadOnlyStyle;
    }
    interface InputWidgetCreationOptions {
        labelCaption?: string;
        showLabel?: boolean;
    }
    interface InputWidgetBase extends ConditionallyEditableWidgetBase {
        labelTemplate: ClientTemplate | null;
        screenReaderLabel: ClientTemplate | null;
    }
    interface ConditionallyEditableWidgetBase extends ConditionallyVisibleWidgetBase {
        conditionalEditabilitySettings: ConditionalEditabilitySettings | null;
        editable: EditableEnum;
    }
    interface ConditionallyVisibleWidgetBase extends WidgetBase {
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
    }
    interface ConditionalSettingsBase extends Primitives.ElementBase {
        attribute: string | null;
        conditions: Enumerations.Condition[];
        expression: string | null;
        sourceVariable: PageVariable | null;
    }
    interface ConditionalVisibilitySettings extends ConditionalSettingsBase {
        $Type: "Pages$ConditionalVisibilitySettings";
        moduleRoles: string[];
        ignoreSecurity: boolean;
    }
    interface ConditionalEditabilitySettings extends ConditionalSettingsBase {
        $Type: "Pages$ConditionalEditabilitySettings";
    }
    interface AccessibilitySettings extends Primitives.ElementBase {
        $Type: "Pages$AccessibilitySettings";
        screenReaderDescription: ClientTemplate;
        screenReaderTitle: ClientTemplate;
    }
    interface TableCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/table relevant section in reference guide}
     */
    interface Table extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$Table";
        $CreationOptions?: TableCreationOptions;
        cells: TableCell[];
        columns: TableColumn[];
        widthUnit: UnitEnum;
        rows: TableRow[];
        addTableCell(): Promise<TableCell>;
        addTableColumn(): Promise<TableColumn>;
        addTableRow(): Promise<TableRow>;
    }
    interface TableCell extends Primitives.ElementBase {
        $Type: "Pages$TableCell";
        appearance: Appearance;
        isHeader: boolean;
        widgets: Widget[];
        leftColumnIndex: number;
        topRowIndex: number;
        width: number;
        height: number;
        getContainer(): Table;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface TableColumn extends Primitives.ElementBase {
        $Type: "Pages$TableColumn";
        width: number;
        getContainer(): Table;
        delete(): void;
    }
    interface TableRow extends Primitives.ElementBase {
        $Type: "Pages$TableRow";
        appearance: Appearance;
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
        getContainer(): Table;
        delete(): void;
    }
    interface EntityWidgetBase extends ConditionallyVisibleWidgetBase {
        dataSource: DataSource;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/data-sources relevant section in reference guide}
     */
    interface DataSourceBase extends Primitives.ElementBase {
        forceFullObjects: boolean;
    }
    interface EntityPathSourceBase extends DataSourceBase {
        entityRef: DomainModels.EntityRef | null;
        sourceVariable: PageVariable | null;
    }
    interface MicroflowSource extends DataSourceBase {
        $Type: "Pages$MicroflowSource";
        microflowSettings: MicroflowSettings;
    }
    interface NanoflowSource extends DataSourceBase {
        $Type: "Pages$NanoflowSource";
        nanoflow: string | null;
        parameterMappings: NanoflowParameterMapping[];
        addNanoflowParameterMapping(): Promise<NanoflowParameterMapping>;
    }
    interface ListenTargetWidgetBase extends EntityWidgetBase {
    }
    interface AssociationSource extends EntityPathSourceBase {
        $Type: "Pages$AssociationSource";
    }
    interface DataViewCreationOptions {
        name: string;
        showFooter?: boolean;
        labelWidth?: number;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/data-view relevant section in reference guide}
     */
    interface DataView extends EntityWidgetBase {
        $Type: "Pages$DataView";
        $CreationOptions?: DataViewCreationOptions;
        widgets: Widget[];
        footerWidgets: Widget[];
        editability: EditableEnum;
        conditionalEditabilitySettings: ConditionalEditabilitySettings | null;
        showFooter: boolean;
        noEntityMessage: Texts.Text;
        labelWidth: number;
        readOnlyStyle: DataViewReadOnlyStyle;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface DataViewSource extends EntityPathSourceBase {
        $Type: "Pages$DataViewSource";
    }
    interface ListenTargetSource extends DataSourceBase {
        $Type: "Pages$ListenTargetSource";
        listenTarget: string;
    }
    interface ControlBarBase extends Primitives.ElementBase {
        items: ControlBarItem[];
        addComparisonSearchField(options: ComparisonSearchFieldCreationOptions): Promise<ComparisonSearchField>;
        getComparisonSearchField(name: string): ComparisonSearchField;
        addDataGridAddButton(options: DataGridAddButtonCreationOptions): Promise<DataGridAddButton>;
        getDataGridAddButton(name: string): DataGridAddButton;
        addDataGridExportToCSVButton(options: DataGridExportToCSVButtonCreationOptions): Promise<DataGridExportToCSVButton>;
        getDataGridExportToCSVButton(name: string): DataGridExportToCSVButton;
        addDataGridExportToExcelButton(options: DataGridExportToExcelButtonCreationOptions): Promise<DataGridExportToExcelButton>;
        getDataGridExportToExcelButton(name: string): DataGridExportToExcelButton;
        addDataGridRemoveButton(options: DataGridRemoveButtonCreationOptions): Promise<DataGridRemoveButton>;
        getDataGridRemoveButton(name: string): DataGridRemoveButton;
        addDropDownSearchField(options: DropDownSearchFieldCreationOptions): Promise<DropDownSearchField>;
        getDropDownSearchField(name: string): DropDownSearchField;
        addGridActionButton(options: GridActionButtonCreationOptions): Promise<GridActionButton>;
        getGridActionButton(name: string): GridActionButton;
        addGridDeselectAllButton(options: GridDeselectAllButtonCreationOptions): Promise<GridDeselectAllButton>;
        getGridDeselectAllButton(name: string): GridDeselectAllButton;
        addGridNewButton(options: GridNewButtonCreationOptions): Promise<GridNewButton>;
        getGridNewButton(name: string): GridNewButton;
        addGridSearchButton(options: GridSearchButtonCreationOptions): Promise<GridSearchButton>;
        getGridSearchButton(name: string): GridSearchButton;
        addGridSelectAllButton(options: GridSelectAllButtonCreationOptions): Promise<GridSelectAllButton>;
        getGridSelectAllButton(name: string): GridSelectAllButton;
        addRangeSearchField(options: RangeSearchFieldCreationOptions): Promise<RangeSearchField>;
        getRangeSearchField(name: string): RangeSearchField;
        addSelectButton(options: SelectButtonCreationOptions): Promise<SelectButton>;
        getSelectButton(name: string): SelectButton;
    }
    interface ControlBarItemBase extends Primitives.ElementBase {
        name: string;
        getContainer(): ControlBar;
        delete(): void;
    }
    interface ControlBarButtonBase extends ControlBarItemBase {
        caption: ClientTemplate;
        tooltip: Texts.Text;
        icon: Icon | null;
        appearance: Appearance;
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
        buttonStyle: ButtonStyle;
    }
    interface ListViewCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/list-view relevant section in reference guide}
     */
    interface ListView extends ListenTargetWidgetBase {
        $Type: "Pages$ListView";
        $CreationOptions?: ListViewCreationOptions;
        widgets: Widget[];
        pageSize: number;
        clickAction: ClientAction;
        editable: boolean;
        templates: ListViewTemplate[];
        scrollDirection: ScrollDirection;
        numberOfColumns: number;
        pullDownAction: ClientAction;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
        addListViewTemplate(): Promise<ListViewTemplate>;
    }
    interface ListViewTemplate extends Primitives.ElementBase {
        $Type: "Pages$ListViewTemplate";
        specialization: string;
        widgets: Widget[];
        getContainer(): ListView;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface SortableEntityPathSourceBase extends EntityPathSourceBase {
        sortBar: GridSortBar;
    }
    interface XPathSourceBaseBase extends SortableEntityPathSourceBase {
        xPathConstraint: string | null;
    }
    interface ListViewXPathSource extends XPathSourceBaseBase {
        $Type: "Pages$ListViewXPathSource";
        search: ListViewSearch;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/sort-bar relevant section in reference guide}
     */
    interface GridSortBar extends Primitives.ElementBase {
        $Type: "Pages$GridSortBar";
        sortItems: GridSortItem[];
        addGridSortItem(): Promise<GridSortItem>;
    }
    interface GridSortItem extends Primitives.ElementBase {
        $Type: "Pages$GridSortItem";
        attributeRef: DomainModels.AttributeRef;
        sortDirection: SortDirection;
        getContainer(): GridSortBar;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/button-widgets relevant section in reference guide}
     */
    interface ButtonBase extends ConditionallyVisibleWidgetBase {
        caption: ClientTemplate;
        tooltip: Texts.Text;
        icon: Icon | null;
        renderType: RenderType;
        buttonStyle: ButtonStyle;
    }
    interface StaticOrDynamicString extends Primitives.ElementBase {
        $Type: "Pages$StaticOrDynamicString";
        isDynamic: boolean;
        value: string;
        attributeRef: DomainModels.AttributeRef | null;
        getContainer(): OpenLinkClientAction;
        delete(): void;
    }
    interface ActionButtonCreationOptions {
        name: string;
        caption?: string;
        buttonStyle?: ButtonStyle;
        renderType?: RenderType;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/button-widgets relevant section in reference guide}
     */
    interface ActionButton extends ButtonBase {
        $Type: "Pages$ActionButton";
        $CreationOptions?: ActionButtonCreationOptions;
        action: ClientAction;
        ariaRole: ButtonAriaRoleType;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface ClientTemplateCreationOptions {
        text: string;
        languageCode?: string;
    }
    interface ClientTemplate extends Primitives.ElementBase {
        $Type: "Pages$ClientTemplate";
        $CreationOptions?: ClientTemplateCreationOptions;
        template: Texts.Text;
        parameters: ClientTemplateParameter[];
        fallback: Texts.Text;
        addClientTemplateParameter(): Promise<ClientTemplateParameter>;
    }
    interface ClientTemplateParameter extends Primitives.ElementBase {
        $Type: "Pages$ClientTemplateParameter";
        attributeRef: DomainModels.AttributeRef | null;
        expression: string | null;
        formattingInfo: FormattingInfo;
        sourceVariable: PageVariable | null;
        getContainer(): ClientTemplate;
        delete(): void;
    }
    interface ColumnGridBase extends GridBase {
        columns: GridColumn[];
        numberOfRows: number;
        showEmptyRows: boolean;
        widthUnit: UnitEnum;
        tooltipPage: string | null;
        addGridColumn(options: GridColumnCreationOptions): Promise<GridColumn>;
        getGridColumn(name: string): GridColumn;
    }
    interface ComparisonSearchFieldCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/search-bar relevant section in reference guide}
     */
    interface ComparisonSearchField extends SingleSearchFieldBase {
        $Type: "Pages$ComparisonSearchField";
        $CreationOptions?: ComparisonSearchFieldCreationOptions;
    }
    interface GridXPathSource extends GridBaseSourceBase {
        $Type: "Pages$GridXPathSource";
        xPathConstraint: string | null;
    }
    interface DataGridCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/data-grid relevant section in reference guide}
     */
    interface DataGrid extends ColumnGridBase {
        $Type: "Pages$DataGrid";
        $CreationOptions?: DataGridCreationOptions;
        caption: ClientTemplate;
    }
    interface DataGridAddButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface DataGridAddButton extends GridControlBarButtonBase {
        $Type: "Pages$DataGridAddButton";
        $CreationOptions?: DataGridAddButtonCreationOptions;
        pageSettings: PageSettings;
    }
    interface DataGridExportToCSVButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface DataGridExportToCSVButton extends GridControlBarButtonBase {
        $Type: "Pages$DataGridExportToCSVButton";
        $CreationOptions?: DataGridExportToCSVButtonCreationOptions;
        maxNumberOfRows: number;
        decimalSeparator: string;
        groupSeparator: string;
        delimiter: string;
        generateExcelHint: boolean;
        useGridDateFormat: boolean;
    }
    interface DataGridExportToExcelButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface DataGridExportToExcelButton extends GridControlBarButtonBase {
        $Type: "Pages$DataGridExportToExcelButton";
        $CreationOptions?: DataGridExportToExcelButtonCreationOptions;
        maxNumberOfRows: number;
        useExcelDateType: boolean;
    }
    interface DataGridRemoveButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface DataGridRemoveButton extends GridControlBarButtonBase {
        $Type: "Pages$DataGridRemoveButton";
        $CreationOptions?: DataGridRemoveButtonCreationOptions;
    }
    interface DropDownCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/drop-down relevant section in reference guide}
     */
    interface DropDown extends AttributeWidgetBase {
        $Type: "Pages$DropDown";
        $CreationOptions?: DropDownCreationOptions;
        emptyOptionCaption: Texts.Text;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface DropDownButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/button-widgets relevant section in reference guide}
     */
    interface DropDownButton extends ButtonBase {
        $Type: "Pages$DropDownButton";
        $CreationOptions?: DropDownButtonCreationOptions;
        items: DropDownButtonItem[];
        addDropDownButtonItem(): Promise<DropDownButtonItem>;
    }
    interface ActionItemBase extends Primitives.ElementBase {
        action: ClientAction;
    }
    interface DropDownButtonItem extends ActionItemBase {
        $Type: "Pages$DropDownButtonItem";
        caption: Texts.Text;
        image: string | null;
        getContainer(): DropDownButton;
        delete(): void;
    }
    interface DropDownSearchFieldCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/search-bar relevant section in reference guide}
     */
    interface DropDownSearchField extends SingleSearchFieldBase {
        $Type: "Pages$DropDownSearchField";
        $CreationOptions?: DropDownSearchFieldCreationOptions;
        sortBar: GridSortBar;
        xPathConstraint: string | null;
        allowMultipleSelect: boolean;
    }
    interface DynamicImageViewerCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/image-viewer relevant section in reference guide}
     */
    interface DynamicImageViewer extends EntityWidgetBase {
        $Type: "Pages$DynamicImageViewer";
        $CreationOptions?: DynamicImageViewerCreationOptions;
        defaultImage: string | null;
        widthUnit: ImageSizeUnit;
        heightUnit: ImageSizeUnit;
        width: number;
        height: number;
        responsive: boolean;
        showAsThumbnail: boolean;
        clickAction: ClientAction;
        onClickEnlarge: boolean;
        alternativeText: ClientTemplate;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface DynamicTextCreationOptions {
        name: string;
        content?: string;
        renderMode?: TextRenderMode;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/text relevant section in reference guide}
     */
    interface DynamicText extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$DynamicText";
        $CreationOptions?: DynamicTextCreationOptions;
        content: ClientTemplate;
        renderMode: TextRenderMode;
        nativeTextStyle: NativeTextStyle;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface FileManagerCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/file-manager relevant section in reference guide}
     */
    interface FileManager extends InputWidgetBase {
        $Type: "Pages$FileManager";
        $CreationOptions?: FileManagerCreationOptions;
        allowedExtensions: string;
        type: FileManagerType;
        maxFileSize: number;
        showFileInBrowser: boolean;
    }
    interface PageForSpecialization extends Primitives.ElementBase {
        $Type: "Pages$PageForSpecialization";
        entity: string;
        pageSettings: PageSettings;
        getContainer(): PageClientAction;
        delete(): void;
    }
    interface GlyphIcon extends IconBase {
        $Type: "Pages$GlyphIcon";
        code: number;
    }
    interface GridBase extends ListenTargetWidgetBase {
        isControlBarVisible: boolean;
        showPagingBar: ShowPagingBarType;
        selectionMode: GridSelectionMode;
        selectFirst: boolean;
        defaultButtonTrigger: ClickTypeType;
        refreshTime: number;
        controlBar: GridControlBar;
    }
    interface GridActionButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridActionButton extends GridControlBarButtonBase {
        $Type: "Pages$GridActionButton";
        $CreationOptions?: GridActionButtonCreationOptions;
        action: ClientAction;
        maintainSelectionAfterMicroflow: boolean;
    }
    interface GridBaseSourceBase extends SortableEntityPathSourceBase {
        searchBar: SearchBar;
    }
    interface GridColumnCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/columns relevant section in reference guide}
     */
    interface GridColumn extends Primitives.ElementBase {
        $Type: "Pages$GridColumn";
        $CreationOptions?: GridColumnCreationOptions;
        name: string;
        caption: Texts.Text;
        attributeRef: DomainModels.AttributeRef | null;
        formattingInfo: FormattingInfo;
        showTooltip: boolean;
        aggregateCaption: Texts.Text;
        aggregateFunction: AggregateFunction;
        editable: boolean;
        width: number;
        appearance: Appearance;
        getContainer(): ColumnGrid;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridControlBar extends ControlBarBase {
        $Type: "Pages$GridControlBar";
        defaultButton: string | null;
        getContainer(): Grid;
        delete(): void;
    }
    interface GridControlBarButtonBase extends ControlBarButtonBase {
    }
    interface GridDeselectAllButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridDeselectAllButton extends GridControlBarButtonBase {
        $Type: "Pages$GridDeselectAllButton";
        $CreationOptions?: GridDeselectAllButtonCreationOptions;
    }
    interface GridNewButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridNewButton extends GridControlBarButtonBase {
        $Type: "Pages$GridNewButton";
        $CreationOptions?: GridNewButtonCreationOptions;
        entity: string | null;
        editLocation: NewButtonEditLocation;
        pageSettings: PageSettings;
    }
    interface GridSearchButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridSearchButton extends GridControlBarButtonBase {
        $Type: "Pages$GridSearchButton";
        $CreationOptions?: GridSearchButtonCreationOptions;
    }
    interface GridSelectAllButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface GridSelectAllButton extends GridControlBarButtonBase {
        $Type: "Pages$GridSelectAllButton";
        $CreationOptions?: GridSelectAllButtonCreationOptions;
        selectionType: SelectionType;
    }
    interface GroupBoxCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/group-box relevant section in reference guide}
     */
    interface GroupBox extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$GroupBox";
        $CreationOptions?: GroupBoxCreationOptions;
        caption: ClientTemplate | null;
        collapsible: GroupBoxCollapsible;
        headerMode: GroupBoxRenderMode;
        widgets: Widget[];
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface HeaderCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/header relevant section in reference guide}
     */
    interface Header extends WidgetBase {
        $Type: "Pages$Header";
        $CreationOptions?: HeaderCreationOptions;
        leftWidgets: Widget[];
        rightWidgets: Widget[];
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/image relevant section in reference guide}
     */
    interface IconBase extends Primitives.ElementBase {
    }
    interface ImageIcon extends IconBase {
        $Type: "Pages$ImageIcon";
        image: string;
    }
    interface IconCollectionIcon extends IconBase {
        $Type: "Pages$IconCollectionIcon";
        image: string;
    }
    interface ImageUploaderCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/image-uploader relevant section in reference guide}
     */
    interface ImageUploader extends InputWidgetBase {
        $Type: "Pages$ImageUploader";
        $CreationOptions?: ImageUploaderCreationOptions;
        allowedExtensions: string;
        thumbnailSize: string;
        maxFileSize: number;
    }
    interface ImageViewerSource extends EntityPathSourceBase {
        $Type: "Pages$ImageViewerSource";
    }
    interface InputReferenceSetSelectorCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/input-reference-set-selector relevant section in reference guide}
     */
    interface InputReferenceSetSelector extends AssociationWidgetBase {
        $Type: "Pages$InputReferenceSetSelector";
        $CreationOptions?: InputReferenceSetSelectorCreationOptions;
    }
    interface LayoutGridCreationOptions {
        name: string;
        columns?: {
            weight: number;
        }[];
        width?: ContainerWidth;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/layout-grid relevant section in reference guide}
     */
    interface LayoutGrid extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$LayoutGrid";
        $CreationOptions?: LayoutGridCreationOptions;
        width: ContainerWidth;
        rows: LayoutGridRow[];
        addLayoutGridRow(options: LayoutGridRowCreationOptions): Promise<LayoutGridRow>;
    }
    interface LayoutGridColumnCreationOptions {
        weight?: number;
    }
    interface LayoutGridColumn extends Primitives.ElementBase {
        $Type: "Pages$LayoutGridColumn";
        $CreationOptions?: LayoutGridColumnCreationOptions;
        weight: number;
        tabletWeight: number;
        phoneWeight: number;
        previewWidth: number;
        widgets: Widget[];
        appearance: Appearance;
        verticalAlignment: LayoutGridAlignment;
        getContainer(): LayoutGridRow;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface LayoutGridRowCreationOptions {
        columns?: {
            weight: number;
        }[];
    }
    interface LayoutGridRow extends Primitives.ElementBase {
        $Type: "Pages$LayoutGridRow";
        $CreationOptions?: LayoutGridRowCreationOptions;
        columns: LayoutGridColumn[];
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
        appearance: Appearance;
        verticalAlignment: LayoutGridAlignment;
        horizontalAlignment: LayoutGridAlignment;
        spacingBetweenColumns: boolean;
        getContainer(): LayoutGrid;
        delete(): void;
        addLayoutGridColumn(options: LayoutGridColumnCreationOptions): Promise<LayoutGridColumn>;
    }
    interface MenuBarCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/menu-bar relevant section in reference guide}
     */
    interface MenuBar extends MenuWidgetBase {
        $Type: "Pages$MenuBar";
        $CreationOptions?: MenuBarCreationOptions;
    }
    interface MenuDocumentSource extends MenuSourceBase {
        $Type: "Pages$MenuDocumentSource";
        menu: string | null;
    }
    interface MenuSourceBase extends Primitives.ElementBase {
        getContainer(): MenuWidget;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/menu-widgets relevant section in reference guide}
     */
    interface MenuWidgetBase extends WidgetBase {
        menuSource: MenuSource;
    }
    interface NavigationListCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/navigation-list relevant section in reference guide}
     */
    interface NavigationList extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$NavigationList";
        $CreationOptions?: NavigationListCreationOptions;
        items: NavigationListItem[];
        addNavigationListItem(): Promise<NavigationListItem>;
    }
    interface NavigationListItem extends ActionItemBase {
        $Type: "Pages$NavigationListItem";
        widgets: Widget[];
        appearance: Appearance;
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
        getContainer(): NavigationList;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface NavigationSource extends MenuSourceBase {
        $Type: "Pages$NavigationSource";
        navigationProfile: string;
    }
    interface NavigationTreeCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/navigation-tree relevant section in reference guide}
     */
    interface NavigationTree extends MenuWidgetBase {
        $Type: "Pages$NavigationTree";
        $CreationOptions?: NavigationTreeCreationOptions;
    }
    interface RangeSearchFieldCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/search-bar relevant section in reference guide}
     */
    interface RangeSearchField extends SearchFieldBase {
        $Type: "Pages$RangeSearchField";
        $CreationOptions?: RangeSearchFieldCreationOptions;
        lowerBoundRef: DomainModels.AttributeRef | null;
        upperBoundRef: DomainModels.AttributeRef | null;
        includeLower: boolean;
        includeUpper: boolean;
    }
    interface ReferenceSelectorCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/reference-selector relevant section in reference guide}
     */
    interface ReferenceSelector extends AssociationWidgetBase {
        $Type: "Pages$ReferenceSelector";
        $CreationOptions?: ReferenceSelectorCreationOptions;
        validation: WidgetValidation;
        renderMode: ReferenceSelectorRenderModeType;
        gotoPageSettings: PageSettings;
        formattingInfo: FormattingInfo;
        emptyOptionCaption: Texts.Text;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface ReferenceSetSelectorCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/reference-set-selector relevant section in reference guide}
     */
    interface ReferenceSetSelector extends ColumnGridBase {
        $Type: "Pages$ReferenceSetSelector";
        $CreationOptions?: ReferenceSetSelectorCreationOptions;
        onChangeAction: ClientAction;
        constrainedByRefs: DomainModels.EntityRef[];
        xPathConstraint: string | null;
    }
    interface ReferenceSetSource extends GridBaseSourceBase {
        $Type: "Pages$ReferenceSetSource";
    }
    interface ScrollContainerCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/scroll-container relevant section in reference guide}
     */
    interface ScrollContainer extends WidgetBase {
        $Type: "Pages$ScrollContainer";
        $CreationOptions?: ScrollContainerCreationOptions;
        center: ScrollContainerRegion;
        left: ScrollContainerRegion | null;
        right: ScrollContainerRegion | null;
        top: ScrollContainerRegion | null;
        bottom: ScrollContainerRegion | null;
        layoutMode: LayoutModeType;
        widthMode: SizeMode;
        width: number;
        alignment: AlignmentEnum;
        scrollBehavior: ScrollBehavior;
        nativeHideScrollbars: boolean;
    }
    interface ScrollContainerRegion extends Primitives.ElementBase {
        $Type: "Pages$ScrollContainerRegion";
        widgets: Widget[];
        sizeMode: SizeMode;
        size: number;
        appearance: Appearance;
        toggleMode: ToggleMode;
        getContainer(): ScrollContainer;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/search-bar relevant section in reference guide}
     */
    interface SearchBar extends ControlBarBase {
        $Type: "Pages$SearchBar";
        type: SearchBarTypeEnum;
        waitForSearch: boolean;
    }
    interface ListViewSearch extends Primitives.ElementBase {
        $Type: "Pages$ListViewSearch";
        searchRefs: DomainModels.AttributeRef[];
    }
    interface SearchFieldBase extends ControlBarItemBase {
        caption: Texts.Text;
        placeholder: Texts.Text;
        customDateFormat: string;
        type: SearchFieldType;
        defaultValue: string;
    }
    interface SelectButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/control-bar relevant section in reference guide}
     */
    interface SelectButton extends GridControlBarButtonBase {
        $Type: "Pages$SelectButton";
        $CreationOptions?: SelectButtonCreationOptions;
    }
    interface AssociationWidgetBase extends MemberWidgetBase {
        selectorSource: SelectorSource;
        selectPageSettings: PageSettings;
        onChangeAction: ClientAction;
        sourceVariable: PageVariable | null;
    }
    interface SelectorXPathSource extends SelectorSourceBase {
        $Type: "Pages$SelectorXPathSource";
        sortBar: GridSortBar;
        xPathConstraint: string | null;
        constrainedByRefs: DomainModels.EntityRef[];
    }
    interface SelectorMicroflowSource extends SelectorSourceBase {
        $Type: "Pages$SelectorMicroflowSource";
        dataSourceMicroflowSettings: MicroflowSettings;
    }
    interface SelectorSourceBase extends Primitives.ElementBase {
        getContainer(): AssociationWidget;
        delete(): void;
    }
    interface SidebarToggleButtonCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/sidebar-toggle-button relevant section in reference guide}
     */
    interface SidebarToggleButton extends ButtonBase {
        $Type: "Pages$SidebarToggleButton";
        $CreationOptions?: SidebarToggleButtonCreationOptions;
    }
    interface SimpleMenuBarCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/simple-menu-bar relevant section in reference guide}
     */
    interface SimpleMenuBar extends MenuWidgetBase {
        $Type: "Pages$SimpleMenuBar";
        $CreationOptions?: SimpleMenuBarCreationOptions;
        orientation: SimpleMenuBarOrientation;
    }
    interface SingleSearchFieldBase extends SearchFieldBase {
        attributeRef: DomainModels.AttributeRef | null;
        operator: SearchFieldOperator;
    }
    /**
     * Options for creating a Snippet.
     */
    interface SnippetCreationOptions {
        /**
         * The name of the snippet.
         */
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/snippet relevant section in reference guide}
     */
    interface Snippet extends FormBaseBase {
        $Type: "Pages$Snippet";
        $CreationOptions?: SnippetCreationOptions;
        widgets: Widget[];
        type: SnippetType;
        parameters: SnippetParameter[];
        variables: LocalVariable[];
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
        addSnippetParameter(options: SnippetParameterCreationOptions): Promise<SnippetParameter>;
        getSnippetParameter(name: string): SnippetParameter;
        addLocalVariable(options: LocalVariableCreationOptions): Promise<LocalVariable>;
        getLocalVariable(name: string): LocalVariable;
    }
    interface SnippetParameterCreationOptions {
        name: string;
    }
    interface SnippetParameter extends Primitives.ElementBase {
        $Type: "Pages$SnippetParameter";
        $CreationOptions?: SnippetParameterCreationOptions;
        name: string;
        parameterType: DataTypes.DataType;
        getContainer(): Snippet;
        delete(): void;
    }
    interface SnippetCall extends Primitives.ElementBase {
        $Type: "Pages$SnippetCall";
        snippet: string | null;
        parameterMappings: SnippetParameterMapping[];
        getContainer(): SnippetCallWidget;
        delete(): void;
        addSnippetParameterMapping(): Promise<SnippetParameterMapping>;
    }
    interface SnippetParameterMapping extends Primitives.ElementBase {
        $Type: "Pages$SnippetParameterMapping";
        parameter: string;
        variable: PageVariable;
        getContainer(): SnippetCall;
        delete(): void;
    }
    interface SnippetCallWidgetCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/snippet-call relevant section in reference guide}
     */
    interface SnippetCallWidget extends WidgetBase {
        $Type: "Pages$SnippetCallWidget";
        $CreationOptions?: SnippetCallWidgetCreationOptions;
        snippetCall: SnippetCall;
    }
    interface TabContainerCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/tab-container relevant section in reference guide}
     */
    interface TabContainer extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$TabContainer";
        $CreationOptions?: TabContainerCreationOptions;
        tabPages: TabPage[];
        defaultPage: string | null;
        activePageAttributeRef: DomainModels.AttributeRef | null;
        activePageSourceVariable: PageVariable | null;
        activePageOnChangeAction: ClientAction;
        addTabPage(options: TabPageCreationOptions): Promise<TabPage>;
        getTabPage(name: string): TabPage;
    }
    interface TabPageCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/tab-container relevant section in reference guide}
     */
    interface TabPage extends Primitives.ElementBase {
        $Type: "Pages$TabPage";
        $CreationOptions?: TabPageCreationOptions;
        name: string;
        caption: Texts.Text;
        refreshOnShow: boolean;
        conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
        widgets: Widget[];
        badge: ClientTemplate | null;
        getContainer(): TabContainer;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface TemplateGridCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/template-grid relevant section in reference guide}
     */
    interface TemplateGrid extends GridBase {
        $Type: "Pages$TemplateGrid";
        $CreationOptions?: TemplateGridCreationOptions;
        contents: TemplateGridContents;
        numberOfRows: number;
        numberOfColumns: number;
    }
    interface TemplateGridContents extends Primitives.ElementBase {
        $Type: "Pages$TemplateGridContents";
        widgets: Widget[];
        getContainer(): TemplateGrid;
        delete(): void;
        addPlaceholder(options: PlaceholderCreationOptions): Promise<Placeholder>;
        getPlaceholder(name: string): Placeholder;
        addTemplatePlaceholder(options: TemplatePlaceholderCreationOptions): Promise<TemplatePlaceholder>;
        getTemplatePlaceholder(name: string): TemplatePlaceholder;
        addLabel(options: LabelCreationOptions): Promise<Label>;
        getLabel(name: string): Label;
        addStaticImageViewer(options: StaticImageViewerCreationOptions): Promise<StaticImageViewer>;
        getStaticImageViewer(name: string): StaticImageViewer;
        addDivContainer(options: DivContainerCreationOptions): Promise<DivContainer>;
        getDivContainer(name: string): DivContainer;
        addTextBox(options: TextBoxCreationOptions): Promise<TextBox>;
        getTextBox(name: string): TextBox;
        addTextArea(options: TextAreaCreationOptions): Promise<TextArea>;
        getTextArea(name: string): TextArea;
        addCheckBox(options: CheckBoxCreationOptions): Promise<CheckBox>;
        getCheckBox(name: string): CheckBox;
        addRadioButtonGroup(options: RadioButtonGroupCreationOptions): Promise<RadioButtonGroup>;
        getRadioButtonGroup(name: string): RadioButtonGroup;
        addDatePicker(options: DatePickerCreationOptions): Promise<DatePicker>;
        getDatePicker(name: string): DatePicker;
        addLoginIdTextBox(options: LoginIdTextBoxCreationOptions): Promise<LoginIdTextBox>;
        getLoginIdTextBox(name: string): LoginIdTextBox;
        addPasswordTextBox(options: PasswordTextBoxCreationOptions): Promise<PasswordTextBox>;
        getPasswordTextBox(name: string): PasswordTextBox;
        addLoginButton(options: LoginButtonCreationOptions): Promise<LoginButton>;
        getLoginButton(name: string): LoginButton;
        addValidationMessage(options: ValidationMessageCreationOptions): Promise<ValidationMessage>;
        getValidationMessage(name: string): ValidationMessage;
        addTable(options: TableCreationOptions): Promise<Table>;
        getTable(name: string): Table;
        addDataView(options: DataViewCreationOptions): Promise<DataView>;
        getDataView(name: string): DataView;
        addListView(options: ListViewCreationOptions): Promise<ListView>;
        getListView(name: string): ListView;
        addActionButton(options: ActionButtonCreationOptions): Promise<ActionButton>;
        getActionButton(name: string): ActionButton;
        addDataGrid(options: DataGridCreationOptions): Promise<DataGrid>;
        getDataGrid(name: string): DataGrid;
        addDropDown(options: DropDownCreationOptions): Promise<DropDown>;
        getDropDown(name: string): DropDown;
        addDropDownButton(options: DropDownButtonCreationOptions): Promise<DropDownButton>;
        getDropDownButton(name: string): DropDownButton;
        addDynamicImageViewer(options: DynamicImageViewerCreationOptions): Promise<DynamicImageViewer>;
        getDynamicImageViewer(name: string): DynamicImageViewer;
        addDynamicText(options: DynamicTextCreationOptions): Promise<DynamicText>;
        getDynamicText(name: string): DynamicText;
        addFileManager(options: FileManagerCreationOptions): Promise<FileManager>;
        getFileManager(name: string): FileManager;
        addGroupBox(options: GroupBoxCreationOptions): Promise<GroupBox>;
        getGroupBox(name: string): GroupBox;
        addHeader(options: HeaderCreationOptions): Promise<Header>;
        getHeader(name: string): Header;
        addImageUploader(options: ImageUploaderCreationOptions): Promise<ImageUploader>;
        getImageUploader(name: string): ImageUploader;
        addInputReferenceSetSelector(options: InputReferenceSetSelectorCreationOptions): Promise<InputReferenceSetSelector>;
        getInputReferenceSetSelector(name: string): InputReferenceSetSelector;
        addLayoutGrid(options: LayoutGridCreationOptions): Promise<LayoutGrid>;
        getLayoutGrid(name: string): LayoutGrid;
        addMenuBar(options: MenuBarCreationOptions): Promise<MenuBar>;
        getMenuBar(name: string): MenuBar;
        addNavigationList(options: NavigationListCreationOptions): Promise<NavigationList>;
        getNavigationList(name: string): NavigationList;
        addNavigationTree(options: NavigationTreeCreationOptions): Promise<NavigationTree>;
        getNavigationTree(name: string): NavigationTree;
        addReferenceSelector(options: ReferenceSelectorCreationOptions): Promise<ReferenceSelector>;
        getReferenceSelector(name: string): ReferenceSelector;
        addReferenceSetSelector(options: ReferenceSetSelectorCreationOptions): Promise<ReferenceSetSelector>;
        getReferenceSetSelector(name: string): ReferenceSetSelector;
        addScrollContainer(options: ScrollContainerCreationOptions): Promise<ScrollContainer>;
        getScrollContainer(name: string): ScrollContainer;
        addSidebarToggleButton(options: SidebarToggleButtonCreationOptions): Promise<SidebarToggleButton>;
        getSidebarToggleButton(name: string): SidebarToggleButton;
        addSimpleMenuBar(options: SimpleMenuBarCreationOptions): Promise<SimpleMenuBar>;
        getSimpleMenuBar(name: string): SimpleMenuBar;
        addSnippetCallWidget(options: SnippetCallWidgetCreationOptions): Promise<SnippetCallWidget>;
        getSnippetCallWidget(name: string): SnippetCallWidget;
        addTabContainer(options: TabContainerCreationOptions): Promise<TabContainer>;
        getTabContainer(name: string): TabContainer;
        addTemplateGrid(options: TemplateGridCreationOptions): Promise<TemplateGrid>;
        getTemplateGrid(name: string): TemplateGrid;
        addTitle(options: TitleCreationOptions): Promise<Title>;
        getTitle(name: string): Title;
    }
    interface TitleCreationOptions {
        name: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/page-title relevant section in reference guide}
     */
    interface Title extends ConditionallyVisibleWidgetBase {
        $Type: "Pages$Title";
        $CreationOptions?: TitleCreationOptions;
        nativeAccessibilitySettings: AccessibilitySettings | null;
    }
    interface WorkflowTemplateTypeBase extends TemplateTypeBase {
    }
    interface UserTaskTemplateType extends WorkflowTemplateTypeBase {
        $Type: "Pages$UserTaskTemplateType";
    }
    interface WorkflowOverviewTemplateType extends WorkflowTemplateTypeBase {
        $Type: "Pages$WorkflowOverviewTemplateType";
    }
    interface CallWorkflowClientAction extends ClientActionBase {
        $Type: "Pages$CallWorkflowClientAction";
        workflow: string | null;
        closePage: boolean;
        confirmationInfo: ConfirmationInfo | null;
    }
    interface OpenUserTaskClientAction extends ClientActionBase {
        $Type: "Pages$OpenUserTaskClientAction";
        assignOnOpen: boolean;
        openWhenAssigned: boolean;
    }
    interface OpenWorkflowClientAction extends ClientActionBase {
        $Type: "Pages$OpenWorkflowClientAction";
        defaultPage: string | null;
    }
    interface SetTaskOutcomeClientAction extends ClientActionBase {
        $Type: "Pages$SetTaskOutcomeClientAction";
        outcomeValue: string;
        closePage: boolean;
        commit: boolean;
    }
    type FormLocation = "Content" | "Popup" | "ModalPopup";
    type ProgressBarType = "None" | "NonBlocking" | "Blocking";
    type FormValidations = "None" | "Widget" | "All";
    type SubmitBehaviourType = "OnEndEditing" | "WhileEditing";
    type AutocompletePurposeType = "On" | "Off" | "FullName" | "HonorificPrefix" | "GivenName" | "AdditionalName" | "FamilyName" | "HonorificSuffix" | "Nickname" | "JobTitle" | "Username" | "NewPassword" | "CurrentPassword" | "CompanyName" | "StreetAddress" | "StreetAddressLine1" | "StreetAddressLine2" | "StreetAddressLine3" | "AddressLevel4" | "AddressLevel3" | "AddressLevel2" | "AddressLevel1" | "CountryCode" | "CountryName" | "PostalCode" | "CreditCardFullName" | "CreditCardGivenName" | "CreditCardAdditionalName" | "CreditCardFamilyName" | "CreditCardNumber" | "CreditCardExpiration" | "CreditCardExpirationMonth" | "CreditCardExpirationYear" | "CreditCardSecurityCode" | "CreditCardType" | "TransactionCurrency" | "TransactionAmount" | "Language" | "Birthday" | "DayOfBirth" | "MonthOfBirth" | "YearOfBirth" | "Sex" | "Url" | "Photo" | "TelephoneNumber" | "TelephoneCountryCode" | "TelephoneWithoutCountryCode" | "TelephoneAreaCode" | "TelephoneLocal" | "TelephoneLocalPrefix" | "TelephoneLocalSuffix" | "TelephoneExtension" | "Email" | "InstantMessageProtocol";
    type KeyboardType = "NumberPad" | "DecimalPad" | "EmailAddress" | "PhonePad" | "URL" | "Default";
    type LabelPosition = "Default" | "BeforeControl" | "AfterControl";
    type NativeRenderMode = "CheckBox" | "Switch";
    type EnumFormat = "Text" | "Image";
    type DateFormat = "Date" | "Time" | "DateTime" | "Custom";
    type ReadOnlyStyle = "Inherit" | "Control" | "Text";
    type EditableEnum = "Always" | "Never" | "Conditional";
    type UnitEnum = "Weight" | "Pixels";
    type DataViewReadOnlyStyle = "Control" | "Text";
    type ScrollDirection = "Vertical" | "Horizontal";
    type SortDirection = "Ascending" | "Descending";
    type RenderType = "Button" | "Link";
    type ButtonStyle = "Default" | "Inverse" | "Primary" | "Info" | "Success" | "Warning" | "Danger";
    type ButtonAriaRoleType = "Button" | "Link" | "Checkbox" | "Radio" | "Tab" | "MenuItem" | "MenuItemCheckbox" | "MenuItemRadio" | "Option" | "Switch" | "TreeItem";
    type NativeTextStyle = "Text" | "Heading1" | "Heading2" | "Heading3" | "Heading4" | "Heading5" | "Heading6";
    type ToggleMode = "None" | "PushContentAside" | "SlideOverContent" | "ShrinkContentInitiallyOpen" | "ShrinkContentInitiallyClosed";
    type SnippetType = "Web" | "Native";
    type AggregateFunction = "None" | "Average" | "Maximum" | "Minimum" | "Sum" | "Count";
    type AlignmentEnum = "Left" | "Center" | "Right";
    type LayoutGridAlignment = "None" | "Start" | "Center" | "End";
    type ClickTypeType = "Single" | "Double";
    type ShowPagingBarType = "YesWithTotalCount" | "YesWithoutTotalCount" | "No";
    type ContainerWidth = "FullWidth" | "FixedWidth";
    type FileManagerType = "Upload" | "Download" | "Both";
    type GridSelectionMode = "None" | "Single" | "SingleAndMaintain" | "Multi" | "SimpleMulti";
    type GroupBoxCollapsible = "No" | "YesInitiallyExpanded" | "YesInitiallyCollapsed";
    type ImageSizeUnit = "Auto" | "Pixels" | "Percentage";
    type LayoutModeType = "Headline" | "Sidebar";
    type LayoutType = "Responsive" | "Tablet" | "Phone" | "ModalPopup" | "Popup" | "Legacy";
    type NativeLayoutType = "Default" | "TopLevel" | "Popup";
    type LinkType = "Web" | "Email" | "Call" | "Text";
    type NewButtonEditLocation = "InlineAtTop" | "InlineAtBottom" | "Form";
    type ReferenceSelectorRenderModeType = "Form" | "DropDown";
    type ScrollBehavior = "PerRegion" | "FullWidget";
    type SearchBarTypeEnum = "None" | "FoldableOpen" | "FoldableClosed" | "AlwaysOpen";
    type SearchFieldOperator = "Contains" | "StartsWith" | "Greater" | "GreaterOrEqual" | "Equal" | "NotEqual" | "SmallerOrEqual" | "Smaller";
    type SearchFieldType = "Normal" | "Hidden" | "ReadOnly";
    type SelectionType = "SelectPage" | "SelectAll";
    type SidebarToggleMode = "PushContentAside" | "SlideOverContent" | "ShrinkContent";
    type SidebarToggleRegion = "Left" | "Right";
    type SimpleMenuBarOrientation = "Horizontal" | "Vertical";
    type SizeMode = "Auto" | "Pixels" | "Percentage";
    type TextRenderMode = "Text" | "Paragraph" | "H1" | "H2" | "H3" | "H4" | "H5" | "H6";
    type ContainerRenderMode = "Div" | "Section" | "Article" | "Header" | "Footer" | "Main" | "Nav" | "Aside" | "Hgroup" | "Address";
    type GroupBoxRenderMode = "Div" | "H1" | "H2" | "H3" | "H4" | "H5" | "H6";
}
//# sourceMappingURL=Pages.gen.d.ts.map