import { Primitives } from '@mendix/model-access';
import { Projects } from './Projects.gen';
import { Texts } from './Texts.gen';
export declare namespace Enumerations {
    /**
     * Options for creating an Enumeration.
     */
    interface EnumerationCreationOptions {
        /**
         * The name of the enumeration.
         */
        name: string;
        /**
         * The values of the enumeration.
         */
        values?: EnumerationValueCreationOptions[];
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/enumerations relevant section in reference guide}
     */
    interface Enumeration extends Projects.Document {
        $Type: "Enumerations$Enumeration";
        $CreationOptions?: EnumerationCreationOptions;
        values: EnumerationValue[];
        remoteSource: RemoteEnumerationSource | null;
        name: string;
        documentation: string;
        addEnumerationValue(options: EnumerationValueCreationOptions): Promise<EnumerationValue>;
        getEnumerationValue(name: string): EnumerationValue;
    }
    /**
     * Options for creating an EnumerationValue.
     */
    interface EnumerationValueCreationOptions {
        /**
         * The name of the enumeration value.
         */
        name: string;
        /**
         * The caption of the enumeration value.
         */
        caption?: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/enumerations relevant section in reference guide}
     */
    interface EnumerationValue extends Primitives.ElementBase {
        $Type: "Enumerations$EnumerationValue";
        $CreationOptions?: EnumerationValueCreationOptions;
        name: string;
        caption: Texts.Text;
        image: string | null;
        remoteValue: RemoteEnumerationValue | null;
        getContainer(): Enumeration;
        delete(): void;
    }
    interface Condition extends Primitives.ElementBase {
        $Type: "Enumerations$Condition";
        attributeValue: string;
        editableVisible: boolean;
    }
    interface RemoteEnumerationSource extends Primitives.ElementBase {
        getContainer(): Enumeration;
        delete(): void;
    }
    interface RemoteEnumerationValue extends Primitives.ElementBase {
        getContainer(): EnumerationValue;
        delete(): void;
    }
}
//# sourceMappingURL=Enumerations.gen.d.ts.map