import { Primitives } from '@mendix/model-access';
import { Projects } from './Projects.gen';
import { Texts } from './Texts.gen';
export declare namespace DomainModels {
    type EntitySource = RemoteEntitySource | ViewEntitySource;
    type RemoteEntitySource = QueryBasedRemoteEntitySource;
    type ViewEntitySource = OqlViewEntitySource;
    type GeneralizationBase = Generalization | NoGeneralization;
    type ValueType = StoredValue | CalculatedValue | OqlViewValue | MappedValue;
    type AttributeType = BinaryAttributeType | BooleanAttributeType | DateTimeAttributeType | EnumerationAttributeType | HashedStringAttributeType | StringAttributeType | NumericAttributeTypeBase;
    type NumericAttributeTypeBase = DecimalAttributeTypeBase | IntegerAttributeTypeBase;
    type DecimalAttributeTypeBase = DecimalAttributeType;
    type IntegerAttributeTypeBase = IntegerAttributeType | LongAttributeType | AutoNumberAttributeType;
    /**
     * See: {@link https://docs.mendix.com/refguide/associations relevant section in reference guide}
     */
    type AssociationBase = Association | CrossAssociation;
    type AssociationSource = RemoteAssociationSource | OqlViewAssociationSource;
    type RuleInfo = EqualsToRuleInfo | MaxLengthRuleInfo | RangeRuleInfo | RegExRuleInfo | RequiredRuleInfo | UniqueRuleInfo;
    type EntityRef = DirectEntityRef | IndirectEntityRef;
    type MemberRef = AttributeRef | AssociationRef;
    /**
     * See: {@link https://docs.mendix.com/refguide/domain-model relevant section in reference guide}
     */
    interface DomainModel extends Projects.ModuleDocumentBase {
        $Type: "DomainModels$DomainModel";
        documentation: string;
        entities: Entity[];
        annotations: Annotation[];
        associations: Association[];
        crossAssociations: CrossAssociation[];
        addEntity(options: EntityCreationOptions): Promise<Entity>;
        getEntity(name: string): Entity;
        addAnnotation(): Promise<Annotation>;
        addAssociation(options: AssociationCreationOptions): Promise<Association>;
        getAssociation(name: string): Association;
        addCrossAssociation(options: CrossAssociationCreationOptions): Promise<CrossAssociation>;
        getCrossAssociation(name: string): CrossAssociation;
    }
    interface EntityCreationOptions {
        name: string;
        attributes?: AttributeCreationOptions[];
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/entities relevant section in reference guide}
     */
    interface Entity extends Primitives.ElementBase {
        $Type: "DomainModels$Entity";
        $CreationOptions?: EntityCreationOptions;
        name: string;
        dataStorageGuid: string;
        location: Primitives.Location;
        documentation: string;
        generalization: GeneralizationBase;
        attributes: Attribute[];
        validationRules: ValidationRule[];
        eventHandlers: EventHandler[];
        indexes: Index[];
        accessRules: AccessRule[];
        image: string | null;
        imageData: any;
        source: EntitySource | null;
        getContainer(): DomainModel;
        delete(): void;
        addAttribute(options: AttributeCreationOptions): Promise<Attribute>;
        getAttribute(name: string): Attribute;
        addValidationRule(): Promise<ValidationRule>;
        addEventHandler(): Promise<EventHandler>;
        addIndex(): Promise<Index>;
        addAccessRule(): Promise<AccessRule>;
    }
    interface EntitySourceBase extends Primitives.ElementBase {
        getContainer(): Entity;
        delete(): void;
    }
    interface RemoteEntitySourceBase extends EntitySourceBase {
    }
    interface QueryBasedRemoteEntitySource extends RemoteEntitySourceBase {
    }
    interface ViewEntitySourceBase extends EntitySourceBase {
    }
    interface OqlViewEntitySource extends ViewEntitySourceBase {
        $Type: "DomainModels$OqlViewEntitySource";
        sourceDocument: string | null;
    }
    interface GeneralizationBaseBase extends Primitives.ElementBase {
        getContainer(): Entity;
        delete(): void;
    }
    interface Generalization extends GeneralizationBaseBase {
        $Type: "DomainModels$Generalization";
        generalization: string;
    }
    interface NoGeneralization extends GeneralizationBaseBase {
        $Type: "DomainModels$NoGeneralization";
        hasChangedDate: boolean;
        hasCreatedDate: boolean;
        hasOwner: boolean;
        hasChangedBy: boolean;
        persistable: boolean;
    }
    interface EntityKey extends Primitives.ElementBase {
        $Type: "DomainModels$EntityKey";
        parts: EntityKeyPart[];
        addEntityKeyPart(options: EntityKeyPartCreationOptions): Promise<EntityKeyPart>;
        getEntityKeyPart(name: string): EntityKeyPart;
    }
    interface EntityKeyPartCreationOptions {
        name: string;
    }
    interface EntityKeyPart extends Primitives.ElementBase {
        $Type: "DomainModels$EntityKeyPart";
        $CreationOptions?: EntityKeyPartCreationOptions;
        name: string;
        type: AttributeType;
        getContainer(): EntityKey;
        delete(): void;
    }
    interface RemoteEntitySourceDocument extends Projects.Document {
        description: string;
        catalogUrl: string;
        icon: any;
        metadata: string;
        metadataUrl: string;
        serviceName: string;
        version: string;
        endpointId: string;
        minimumMxVersion: string;
        recommendedMxVersion: string;
        applicationId: string;
        environmentType: EnvironmentType;
        metadataHash: string;
        validated: boolean;
        validatedEntities: string[];
        name: string;
        documentation: string;
    }
    interface ViewEntitySourceDocumentCreationOptions {
        name: string;
    }
    interface ViewEntitySourceDocument extends Projects.Document {
        $Type: "DomainModels$ViewEntitySourceDocument";
        $CreationOptions?: ViewEntitySourceDocumentCreationOptions;
        name: string;
        documentation: string;
    }
    interface AttributeCreationOptions {
        name: string;
        type?: "Binary" | "Boolean" | "DateTime" | "HashedString" | "String" | "Decimal" | "Integer" | "Long" | "AutoNumber" | "Enumeration";
        enumerationName?: string;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/attributes relevant section in reference guide}
     */
    interface Attribute extends Primitives.ElementBase {
        $Type: "DomainModels$Attribute";
        $CreationOptions?: AttributeCreationOptions;
        name: string;
        dataStorageGuid: string;
        type: AttributeType;
        documentation: string;
        value: ValueType;
        getContainer(): Entity;
        delete(): void;
    }
    interface ValueTypeBase extends Primitives.ElementBase {
        getContainer(): Attribute;
        delete(): void;
    }
    interface StoredValueCreationOptions {
        defaultValue: string;
    }
    interface StoredValue extends ValueTypeBase {
        $Type: "DomainModels$StoredValue";
        $CreationOptions?: StoredValueCreationOptions;
        defaultValue: string;
    }
    interface CalculatedValue extends ValueTypeBase {
        $Type: "DomainModels$CalculatedValue";
        microflow: string | null;
        passEntity: boolean;
    }
    interface OqlViewValue extends ValueTypeBase {
        $Type: "DomainModels$OqlViewValue";
        reference: string;
    }
    interface MappedValue extends ValueTypeBase {
        defaultValueDesignTime: string;
    }
    interface AttributeTypeBase extends Primitives.ElementBase {
    }
    interface BinaryAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$BinaryAttributeType";
    }
    interface BooleanAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$BooleanAttributeType";
    }
    interface DateTimeAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$DateTimeAttributeType";
        localizeDate: boolean;
    }
    interface EnumerationAttributeTypeCreationOptions {
        enumeration?: string;
    }
    interface EnumerationAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$EnumerationAttributeType";
        $CreationOptions?: EnumerationAttributeTypeCreationOptions;
        enumeration: string;
    }
    interface HashedStringAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$HashedStringAttributeType";
    }
    interface StringAttributeType extends AttributeTypeBase {
        $Type: "DomainModels$StringAttributeType";
        length: number;
    }
    interface NumericAttributeTypeBaseBase extends AttributeTypeBase {
    }
    interface DecimalAttributeTypeBaseBase extends NumericAttributeTypeBaseBase {
    }
    interface DecimalAttributeType extends DecimalAttributeTypeBaseBase {
        $Type: "DomainModels$DecimalAttributeType";
    }
    interface IntegerAttributeTypeBaseBase extends NumericAttributeTypeBaseBase {
    }
    interface IntegerAttributeType extends IntegerAttributeTypeBaseBase {
        $Type: "DomainModels$IntegerAttributeType";
    }
    interface LongAttributeType extends IntegerAttributeTypeBaseBase {
        $Type: "DomainModels$LongAttributeType";
    }
    interface AutoNumberAttributeType extends IntegerAttributeTypeBaseBase {
        $Type: "DomainModels$AutoNumberAttributeType";
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/associations relevant section in reference guide}
     */
    interface AssociationBaseBase extends Primitives.ElementBase {
        name: string;
        dataStorageGuid: string;
        type: AssociationType;
        owner: AssociationOwner;
        storageFormat: AssociationStorage;
        deleteBehavior: AssociationDeleteBehavior;
        parent: string;
        documentation: string;
        source: AssociationSource | null;
    }
    interface AssociationCreationOptions {
        name: string;
        parentEntity?: Entity;
        childEntity?: Entity;
        multiplicity?: "one_to_one" | "one_to_many" | "many_to_many";
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/associations relevant section in reference guide}
     */
    interface Association extends AssociationBaseBase {
        $Type: "DomainModels$Association";
        $CreationOptions?: AssociationCreationOptions;
        child: string;
        parentConnection: Primitives.Location;
        childConnection: Primitives.Location;
        getContainer(): DomainModel;
        delete(): void;
    }
    interface CrossAssociationCreationOptions {
        name: string;
    }
    interface CrossAssociation extends AssociationBaseBase {
        $Type: "DomainModels$CrossAssociation";
        $CreationOptions?: CrossAssociationCreationOptions;
        child: string;
        getContainer(): DomainModel;
        delete(): void;
    }
    interface AssociationSourceBase extends Primitives.ElementBase {
        getContainer(): AssociationBase;
        delete(): void;
    }
    interface RemoteAssociationSource extends AssociationSourceBase {
    }
    interface OqlViewAssociationSource extends AssociationSourceBase {
        $Type: "DomainModels$OqlViewAssociationSource";
        reference: string;
    }
    interface AssociationDeleteBehavior extends Primitives.ElementBase {
        $Type: "DomainModels$AssociationDeleteBehavior";
        parentDeleteBehavior: DeletingBehavior;
        childDeleteBehavior: DeletingBehavior;
        parentErrorMessage: Texts.Text | null;
        childErrorMessage: Texts.Text | null;
        getContainer(): AssociationBase;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/annotations relevant section in reference guide}
     */
    interface Annotation extends Primitives.ElementBase {
        $Type: "DomainModels$Annotation";
        caption: string;
        location: Primitives.Location;
        width: number;
        getContainer(): DomainModel;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/access-rules relevant section in reference guide}
     */
    interface AccessRule extends Primitives.ElementBase {
        $Type: "DomainModels$AccessRule";
        memberAccesses: MemberAccess[];
        moduleRoles: string[];
        documentation: string;
        allowCreate: boolean;
        allowDelete: boolean;
        defaultMemberAccessRights: MemberAccessRights;
        xPathConstraintCaption: string;
        xPathConstraint: string | null;
        addMemberAccess(): Promise<MemberAccess>;
    }
    interface MemberAccess extends Primitives.ElementBase {
        $Type: "DomainModels$MemberAccess";
        attribute: string | null;
        association: string | null;
        accessRights: MemberAccessRights;
        getContainer(): AccessRule;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/event-handlers relevant section in reference guide}
     */
    interface EventHandler extends Primitives.ElementBase {
        $Type: "DomainModels$EventHandler";
        moment: ActionMoment;
        event: EventType;
        microflow: string | null;
        raiseErrorOnFalse: boolean;
        passEventObject: boolean;
        getContainer(): Entity;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/indexes relevant section in reference guide}
     */
    interface Index extends Primitives.ElementBase {
        $Type: "DomainModels$Index";
        dataStorageGuid: string;
        attributes: IndexedAttribute[];
        includeInOffline: boolean;
        getContainer(): Entity;
        delete(): void;
        addIndexedAttribute(): Promise<IndexedAttribute>;
    }
    interface IndexedAttribute extends Primitives.ElementBase {
        $Type: "DomainModels$IndexedAttribute";
        type: IndexedAttributeType;
        attribute: string | null;
        ascending: boolean;
        getContainer(): Index;
        delete(): void;
    }
    /**
     * See: {@link https://docs.mendix.com/refguide/validation-rules relevant section in reference guide}
     */
    interface ValidationRule extends Primitives.ElementBase {
        $Type: "DomainModels$ValidationRule";
        attribute: string;
        errorMessage: Texts.Text;
        ruleInfo: RuleInfo;
        getContainer(): Entity;
        delete(): void;
    }
    interface RuleInfoBase extends Primitives.ElementBase {
        getContainer(): ValidationRule;
        delete(): void;
    }
    interface EqualsToRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$EqualsToRuleInfo";
        useValue: boolean;
        equalsToValue: string;
        equalsToAttribute: string | null;
    }
    interface MaxLengthRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$MaxLengthRuleInfo";
        maxLength: number;
    }
    interface RangeRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$RangeRuleInfo";
        typeOfRange: RangeType;
        useMinValue: boolean;
        useMaxValue: boolean;
        minValue: string;
        maxValue: string;
        minAttribute: string | null;
        maxAttribute: string | null;
    }
    interface RegExRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$RegExRuleInfo";
        regularExpression: string | null;
    }
    interface RequiredRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$RequiredRuleInfo";
    }
    interface UniqueRuleInfo extends RuleInfoBase {
        $Type: "DomainModels$UniqueRuleInfo";
    }
    interface EntityRefBase extends Primitives.ElementBase {
    }
    interface DirectEntityRef extends EntityRefBase {
        $Type: "DomainModels$DirectEntityRef";
        entity: string;
    }
    interface IndirectEntityRef extends EntityRefBase {
        $Type: "DomainModels$IndirectEntityRef";
        steps: EntityRefStep[];
        addEntityRefStep(): Promise<EntityRefStep>;
    }
    interface EntityRefStep extends Primitives.ElementBase {
        $Type: "DomainModels$EntityRefStep";
        association: string;
        destinationEntity: string;
        getContainer(): IndirectEntityRef;
        delete(): void;
    }
    interface MemberRefBase extends Primitives.ElementBase {
        entityRef: IndirectEntityRef | null;
    }
    interface AttributeRef extends MemberRefBase {
        $Type: "DomainModels$AttributeRef";
        attribute: string;
    }
    interface AssociationRef extends MemberRefBase {
        $Type: "DomainModels$AssociationRef";
        association: string;
    }
    type EnvironmentType = "Production" | "Sandbox" | "NonProduction" | "Unknown";
    type AssociationType = "Reference" | "ReferenceSet";
    type AssociationOwner = "Default" | "Both";
    type AssociationStorage = "Table" | "Column";
    type DeletingBehavior = "DeleteMeAndReferences" | "DeleteMeButKeepReferences" | "DeleteMeIfNoReferences";
    type Navigability = "BothDirections" | "ParentToChild";
    type MemberAccessRights = "None" | "ReadOnly" | "ReadWrite";
    type ActionMoment = "Before" | "After";
    type EventType = "Create" | "Commit" | "Delete" | "RollBack";
    type IndexedAttributeType = "Normal" | "CreatedDate" | "ChangedDate";
    type RangeType = "GreaterThanOrEqualTo" | "SmallerThanOrEqualTo" | "Between";
}
//# sourceMappingURL=DomainModels.gen.d.ts.map