import { Primitives } from '@mendix/model-access';
export declare namespace DataTypes {
    /**
     * See: {@link https://docs.mendix.com/refguide/data-types relevant section in reference guide}
     */
    type DataType = UnknownType | VoidType | EmptyType | BooleanType | BinaryType | DecimalType | IntegerType | FloatType | DateTimeType | StringType | EnumerationType | EntityType;
    type EntityType = ObjectType | ListType;
    /**
     * See: {@link https://docs.mendix.com/refguide/data-types relevant section in reference guide}
     */
    interface DataTypeBase extends Primitives.ElementBase {
    }
    interface UnknownType extends DataTypeBase {
        $Type: "DataTypes$UnknownType";
    }
    interface VoidType extends DataTypeBase {
        $Type: "DataTypes$VoidType";
    }
    interface EmptyType extends DataTypeBase {
        $Type: "DataTypes$EmptyType";
    }
    interface BooleanType extends DataTypeBase {
        $Type: "DataTypes$BooleanType";
    }
    interface BinaryType extends DataTypeBase {
        $Type: "DataTypes$BinaryType";
    }
    interface DecimalType extends DataTypeBase {
        $Type: "DataTypes$DecimalType";
    }
    interface IntegerType extends DataTypeBase {
        $Type: "DataTypes$IntegerType";
    }
    interface FloatType extends DataTypeBase {
        $Type: "DataTypes$FloatType";
    }
    interface DateTimeType extends DataTypeBase {
        $Type: "DataTypes$DateTimeType";
    }
    interface StringType extends DataTypeBase {
        $Type: "DataTypes$StringType";
    }
    interface EnumerationType extends DataTypeBase {
        $Type: "DataTypes$EnumerationType";
        enumeration: string;
    }
    interface EntityTypeBase extends DataTypeBase {
        entity: string;
    }
    interface ObjectType extends EntityTypeBase {
        $Type: "DataTypes$ObjectType";
    }
    interface ListType extends EntityTypeBase {
        $Type: "DataTypes$ListType";
    }
}
//# sourceMappingURL=DataTypes.gen.d.ts.map