import { Primitives } from '@mendix/model-access';
import { DomainModels } from './DomainModels.gen';
import { Pages } from './Pages.gen';
import { Texts } from './Texts.gen';
export declare namespace CustomWidgets {
    interface CustomWidgetCreationOptions {
        name: string;
    }
    interface CustomWidget extends Pages.WidgetBase {
        $Type: "CustomWidgets$CustomWidget";
        $CreationOptions?: CustomWidgetCreationOptions;
        type: CustomWidgetType | null;
        object: WidgetObject | null;
        labelTemplate: Pages.ClientTemplate | null;
        conditionalEditabilitySettings: Pages.ConditionalEditabilitySettings | null;
        editable: Pages.EditableEnum;
        conditionalVisibilitySettings: Pages.ConditionalVisibilitySettings | null;
    }
    interface CustomWidgetTypeCreationOptions {
        name: string;
    }
    interface CustomWidgetType extends Primitives.ElementBase {
        $Type: "CustomWidgets$CustomWidgetType";
        $CreationOptions?: CustomWidgetTypeCreationOptions;
        widgetId: string;
        needsEntityContext: boolean;
        pluginWidget: boolean;
        name: string;
        description: string;
        studioProCategory: string;
        studioCategory: string;
        offlineCapable: boolean;
        objectType: WidgetObjectType;
        helpUrl: string;
        getContainer(): CustomWidget;
        delete(): void;
    }
    interface WidgetEnumerationValue extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetEnumerationValue";
        key: string;
        caption: string;
        getContainer(): WidgetValueType;
        delete(): void;
    }
    interface WidgetObject extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetObject";
        type: string | null;
        properties: WidgetProperty[];
        addWidgetProperty(): Promise<WidgetProperty>;
    }
    interface WidgetObjectType extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetObjectType";
        propertyTypes: WidgetPropertyType[];
        addWidgetPropertyType(): Promise<WidgetPropertyType>;
    }
    interface WidgetProperty extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetProperty";
        type: string | null;
        value: WidgetValue | null;
        getContainer(): WidgetObject;
        delete(): void;
    }
    interface WidgetPropertyType extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetPropertyType";
        key: string;
        category: string;
        caption: string;
        description: string;
        isDefault: boolean;
        valueType: WidgetValueType | null;
        getContainer(): WidgetObjectType;
        delete(): void;
    }
    interface WidgetReturnType extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetReturnType";
        type: WidgetReturnTypeEnum;
        isList: boolean;
        entityProperty: string;
        assignableTo: string;
        getContainer(): WidgetValueType;
        delete(): void;
    }
    interface WidgetTranslation extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetTranslation";
        languageCode: string;
        text: string;
        getContainer(): WidgetValueType;
        delete(): void;
    }
    interface WidgetActionVariable extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetActionVariable";
        key: string;
        type: WidgetReturnTypeEnum;
        caption: string;
        getContainer(): WidgetValueType;
        delete(): void;
    }
    interface WidgetValue extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetValue";
        type: string;
        primitiveValue: string;
        entityRef: DomainModels.EntityRef | null;
        attributeRef: DomainModels.AttributeRef | null;
        page: string | null;
        microflow: string | null;
        nanoflow: string | null;
        icon: Pages.Icon | null;
        image: string | null;
        translatableValue: Texts.Text | null;
        textTemplate: Pages.ClientTemplate | null;
        xPathConstraint: string | null;
        objects: WidgetObject[];
        action: Pages.ClientAction;
        expression: string | null;
        widgets: Pages.Widget[];
        dataSource: Pages.DataSource | null;
        sourceVariable: Pages.PageVariable | null;
        selection: CustomWidgetSelectionType;
        getContainer(): WidgetProperty;
        delete(): void;
        addWidgetObject(): Promise<WidgetObject>;
    }
    interface WidgetValueType extends Primitives.ElementBase {
        $Type: "CustomWidgets$WidgetValueType";
        type: WidgetValueTypeEnum;
        isList: boolean;
        isLinked: boolean;
        isMetaData: boolean;
        entityProperty: string;
        allowNonPersistableEntities: boolean;
        isPath: IsPath;
        pathType: PathType;
        parameterIsList: boolean;
        multiline: boolean;
        defaultValue: string;
        required: boolean;
        onChangeProperty: string;
        dataSourceProperty: string;
        selectableObjectsProperty: string;
        attributeTypes: CustomWidgetAttributeType[];
        associationTypes: CustomWidgetAssociationType[];
        selectionTypes: CustomWidgetSelectionType[];
        enumerationValues: WidgetEnumerationValue[];
        actionVariables: WidgetActionVariable[];
        objectType: WidgetObjectType | null;
        returnType: WidgetReturnType | null;
        translations: WidgetTranslation[];
        setLabel: boolean;
        defaultType: DefaultTypeEnum;
        getContainer(): WidgetPropertyType;
        delete(): void;
        addWidgetEnumerationValue(): Promise<WidgetEnumerationValue>;
        addWidgetActionVariable(): Promise<WidgetActionVariable>;
        addWidgetTranslation(): Promise<WidgetTranslation>;
    }
    interface CustomWidgetXPathSource extends Pages.XPathSourceBaseBase {
        $Type: "CustomWidgets$CustomWidgetXPathSource";
    }
    type CustomWidgetAttributeType = "AutoNumber" | "Binary" | "Boolean" | "Currency" | "DateTime" | "Enum" | "Float" | "HashString" | "Integer" | "Long" | "String" | "Decimal";
    type CustomWidgetAssociationType = "Reference" | "ReferenceSet";
    type CustomWidgetSelectionType = "None" | "Single" | "Multi";
    type IsPath = "No" | "Optional" | "Yes";
    type PathType = "None" | "Reference" | "ReferenceSet";
    type WidgetReturnTypeEnum = "None" | "Void" | "Boolean" | "Integer" | "Float" | "DateTime" | "String" | "Object" | "Decimal";
    type WidgetValueTypeEnum = "Action" | "Attribute" | "Association" | "Boolean" | "DataSource" | "Entity" | "EntityConstraint" | "Enumeration" | "Expression" | "File" | "Form" | "Icon" | "Image" | "Integer" | "Decimal" | "Microflow" | "Nanoflow" | "Object" | "String" | "Selection" | "TranslatableString" | "TextTemplate" | "System" | "Widgets";
    type SystemPropertyEnum = "Label" | "Name" | "TabIndex" | "Editability" | "Visibility";
    type DefaultTypeEnum = "None" | "CallMicroflow" | "CallNanoflow" | "OpenPage" | "Database" | "Microflow" | "Nanoflow" | "Association";
}
//# sourceMappingURL=CustomWidgets.gen.d.ts.map