declare const _default: {
  "DomainModels$DomainModel": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$DomainModel"
    ],
    "properties": {
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "entities": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "PART"
      },
      "annotations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$Annotation",
        "kind": "PART"
      },
      "associations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$Association",
        "kind": "PART"
      },
      "crossAssociations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$CrossAssociation",
        "kind": "PART"
      }
    }
  },
  "DomainModels$Entity": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Entity"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "dataStorageGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "GUID"
      },
      "location": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "POINT"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "generalization": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$GeneralizationBase",
        "kind": "PART"
      },
      "attributes": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "PART"
      },
      "validationRules": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$ValidationRule",
        "kind": "PART"
      },
      "eventHandlers": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$EventHandler",
        "kind": "PART"
      },
      "indexes": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$Index",
        "kind": "PART"
      },
      "accessRules": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$AccessRule",
        "kind": "PART"
      },
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      },
      "imageData": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BLOB"
      },
      "source": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntitySource",
        "kind": "PART"
      }
    }
  },
  "DomainModels$EntitySource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$OqlViewEntitySource",
      "DomainModels$QueryBasedRemoteEntitySource",
      "DomainModels$RemoteEntitySource",
      "DomainModels$ViewEntitySource"
    ]
  },
  "DomainModels$RemoteEntitySource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$EntitySource"
    ],
    "allCompatibleTypes": [
      "DomainModels$QueryBasedRemoteEntitySource"
    ]
  },
  "DomainModels$QueryBasedRemoteEntitySource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$EntitySource",
      "DomainModels$RemoteEntitySource"
    ],
    "allCompatibleTypes": []
  },
  "DomainModels$ViewEntitySource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$EntitySource"
    ],
    "allCompatibleTypes": [
      "DomainModels$OqlViewEntitySource"
    ]
  },
  "DomainModels$OqlViewEntitySource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$EntitySource",
      "DomainModels$ViewEntitySource"
    ],
    "allCompatibleTypes": [
      "DomainModels$OqlViewEntitySource"
    ],
    "properties": {
      "sourceDocument": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$ViewEntitySourceDocument",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$GeneralizationBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Generalization",
      "DomainModels$NoGeneralization"
    ]
  },
  "DomainModels$Generalization": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$GeneralizationBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$Generalization"
    ],
    "properties": {
      "generalization": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$NoGeneralization": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$GeneralizationBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$NoGeneralization"
    ],
    "properties": {
      "hasChangedDate": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "hasCreatedDate": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "hasOwner": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "hasChangedBy": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "persistable": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$EntityKey": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$EntityKey"
    ],
    "properties": {
      "parts": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityKeyPart",
        "kind": "PART"
      }
    }
  },
  "DomainModels$EntityKeyPart": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$EntityKeyPart"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeType",
        "kind": "PART"
      }
    }
  },
  "DomainModels$RemoteEntitySourceDocument": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [],
    "properties": {
      "description": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "catalogUrl": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "icon": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BLOB"
      },
      "metadata": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "metadataUrl": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "serviceName": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "version": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "endpointId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "minimumMxVersion": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "recommendedMxVersion": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "applicationId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "environmentType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Production",
          "Sandbox",
          "NonProduction",
          "Unknown"
        ]
      },
      "metadataHash": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "validated": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "validatedEntities": {
        "list": true,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$ViewEntitySourceDocument": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$ViewEntitySourceDocument"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$Attribute": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Attribute"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "dataStorageGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "GUID"
      },
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeType",
        "kind": "PART"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "value": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$ValueType",
        "kind": "PART"
      }
    }
  },
  "DomainModels$ValueType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$CalculatedValue",
      "DomainModels$MappedValue",
      "DomainModels$OqlViewValue",
      "DomainModels$StoredValue"
    ]
  },
  "DomainModels$StoredValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$ValueType"
    ],
    "allCompatibleTypes": [
      "DomainModels$StoredValue"
    ],
    "properties": {
      "defaultValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$CalculatedValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$ValueType"
    ],
    "allCompatibleTypes": [
      "DomainModels$CalculatedValue"
    ],
    "properties": {
      "microflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Microflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "passEntity": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$OqlViewValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$ValueType"
    ],
    "allCompatibleTypes": [
      "DomainModels$OqlViewValue"
    ],
    "properties": {
      "reference": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$MappedValue": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$ValueType"
    ],
    "allCompatibleTypes": [],
    "properties": {
      "defaultValueDesignTime": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$AttributeType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$AutoNumberAttributeType",
      "DomainModels$BinaryAttributeType",
      "DomainModels$BooleanAttributeType",
      "DomainModels$DateTimeAttributeType",
      "DomainModels$DecimalAttributeType",
      "DomainModels$DecimalAttributeTypeBase",
      "DomainModels$EnumerationAttributeType",
      "DomainModels$HashedStringAttributeType",
      "DomainModels$IntegerAttributeType",
      "DomainModels$IntegerAttributeTypeBase",
      "DomainModels$LongAttributeType",
      "DomainModels$NumericAttributeTypeBase",
      "DomainModels$StringAttributeType"
    ]
  },
  "DomainModels$BinaryAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$BinaryAttributeType"
    ]
  },
  "DomainModels$BooleanAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$BooleanAttributeType"
    ]
  },
  "DomainModels$DateTimeAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$DateTimeAttributeType"
    ],
    "properties": {
      "localizeDate": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$EnumerationAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$EnumerationAttributeType"
    ],
    "properties": {
      "enumeration": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Enumerations$Enumeration",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$HashedStringAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$HashedStringAttributeType"
    ]
  },
  "DomainModels$StringAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$StringAttributeType"
    ],
    "properties": {
      "length": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "DomainModels$NumericAttributeTypeBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$AttributeType"
    ],
    "allCompatibleTypes": [
      "DomainModels$AutoNumberAttributeType",
      "DomainModels$DecimalAttributeType",
      "DomainModels$DecimalAttributeTypeBase",
      "DomainModels$IntegerAttributeType",
      "DomainModels$IntegerAttributeTypeBase",
      "DomainModels$LongAttributeType"
    ]
  },
  "DomainModels$DecimalAttributeTypeBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$DecimalAttributeType"
    ]
  },
  "DomainModels$DecimalAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$DecimalAttributeTypeBase",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$DecimalAttributeType"
    ]
  },
  "DomainModels$IntegerAttributeTypeBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$AutoNumberAttributeType",
      "DomainModels$IntegerAttributeType",
      "DomainModels$LongAttributeType"
    ]
  },
  "DomainModels$IntegerAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$IntegerAttributeTypeBase",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$IntegerAttributeType"
    ]
  },
  "DomainModels$LongAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$IntegerAttributeTypeBase",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$LongAttributeType"
    ]
  },
  "DomainModels$AutoNumberAttributeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AttributeType",
      "DomainModels$IntegerAttributeTypeBase",
      "DomainModels$NumericAttributeTypeBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$AutoNumberAttributeType"
    ]
  },
  "DomainModels$AssociationBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Association",
      "DomainModels$CrossAssociation"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "dataStorageGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "GUID"
      },
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Reference",
          "ReferenceSet"
        ]
      },
      "owner": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Default",
          "Both"
        ]
      },
      "storageFormat": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Table",
          "Column"
        ]
      },
      "deleteBehavior": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AssociationDeleteBehavior",
        "kind": "PART"
      },
      "parent": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_ID_REFERENCE"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "source": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AssociationSource",
        "kind": "PART"
      }
    }
  },
  "DomainModels$Association": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AssociationBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$Association"
    ],
    "properties": {
      "child": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_ID_REFERENCE"
      },
      "parentConnection": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "POINT"
      },
      "childConnection": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "POINT"
      }
    }
  },
  "DomainModels$CrossAssociation": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AssociationBase"
    ],
    "allCompatibleTypes": [
      "DomainModels$CrossAssociation"
    ],
    "properties": {
      "child": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$AssociationSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$OqlViewAssociationSource",
      "DomainModels$RemoteAssociationSource"
    ]
  },
  "DomainModels$RemoteAssociationSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DomainModels$AssociationSource"
    ],
    "allCompatibleTypes": []
  },
  "DomainModels$OqlViewAssociationSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$AssociationSource"
    ],
    "allCompatibleTypes": [
      "DomainModels$OqlViewAssociationSource"
    ],
    "properties": {
      "reference": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$AssociationDeleteBehavior": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$AssociationDeleteBehavior"
    ],
    "properties": {
      "parentDeleteBehavior": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "DeleteMeAndReferences",
          "DeleteMeButKeepReferences",
          "DeleteMeIfNoReferences"
        ]
      },
      "childDeleteBehavior": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "DeleteMeAndReferences",
          "DeleteMeButKeepReferences",
          "DeleteMeIfNoReferences"
        ]
      },
      "parentErrorMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "childErrorMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "DomainModels$Annotation": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Annotation"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "location": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "POINT"
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "DomainModels$AccessRule": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$AccessRule"
    ],
    "properties": {
      "memberAccesses": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$MemberAccess",
        "kind": "PART"
      },
      "moduleRoles": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Security$ModuleRole",
        "kind": "BY_NAME_REFERENCE"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "allowCreate": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "allowDelete": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "defaultMemberAccessRights": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "ReadOnly",
          "ReadWrite"
        ]
      },
      "xPathConstraintCaption": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "DomainModels$MemberAccess": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$MemberAccess"
    ],
    "properties": {
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      },
      "association": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AssociationBase",
        "kind": "BY_NAME_REFERENCE"
      },
      "accessRights": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "ReadOnly",
          "ReadWrite"
        ]
      }
    }
  },
  "DomainModels$EventHandler": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$EventHandler"
    ],
    "properties": {
      "moment": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Before",
          "After"
        ]
      },
      "event": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Create",
          "Commit",
          "Delete",
          "RollBack"
        ]
      },
      "microflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Microflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "raiseErrorOnFalse": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "passEventObject": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$Index": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$Index"
    ],
    "properties": {
      "dataStorageGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "GUID"
      },
      "attributes": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$IndexedAttribute",
        "kind": "PART"
      },
      "includeInOffline": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$IndexedAttribute": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$IndexedAttribute"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Normal",
          "CreatedDate",
          "ChangedDate"
        ]
      },
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_ID_REFERENCE"
      },
      "ascending": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "DomainModels$ValidationRule": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$ValidationRule"
    ],
    "properties": {
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      },
      "errorMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "ruleInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$RuleInfo",
        "kind": "PART"
      }
    }
  },
  "DomainModels$RuleInfo": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$EqualsToRuleInfo",
      "DomainModels$MaxLengthRuleInfo",
      "DomainModels$RangeRuleInfo",
      "DomainModels$RegExRuleInfo",
      "DomainModels$RequiredRuleInfo",
      "DomainModels$UniqueRuleInfo"
    ]
  },
  "DomainModels$EqualsToRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$EqualsToRuleInfo"
    ],
    "properties": {
      "useValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "equalsToValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "equalsToAttribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$MaxLengthRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$MaxLengthRuleInfo"
    ],
    "properties": {
      "maxLength": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "DomainModels$RangeRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$RangeRuleInfo"
    ],
    "properties": {
      "typeOfRange": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "GreaterThanOrEqualTo",
          "SmallerThanOrEqualTo",
          "Between"
        ]
      },
      "useMinValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "useMaxValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "minValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "maxValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "minAttribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      },
      "maxAttribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$RegExRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$RegExRuleInfo"
    ],
    "properties": {
      "regularExpression": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "RegularExpressions$RegularExpression",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$RequiredRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$RequiredRuleInfo"
    ]
  },
  "DomainModels$UniqueRuleInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$RuleInfo"
    ],
    "allCompatibleTypes": [
      "DomainModels$UniqueRuleInfo"
    ]
  },
  "DomainModels$EntityRef": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$DirectEntityRef",
      "DomainModels$IndirectEntityRef"
    ]
  },
  "DomainModels$DirectEntityRef": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$EntityRef"
    ],
    "allCompatibleTypes": [
      "DomainModels$DirectEntityRef"
    ],
    "properties": {
      "entity": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$IndirectEntityRef": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$EntityRef"
    ],
    "allCompatibleTypes": [
      "DomainModels$IndirectEntityRef"
    ],
    "properties": {
      "steps": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRefStep",
        "kind": "PART"
      }
    }
  },
  "DomainModels$EntityRefStep": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$EntityRefStep"
    ],
    "properties": {
      "association": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AssociationBase",
        "kind": "BY_NAME_REFERENCE"
      },
      "destinationEntity": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$MemberRef": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DomainModels$AssociationRef",
      "DomainModels$AttributeRef"
    ],
    "properties": {
      "entityRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$IndirectEntityRef",
        "kind": "PART"
      }
    }
  },
  "DomainModels$AttributeRef": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$MemberRef"
    ],
    "allCompatibleTypes": [
      "DomainModels$AttributeRef"
    ],
    "properties": {
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DomainModels$AssociationRef": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DomainModels$MemberRef"
    ],
    "allCompatibleTypes": [
      "DomainModels$AssociationRef"
    ],
    "properties": {
      "association": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AssociationBase",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Texts$Text": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Texts$Text"
    ],
    "properties": {
      "translations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Texts$Translation",
        "kind": "PART"
      }
    }
  },
  "Texts$Translation": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Texts$Translation"
    ],
    "properties": {
      "languageCode": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "text": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Texts$SystemText": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Texts$SystemText"
    ],
    "properties": {
      "text": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "key": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Texts$SystemTextCollection": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Texts$SystemTextCollection"
    ],
    "properties": {
      "systemTexts": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Texts$SystemText",
        "kind": "PART"
      }
    }
  },
  "Url$UrlSegment": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Url$StaticUrlSegment"
    ]
  },
  "Url$StaticUrlSegment": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Url$UrlSegment"
    ],
    "allCompatibleTypes": [
      "Url$StaticUrlSegment"
    ],
    "properties": {
      "segment": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Enumerations$Enumeration": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Enumerations$Enumeration"
    ],
    "properties": {
      "values": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Enumerations$EnumerationValue",
        "kind": "PART"
      },
      "remoteSource": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Enumerations$RemoteEnumerationSource",
        "kind": "PART"
      },
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Enumerations$EnumerationValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Enumerations$EnumerationValue"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      },
      "remoteValue": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Enumerations$RemoteEnumerationValue",
        "kind": "PART"
      }
    }
  },
  "Enumerations$Condition": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Enumerations$Condition"
    ],
    "properties": {
      "attributeValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "editableVisible": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Enumerations$RemoteEnumerationSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": []
  },
  "Enumerations$RemoteEnumerationValue": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": []
  },
  "DataTypes$DataType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "DataTypes$BinaryType",
      "DataTypes$BooleanType",
      "DataTypes$DateTimeType",
      "DataTypes$DecimalType",
      "DataTypes$EmptyType",
      "DataTypes$EntityType",
      "DataTypes$EnumerationType",
      "DataTypes$FloatType",
      "DataTypes$IntegerType",
      "DataTypes$ListType",
      "DataTypes$ObjectType",
      "DataTypes$StringType",
      "DataTypes$UnknownType",
      "DataTypes$VoidType"
    ]
  },
  "DataTypes$UnknownType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$UnknownType"
    ]
  },
  "DataTypes$VoidType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$VoidType"
    ]
  },
  "DataTypes$EmptyType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$EmptyType"
    ]
  },
  "DataTypes$BooleanType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$BooleanType"
    ]
  },
  "DataTypes$BinaryType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$BinaryType"
    ]
  },
  "DataTypes$DecimalType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$DecimalType"
    ]
  },
  "DataTypes$IntegerType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$IntegerType"
    ]
  },
  "DataTypes$FloatType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$FloatType"
    ]
  },
  "DataTypes$DateTimeType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$DateTimeType"
    ]
  },
  "DataTypes$StringType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$StringType"
    ]
  },
  "DataTypes$EnumerationType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$EnumerationType"
    ],
    "properties": {
      "enumeration": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Enumerations$Enumeration",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DataTypes$EntityType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "DataTypes$DataType"
    ],
    "allCompatibleTypes": [
      "DataTypes$ListType",
      "DataTypes$ObjectType"
    ],
    "properties": {
      "entity": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "DataTypes$ObjectType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType",
      "DataTypes$EntityType"
    ],
    "allCompatibleTypes": [
      "DataTypes$ObjectType"
    ]
  },
  "DataTypes$ListType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "DataTypes$DataType",
      "DataTypes$EntityType"
    ],
    "allCompatibleTypes": [
      "DataTypes$ListType"
    ]
  },
  "CustomWidgets$CustomWidget": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "CustomWidgets$CustomWidget"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$CustomWidgetType",
        "kind": "PART"
      },
      "object": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetObject",
        "kind": "PART"
      },
      "labelTemplate": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "conditionalEditabilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalEditabilitySettings",
        "kind": "PART"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      }
    }
  },
  "CustomWidgets$CustomWidgetType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$CustomWidgetType"
    ],
    "properties": {
      "widgetId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "needsEntityContext": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "pluginWidget": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "description": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "studioProCategory": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "studioCategory": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "offlineCapable": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "objectType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetObjectType",
        "kind": "PART"
      },
      "helpUrl": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "CustomWidgets$WidgetEnumerationValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetEnumerationValue"
    ],
    "properties": {
      "key": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "caption": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "CustomWidgets$WidgetObject": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetObject"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetObjectType",
        "kind": "BY_ID_REFERENCE"
      },
      "properties": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetProperty",
        "kind": "PART"
      }
    }
  },
  "CustomWidgets$WidgetObjectType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetObjectType"
    ],
    "properties": {
      "propertyTypes": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetPropertyType",
        "kind": "PART"
      }
    }
  },
  "CustomWidgets$WidgetProperty": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetProperty"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetPropertyType",
        "kind": "BY_ID_REFERENCE"
      },
      "value": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetValue",
        "kind": "PART"
      }
    }
  },
  "CustomWidgets$WidgetPropertyType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetPropertyType"
    ],
    "properties": {
      "key": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "category": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "caption": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "description": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "isDefault": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "valueType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetValueType",
        "kind": "PART"
      }
    }
  },
  "CustomWidgets$WidgetReturnType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetReturnType"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Void",
          "Boolean",
          "Integer",
          "Float",
          "DateTime",
          "String",
          "Object",
          "Decimal"
        ]
      },
      "isList": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "entityProperty": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "assignableTo": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "CustomWidgets$WidgetTranslation": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetTranslation"
    ],
    "properties": {
      "languageCode": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "text": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "CustomWidgets$WidgetActionVariable": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetActionVariable"
    ],
    "properties": {
      "key": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Void",
          "Boolean",
          "Integer",
          "Float",
          "DateTime",
          "String",
          "Object",
          "Decimal"
        ]
      },
      "caption": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "CustomWidgets$WidgetValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetValue"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetValueType",
        "kind": "BY_ID_REFERENCE"
      },
      "primitiveValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "entityRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRef",
        "kind": "PART"
      },
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "page": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Page",
        "kind": "BY_NAME_REFERENCE"
      },
      "microflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Microflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "nanoflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Nanoflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "icon": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Icon",
        "kind": "PART"
      },
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      },
      "translatableValue": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "textTemplate": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "objects": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetObject",
        "kind": "PART"
      },
      "action": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "dataSource": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$DataSource",
        "kind": "PART"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      },
      "selection": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Single",
          "Multi"
        ]
      }
    }
  },
  "CustomWidgets$WidgetValueType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "CustomWidgets$WidgetValueType"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Action",
          "Attribute",
          "Association",
          "Boolean",
          "DataSource",
          "Entity",
          "EntityConstraint",
          "Enumeration",
          "Expression",
          "File",
          "Form",
          "Icon",
          "Image",
          "Integer",
          "Decimal",
          "Microflow",
          "Nanoflow",
          "Object",
          "String",
          "Selection",
          "TranslatableString",
          "TextTemplate",
          "System",
          "Widgets"
        ]
      },
      "isList": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "isLinked": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "isMetaData": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "entityProperty": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "allowNonPersistableEntities": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "isPath": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "No",
          "Optional",
          "Yes"
        ]
      },
      "pathType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Reference",
          "ReferenceSet"
        ]
      },
      "parameterIsList": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "multiline": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "defaultValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "required": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "onChangeProperty": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "dataSourceProperty": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "selectableObjectsProperty": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "attributeTypes": {
        "list": true,
        "type": "ENUMERATION",
        "values": [
          "AutoNumber",
          "Binary",
          "Boolean",
          "Currency",
          "DateTime",
          "Enum",
          "Float",
          "HashString",
          "Integer",
          "Long",
          "String",
          "Decimal"
        ]
      },
      "associationTypes": {
        "list": true,
        "type": "ENUMERATION",
        "values": [
          "Reference",
          "ReferenceSet"
        ]
      },
      "selectionTypes": {
        "list": true,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Single",
          "Multi"
        ]
      },
      "enumerationValues": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetEnumerationValue",
        "kind": "PART"
      },
      "actionVariables": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetActionVariable",
        "kind": "PART"
      },
      "objectType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetObjectType",
        "kind": "PART"
      },
      "returnType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetReturnType",
        "kind": "PART"
      },
      "translations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "CustomWidgets$WidgetTranslation",
        "kind": "PART"
      },
      "setLabel": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "defaultType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "CallMicroflow",
          "CallNanoflow",
          "OpenPage",
          "Database",
          "Microflow",
          "Nanoflow",
          "Association"
        ]
      }
    }
  },
  "CustomWidgets$CustomWidgetXPathSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$SortableEntityPathSource",
      "Pages$XPathSourceBase"
    ],
    "allCompatibleTypes": [
      "CustomWidgets$CustomWidgetXPathSource"
    ]
  },
  "Pages$FormBase": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$BuildingBlock",
      "Pages$Layout",
      "Pages$Page",
      "Pages$PageTemplate",
      "Pages$Snippet",
      "Pages$TemplateFormBase"
    ],
    "properties": {
      "canvasWidth": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "canvasHeight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$Page": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [
      "Pages$FormBase"
    ],
    "allCompatibleTypes": [
      "Pages$Page"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameters": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameter",
        "kind": "PART"
      },
      "layoutCall": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutCall",
        "kind": "PART"
      },
      "title": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "allowedRoles": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Security$ModuleRole",
        "kind": "BY_NAME_REFERENCE"
      },
      "popupCloseAction": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "popupWidth": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "popupHeight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "popupResizable": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "markAsUsed": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "url": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "variables": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LocalVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$ParameterAttributeUrlSegment": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Url$UrlSegment"
    ],
    "allCompatibleTypes": [
      "Pages$ParameterAttributeUrlSegment"
    ],
    "properties": {
      "pageParameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameter",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      },
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$ParameterIdUrlSegment": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Url$UrlSegment"
    ],
    "allCompatibleTypes": [
      "Pages$ParameterIdUrlSegment"
    ],
    "properties": {
      "pageParameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameter",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$PageParameter": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$PageParameter"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "parameterType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DataTypes$DataType",
        "kind": "PART"
      }
    }
  },
  "Pages$Layout": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [
      "Pages$FormBase"
    ],
    "allCompatibleTypes": [
      "Pages$Layout"
    ],
    "properties": {
      "parameters": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutParameter",
        "kind": "PART"
      },
      "content": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutContent",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      }
    }
  },
  "Pages$LayoutContent": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$NativeLayoutContent",
      "Pages$WebLayoutContent"
    ]
  },
  "Pages$WebLayoutContent": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$LayoutContent"
    ],
    "allCompatibleTypes": [
      "Pages$WebLayoutContent"
    ],
    "properties": {
      "layoutType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Responsive",
          "Tablet",
          "Phone",
          "ModalPopup",
          "Popup",
          "Legacy"
        ]
      },
      "layoutCall": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutCall",
        "kind": "PART"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$NativeLayoutContent": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$LayoutContent"
    ],
    "allCompatibleTypes": [
      "Pages$NativeLayoutContent"
    ],
    "properties": {
      "layoutType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Default",
          "TopLevel",
          "Popup"
        ]
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "rightHeaderPlaceholder": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Placeholder",
        "kind": "PART"
      },
      "showBottomBar": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "sidebar": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "sidebarWidgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$LayoutCall": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LayoutCall"
    ],
    "properties": {
      "layout": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Layout",
        "kind": "BY_NAME_REFERENCE"
      },
      "arguments": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutCallArgument",
        "kind": "PART"
      }
    }
  },
  "Pages$LayoutCallArgument": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LayoutCallArgument"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutParameter",
        "kind": "BY_NAME_REFERENCE"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$LayoutParameter": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LayoutParameter"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$Placeholder": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$Placeholder"
    ]
  },
  "Pages$TemplateFormBase": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [
      "Pages$FormBase"
    ],
    "allCompatibleTypes": [
      "Pages$BuildingBlock",
      "Pages$PageTemplate"
    ],
    "properties": {
      "displayName": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentationUrl": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "templateCategory": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "templateCategoryWeight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "imageData": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BLOB"
      }
    }
  },
  "Pages$BuildingBlock": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [
      "Pages$FormBase",
      "Pages$TemplateFormBase"
    ],
    "allCompatibleTypes": [
      "Pages$BuildingBlock"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "platform": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Web",
          "Native"
        ]
      }
    }
  },
  "Pages$TemplateType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$EditPageTemplateType",
      "Pages$RegularPageTemplateType",
      "Pages$SelectPageTemplateType",
      "Pages$UserTaskTemplateType",
      "Pages$WorkflowOverviewTemplateType",
      "Pages$WorkflowTemplateType"
    ]
  },
  "Pages$RegularPageTemplateType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$TemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$RegularPageTemplateType"
    ]
  },
  "Pages$EditPageTemplateType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$TemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$EditPageTemplateType"
    ]
  },
  "Pages$SelectPageTemplateType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$TemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$SelectPageTemplateType"
    ]
  },
  "Pages$PageTemplate": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [
      "Pages$FormBase",
      "Pages$TemplateFormBase"
    ],
    "allCompatibleTypes": [
      "Pages$PageTemplate"
    ],
    "properties": {
      "layoutCall": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutCall",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "templateType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$TemplateType",
        "kind": "PART"
      }
    }
  },
  "Pages$TemplatePlaceholder": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TemplatePlaceholder"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ClientAction": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$CallNanoflowClientAction",
      "Pages$CallWorkflowClientAction",
      "Pages$CancelChangesClientAction",
      "Pages$ClosePageClientAction",
      "Pages$CreateObjectClientAction",
      "Pages$DeleteClientAction",
      "Pages$MicroflowClientAction",
      "Pages$NoClientAction",
      "Pages$OpenLinkClientAction",
      "Pages$OpenUserTaskClientAction",
      "Pages$OpenWorkflowClientAction",
      "Pages$PageClientAction",
      "Pages$SaveChangesClientAction",
      "Pages$SetTaskOutcomeClientAction",
      "Pages$SignOutClientAction",
      "Pages$SyncClientAction"
    ],
    "properties": {
      "disabledDuringExecution": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$NoClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$NoClientAction"
    ]
  },
  "Pages$PageClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$PageClientAction"
    ],
    "properties": {
      "pageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      },
      "pagesForSpecializations": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$PageForSpecialization",
        "kind": "PART"
      },
      "numberOfPagesToClose2": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$MicroflowClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$MicroflowClientAction"
    ],
    "properties": {
      "microflowSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$MicroflowSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$CallNanoflowClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$CallNanoflowClientAction"
    ],
    "properties": {
      "nanoflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Nanoflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameterMappings": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$NanoflowParameterMapping",
        "kind": "PART"
      },
      "progressBar": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "NonBlocking",
          "Blocking"
        ]
      },
      "progressMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "confirmationInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConfirmationInfo",
        "kind": "PART"
      }
    }
  },
  "Pages$SignOutClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$SignOutClientAction"
    ]
  },
  "Pages$SaveChangesClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$SaveChangesClientAction"
    ],
    "properties": {
      "syncAutomatically": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "closePage": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$CancelChangesClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$CancelChangesClientAction"
    ],
    "properties": {
      "closePage": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$ClosePageClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$ClosePageClientAction"
    ],
    "properties": {
      "numberOfPagesToClose": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$SyncClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$SyncClientAction"
    ]
  },
  "Pages$OpenLinkClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$OpenLinkClientAction"
    ],
    "properties": {
      "linkType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Web",
          "Email",
          "Call",
          "Text"
        ]
      },
      "address": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$StaticOrDynamicString",
        "kind": "PART"
      }
    }
  },
  "Pages$DeleteClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$DeleteClientAction"
    ],
    "properties": {
      "closePage": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$CreateObjectClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$CreateObjectClientAction"
    ],
    "properties": {
      "entityRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRef",
        "kind": "PART"
      },
      "pageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      },
      "numberOfPagesToClose2": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$PageSettings": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$PageSettings"
    ],
    "properties": {
      "page": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Page",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameterMappings": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameterMapping",
        "kind": "PART"
      }
    }
  },
  "Pages$PageParameterMapping": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$PageParameterMapping"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameter",
        "kind": "BY_NAME_REFERENCE"
      },
      "variable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      },
      "argument": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$MicroflowSettings": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$MicroflowSettings"
    ],
    "properties": {
      "microflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Microflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameterMappings": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$MicroflowParameterMapping",
        "kind": "PART"
      },
      "progressBar": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "NonBlocking",
          "Blocking"
        ]
      },
      "progressMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "asynchronous": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "formValidations": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Widget",
          "All"
        ]
      },
      "confirmationInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConfirmationInfo",
        "kind": "PART"
      }
    }
  },
  "Pages$MicroflowParameterMapping": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$MicroflowParameterMapping"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$MicroflowParameter",
        "kind": "BY_NAME_REFERENCE"
      },
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "variable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$NanoflowParameterMapping": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$NanoflowParameterMapping"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$NanoflowParameter",
        "kind": "BY_NAME_REFERENCE"
      },
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "variable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$ConfirmationInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ConfirmationInfo"
    ],
    "properties": {
      "question": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "proceedButtonCaption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "cancelButtonCaption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "Pages$PageVariable": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$PageVariable"
    ],
    "properties": {
      "widget": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      },
      "pageParameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageParameter",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      },
      "snippetParameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$SnippetParameter",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      },
      "localVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$LocalVariable",
        "kind": "LOCAL_BY_NAME_REFERENCE"
      },
      "useAllPages": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "subKey": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$LocalVariable": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LocalVariable"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "variableType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DataTypes$DataType",
        "kind": "PART"
      },
      "defaultValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$Appearance": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$Appearance"
    ],
    "properties": {
      "class": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "style": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "designProperties": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$DesignPropertyValue",
        "kind": "PART"
      },
      "dynamicClasses": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$DesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$DesignPropertyValue"
    ],
    "properties": {
      "key": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "value": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AbstractDesignPropertyValue",
        "kind": "PART"
      }
    }
  },
  "Pages$AbstractDesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$CompoundDesignPropertyValue",
      "Pages$CustomDesignPropertyValue",
      "Pages$OptionDesignPropertyValue",
      "Pages$ToggleDesignPropertyValue"
    ]
  },
  "Pages$OptionDesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AbstractDesignPropertyValue"
    ],
    "allCompatibleTypes": [
      "Pages$OptionDesignPropertyValue"
    ],
    "properties": {
      "option": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ToggleDesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AbstractDesignPropertyValue"
    ],
    "allCompatibleTypes": [
      "Pages$ToggleDesignPropertyValue"
    ]
  },
  "Pages$CustomDesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AbstractDesignPropertyValue"
    ],
    "allCompatibleTypes": [
      "Pages$CustomDesignPropertyValue"
    ],
    "properties": {
      "value": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$CompoundDesignPropertyValue": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AbstractDesignPropertyValue"
    ],
    "allCompatibleTypes": [
      "Pages$CompoundDesignPropertyValue"
    ],
    "properties": {
      "properties": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$DesignPropertyValue",
        "kind": "PART"
      }
    }
  },
  "Pages$Widget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ActionButton",
      "Pages$AssociationWidget",
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$Button",
      "Pages$CheckBox",
      "Pages$ColumnGrid",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$DataGrid",
      "Pages$DataView",
      "Pages$DatePicker",
      "Pages$DivContainer",
      "Pages$DropDown",
      "Pages$DropDownButton",
      "Pages$DynamicImageViewer",
      "Pages$DynamicText",
      "Pages$EntityWidget",
      "Pages$FileManager",
      "Pages$Grid",
      "Pages$GroupBox",
      "Pages$Header",
      "Pages$ImageUploader",
      "Pages$InputReferenceSetSelector",
      "Pages$InputWidget",
      "Pages$Label",
      "Pages$LayoutGrid",
      "Pages$ListView",
      "Pages$ListenTargetWidget",
      "Pages$LoginButton",
      "Pages$LoginIdTextBox",
      "Pages$LoginTextBox",
      "Pages$MemberWidget",
      "Pages$MenuBar",
      "Pages$MenuWidget",
      "Pages$NavigationList",
      "Pages$NavigationTree",
      "Pages$PasswordTextBox",
      "Pages$Placeholder",
      "Pages$RadioButtonGroup",
      "Pages$ReferenceSelector",
      "Pages$ReferenceSetSelector",
      "Pages$ScrollContainer",
      "Pages$SidebarToggleButton",
      "Pages$SimpleMenuBar",
      "Pages$SnippetCallWidget",
      "Pages$StaticImageViewer",
      "Pages$TabContainer",
      "Pages$Table",
      "Pages$TemplateGrid",
      "Pages$TemplatePlaceholder",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget",
      "Pages$Title",
      "Pages$ValidationMessage"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "tabIndex": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$Label": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$Label"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "Pages$StaticImageViewer": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$StaticImageViewer"
    ],
    "properties": {
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      },
      "widthUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "heightUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "height": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "clickAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "responsive": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "alternativeText": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$DivContainer": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DivContainer"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "renderMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Div",
          "Section",
          "Article",
          "Header",
          "Footer",
          "Main",
          "Nav",
          "Aside",
          "Hgroup",
          "Address"
        ]
      },
      "onClickAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "screenReaderHidden": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$TextBox": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$TextWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TextBox"
    ],
    "properties": {
      "inputMask": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "formattingInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$FormattingInfo",
        "kind": "PART"
      },
      "isPasswordBox": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "keyboardType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "NumberPad",
          "DecimalPad",
          "EmailAddress",
          "PhonePad",
          "URL",
          "Default"
        ]
      },
      "onEnterKeyPressAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "autocomplete": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "autocompletePurpose": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "On",
          "Off",
          "FullName",
          "HonorificPrefix",
          "GivenName",
          "AdditionalName",
          "FamilyName",
          "HonorificSuffix",
          "Nickname",
          "JobTitle",
          "Username",
          "NewPassword",
          "CurrentPassword",
          "CompanyName",
          "StreetAddress",
          "StreetAddressLine1",
          "StreetAddressLine2",
          "StreetAddressLine3",
          "AddressLevel4",
          "AddressLevel3",
          "AddressLevel2",
          "AddressLevel1",
          "CountryCode",
          "CountryName",
          "PostalCode",
          "CreditCardFullName",
          "CreditCardGivenName",
          "CreditCardAdditionalName",
          "CreditCardFamilyName",
          "CreditCardNumber",
          "CreditCardExpiration",
          "CreditCardExpirationMonth",
          "CreditCardExpirationYear",
          "CreditCardSecurityCode",
          "CreditCardType",
          "TransactionCurrency",
          "TransactionAmount",
          "Language",
          "Birthday",
          "DayOfBirth",
          "MonthOfBirth",
          "YearOfBirth",
          "Sex",
          "Url",
          "Photo",
          "TelephoneNumber",
          "TelephoneCountryCode",
          "TelephoneWithoutCountryCode",
          "TelephoneAreaCode",
          "TelephoneLocal",
          "TelephoneLocalPrefix",
          "TelephoneLocalSuffix",
          "TelephoneExtension",
          "Email",
          "InstantMessageProtocol"
        ]
      },
      "submitBehaviour": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "OnEndEditing",
          "WhileEditing"
        ]
      },
      "submitOnInputDelay": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$TextArea": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$TextWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TextArea"
    ],
    "properties": {
      "numberOfLines": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "counterMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "textTooLongMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "autocomplete": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "submitBehaviour": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "OnEndEditing",
          "WhileEditing"
        ]
      },
      "submitOnInputDelay": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$CheckBox": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$CheckBox"
    ],
    "properties": {
      "labelPosition": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Default",
          "BeforeControl",
          "AfterControl"
        ]
      },
      "nativeRenderMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "CheckBox",
          "Switch"
        ]
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$RadioButtonGroup": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$RadioButtonGroup"
    ],
    "properties": {
      "renderHorizontal": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$DatePicker": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DatePicker"
    ],
    "properties": {
      "formattingInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$FormattingInfo",
        "kind": "PART"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$LoginTextBox": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$LoginIdTextBox",
      "Pages$PasswordTextBox"
    ],
    "properties": {
      "label": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "labelWidth": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "placeholder": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "Pages$LoginIdTextBox": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$LoginTextBox",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$LoginIdTextBox"
    ]
  },
  "Pages$PasswordTextBox": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$LoginTextBox",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$PasswordTextBox"
    ]
  },
  "Pages$LoginButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Button",
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$LoginButton"
    ],
    "properties": {
      "validationMessageWidget": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ValidationMessage": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ValidationMessage"
    ]
  },
  "Pages$FormattingInfo": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$FormattingInfo"
    ],
    "properties": {
      "decimalPrecision": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "groupDigits": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "enumFormat": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Text",
          "Image"
        ]
      },
      "dateFormat": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Date",
          "Time",
          "DateTime",
          "Custom"
        ]
      },
      "customDateFormat": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$TextWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TextArea",
      "Pages$TextBox"
    ],
    "properties": {
      "maxLengthCode": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "autoFocus": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$AttributeWidgetWithPlaceholder": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DatePicker",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget"
    ],
    "properties": {
      "placeholderTemplate": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      }
    }
  },
  "Pages$AttributeWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$CheckBox",
      "Pages$DatePicker",
      "Pages$DropDown",
      "Pages$RadioButtonGroup",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget"
    ],
    "properties": {
      "validation": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$WidgetValidation",
        "kind": "PART"
      },
      "onChangeAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "onEnterAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "onLeaveAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      },
      "ariaRequired": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$WidgetValidation": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$WidgetValidation"
    ],
    "properties": {
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "message": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "Pages$MemberWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$AssociationWidget",
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$CheckBox",
      "Pages$DatePicker",
      "Pages$DropDown",
      "Pages$InputReferenceSetSelector",
      "Pages$RadioButtonGroup",
      "Pages$ReferenceSelector",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget"
    ],
    "properties": {
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "readOnlyStyle": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Inherit",
          "Control",
          "Text"
        ]
      }
    }
  },
  "Pages$InputWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$AssociationWidget",
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$CheckBox",
      "Pages$DatePicker",
      "Pages$DropDown",
      "Pages$FileManager",
      "Pages$ImageUploader",
      "Pages$InputReferenceSetSelector",
      "Pages$MemberWidget",
      "Pages$RadioButtonGroup",
      "Pages$ReferenceSelector",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget"
    ],
    "properties": {
      "labelTemplate": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "screenReaderLabel": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      }
    }
  },
  "Pages$ConditionallyEditableWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$AssociationWidget",
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$CheckBox",
      "Pages$DatePicker",
      "Pages$DropDown",
      "Pages$FileManager",
      "Pages$ImageUploader",
      "Pages$InputReferenceSetSelector",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$RadioButtonGroup",
      "Pages$ReferenceSelector",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget"
    ],
    "properties": {
      "conditionalEditabilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalEditabilitySettings",
        "kind": "PART"
      },
      "editable": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Always",
          "Never",
          "Conditional"
        ]
      }
    }
  },
  "Pages$ConditionallyVisibleWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ActionButton",
      "Pages$AssociationWidget",
      "Pages$AttributeWidget",
      "Pages$AttributeWidgetWithPlaceholder",
      "Pages$Button",
      "Pages$CheckBox",
      "Pages$ColumnGrid",
      "Pages$ConditionallyEditableWidget",
      "Pages$DataGrid",
      "Pages$DataView",
      "Pages$DatePicker",
      "Pages$DivContainer",
      "Pages$DropDown",
      "Pages$DropDownButton",
      "Pages$DynamicImageViewer",
      "Pages$DynamicText",
      "Pages$EntityWidget",
      "Pages$FileManager",
      "Pages$Grid",
      "Pages$GroupBox",
      "Pages$ImageUploader",
      "Pages$InputReferenceSetSelector",
      "Pages$InputWidget",
      "Pages$Label",
      "Pages$LayoutGrid",
      "Pages$ListView",
      "Pages$ListenTargetWidget",
      "Pages$LoginButton",
      "Pages$MemberWidget",
      "Pages$NavigationList",
      "Pages$RadioButtonGroup",
      "Pages$ReferenceSelector",
      "Pages$ReferenceSetSelector",
      "Pages$SidebarToggleButton",
      "Pages$StaticImageViewer",
      "Pages$TabContainer",
      "Pages$Table",
      "Pages$TemplateGrid",
      "Pages$TextArea",
      "Pages$TextBox",
      "Pages$TextWidget",
      "Pages$Title"
    ],
    "properties": {
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$ConditionalSettings": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ConditionalEditabilitySettings",
      "Pages$ConditionalVisibilitySettings"
    ],
    "properties": {
      "attribute": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Attribute",
        "kind": "BY_NAME_REFERENCE"
      },
      "conditions": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Enumerations$Condition",
        "kind": "PART"
      },
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$ConditionalVisibilitySettings": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionalSettings"
    ],
    "allCompatibleTypes": [
      "Pages$ConditionalVisibilitySettings"
    ],
    "properties": {
      "moduleRoles": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Security$ModuleRole",
        "kind": "BY_NAME_REFERENCE"
      },
      "ignoreSecurity": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$ConditionalEditabilitySettings": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionalSettings"
    ],
    "allCompatibleTypes": [
      "Pages$ConditionalEditabilitySettings"
    ]
  },
  "Pages$AccessibilitySettings": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$AccessibilitySettings"
    ],
    "properties": {
      "screenReaderDescription": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "screenReaderTitle": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      }
    }
  },
  "Pages$Table": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$Table"
    ],
    "properties": {
      "cells": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$TableCell",
        "kind": "PART"
      },
      "columns": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$TableColumn",
        "kind": "PART"
      },
      "widthUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Weight",
          "Pixels"
        ]
      },
      "rows": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$TableRow",
        "kind": "PART"
      }
    }
  },
  "Pages$TableCell": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$TableCell"
    ],
    "properties": {
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "isHeader": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "leftColumnIndex": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "topRowIndex": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "height": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$TableColumn": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$TableColumn"
    ],
    "properties": {
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$TableRow": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$TableRow"
    ],
    "properties": {
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$EntityWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ColumnGrid",
      "Pages$DataGrid",
      "Pages$DataView",
      "Pages$DynamicImageViewer",
      "Pages$Grid",
      "Pages$ListView",
      "Pages$ListenTargetWidget",
      "Pages$ReferenceSetSelector",
      "Pages$TemplateGrid"
    ],
    "properties": {
      "dataSource": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$DataSource",
        "kind": "PART"
      }
    }
  },
  "Pages$DataSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$AssociationSource",
      "Pages$DataViewSource",
      "Pages$EntityPathSource",
      "Pages$GridBaseSource",
      "Pages$GridXPathSource",
      "Pages$ImageViewerSource",
      "Pages$ListViewXPathSource",
      "Pages$ListenTargetSource",
      "Pages$MicroflowSource",
      "Pages$NanoflowSource",
      "Pages$ReferenceSetSource",
      "Pages$SortableEntityPathSource",
      "Pages$XPathSourceBase"
    ],
    "properties": {
      "forceFullObjects": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$EntityPathSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$DataSource"
    ],
    "allCompatibleTypes": [
      "Pages$AssociationSource",
      "Pages$DataViewSource",
      "Pages$GridBaseSource",
      "Pages$GridXPathSource",
      "Pages$ImageViewerSource",
      "Pages$ListViewXPathSource",
      "Pages$ReferenceSetSource",
      "Pages$SortableEntityPathSource",
      "Pages$XPathSourceBase"
    ],
    "properties": {
      "entityRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRef",
        "kind": "PART"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$MicroflowSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource"
    ],
    "allCompatibleTypes": [
      "Pages$MicroflowSource"
    ],
    "properties": {
      "microflowSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$MicroflowSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$NanoflowSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource"
    ],
    "allCompatibleTypes": [
      "Pages$NanoflowSource"
    ],
    "properties": {
      "nanoflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Microflows$Nanoflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameterMappings": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$NanoflowParameterMapping",
        "kind": "PART"
      }
    }
  },
  "Pages$ListenTargetWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ColumnGrid",
      "Pages$DataGrid",
      "Pages$Grid",
      "Pages$ListView",
      "Pages$ReferenceSetSelector",
      "Pages$TemplateGrid"
    ]
  },
  "Pages$AssociationSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$AssociationSource"
    ]
  },
  "Pages$DataView": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DataView"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "footerWidgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "editability": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Always",
          "Never",
          "Conditional"
        ]
      },
      "conditionalEditabilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalEditabilitySettings",
        "kind": "PART"
      },
      "showFooter": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "noEntityMessage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "labelWidth": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "readOnlyStyle": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Control",
          "Text"
        ]
      }
    }
  },
  "Pages$DataViewSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$DataViewSource"
    ]
  },
  "Pages$ListenTargetSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource"
    ],
    "allCompatibleTypes": [
      "Pages$ListenTargetSource"
    ],
    "properties": {
      "listenTarget": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ControlBar": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$GridControlBar",
      "Pages$SearchBar"
    ],
    "properties": {
      "items": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$ControlBarItem",
        "kind": "PART"
      }
    }
  },
  "Pages$ControlBarItem": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ComparisonSearchField",
      "Pages$ControlBarButton",
      "Pages$DataGridAddButton",
      "Pages$DataGridExportToCSVButton",
      "Pages$DataGridExportToExcelButton",
      "Pages$DataGridRemoveButton",
      "Pages$DropDownSearchField",
      "Pages$GridActionButton",
      "Pages$GridControlBarButton",
      "Pages$GridDeselectAllButton",
      "Pages$GridNewButton",
      "Pages$GridSearchButton",
      "Pages$GridSelectAllButton",
      "Pages$RangeSearchField",
      "Pages$SearchField",
      "Pages$SelectButton",
      "Pages$SingleSearchField"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ControlBarButton": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ControlBarItem"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridAddButton",
      "Pages$DataGridExportToCSVButton",
      "Pages$DataGridExportToExcelButton",
      "Pages$DataGridRemoveButton",
      "Pages$GridActionButton",
      "Pages$GridControlBarButton",
      "Pages$GridDeselectAllButton",
      "Pages$GridNewButton",
      "Pages$GridSearchButton",
      "Pages$GridSelectAllButton",
      "Pages$SelectButton"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "tooltip": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "icon": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Icon",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      },
      "buttonStyle": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Default",
          "Inverse",
          "Primary",
          "Info",
          "Success",
          "Warning",
          "Danger"
        ]
      }
    }
  },
  "Pages$ListView": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ListView"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "pageSize": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "clickAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "editable": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "templates": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$ListViewTemplate",
        "kind": "PART"
      },
      "scrollDirection": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Vertical",
          "Horizontal"
        ]
      },
      "numberOfColumns": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "pullDownAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      }
    }
  },
  "Pages$ListViewTemplate": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ListViewTemplate"
    ],
    "properties": {
      "specialization": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$SortableEntityPathSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$GridBaseSource",
      "Pages$GridXPathSource",
      "Pages$ListViewXPathSource",
      "Pages$ReferenceSetSource",
      "Pages$XPathSourceBase"
    ],
    "properties": {
      "sortBar": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$GridSortBar",
        "kind": "PART"
      }
    }
  },
  "Pages$XPathSourceBase": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$SortableEntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$ListViewXPathSource"
    ],
    "properties": {
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ListViewXPathSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$SortableEntityPathSource",
      "Pages$XPathSourceBase"
    ],
    "allCompatibleTypes": [
      "Pages$ListViewXPathSource"
    ],
    "properties": {
      "search": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ListViewSearch",
        "kind": "PART"
      }
    }
  },
  "Pages$GridSortBar": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$GridSortBar"
    ],
    "properties": {
      "sortItems": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$GridSortItem",
        "kind": "PART"
      }
    }
  },
  "Pages$GridSortItem": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$GridSortItem"
    ],
    "properties": {
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "sortDirection": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Ascending",
          "Descending"
        ]
      }
    }
  },
  "Pages$Button": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ActionButton",
      "Pages$DropDownButton",
      "Pages$LoginButton",
      "Pages$SidebarToggleButton"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "tooltip": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "icon": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Icon",
        "kind": "PART"
      },
      "renderType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Button",
          "Link"
        ]
      },
      "buttonStyle": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Default",
          "Inverse",
          "Primary",
          "Info",
          "Success",
          "Warning",
          "Danger"
        ]
      }
    }
  },
  "Pages$StaticOrDynamicString": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$StaticOrDynamicString"
    ],
    "properties": {
      "isDynamic": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "value": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      }
    }
  },
  "Pages$ActionButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Button",
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ActionButton"
    ],
    "properties": {
      "action": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "ariaRole": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Button",
          "Link",
          "Checkbox",
          "Radio",
          "Tab",
          "MenuItem",
          "MenuItemCheckbox",
          "MenuItemRadio",
          "Option",
          "Switch",
          "TreeItem"
        ]
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$ClientTemplate": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ClientTemplate"
    ],
    "properties": {
      "template": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "parameters": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplateParameter",
        "kind": "PART"
      },
      "fallback": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      }
    }
  },
  "Pages$ClientTemplateParameter": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ClientTemplateParameter"
    ],
    "properties": {
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "expression": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "formattingInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$FormattingInfo",
        "kind": "PART"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$ColumnGrid": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Grid",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DataGrid",
      "Pages$ReferenceSetSelector"
    ],
    "properties": {
      "columns": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$GridColumn",
        "kind": "PART"
      },
      "numberOfRows": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "showEmptyRows": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "widthUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Weight",
          "Pixels"
        ]
      },
      "tooltipPage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Page",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$ComparisonSearchField": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarItem",
      "Pages$SearchField",
      "Pages$SingleSearchField"
    ],
    "allCompatibleTypes": [
      "Pages$ComparisonSearchField"
    ]
  },
  "Pages$GridXPathSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$GridBaseSource",
      "Pages$SortableEntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$GridXPathSource"
    ],
    "properties": {
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$DataGrid": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ColumnGrid",
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Grid",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DataGrid"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      }
    }
  },
  "Pages$DataGridAddButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridAddButton"
    ],
    "properties": {
      "pageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$DataGridExportToCSVButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridExportToCSVButton"
    ],
    "properties": {
      "maxNumberOfRows": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "decimalSeparator": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "groupSeparator": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "delimiter": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "generateExcelHint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "useGridDateFormat": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$DataGridExportToExcelButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridExportToExcelButton"
    ],
    "properties": {
      "maxNumberOfRows": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "useExcelDateType": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$DataGridRemoveButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridRemoveButton"
    ]
  },
  "Pages$DropDown": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AttributeWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DropDown"
    ],
    "properties": {
      "emptyOptionCaption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$DropDownButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Button",
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DropDownButton"
    ],
    "properties": {
      "items": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$DropDownButtonItem",
        "kind": "PART"
      }
    }
  },
  "Pages$ActionItem": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$DropDownButtonItem",
      "Pages$NavigationListItem"
    ],
    "properties": {
      "action": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      }
    }
  },
  "Pages$DropDownButtonItem": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ActionItem"
    ],
    "allCompatibleTypes": [
      "Pages$DropDownButtonItem"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$DropDownSearchField": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarItem",
      "Pages$SearchField",
      "Pages$SingleSearchField"
    ],
    "allCompatibleTypes": [
      "Pages$DropDownSearchField"
    ],
    "properties": {
      "sortBar": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$GridSortBar",
        "kind": "PART"
      },
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "allowMultipleSelect": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$DynamicImageViewer": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DynamicImageViewer"
    ],
    "properties": {
      "defaultImage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      },
      "widthUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "heightUnit": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "height": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "responsive": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "showAsThumbnail": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "clickAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "onClickEnlarge": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "alternativeText": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$DynamicText": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$DynamicText"
    ],
    "properties": {
      "content": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "renderMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Text",
          "Paragraph",
          "H1",
          "H2",
          "H3",
          "H4",
          "H5",
          "H6"
        ]
      },
      "nativeTextStyle": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Text",
          "Heading1",
          "Heading2",
          "Heading3",
          "Heading4",
          "Heading5",
          "Heading6"
        ]
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$FileManager": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$FileManager"
    ],
    "properties": {
      "allowedExtensions": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Upload",
          "Download",
          "Both"
        ]
      },
      "maxFileSize": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "showFileInBrowser": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$PageForSpecialization": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$PageForSpecialization"
    ],
    "properties": {
      "entity": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      },
      "pageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$GlyphIcon": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Icon"
    ],
    "allCompatibleTypes": [
      "Pages$GlyphIcon"
    ],
    "properties": {
      "code": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$Grid": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ColumnGrid",
      "Pages$DataGrid",
      "Pages$ReferenceSetSelector",
      "Pages$TemplateGrid"
    ],
    "properties": {
      "isControlBarVisible": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "showPagingBar": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "YesWithTotalCount",
          "YesWithoutTotalCount",
          "No"
        ]
      },
      "selectionMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Single",
          "SingleAndMaintain",
          "Multi",
          "SimpleMulti"
        ]
      },
      "selectFirst": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "defaultButtonTrigger": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Single",
          "Double"
        ]
      },
      "refreshTime": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "controlBar": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$GridControlBar",
        "kind": "PART"
      }
    }
  },
  "Pages$GridActionButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$GridActionButton"
    ],
    "properties": {
      "action": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "maintainSelectionAfterMicroflow": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$GridBaseSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$SortableEntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$GridXPathSource",
      "Pages$ReferenceSetSource"
    ],
    "properties": {
      "searchBar": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$SearchBar",
        "kind": "PART"
      }
    }
  },
  "Pages$GridColumn": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$GridColumn"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "formattingInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$FormattingInfo",
        "kind": "PART"
      },
      "showTooltip": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "aggregateCaption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "aggregateFunction": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Average",
          "Maximum",
          "Minimum",
          "Sum",
          "Count"
        ]
      },
      "editable": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      }
    }
  },
  "Pages$GridControlBar": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBar"
    ],
    "allCompatibleTypes": [
      "Pages$GridControlBar"
    ],
    "properties": {
      "defaultButton": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ControlBarItem",
        "kind": "BY_ID_REFERENCE"
      }
    }
  },
  "Pages$GridControlBarButton": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem"
    ],
    "allCompatibleTypes": [
      "Pages$DataGridAddButton",
      "Pages$DataGridExportToCSVButton",
      "Pages$DataGridExportToExcelButton",
      "Pages$DataGridRemoveButton",
      "Pages$GridActionButton",
      "Pages$GridDeselectAllButton",
      "Pages$GridNewButton",
      "Pages$GridSearchButton",
      "Pages$GridSelectAllButton",
      "Pages$SelectButton"
    ]
  },
  "Pages$GridDeselectAllButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$GridDeselectAllButton"
    ]
  },
  "Pages$GridNewButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$GridNewButton"
    ],
    "properties": {
      "entity": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$Entity",
        "kind": "BY_NAME_REFERENCE"
      },
      "editLocation": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "InlineAtTop",
          "InlineAtBottom",
          "Form"
        ]
      },
      "pageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$GridSearchButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$GridSearchButton"
    ]
  },
  "Pages$GridSelectAllButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$GridSelectAllButton"
    ],
    "properties": {
      "selectionType": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "SelectPage",
          "SelectAll"
        ]
      }
    }
  },
  "Pages$GroupBox": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$GroupBox"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      },
      "collapsible": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "No",
          "YesInitiallyExpanded",
          "YesInitiallyCollapsed"
        ]
      },
      "headerMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Div",
          "H1",
          "H2",
          "H3",
          "H4",
          "H5",
          "H6"
        ]
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$Header": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$Header"
    ],
    "properties": {
      "leftWidgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "rightWidgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$Icon": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$GlyphIcon",
      "Pages$IconCollectionIcon",
      "Pages$ImageIcon"
    ]
  },
  "Pages$ImageIcon": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Icon"
    ],
    "allCompatibleTypes": [
      "Pages$ImageIcon"
    ],
    "properties": {
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Images$Image",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$IconCollectionIcon": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Icon"
    ],
    "allCompatibleTypes": [
      "Pages$IconCollectionIcon"
    ],
    "properties": {
      "image": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "CustomIcons$CustomIcon",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$ImageUploader": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ImageUploader"
    ],
    "properties": {
      "allowedExtensions": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "thumbnailSize": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "SIZE"
      },
      "maxFileSize": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$ImageViewerSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$ImageViewerSource"
    ]
  },
  "Pages$InputReferenceSetSelector": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AssociationWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$InputReferenceSetSelector"
    ]
  },
  "Pages$LayoutGrid": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$LayoutGrid"
    ],
    "properties": {
      "width": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "FullWidth",
          "FixedWidth"
        ]
      },
      "rows": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutGridRow",
        "kind": "PART"
      }
    }
  },
  "Pages$LayoutGridColumn": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LayoutGridColumn"
    ],
    "properties": {
      "weight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "tabletWeight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "phoneWeight": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "previewWidth": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "verticalAlignment": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Start",
          "Center",
          "End"
        ]
      }
    }
  },
  "Pages$LayoutGridRow": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$LayoutGridRow"
    ],
    "properties": {
      "columns": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LayoutGridColumn",
        "kind": "PART"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "verticalAlignment": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Start",
          "Center",
          "End"
        ]
      },
      "horizontalAlignment": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "Start",
          "Center",
          "End"
        ]
      },
      "spacingBetweenColumns": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$MenuBar": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$MenuWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$MenuBar"
    ]
  },
  "Pages$MenuDocumentSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$MenuSource"
    ],
    "allCompatibleTypes": [
      "Pages$MenuDocumentSource"
    ],
    "properties": {
      "menu": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Menus$MenuDocument",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$MenuSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$MenuDocumentSource",
      "Pages$NavigationSource"
    ]
  },
  "Pages$MenuWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$MenuBar",
      "Pages$NavigationTree",
      "Pages$SimpleMenuBar"
    ],
    "properties": {
      "menuSource": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$MenuSource",
        "kind": "PART"
      }
    }
  },
  "Pages$NavigationList": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$NavigationList"
    ],
    "properties": {
      "items": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$NavigationListItem",
        "kind": "PART"
      }
    }
  },
  "Pages$NavigationListItem": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ActionItem"
    ],
    "allCompatibleTypes": [
      "Pages$NavigationListItem"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$NavigationSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$MenuSource"
    ],
    "allCompatibleTypes": [
      "Pages$NavigationSource"
    ],
    "properties": {
      "navigationProfile": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Navigation$NavigationProfile",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$NavigationTree": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$MenuWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$NavigationTree"
    ]
  },
  "Pages$RangeSearchField": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarItem",
      "Pages$SearchField"
    ],
    "allCompatibleTypes": [
      "Pages$RangeSearchField"
    ],
    "properties": {
      "lowerBoundRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "upperBoundRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "includeLower": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "includeUpper": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$ReferenceSelector": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$AssociationWidget",
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ReferenceSelector"
    ],
    "properties": {
      "validation": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$WidgetValidation",
        "kind": "PART"
      },
      "renderMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Form",
          "DropDown"
        ]
      },
      "gotoPageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      },
      "formattingInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$FormattingInfo",
        "kind": "PART"
      },
      "emptyOptionCaption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$ReferenceSetSelector": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ColumnGrid",
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Grid",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ReferenceSetSelector"
    ],
    "properties": {
      "onChangeAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "constrainedByRefs": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRef",
        "kind": "PART"
      },
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$ReferenceSetSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$DataSource",
      "Pages$EntityPathSource",
      "Pages$GridBaseSource",
      "Pages$SortableEntityPathSource"
    ],
    "allCompatibleTypes": [
      "Pages$ReferenceSetSource"
    ]
  },
  "Pages$ScrollContainer": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$ScrollContainer"
    ],
    "properties": {
      "center": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ScrollContainerRegion",
        "kind": "PART"
      },
      "left": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ScrollContainerRegion",
        "kind": "PART"
      },
      "right": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ScrollContainerRegion",
        "kind": "PART"
      },
      "top": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ScrollContainerRegion",
        "kind": "PART"
      },
      "bottom": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ScrollContainerRegion",
        "kind": "PART"
      },
      "layoutMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Headline",
          "Sidebar"
        ]
      },
      "widthMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "width": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "alignment": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Left",
          "Center",
          "Right"
        ]
      },
      "scrollBehavior": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "PerRegion",
          "FullWidget"
        ]
      },
      "nativeHideScrollbars": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$ScrollContainerRegion": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ScrollContainerRegion"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "sizeMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Auto",
          "Pixels",
          "Percentage"
        ]
      },
      "size": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "appearance": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Appearance",
        "kind": "PART"
      },
      "toggleMode": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "PushContentAside",
          "SlideOverContent",
          "ShrinkContentInitiallyOpen",
          "ShrinkContentInitiallyClosed"
        ]
      }
    }
  },
  "Pages$SearchBar": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBar"
    ],
    "allCompatibleTypes": [
      "Pages$SearchBar"
    ],
    "properties": {
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "None",
          "FoldableOpen",
          "FoldableClosed",
          "AlwaysOpen"
        ]
      },
      "waitForSearch": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$ListViewSearch": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$ListViewSearch"
    ],
    "properties": {
      "searchRefs": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      }
    }
  },
  "Pages$SearchField": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ControlBarItem"
    ],
    "allCompatibleTypes": [
      "Pages$ComparisonSearchField",
      "Pages$DropDownSearchField",
      "Pages$RangeSearchField",
      "Pages$SingleSearchField"
    ],
    "properties": {
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "placeholder": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "customDateFormat": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Normal",
          "Hidden",
          "ReadOnly"
        ]
      },
      "defaultValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Pages$SelectButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ControlBarButton",
      "Pages$ControlBarItem",
      "Pages$GridControlBarButton"
    ],
    "allCompatibleTypes": [
      "Pages$SelectButton"
    ]
  },
  "Pages$AssociationWidget": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ConditionallyEditableWidget",
      "Pages$ConditionallyVisibleWidget",
      "Pages$InputWidget",
      "Pages$MemberWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$InputReferenceSetSelector",
      "Pages$ReferenceSelector"
    ],
    "properties": {
      "selectorSource": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$SelectorSource",
        "kind": "PART"
      },
      "selectPageSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageSettings",
        "kind": "PART"
      },
      "onChangeAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      },
      "sourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$SelectorXPathSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$SelectorSource"
    ],
    "allCompatibleTypes": [
      "Pages$SelectorXPathSource"
    ],
    "properties": {
      "sortBar": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$GridSortBar",
        "kind": "PART"
      },
      "xPathConstraint": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "constrainedByRefs": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "DomainModels$EntityRef",
        "kind": "PART"
      }
    }
  },
  "Pages$SelectorMicroflowSource": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$SelectorSource"
    ],
    "allCompatibleTypes": [
      "Pages$SelectorMicroflowSource"
    ],
    "properties": {
      "dataSourceMicroflowSettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$MicroflowSettings",
        "kind": "PART"
      }
    }
  },
  "Pages$SelectorSource": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$SelectorMicroflowSource",
      "Pages$SelectorXPathSource"
    ]
  },
  "Pages$SidebarToggleButton": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Button",
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$SidebarToggleButton"
    ]
  },
  "Pages$SimpleMenuBar": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$MenuWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$SimpleMenuBar"
    ],
    "properties": {
      "orientation": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Horizontal",
          "Vertical"
        ]
      }
    }
  },
  "Pages$SingleSearchField": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$ControlBarItem",
      "Pages$SearchField"
    ],
    "allCompatibleTypes": [
      "Pages$ComparisonSearchField",
      "Pages$DropDownSearchField"
    ],
    "properties": {
      "attributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "operator": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Contains",
          "StartsWith",
          "Greater",
          "GreaterOrEqual",
          "Equal",
          "NotEqual",
          "SmallerOrEqual",
          "Smaller"
        ]
      }
    }
  },
  "Pages$Snippet": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [
      "Pages$FormBase"
    ],
    "allCompatibleTypes": [
      "Pages$Snippet"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "type": {
        "list": false,
        "type": "ENUMERATION",
        "values": [
          "Web",
          "Native"
        ]
      },
      "parameters": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$SnippetParameter",
        "kind": "PART"
      },
      "variables": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$LocalVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$SnippetParameter": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$SnippetParameter"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "parameterType": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DataTypes$DataType",
        "kind": "PART"
      }
    }
  },
  "Pages$SnippetCall": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$SnippetCall"
    ],
    "properties": {
      "snippet": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Snippet",
        "kind": "BY_NAME_REFERENCE"
      },
      "parameterMappings": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$SnippetParameterMapping",
        "kind": "PART"
      }
    }
  },
  "Pages$SnippetParameterMapping": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$SnippetParameterMapping"
    ],
    "properties": {
      "parameter": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$SnippetParameter",
        "kind": "BY_NAME_REFERENCE"
      },
      "variable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      }
    }
  },
  "Pages$SnippetCallWidget": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$SnippetCallWidget"
    ],
    "properties": {
      "snippetCall": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$SnippetCall",
        "kind": "PART"
      }
    }
  },
  "Pages$TabContainer": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TabContainer"
    ],
    "properties": {
      "tabPages": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$TabPage",
        "kind": "PART"
      },
      "defaultPage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$TabPage",
        "kind": "BY_ID_REFERENCE"
      },
      "activePageAttributeRef": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "DomainModels$AttributeRef",
        "kind": "PART"
      },
      "activePageSourceVariable": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$PageVariable",
        "kind": "PART"
      },
      "activePageOnChangeAction": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientAction",
        "kind": "PART"
      }
    }
  },
  "Pages$TabPage": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$TabPage"
    ],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "caption": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Texts$Text",
        "kind": "PART"
      },
      "refreshOnShow": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "conditionalVisibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConditionalVisibilitySettings",
        "kind": "PART"
      },
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      },
      "badge": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ClientTemplate",
        "kind": "PART"
      }
    }
  },
  "Pages$TemplateGrid": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$EntityWidget",
      "Pages$Grid",
      "Pages$ListenTargetWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$TemplateGrid"
    ],
    "properties": {
      "contents": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$TemplateGridContents",
        "kind": "PART"
      },
      "numberOfRows": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      },
      "numberOfColumns": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "INTEGER"
      }
    }
  },
  "Pages$TemplateGridContents": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": [
      "Pages$TemplateGridContents"
    ],
    "properties": {
      "widgets": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Pages$Widget",
        "kind": "PART"
      }
    }
  },
  "Pages$Title": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ConditionallyVisibleWidget",
      "Pages$Widget"
    ],
    "allCompatibleTypes": [
      "Pages$Title"
    ],
    "properties": {
      "nativeAccessibilitySettings": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$AccessibilitySettings",
        "kind": "PART"
      }
    }
  },
  "Pages$WorkflowTemplateType": {
    "type": "ELEMENT",
    "abstract": true,
    "baseTypes": [
      "Pages$TemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$UserTaskTemplateType",
      "Pages$WorkflowOverviewTemplateType"
    ]
  },
  "Pages$UserTaskTemplateType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$TemplateType",
      "Pages$WorkflowTemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$UserTaskTemplateType"
    ]
  },
  "Pages$WorkflowOverviewTemplateType": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$TemplateType",
      "Pages$WorkflowTemplateType"
    ],
    "allCompatibleTypes": [
      "Pages$WorkflowOverviewTemplateType"
    ]
  },
  "Pages$CallWorkflowClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$CallWorkflowClientAction"
    ],
    "properties": {
      "workflow": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Workflows$Workflow",
        "kind": "BY_NAME_REFERENCE"
      },
      "closePage": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "confirmationInfo": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$ConfirmationInfo",
        "kind": "PART"
      }
    }
  },
  "Pages$OpenUserTaskClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$OpenUserTaskClientAction"
    ],
    "properties": {
      "assignOnOpen": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "openWhenAssigned": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Pages$OpenWorkflowClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$OpenWorkflowClientAction"
    ],
    "properties": {
      "defaultPage": {
        "list": false,
        "type": "ELEMENT",
        "elementType": "Pages$Page",
        "kind": "BY_NAME_REFERENCE"
      }
    }
  },
  "Pages$SetTaskOutcomeClientAction": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [
      "Pages$ClientAction"
    ],
    "allCompatibleTypes": [
      "Pages$SetTaskOutcomeClientAction"
    ],
    "properties": {
      "outcomeValue": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "closePage": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "commit": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Projects$Project": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$Project"],
    "properties": {
      "isSystemProject": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Projects$ProjectDocument": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": []
  },
  "Projects$FolderBase": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": []
  },
  "Projects$Folder": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$Folder"],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Projects$Module": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$Module"],
    "properties": {
      "sortIndex": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "DOUBLE"
      },
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "fromAppStore": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "appStoreGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "appStoreVersionGuid": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "appStoreVersion": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "appStorePackageIdString": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "isThemeModule": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      }
    }
  },
  "Projects$ModuleSettings": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": ["Projects$ModuleDocument"],
    "allCompatibleTypes": ["Projects$ModuleSettings"],
    "properties": {
      "exportLevel": {
        "list": false,
        "type": "ENUMERATION",
        "values": ["Source", "Protected"]
      },
      "protectedModuleType": {
        "list": false,
        "type": "ENUMERATION",
        "values": ["AddOn", "Solution"]
      },
      "version": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "solutionIdentifier": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "extensionName": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "jarDependencies": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Projects$JarDependency",
        "kind": "PART"
      },
      "basedOnVersion": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Projects$ModuleDocument": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$Document", "Projects$ModuleSettings"]
  },
  "Projects$Document": {
    "type": "MODEL_UNIT",
    "abstract": true,
    "baseTypes": ["Projects$ModuleDocument"],
    "allCompatibleTypes": [],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "documentation": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "excluded": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "exportLevel": {
        "list": false,
        "type": "ENUMERATION",
        "values": ["Hidden", "API"]
      }
    }
  },
  "Projects$OneTimeConversionMarker": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$OneTimeConversionMarker"],
    "properties": {
      "name": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  },
  "Projects$ProjectConversion": {
    "type": "MODEL_UNIT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$ProjectConversion"],
    "properties": {
      "markers": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Projects$OneTimeConversionMarker",
        "kind": "PART"
      }
    }
  },
  "Projects$JarDependency": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$JarDependency"],
    "properties": {
      "groupId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "artifactId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "version": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "isIncluded": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "BOOLEAN"
      },
      "exclusions": {
        "list": true,
        "type": "ELEMENT",
        "elementType": "Projects$JarDependencyExclusion",
        "kind": "PART"
      }
    }
  },
  "Projects$JarDependencyExclusion": {
    "type": "ELEMENT",
    "abstract": false,
    "baseTypes": [],
    "allCompatibleTypes": ["Projects$JarDependencyExclusion"],
    "properties": {
      "groupId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      },
      "artifactId": {
        "list": false,
        "type": "PRIMITIVE",
        "primitiveType": "STRING"
      }
    }
  }
}
;

export default _default;
