import { ModelElementBase, ModelUnitBase, StructuralUnitBase } from '@mendix/model-access-publisher';
export declare class Project extends StructuralUnitBase {
    $Type: "Projects$Project";
    isSystemProject: boolean;
}
export declare abstract class ProjectDocument extends ModelUnitBase {
}
export declare abstract class FolderBase extends StructuralUnitBase {
}
export interface FolderCreationOptions {
    name: string;
}
export declare class Folder extends FolderBase {
    constructor(options?: FolderCreationOptions);
    $Type: "Projects$Folder";
    name: string;
}
export interface ModuleCreationOptions {
    name: string;
}
export declare class Module extends FolderBase {
    constructor(options?: ModuleCreationOptions);
    $Type: "Projects$Module";
    sortIndex: number;
    name: string;
    fromAppStore: boolean;
    appStoreGuid: string;
    appStoreVersionGuid: string;
    appStoreVersion: string;
    appStorePackageIdString: string;
    isThemeModule: boolean;
}
export declare abstract class ModuleDocument extends ModelUnitBase {
}
export declare abstract class Document extends ModuleDocument {
    name: string;
    documentation: string;
    excluded: boolean;
    exportLevel: ExportLevel;
}
export interface OneTimeConversionMarkerCreationOptions {
    name: string;
}
export declare class OneTimeConversionMarker extends ModelElementBase {
    constructor(options?: OneTimeConversionMarkerCreationOptions);
    $Type: "Projects$OneTimeConversionMarker";
    name: string;
}
export declare class ProjectConversion extends ModelUnitBase {
    $Type: "Projects$ProjectConversion";
    markers: OneTimeConversionMarker[];
}
export declare class JarDependency extends ModelElementBase {
    $Type: "Projects$JarDependency";
    groupId: string;
    artifactId: string;
    version: string;
    isIncluded: boolean;
    exclusions: JarDependencyExclusion[];
}
export declare class JarDependencyExclusion extends ModelElementBase {
    $Type: "Projects$JarDependencyExclusion";
    groupId: string;
    artifactId: string;
}
export declare class ModuleSettings extends ModuleDocument {
    $Type: "Projects$ModuleSettings";
    exportLevel: ModuleExportLevel;
    protectedModuleType: ProtectedModuleType;
    version: string;
    solutionIdentifier: string;
    extensionName: string;
    jarDependencies: JarDependency[];
    basedOnVersion: string;
}
export type ModuleExportLevel = "Source" | "Protected";
export type ExportLevel = "Hidden" | "API";
export type ProtectedModuleType = "AddOn" | "Solution";
//# sourceMappingURL=Projects.d.ts.map