import { ModelElementBase } from '@mendix/model-access-publisher';
import * as DataTypes from "./DataTypes";
import * as DomainModels from "./DomainModels";
import * as Enumerations from "./Enumerations";
import * as Projects from "./Projects";
import * as Texts from "./Texts";
import * as Url from "./Url";
export declare abstract class FormBase extends Projects.Document {
    canvasWidth: number;
    canvasHeight: number;
    name: string;
    documentation: string;
}
export interface PageCreationOptions {
    name: string;
}
export declare class Page extends FormBase {
    constructor(options?: PageCreationOptions);
    $Type: "Pages$Page";
    parameter: string;
    parameters: PageParameter[];
    layoutCall: LayoutCall;
    title: Texts.Text;
    appearance: Appearance;
    allowedRoles: string[];
    popupCloseAction: string;
    popupWidth: number;
    popupHeight: number;
    popupResizable: boolean;
    markAsUsed: boolean;
    url: string;
    variables: LocalVariable[];
}
export declare class ParameterAttributeUrlSegment extends Url.UrlSegment {
    $Type: "Pages$ParameterAttributeUrlSegment";
    pageParameter: string;
    attribute: string;
}
export declare class ParameterIdUrlSegment extends Url.UrlSegment {
    $Type: "Pages$ParameterIdUrlSegment";
    pageParameter: string;
}
export interface PageParameterCreationOptions {
    name: string;
}
export declare class PageParameter extends ModelElementBase {
    constructor(options?: PageParameterCreationOptions);
    $Type: "Pages$PageParameter";
    name: string;
    parameterType: DataTypes.DataType;
}
export interface LayoutCreationOptions {
    name: string;
}
export declare class Layout extends FormBase {
    constructor(options?: LayoutCreationOptions);
    $Type: "Pages$Layout";
    parameters: LayoutParameter[];
    content: LayoutContent;
    appearance: Appearance;
}
export declare abstract class LayoutContent extends ModelElementBase {
}
export declare class WebLayoutContent extends LayoutContent {
    $Type: "Pages$WebLayoutContent";
    layoutType: LayoutType;
    layoutCall: LayoutCall | null;
    widgets: Widget[];
}
export declare class NativeLayoutContent extends LayoutContent {
    $Type: "Pages$NativeLayoutContent";
    layoutType: NativeLayoutType;
    widgets: Widget[];
    rightHeaderPlaceholder: Placeholder | null;
    showBottomBar: boolean;
    sidebar: boolean;
    sidebarWidgets: Widget[];
}
export interface LayoutCallCreationOptions {
    layout?: string;
}
export declare class LayoutCall extends ModelElementBase {
    constructor(options?: LayoutCallCreationOptions);
    $Type: "Pages$LayoutCall";
    layout: string;
    arguments: LayoutCallArgument[];
}
export interface LayoutCallArgumentCreationOptions {
    parameter?: string;
}
export declare class LayoutCallArgument extends ModelElementBase {
    constructor(options?: LayoutCallArgumentCreationOptions);
    $Type: "Pages$LayoutCallArgument";
    parameter: string;
    widgets: Widget[];
}
export interface LayoutParameterCreationOptions {
    name: string;
}
export declare class LayoutParameter extends ModelElementBase {
    constructor(options?: LayoutParameterCreationOptions);
    $Type: "Pages$LayoutParameter";
    name: string;
}
export declare abstract class TemplateFormBase extends FormBase {
    displayName: string;
    documentationUrl: string;
    templateCategory: string;
    templateCategoryWeight: number;
    imageData: any;
}
export interface BuildingBlockCreationOptions {
    name: string;
}
export declare class BuildingBlock extends TemplateFormBase {
    constructor(options?: BuildingBlockCreationOptions);
    $Type: "Pages$BuildingBlock";
    widgets: Widget[];
    platform: SnippetType;
}
export declare abstract class TemplateType extends ModelElementBase {
}
export declare class RegularPageTemplateType extends TemplateType {
    $Type: "Pages$RegularPageTemplateType";
}
export declare class EditPageTemplateType extends TemplateType {
    $Type: "Pages$EditPageTemplateType";
}
export declare class SelectPageTemplateType extends TemplateType {
    $Type: "Pages$SelectPageTemplateType";
}
export interface PageTemplateCreationOptions {
    name: string;
}
export declare class PageTemplate extends TemplateFormBase {
    constructor(options?: PageTemplateCreationOptions);
    $Type: "Pages$PageTemplate";
    layoutCall: LayoutCall;
    appearance: Appearance;
    templateType: TemplateType;
}
export declare abstract class ClientAction extends ModelElementBase {
    disabledDuringExecution: boolean;
}
export declare class NoClientAction extends ClientAction {
    $Type: "Pages$NoClientAction";
}
export declare class PageClientAction extends ClientAction {
    $Type: "Pages$PageClientAction";
    pageSettings: PageSettings;
    pagesForSpecializations: PageForSpecialization[];
    numberOfPagesToClose2: string | null;
}
export declare class MicroflowClientAction extends ClientAction {
    $Type: "Pages$MicroflowClientAction";
    microflowSettings: MicroflowSettings;
}
export declare class CallNanoflowClientAction extends ClientAction {
    $Type: "Pages$CallNanoflowClientAction";
    nanoflow: string | null;
    parameterMappings: NanoflowParameterMapping[];
    progressBar: ProgressBarType;
    progressMessage: Texts.Text | null;
    confirmationInfo: ConfirmationInfo | null;
}
export declare class SignOutClientAction extends ClientAction {
    $Type: "Pages$SignOutClientAction";
}
export declare class SaveChangesClientAction extends ClientAction {
    $Type: "Pages$SaveChangesClientAction";
    syncAutomatically: boolean;
    closePage: boolean;
}
export declare class CancelChangesClientAction extends ClientAction {
    $Type: "Pages$CancelChangesClientAction";
    closePage: boolean;
}
export declare class ClosePageClientAction extends ClientAction {
    $Type: "Pages$ClosePageClientAction";
    numberOfPagesToClose: string | null;
}
export declare class SyncClientAction extends ClientAction {
    $Type: "Pages$SyncClientAction";
}
export declare class OpenLinkClientAction extends ClientAction {
    $Type: "Pages$OpenLinkClientAction";
    linkType: LinkType;
    address: StaticOrDynamicString;
}
export declare class DeleteClientAction extends ClientAction {
    $Type: "Pages$DeleteClientAction";
    closePage: boolean;
    sourceVariable: PageVariable | null;
}
export declare class CreateObjectClientAction extends ClientAction {
    $Type: "Pages$CreateObjectClientAction";
    entityRef: DomainModels.EntityRef | null;
    pageSettings: PageSettings;
    numberOfPagesToClose2: string | null;
}
export declare class PageSettings extends ModelElementBase {
    $Type: "Pages$PageSettings";
    page: string | null;
    parameterMappings: PageParameterMapping[];
}
export declare class PageParameterMapping extends ModelElementBase {
    $Type: "Pages$PageParameterMapping";
    parameter: string;
    variable: PageVariable;
    argument: string | null;
}
export declare class MicroflowSettings extends ModelElementBase {
    $Type: "Pages$MicroflowSettings";
    microflow: string | null;
    parameterMappings: MicroflowParameterMapping[];
    progressBar: ProgressBarType;
    progressMessage: Texts.Text | null;
    asynchronous: boolean;
    formValidations: FormValidations;
    confirmationInfo: ConfirmationInfo | null;
}
export declare class MicroflowParameterMapping extends ModelElementBase {
    $Type: "Pages$MicroflowParameterMapping";
    parameter: string;
    expression: string | null;
    variable: PageVariable | null;
}
export declare class NanoflowParameterMapping extends ModelElementBase {
    $Type: "Pages$NanoflowParameterMapping";
    parameter: string;
    expression: string | null;
    variable: PageVariable | null;
}
export declare class ConfirmationInfo extends ModelElementBase {
    $Type: "Pages$ConfirmationInfo";
    question: Texts.Text;
    proceedButtonCaption: Texts.Text;
    cancelButtonCaption: Texts.Text;
}
export declare class PageVariable extends ModelElementBase {
    $Type: "Pages$PageVariable";
    widget: string | null;
    pageParameter: string | null;
    snippetParameter: string | null;
    localVariable: string | null;
    useAllPages: boolean;
    subKey: string;
}
export interface LocalVariableCreationOptions {
    name: string;
}
export declare class LocalVariable extends ModelElementBase {
    constructor(options?: LocalVariableCreationOptions);
    $Type: "Pages$LocalVariable";
    name: string;
    variableType: DataTypes.DataType;
    defaultValue: string | null;
}
export declare class Appearance extends ModelElementBase {
    $Type: "Pages$Appearance";
    class: string;
    style: string;
    designProperties: DesignPropertyValue[];
    dynamicClasses: string | null;
}
export declare class DesignPropertyValue extends ModelElementBase {
    $Type: "Pages$DesignPropertyValue";
    key: string;
    value: AbstractDesignPropertyValue | null;
}
export declare abstract class AbstractDesignPropertyValue extends ModelElementBase {
}
export declare class OptionDesignPropertyValue extends AbstractDesignPropertyValue {
    $Type: "Pages$OptionDesignPropertyValue";
    option: string;
}
export declare class ToggleDesignPropertyValue extends AbstractDesignPropertyValue {
    $Type: "Pages$ToggleDesignPropertyValue";
}
export declare class CustomDesignPropertyValue extends AbstractDesignPropertyValue {
    $Type: "Pages$CustomDesignPropertyValue";
    value: string;
}
export declare class CompoundDesignPropertyValue extends AbstractDesignPropertyValue {
    $Type: "Pages$CompoundDesignPropertyValue";
    properties: DesignPropertyValue[];
}
export declare abstract class Widget extends ModelElementBase {
    name: string;
    appearance: Appearance;
    tabIndex: number;
}
export declare abstract class LoginTextBox extends Widget {
    label: Texts.Text | null;
    labelWidth: number;
    placeholder: Texts.Text;
}
export interface LoginIdTextBoxCreationOptions {
    name: string;
}
export declare class LoginIdTextBox extends LoginTextBox {
    constructor(options?: LoginIdTextBoxCreationOptions);
    $Type: "Pages$LoginIdTextBox";
}
export interface PasswordTextBoxCreationOptions {
    name: string;
}
export declare class PasswordTextBox extends LoginTextBox {
    constructor(options?: PasswordTextBoxCreationOptions);
    $Type: "Pages$PasswordTextBox";
}
export interface ValidationMessageCreationOptions {
    name: string;
}
export declare class ValidationMessage extends Widget {
    constructor(options?: ValidationMessageCreationOptions);
    $Type: "Pages$ValidationMessage";
}
export declare class FormattingInfo extends ModelElementBase {
    $Type: "Pages$FormattingInfo";
    decimalPrecision: number;
    groupDigits: boolean;
    enumFormat: EnumFormat;
    dateFormat: DateFormat;
    customDateFormat: string;
}
export declare class WidgetValidation extends ModelElementBase {
    $Type: "Pages$WidgetValidation";
    expression: string | null;
    message: Texts.Text;
}
export declare abstract class ConditionallyVisibleWidget extends Widget {
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
}
export declare abstract class ConditionalSettings extends ModelElementBase {
    attribute: string | null;
    conditions: Enumerations.Condition[];
    expression: string | null;
    sourceVariable: PageVariable | null;
}
export declare class ConditionalVisibilitySettings extends ConditionalSettings {
    $Type: "Pages$ConditionalVisibilitySettings";
    moduleRoles: string[];
    ignoreSecurity: boolean;
}
export declare class ConditionalEditabilitySettings extends ConditionalSettings {
    $Type: "Pages$ConditionalEditabilitySettings";
}
export declare class AccessibilitySettings extends ModelElementBase {
    $Type: "Pages$AccessibilitySettings";
    screenReaderDescription: ClientTemplate;
    screenReaderTitle: ClientTemplate;
}
export interface TableCreationOptions {
    name: string;
}
export declare class Table extends ConditionallyVisibleWidget {
    constructor(options?: TableCreationOptions);
    $Type: "Pages$Table";
    cells: TableCell[];
    columns: TableColumn[];
    widthUnit: UnitEnum;
    rows: TableRow[];
}
export declare class TableCell extends ModelElementBase {
    $Type: "Pages$TableCell";
    appearance: Appearance;
    isHeader: boolean;
    widgets: Widget[];
    leftColumnIndex: number;
    topRowIndex: number;
    width: number;
    height: number;
}
export declare class TableColumn extends ModelElementBase {
    $Type: "Pages$TableColumn";
    width: number;
}
export declare class TableRow extends ModelElementBase {
    $Type: "Pages$TableRow";
    appearance: Appearance;
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
}
export declare abstract class EntityWidget extends ConditionallyVisibleWidget {
    dataSource: DataSource | null;
}
export declare abstract class DataSource extends ModelElementBase {
    forceFullObjects: boolean;
}
export declare abstract class EntityPathSource extends DataSource {
    entityRef: DomainModels.EntityRef | null;
    sourceVariable: PageVariable | null;
}
export declare class MicroflowSource extends DataSource {
    $Type: "Pages$MicroflowSource";
    microflowSettings: MicroflowSettings;
}
export declare class NanoflowSource extends DataSource {
    $Type: "Pages$NanoflowSource";
    nanoflow: string | null;
    parameterMappings: NanoflowParameterMapping[];
}
export declare abstract class ListenTargetWidget extends EntityWidget {
}
export declare class AssociationSource extends EntityPathSource {
    $Type: "Pages$AssociationSource";
}
export interface DataViewCreationOptions {
    name: string;
    showFooter?: boolean;
    labelWidth?: number;
}
export declare class DataView extends EntityWidget {
    constructor(options?: DataViewCreationOptions);
    $Type: "Pages$DataView";
    widgets: Widget[];
    footerWidgets: Widget[];
    editability: EditableEnum;
    conditionalEditabilitySettings: ConditionalEditabilitySettings | null;
    showFooter: boolean;
    noEntityMessage: Texts.Text;
    labelWidth: number;
    readOnlyStyle: DataViewReadOnlyStyle;
}
export declare class DataViewSource extends EntityPathSource {
    $Type: "Pages$DataViewSource";
}
export declare class ListenTargetSource extends DataSource {
    $Type: "Pages$ListenTargetSource";
    listenTarget: string;
}
export declare abstract class ControlBar extends ModelElementBase {
    items: ControlBarItem[];
}
export declare abstract class ControlBarItem extends ModelElementBase {
    name: string;
}
export declare abstract class ControlBarButton extends ControlBarItem {
    caption: ClientTemplate;
    tooltip: Texts.Text;
    icon: Icon | null;
    appearance: Appearance;
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
    buttonStyle: ButtonStyle;
}
export interface ListViewCreationOptions {
    name: string;
}
export declare class ListView extends ListenTargetWidget {
    constructor(options?: ListViewCreationOptions);
    $Type: "Pages$ListView";
    widgets: Widget[];
    pageSize: number;
    clickAction: ClientAction;
    editable: boolean;
    templates: ListViewTemplate[];
    scrollDirection: ScrollDirection;
    numberOfColumns: number;
    pullDownAction: ClientAction;
}
export declare class ListViewTemplate extends ModelElementBase {
    $Type: "Pages$ListViewTemplate";
    specialization: string;
    widgets: Widget[];
}
export declare abstract class SortableEntityPathSource extends EntityPathSource {
    sortBar: GridSortBar;
}
export declare abstract class XPathSourceBase extends SortableEntityPathSource {
    xPathConstraint: string | null;
}
export declare class ListViewXPathSource extends XPathSourceBase {
    $Type: "Pages$ListViewXPathSource";
    search: ListViewSearch;
}
export declare class GridSortBar extends ModelElementBase {
    $Type: "Pages$GridSortBar";
    sortItems: GridSortItem[];
}
export declare class GridSortItem extends ModelElementBase {
    $Type: "Pages$GridSortItem";
    attributeRef: DomainModels.AttributeRef;
    sortDirection: SortDirection;
}
export declare abstract class Button extends ConditionallyVisibleWidget {
    caption: ClientTemplate;
    tooltip: Texts.Text;
    icon: Icon | null;
    renderType: RenderType;
    buttonStyle: ButtonStyle;
}
export declare class StaticOrDynamicString extends ModelElementBase {
    $Type: "Pages$StaticOrDynamicString";
    isDynamic: boolean;
    value: string;
    attributeRef: DomainModels.AttributeRef | null;
}
export interface ActionButtonCreationOptions {
    name: string;
    caption?: string;
    buttonStyle?: ButtonStyle;
    renderType?: RenderType;
}
export declare class ActionButton extends Button {
    constructor(options?: ActionButtonCreationOptions);
    $Type: "Pages$ActionButton";
    action: ClientAction;
    ariaRole: ButtonAriaRoleType;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface ClientTemplateCreationOptions {
    text: string;
    languageCode?: string;
}
export declare class ClientTemplate extends ModelElementBase {
    constructor(options?: ClientTemplateCreationOptions);
    $Type: "Pages$ClientTemplate";
    template: Texts.Text;
    parameters: ClientTemplateParameter[];
    fallback: Texts.Text;
}
export declare class ClientTemplateParameter extends ModelElementBase {
    $Type: "Pages$ClientTemplateParameter";
    attributeRef: DomainModels.AttributeRef | null;
    expression: string | null;
    formattingInfo: FormattingInfo;
    sourceVariable: PageVariable | null;
}
export interface DropDownButtonCreationOptions {
    name: string;
}
export declare class DropDownButton extends Button {
    constructor(options?: DropDownButtonCreationOptions);
    $Type: "Pages$DropDownButton";
    items: DropDownButtonItem[];
}
export declare abstract class ActionItem extends ModelElementBase {
    action: ClientAction;
}
export declare class DropDownButtonItem extends ActionItem {
    $Type: "Pages$DropDownButtonItem";
    caption: Texts.Text;
    image: string | null;
}
export interface DynamicImageViewerCreationOptions {
    name: string;
}
export declare class DynamicImageViewer extends EntityWidget {
    constructor(options?: DynamicImageViewerCreationOptions);
    $Type: "Pages$DynamicImageViewer";
    defaultImage: string | null;
    widthUnit: ImageSizeUnit;
    heightUnit: ImageSizeUnit;
    width: number;
    height: number;
    responsive: boolean;
    showAsThumbnail: boolean;
    clickAction: ClientAction;
    onClickEnlarge: boolean;
    alternativeText: ClientTemplate;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface DynamicTextCreationOptions {
    name: string;
    content?: string;
    renderMode?: TextRenderMode;
}
export declare class DynamicText extends ConditionallyVisibleWidget {
    constructor(options?: DynamicTextCreationOptions);
    $Type: "Pages$DynamicText";
    content: ClientTemplate;
    renderMode: TextRenderMode;
    nativeTextStyle: NativeTextStyle;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export declare class PageForSpecialization extends ModelElementBase {
    $Type: "Pages$PageForSpecialization";
    entity: string;
    pageSettings: PageSettings;
}
export declare abstract class Grid extends ListenTargetWidget {
    isControlBarVisible: boolean;
    showPagingBar: ShowPagingBarType;
    selectionMode: GridSelectionMode;
    selectFirst: boolean;
    defaultButtonTrigger: ClickTypeType;
    refreshTime: number;
    controlBar: GridControlBar;
}
export declare abstract class GridBaseSource extends SortableEntityPathSource {
    searchBar: SearchBar;
}
export interface GridColumnCreationOptions {
    name: string;
}
export declare class GridColumn extends ModelElementBase {
    constructor(options?: GridColumnCreationOptions);
    $Type: "Pages$GridColumn";
    name: string;
    caption: Texts.Text;
    attributeRef: DomainModels.AttributeRef | null;
    formattingInfo: FormattingInfo;
    showTooltip: boolean;
    aggregateCaption: Texts.Text;
    aggregateFunction: AggregateFunction;
    editable: boolean;
    width: number;
    appearance: Appearance;
}
export declare class GridControlBar extends ControlBar {
    $Type: "Pages$GridControlBar";
    defaultButton: string | null;
}
export declare abstract class GridControlBarButton extends ControlBarButton {
}
export interface GridDeselectAllButtonCreationOptions {
    name: string;
}
export declare class GridDeselectAllButton extends GridControlBarButton {
    constructor(options?: GridDeselectAllButtonCreationOptions);
    $Type: "Pages$GridDeselectAllButton";
}
export interface GridNewButtonCreationOptions {
    name: string;
}
export declare class GridNewButton extends GridControlBarButton {
    constructor(options?: GridNewButtonCreationOptions);
    $Type: "Pages$GridNewButton";
    entity: string | null;
    editLocation: NewButtonEditLocation;
    pageSettings: PageSettings;
}
export interface GridSearchButtonCreationOptions {
    name: string;
}
export declare class GridSearchButton extends GridControlBarButton {
    constructor(options?: GridSearchButtonCreationOptions);
    $Type: "Pages$GridSearchButton";
}
export interface GridSelectAllButtonCreationOptions {
    name: string;
}
export declare class GridSelectAllButton extends GridControlBarButton {
    constructor(options?: GridSelectAllButtonCreationOptions);
    $Type: "Pages$GridSelectAllButton";
    selectionType: SelectionType;
}
export interface GroupBoxCreationOptions {
    name: string;
}
export declare class GroupBox extends ConditionallyVisibleWidget {
    constructor(options?: GroupBoxCreationOptions);
    $Type: "Pages$GroupBox";
    caption: ClientTemplate | null;
    collapsible: GroupBoxCollapsible;
    headerMode: GroupBoxRenderMode;
    widgets: Widget[];
}
export interface HeaderCreationOptions {
    name: string;
}
export declare class Header extends Widget {
    constructor(options?: HeaderCreationOptions);
    $Type: "Pages$Header";
    leftWidgets: Widget[];
    rightWidgets: Widget[];
}
export declare abstract class Icon extends ModelElementBase {
}
export declare class ImageIcon extends Icon {
    $Type: "Pages$ImageIcon";
    image: string;
}
export declare class IconCollectionIcon extends Icon {
    $Type: "Pages$IconCollectionIcon";
    image: string;
}
export declare class ImageViewerSource extends EntityPathSource {
    $Type: "Pages$ImageViewerSource";
}
export interface LayoutGridCreationOptions {
    name: string;
    columns?: {
        weight: number;
    }[];
    width?: ContainerWidth;
}
export declare class LayoutGrid extends ConditionallyVisibleWidget {
    constructor(options?: LayoutGridCreationOptions);
    $Type: "Pages$LayoutGrid";
    width: ContainerWidth;
    rows: LayoutGridRow[];
}
export interface LayoutGridColumnCreationOptions {
    weight?: number;
}
export declare class LayoutGridColumn extends ModelElementBase {
    constructor(options?: LayoutGridColumnCreationOptions);
    $Type: "Pages$LayoutGridColumn";
    weight: number;
    tabletWeight: number;
    phoneWeight: number;
    previewWidth: number;
    widgets: Widget[];
    appearance: Appearance;
    verticalAlignment: LayoutGridAlignment;
}
export interface LayoutGridRowCreationOptions {
    columns?: {
        weight: number;
    }[];
}
export declare class LayoutGridRow extends ModelElementBase {
    constructor(options?: LayoutGridRowCreationOptions);
    $Type: "Pages$LayoutGridRow";
    columns: LayoutGridColumn[];
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
    appearance: Appearance;
    verticalAlignment: LayoutGridAlignment;
    horizontalAlignment: LayoutGridAlignment;
    spacingBetweenColumns: boolean;
}
export declare abstract class MenuSource extends ModelElementBase {
}
export declare abstract class MenuWidget extends Widget {
    menuSource: MenuSource;
}
export interface NavigationListCreationOptions {
    name: string;
}
export declare class NavigationList extends ConditionallyVisibleWidget {
    constructor(options?: NavigationListCreationOptions);
    $Type: "Pages$NavigationList";
    items: NavigationListItem[];
}
export declare class NavigationListItem extends ActionItem {
    $Type: "Pages$NavigationListItem";
    widgets: Widget[];
    appearance: Appearance;
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
}
export declare class NavigationSource extends MenuSource {
    $Type: "Pages$NavigationSource";
    navigationProfile: string;
}
export interface NavigationTreeCreationOptions {
    name: string;
}
export declare class NavigationTree extends MenuWidget {
    constructor(options?: NavigationTreeCreationOptions);
    $Type: "Pages$NavigationTree";
}
export declare class ReferenceSetSource extends GridBaseSource {
    $Type: "Pages$ReferenceSetSource";
}
export interface ScrollContainerCreationOptions {
    name: string;
}
export declare class ScrollContainer extends Widget {
    constructor(options?: ScrollContainerCreationOptions);
    $Type: "Pages$ScrollContainer";
    center: ScrollContainerRegion;
    left: ScrollContainerRegion | null;
    right: ScrollContainerRegion | null;
    top: ScrollContainerRegion | null;
    bottom: ScrollContainerRegion | null;
    layoutMode: LayoutModeType;
    widthMode: SizeMode;
    width: number;
    alignment: AlignmentEnum;
    scrollBehavior: ScrollBehavior;
    nativeHideScrollbars: boolean;
}
export declare class ScrollContainerRegion extends ModelElementBase {
    $Type: "Pages$ScrollContainerRegion";
    widgets: Widget[];
    sizeMode: SizeMode;
    size: number;
    appearance: Appearance;
    toggleMode: ToggleMode;
}
export declare class SearchBar extends ControlBar {
    $Type: "Pages$SearchBar";
    type: SearchBarTypeEnum;
    waitForSearch: boolean;
}
export declare class ListViewSearch extends ModelElementBase {
    $Type: "Pages$ListViewSearch";
    searchRefs: DomainModels.AttributeRef[];
}
export declare abstract class SearchField extends ControlBarItem {
    caption: Texts.Text;
    placeholder: Texts.Text;
    customDateFormat: string;
    type: SearchFieldType;
    defaultValue: string;
}
export interface SelectButtonCreationOptions {
    name: string;
}
export declare class SelectButton extends GridControlBarButton {
    constructor(options?: SelectButtonCreationOptions);
    $Type: "Pages$SelectButton";
}
export declare abstract class SelectorSource extends ModelElementBase {
}
export interface SidebarToggleButtonCreationOptions {
    name: string;
}
export declare class SidebarToggleButton extends Button {
    constructor(options?: SidebarToggleButtonCreationOptions);
    $Type: "Pages$SidebarToggleButton";
}
export interface SimpleMenuBarCreationOptions {
    name: string;
}
export declare class SimpleMenuBar extends MenuWidget {
    constructor(options?: SimpleMenuBarCreationOptions);
    $Type: "Pages$SimpleMenuBar";
    orientation: SimpleMenuBarOrientation;
}
export declare abstract class SingleSearchField extends SearchField {
    attributeRef: DomainModels.AttributeRef | null;
    operator: SearchFieldOperator;
}
export interface SnippetCreationOptions {
    name: string;
}
export declare class Snippet extends FormBase {
    constructor(options?: SnippetCreationOptions);
    $Type: "Pages$Snippet";
    widgets: Widget[];
    type: SnippetType;
    parameters: SnippetParameter[];
    variables: LocalVariable[];
}
export interface SnippetParameterCreationOptions {
    name: string;
}
export declare class SnippetParameter extends ModelElementBase {
    constructor(options?: SnippetParameterCreationOptions);
    $Type: "Pages$SnippetParameter";
    name: string;
    parameterType: DataTypes.DataType;
}
export declare class SnippetCall extends ModelElementBase {
    $Type: "Pages$SnippetCall";
    snippet: string | null;
    parameterMappings: SnippetParameterMapping[];
}
export declare class SnippetParameterMapping extends ModelElementBase {
    $Type: "Pages$SnippetParameterMapping";
    parameter: string;
    variable: PageVariable;
}
export interface SnippetCallWidgetCreationOptions {
    name: string;
}
export declare class SnippetCallWidget extends Widget {
    constructor(options?: SnippetCallWidgetCreationOptions);
    $Type: "Pages$SnippetCallWidget";
    snippetCall: SnippetCall;
}
export interface TabContainerCreationOptions {
    name: string;
}
export declare class TabContainer extends ConditionallyVisibleWidget {
    constructor(options?: TabContainerCreationOptions);
    $Type: "Pages$TabContainer";
    tabPages: TabPage[];
    defaultPage: string | null;
    activePageAttributeRef: DomainModels.AttributeRef | null;
    activePageSourceVariable: PageVariable | null;
    activePageOnChangeAction: ClientAction;
}
export interface TabPageCreationOptions {
    name: string;
}
export declare class TabPage extends ModelElementBase {
    constructor(options?: TabPageCreationOptions);
    $Type: "Pages$TabPage";
    name: string;
    caption: Texts.Text;
    refreshOnShow: boolean;
    conditionalVisibilitySettings: ConditionalVisibilitySettings | null;
    widgets: Widget[];
    badge: ClientTemplate | null;
}
export interface TemplateGridCreationOptions {
    name: string;
}
export declare class TemplateGrid extends Grid {
    constructor(options?: TemplateGridCreationOptions);
    $Type: "Pages$TemplateGrid";
    contents: TemplateGridContents;
    numberOfRows: number;
    numberOfColumns: number;
}
export declare class TemplateGridContents extends ModelElementBase {
    $Type: "Pages$TemplateGridContents";
    widgets: Widget[];
}
export interface TitleCreationOptions {
    name: string;
}
export declare class Title extends ConditionallyVisibleWidget {
    constructor(options?: TitleCreationOptions);
    $Type: "Pages$Title";
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export declare abstract class WorkflowTemplateType extends TemplateType {
}
export declare class UserTaskTemplateType extends WorkflowTemplateType {
    $Type: "Pages$UserTaskTemplateType";
}
export declare class WorkflowOverviewTemplateType extends WorkflowTemplateType {
    $Type: "Pages$WorkflowOverviewTemplateType";
}
export declare class CallWorkflowClientAction extends ClientAction {
    $Type: "Pages$CallWorkflowClientAction";
    workflow: string | null;
    closePage: boolean;
    confirmationInfo: ConfirmationInfo | null;
}
export declare class OpenUserTaskClientAction extends ClientAction {
    $Type: "Pages$OpenUserTaskClientAction";
    assignOnOpen: boolean;
    openWhenAssigned: boolean;
}
export declare class OpenWorkflowClientAction extends ClientAction {
    $Type: "Pages$OpenWorkflowClientAction";
    defaultPage: string | null;
}
export declare class SetTaskOutcomeClientAction extends ClientAction {
    $Type: "Pages$SetTaskOutcomeClientAction";
    outcomeValue: string;
    closePage: boolean;
    commit: boolean;
}
export interface PlaceholderCreationOptions {
    name: string;
}
export declare class Placeholder extends Widget {
    constructor(options?: PlaceholderCreationOptions);
    $Type: "Pages$Placeholder";
}
export interface TemplatePlaceholderCreationOptions {
    name: string;
}
export declare class TemplatePlaceholder extends Widget {
    constructor(options?: TemplatePlaceholderCreationOptions);
    $Type: "Pages$TemplatePlaceholder";
    type: string;
}
export interface LabelCreationOptions {
    name: string;
}
export declare class Label extends ConditionallyVisibleWidget {
    constructor(options?: LabelCreationOptions);
    $Type: "Pages$Label";
    caption: Texts.Text;
}
export interface StaticImageViewerCreationOptions {
    name: string;
}
export declare class StaticImageViewer extends ConditionallyVisibleWidget {
    constructor(options?: StaticImageViewerCreationOptions);
    $Type: "Pages$StaticImageViewer";
    image: string | null;
    widthUnit: ImageSizeUnit;
    heightUnit: ImageSizeUnit;
    width: number;
    height: number;
    clickAction: ClientAction;
    responsive: boolean;
    alternativeText: ClientTemplate;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface DivContainerCreationOptions {
    name: string;
    renderMode?: ContainerRenderMode;
}
export declare class DivContainer extends ConditionallyVisibleWidget {
    constructor(options?: DivContainerCreationOptions);
    $Type: "Pages$DivContainer";
    widgets: Widget[];
    renderMode: ContainerRenderMode;
    onClickAction: ClientAction;
    screenReaderHidden: boolean;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface LoginButtonCreationOptions {
    name: string;
}
export declare class LoginButton extends Button {
    constructor(options?: LoginButtonCreationOptions);
    $Type: "Pages$LoginButton";
    validationMessageWidget: string;
}
export declare abstract class ConditionallyEditableWidget extends ConditionallyVisibleWidget {
    conditionalEditabilitySettings: ConditionalEditabilitySettings | null;
    editable: EditableEnum;
}
export declare abstract class ColumnGrid extends Grid {
    columns: GridColumn[];
    numberOfRows: number;
    showEmptyRows: boolean;
    widthUnit: UnitEnum;
    tooltipPage: string | null;
}
export interface ComparisonSearchFieldCreationOptions {
    name: string;
}
export declare class ComparisonSearchField extends SingleSearchField {
    constructor(options?: ComparisonSearchFieldCreationOptions);
    $Type: "Pages$ComparisonSearchField";
}
export declare class GridXPathSource extends GridBaseSource {
    $Type: "Pages$GridXPathSource";
    xPathConstraint: string | null;
}
export interface DataGridCreationOptions {
    name: string;
}
export declare class DataGrid extends ColumnGrid {
    constructor(options?: DataGridCreationOptions);
    $Type: "Pages$DataGrid";
    caption: ClientTemplate;
}
export interface DataGridAddButtonCreationOptions {
    name: string;
}
export declare class DataGridAddButton extends GridControlBarButton {
    constructor(options?: DataGridAddButtonCreationOptions);
    $Type: "Pages$DataGridAddButton";
    pageSettings: PageSettings;
}
export interface DataGridExportToCSVButtonCreationOptions {
    name: string;
}
export declare class DataGridExportToCSVButton extends GridControlBarButton {
    constructor(options?: DataGridExportToCSVButtonCreationOptions);
    $Type: "Pages$DataGridExportToCSVButton";
    maxNumberOfRows: number;
    decimalSeparator: string;
    groupSeparator: string;
    delimiter: string;
    generateExcelHint: boolean;
    useGridDateFormat: boolean;
}
export interface DataGridExportToExcelButtonCreationOptions {
    name: string;
}
export declare class DataGridExportToExcelButton extends GridControlBarButton {
    constructor(options?: DataGridExportToExcelButtonCreationOptions);
    $Type: "Pages$DataGridExportToExcelButton";
    maxNumberOfRows: number;
    useExcelDateType: boolean;
}
export interface DataGridRemoveButtonCreationOptions {
    name: string;
}
export declare class DataGridRemoveButton extends GridControlBarButton {
    constructor(options?: DataGridRemoveButtonCreationOptions);
    $Type: "Pages$DataGridRemoveButton";
}
export interface DropDownSearchFieldCreationOptions {
    name: string;
}
export declare class DropDownSearchField extends SingleSearchField {
    constructor(options?: DropDownSearchFieldCreationOptions);
    $Type: "Pages$DropDownSearchField";
    sortBar: GridSortBar;
    xPathConstraint: string | null;
    allowMultipleSelect: boolean;
}
export declare class GlyphIcon extends Icon {
    $Type: "Pages$GlyphIcon";
    code: number;
}
export interface GridActionButtonCreationOptions {
    name: string;
}
export declare class GridActionButton extends GridControlBarButton {
    constructor(options?: GridActionButtonCreationOptions);
    $Type: "Pages$GridActionButton";
    action: ClientAction;
    maintainSelectionAfterMicroflow: boolean;
}
export interface MenuBarCreationOptions {
    name: string;
}
export declare class MenuBar extends MenuWidget {
    constructor(options?: MenuBarCreationOptions);
    $Type: "Pages$MenuBar";
}
export declare class MenuDocumentSource extends MenuSource {
    $Type: "Pages$MenuDocumentSource";
    menu: string | null;
}
export interface RangeSearchFieldCreationOptions {
    name: string;
}
export declare class RangeSearchField extends SearchField {
    constructor(options?: RangeSearchFieldCreationOptions);
    $Type: "Pages$RangeSearchField";
    lowerBoundRef: DomainModels.AttributeRef | null;
    upperBoundRef: DomainModels.AttributeRef | null;
    includeLower: boolean;
    includeUpper: boolean;
}
export interface ReferenceSetSelectorCreationOptions {
    name: string;
}
export declare class ReferenceSetSelector extends ColumnGrid {
    constructor(options?: ReferenceSetSelectorCreationOptions);
    $Type: "Pages$ReferenceSetSelector";
    onChangeAction: ClientAction;
    constrainedByRefs: DomainModels.EntityRef[];
    xPathConstraint: string | null;
}
export declare class SelectorXPathSource extends SelectorSource {
    $Type: "Pages$SelectorXPathSource";
    sortBar: GridSortBar;
    xPathConstraint: string | null;
    constrainedByRefs: DomainModels.EntityRef[];
}
export declare class SelectorMicroflowSource extends SelectorSource {
    $Type: "Pages$SelectorMicroflowSource";
    dataSourceMicroflowSettings: MicroflowSettings;
}
export interface InputWidgetCreationOptions {
    labelCaption?: string;
    showLabel?: boolean;
}
export declare abstract class InputWidget extends ConditionallyEditableWidget {
    constructor(options?: InputWidgetCreationOptions);
    labelTemplate: ClientTemplate | null;
    screenReaderLabel: ClientTemplate | null;
}
export interface FileManagerCreationOptions {
    name: string;
}
export declare class FileManager extends InputWidget {
    constructor(options?: FileManagerCreationOptions);
    $Type: "Pages$FileManager";
    allowedExtensions: string;
    type: FileManagerType;
    maxFileSize: number;
    showFileInBrowser: boolean;
}
export interface ImageUploaderCreationOptions {
    name: string;
}
export declare class ImageUploader extends InputWidget {
    constructor(options?: ImageUploaderCreationOptions);
    $Type: "Pages$ImageUploader";
    allowedExtensions: string;
    thumbnailSize: string;
    maxFileSize: number;
}
export declare abstract class MemberWidget extends InputWidget {
    attributeRef: DomainModels.AttributeRef | null;
    readOnlyStyle: ReadOnlyStyle;
}
export declare abstract class AssociationWidget extends MemberWidget {
    selectorSource: SelectorSource;
    selectPageSettings: PageSettings;
    onChangeAction: ClientAction;
    sourceVariable: PageVariable | null;
}
export declare abstract class AttributeWidget extends MemberWidget {
    validation: WidgetValidation;
    onChangeAction: ClientAction;
    onEnterAction: ClientAction;
    onLeaveAction: ClientAction;
    sourceVariable: PageVariable | null;
    ariaRequired: boolean;
}
export interface DropDownCreationOptions {
    name: string;
}
export declare class DropDown extends AttributeWidget {
    constructor(options?: DropDownCreationOptions);
    $Type: "Pages$DropDown";
    emptyOptionCaption: Texts.Text;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface InputReferenceSetSelectorCreationOptions {
    name: string;
}
export declare class InputReferenceSetSelector extends AssociationWidget {
    constructor(options?: InputReferenceSetSelectorCreationOptions);
    $Type: "Pages$InputReferenceSetSelector";
}
export interface ReferenceSelectorCreationOptions {
    name: string;
}
export declare class ReferenceSelector extends AssociationWidget {
    constructor(options?: ReferenceSelectorCreationOptions);
    $Type: "Pages$ReferenceSelector";
    validation: WidgetValidation;
    renderMode: ReferenceSelectorRenderModeType;
    gotoPageSettings: PageSettings;
    formattingInfo: FormattingInfo;
    emptyOptionCaption: Texts.Text;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface CheckBoxCreationOptions extends InputWidgetCreationOptions {
    name: string;
}
export declare class CheckBox extends AttributeWidget {
    constructor(options?: CheckBoxCreationOptions);
    $Type: "Pages$CheckBox";
    labelPosition: LabelPosition;
    nativeRenderMode: NativeRenderMode;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface RadioButtonGroupCreationOptions extends InputWidgetCreationOptions {
    name: string;
    renderHorizontal?: boolean;
}
export declare class RadioButtonGroup extends AttributeWidget {
    constructor(options?: RadioButtonGroupCreationOptions);
    $Type: "Pages$RadioButtonGroup";
    renderHorizontal: boolean;
}
export declare abstract class AttributeWidgetWithPlaceholder extends AttributeWidget {
    placeholderTemplate: ClientTemplate;
}
export interface DatePickerCreationOptions extends InputWidgetCreationOptions {
    name: string;
}
export declare class DatePicker extends AttributeWidgetWithPlaceholder {
    constructor(options?: DatePickerCreationOptions);
    $Type: "Pages$DatePicker";
    formattingInfo: FormattingInfo;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export declare abstract class TextWidget extends AttributeWidgetWithPlaceholder {
    maxLengthCode: number;
    autoFocus: boolean;
}
export interface TextBoxCreationOptions extends InputWidgetCreationOptions {
    name: string;
    isPasswordBox?: boolean;
}
export declare class TextBox extends TextWidget {
    constructor(options?: TextBoxCreationOptions);
    $Type: "Pages$TextBox";
    inputMask: string;
    formattingInfo: FormattingInfo;
    isPasswordBox: boolean;
    keyboardType: KeyboardType;
    onEnterKeyPressAction: ClientAction;
    autocomplete: boolean;
    autocompletePurpose: AutocompletePurposeType;
    submitBehaviour: SubmitBehaviourType;
    submitOnInputDelay: number;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export interface TextAreaCreationOptions extends InputWidgetCreationOptions {
    name: string;
}
export declare class TextArea extends TextWidget {
    constructor(options?: TextAreaCreationOptions);
    $Type: "Pages$TextArea";
    numberOfLines: number;
    counterMessage: Texts.Text;
    textTooLongMessage: Texts.Text;
    autocomplete: boolean;
    submitBehaviour: SubmitBehaviourType;
    submitOnInputDelay: number;
    nativeAccessibilitySettings: AccessibilitySettings | null;
}
export type FormLocation = "Content" | "Popup" | "ModalPopup";
export type ProgressBarType = "None" | "NonBlocking" | "Blocking";
export type FormValidations = "None" | "Widget" | "All";
export type SubmitBehaviourType = "OnEndEditing" | "WhileEditing";
export type AutocompletePurposeType = "On" | "Off" | "FullName" | "HonorificPrefix" | "GivenName" | "AdditionalName" | "FamilyName" | "HonorificSuffix" | "Nickname" | "JobTitle" | "Username" | "NewPassword" | "CurrentPassword" | "CompanyName" | "StreetAddress" | "StreetAddressLine1" | "StreetAddressLine2" | "StreetAddressLine3" | "AddressLevel4" | "AddressLevel3" | "AddressLevel2" | "AddressLevel1" | "CountryCode" | "CountryName" | "PostalCode" | "CreditCardFullName" | "CreditCardGivenName" | "CreditCardAdditionalName" | "CreditCardFamilyName" | "CreditCardNumber" | "CreditCardExpiration" | "CreditCardExpirationMonth" | "CreditCardExpirationYear" | "CreditCardSecurityCode" | "CreditCardType" | "TransactionCurrency" | "TransactionAmount" | "Language" | "Birthday" | "DayOfBirth" | "MonthOfBirth" | "YearOfBirth" | "Sex" | "Url" | "Photo" | "TelephoneNumber" | "TelephoneCountryCode" | "TelephoneWithoutCountryCode" | "TelephoneAreaCode" | "TelephoneLocal" | "TelephoneLocalPrefix" | "TelephoneLocalSuffix" | "TelephoneExtension" | "Email" | "InstantMessageProtocol";
export type KeyboardType = "NumberPad" | "DecimalPad" | "EmailAddress" | "PhonePad" | "URL" | "Default";
export type LabelPosition = "Default" | "BeforeControl" | "AfterControl";
export type NativeRenderMode = "CheckBox" | "Switch";
export type EnumFormat = "Text" | "Image";
export type DateFormat = "Date" | "Time" | "DateTime" | "Custom";
export type ReadOnlyStyle = "Inherit" | "Control" | "Text";
export type EditableEnum = "Always" | "Never" | "Conditional";
export type UnitEnum = "Weight" | "Pixels";
export type DataViewReadOnlyStyle = "Control" | "Text";
export type ScrollDirection = "Vertical" | "Horizontal";
export type SortDirection = "Ascending" | "Descending";
export type RenderType = "Button" | "Link";
export type ButtonStyle = "Default" | "Inverse" | "Primary" | "Info" | "Success" | "Warning" | "Danger";
export type ButtonAriaRoleType = "Button" | "Link" | "Checkbox" | "Radio" | "Tab" | "MenuItem" | "MenuItemCheckbox" | "MenuItemRadio" | "Option" | "Switch" | "TreeItem";
export type NativeTextStyle = "Text" | "Heading1" | "Heading2" | "Heading3" | "Heading4" | "Heading5" | "Heading6";
export type ToggleMode = "None" | "PushContentAside" | "SlideOverContent" | "ShrinkContentInitiallyOpen" | "ShrinkContentInitiallyClosed";
export type SnippetType = "Web" | "Native";
export type AggregateFunction = "None" | "Average" | "Maximum" | "Minimum" | "Sum" | "Count";
export type AlignmentEnum = "Left" | "Center" | "Right";
export type LayoutGridAlignment = "None" | "Start" | "Center" | "End";
export type ClickTypeType = "Single" | "Double";
export type ShowPagingBarType = "YesWithTotalCount" | "YesWithoutTotalCount" | "No";
export type ContainerWidth = "FullWidth" | "FixedWidth";
export type FileManagerType = "Upload" | "Download" | "Both";
export type GridSelectionMode = "None" | "Single" | "SingleAndMaintain" | "Multi" | "SimpleMulti";
export type GroupBoxCollapsible = "No" | "YesInitiallyExpanded" | "YesInitiallyCollapsed";
export type ImageSizeUnit = "Auto" | "Pixels" | "Percentage";
export type LayoutModeType = "Headline" | "Sidebar";
export type LayoutType = "Responsive" | "Tablet" | "Phone" | "ModalPopup" | "Popup" | "Legacy";
export type NativeLayoutType = "Default" | "TopLevel" | "Popup";
export type LinkType = "Web" | "Email" | "Call" | "Text";
export type NewButtonEditLocation = "InlineAtTop" | "InlineAtBottom" | "Form";
export type ReferenceSelectorRenderModeType = "Form" | "DropDown";
export type ScrollBehavior = "PerRegion" | "FullWidget";
export type SearchBarTypeEnum = "None" | "FoldableOpen" | "FoldableClosed" | "AlwaysOpen";
export type SearchFieldOperator = "Contains" | "StartsWith" | "Greater" | "GreaterOrEqual" | "Equal" | "NotEqual" | "SmallerOrEqual" | "Smaller";
export type SearchFieldType = "Normal" | "Hidden" | "ReadOnly";
export type SelectionType = "SelectPage" | "SelectAll";
export type SidebarToggleMode = "PushContentAside" | "SlideOverContent" | "ShrinkContent";
export type SidebarToggleRegion = "Left" | "Right";
export type SimpleMenuBarOrientation = "Horizontal" | "Vertical";
export type SizeMode = "Auto" | "Pixels" | "Percentage";
export type TextRenderMode = "Text" | "Paragraph" | "H1" | "H2" | "H3" | "H4" | "H5" | "H6";
export type ContainerRenderMode = "Div" | "Section" | "Article" | "Header" | "Footer" | "Main" | "Nav" | "Aside" | "Hgroup" | "Address";
export type GroupBoxRenderMode = "Div" | "H1" | "H2" | "H3" | "H4" | "H5" | "H6";
//# sourceMappingURL=Pages.d.ts.map