import { ModelElementBase } from '@mendix/model-access-publisher';
import * as Projects from "./Projects";
import * as Texts from "./Texts";
export interface EnumerationCreationOptions {
    name: string;
    values?: EnumerationValueCreationOptions[];
}
export declare class Enumeration extends Projects.Document {
    constructor(options?: EnumerationCreationOptions);
    $Type: "Enumerations$Enumeration";
    values: EnumerationValue[];
    remoteSource: RemoteEnumerationSource | null;
    name: string;
    documentation: string;
}
export interface EnumerationValueCreationOptions {
    name: string;
    caption?: string;
}
export declare class EnumerationValue extends ModelElementBase {
    constructor(options?: EnumerationValueCreationOptions);
    $Type: "Enumerations$EnumerationValue";
    name: string;
    caption: Texts.Text;
    image: string | null;
    remoteValue: RemoteEnumerationValue | null;
}
export declare class Condition extends ModelElementBase {
    $Type: "Enumerations$Condition";
    attributeValue: string;
    editableVisible: boolean;
}
export declare abstract class RemoteEnumerationSource extends ModelElementBase {
}
export declare abstract class RemoteEnumerationValue extends ModelElementBase {
}
//# sourceMappingURL=Enumerations.d.ts.map