import { Primitives } from '@mendix/model-access';
import { ModelElementBase } from '@mendix/model-access-publisher';
import * as Projects from "./Projects";
import * as Texts from "./Texts";
export declare class DomainModel extends Projects.ModuleDocument {
    $Type: "DomainModels$DomainModel";
    documentation: string;
    entities: Entity[];
    annotations: Annotation[];
    associations: Association[];
    crossAssociations: CrossAssociation[];
}
export interface EntityCreationOptions {
    name: string;
    attributes?: AttributeCreationOptions[];
}
export declare class Entity extends ModelElementBase {
    constructor(options?: EntityCreationOptions);
    $Type: "DomainModels$Entity";
    name: string;
    dataStorageGuid: string;
    location: Primitives.Location;
    documentation: string;
    generalization: GeneralizationBase;
    attributes: Attribute[];
    validationRules: ValidationRule[];
    eventHandlers: EventHandler[];
    indexes: Index[];
    accessRules: AccessRule[];
    image: string | null;
    imageData: any;
    source: EntitySource | null;
}
export declare abstract class EntitySource extends ModelElementBase {
}
export declare abstract class RemoteEntitySource extends EntitySource {
}
export declare abstract class QueryBasedRemoteEntitySource extends RemoteEntitySource {
}
export declare abstract class ViewEntitySource extends EntitySource {
}
export declare class OqlViewEntitySource extends ViewEntitySource {
    $Type: "DomainModels$OqlViewEntitySource";
    sourceDocument: string | null;
}
export declare abstract class GeneralizationBase extends ModelElementBase {
}
export declare class Generalization extends GeneralizationBase {
    $Type: "DomainModels$Generalization";
    generalization: string;
}
export declare class NoGeneralization extends GeneralizationBase {
    $Type: "DomainModels$NoGeneralization";
    hasChangedDate: boolean;
    hasCreatedDate: boolean;
    hasOwner: boolean;
    hasChangedBy: boolean;
    persistable: boolean;
}
export declare class EntityKey extends ModelElementBase {
    $Type: "DomainModels$EntityKey";
    parts: EntityKeyPart[];
}
export interface EntityKeyPartCreationOptions {
    name: string;
}
export declare class EntityKeyPart extends ModelElementBase {
    constructor(options?: EntityKeyPartCreationOptions);
    $Type: "DomainModels$EntityKeyPart";
    name: string;
    type: AttributeType;
}
export declare abstract class RemoteEntitySourceDocument extends Projects.Document {
    description: string;
    catalogUrl: string;
    icon: any;
    metadata: string;
    metadataUrl: string;
    serviceName: string;
    version: string;
    endpointId: string;
    minimumMxVersion: string;
    recommendedMxVersion: string;
    applicationId: string;
    environmentType: EnvironmentType;
    metadataHash: string;
    validated: boolean;
    validatedEntities: string[];
    name: string;
    documentation: string;
}
export interface ViewEntitySourceDocumentCreationOptions {
    name: string;
}
export declare class ViewEntitySourceDocument extends Projects.Document {
    constructor(options?: ViewEntitySourceDocumentCreationOptions);
    $Type: "DomainModels$ViewEntitySourceDocument";
    name: string;
    documentation: string;
}
export interface AttributeCreationOptions {
    name: string;
    type?: "Binary" | "Boolean" | "DateTime" | "HashedString" | "String" | "Decimal" | "Integer" | "Long" | "AutoNumber" | "Enumeration";
    enumerationName?: string;
}
export declare class Attribute extends ModelElementBase {
    constructor(options?: AttributeCreationOptions);
    $Type: "DomainModels$Attribute";
    name: string;
    dataStorageGuid: string;
    type: AttributeType;
    documentation: string;
    value: ValueType;
}
export declare abstract class ValueType extends ModelElementBase {
}
export interface StoredValueCreationOptions {
    defaultValue: string;
}
export declare class StoredValue extends ValueType {
    constructor(options?: StoredValueCreationOptions);
    $Type: "DomainModels$StoredValue";
    defaultValue: string;
}
export declare class CalculatedValue extends ValueType {
    $Type: "DomainModels$CalculatedValue";
    microflow: string | null;
    passEntity: boolean;
}
export declare class OqlViewValue extends ValueType {
    $Type: "DomainModels$OqlViewValue";
    reference: string;
}
export declare abstract class MappedValue extends ValueType {
    defaultValueDesignTime: string;
}
export declare abstract class AttributeType extends ModelElementBase {
}
export declare class BinaryAttributeType extends AttributeType {
    $Type: "DomainModels$BinaryAttributeType";
}
export declare class BooleanAttributeType extends AttributeType {
    $Type: "DomainModels$BooleanAttributeType";
}
export declare class DateTimeAttributeType extends AttributeType {
    $Type: "DomainModels$DateTimeAttributeType";
    localizeDate: boolean;
}
export interface EnumerationAttributeTypeCreationOptions {
    enumeration?: string;
}
export declare class EnumerationAttributeType extends AttributeType {
    constructor(options?: EnumerationAttributeTypeCreationOptions);
    $Type: "DomainModels$EnumerationAttributeType";
    enumeration: string;
}
export declare class HashedStringAttributeType extends AttributeType {
    $Type: "DomainModels$HashedStringAttributeType";
}
export declare class StringAttributeType extends AttributeType {
    $Type: "DomainModels$StringAttributeType";
    length: number;
}
export declare abstract class NumericAttributeTypeBase extends AttributeType {
}
export declare abstract class DecimalAttributeTypeBase extends NumericAttributeTypeBase {
}
export declare class DecimalAttributeType extends DecimalAttributeTypeBase {
    $Type: "DomainModels$DecimalAttributeType";
}
export declare abstract class IntegerAttributeTypeBase extends NumericAttributeTypeBase {
}
export declare class IntegerAttributeType extends IntegerAttributeTypeBase {
    $Type: "DomainModels$IntegerAttributeType";
}
export declare class LongAttributeType extends IntegerAttributeTypeBase {
    $Type: "DomainModels$LongAttributeType";
}
export declare class AutoNumberAttributeType extends IntegerAttributeTypeBase {
    $Type: "DomainModels$AutoNumberAttributeType";
}
export declare abstract class AssociationBase extends ModelElementBase {
    name: string;
    dataStorageGuid: string;
    type: AssociationType;
    owner: AssociationOwner;
    storageFormat: AssociationStorage;
    deleteBehavior: AssociationDeleteBehavior;
    parent: string;
    documentation: string;
    source: AssociationSource | null;
}
export interface AssociationCreationOptions {
    name: string;
    parentEntity?: Entity;
    childEntity?: Entity;
    multiplicity?: "one_to_one" | "one_to_many" | "many_to_many";
}
export declare class Association extends AssociationBase {
    constructor(options?: AssociationCreationOptions);
    $Type: "DomainModels$Association";
    child: string;
    parentConnection: Primitives.Location;
    childConnection: Primitives.Location;
}
export interface CrossAssociationCreationOptions {
    name: string;
}
export declare class CrossAssociation extends AssociationBase {
    constructor(options?: CrossAssociationCreationOptions);
    $Type: "DomainModels$CrossAssociation";
    child: string;
}
export declare abstract class AssociationSource extends ModelElementBase {
}
export declare abstract class RemoteAssociationSource extends AssociationSource {
}
export declare class OqlViewAssociationSource extends AssociationSource {
    $Type: "DomainModels$OqlViewAssociationSource";
    reference: string;
}
export declare class AssociationDeleteBehavior extends ModelElementBase {
    $Type: "DomainModels$AssociationDeleteBehavior";
    parentDeleteBehavior: DeletingBehavior;
    childDeleteBehavior: DeletingBehavior;
    parentErrorMessage: Texts.Text | null;
    childErrorMessage: Texts.Text | null;
}
export declare class Annotation extends ModelElementBase {
    $Type: "DomainModels$Annotation";
    caption: string;
    location: Primitives.Location;
    width: number;
}
export declare class AccessRule extends ModelElementBase {
    $Type: "DomainModels$AccessRule";
    memberAccesses: MemberAccess[];
    moduleRoles: string[];
    documentation: string;
    allowCreate: boolean;
    allowDelete: boolean;
    defaultMemberAccessRights: MemberAccessRights;
    xPathConstraintCaption: string;
    xPathConstraint: string | null;
}
export declare class MemberAccess extends ModelElementBase {
    $Type: "DomainModels$MemberAccess";
    attribute: string | null;
    association: string | null;
    accessRights: MemberAccessRights;
}
export declare class EventHandler extends ModelElementBase {
    $Type: "DomainModels$EventHandler";
    moment: ActionMoment;
    event: EventType;
    microflow: string | null;
    raiseErrorOnFalse: boolean;
    passEventObject: boolean;
}
export declare class Index extends ModelElementBase {
    $Type: "DomainModels$Index";
    dataStorageGuid: string;
    attributes: IndexedAttribute[];
    includeInOffline: boolean;
}
export declare class IndexedAttribute extends ModelElementBase {
    $Type: "DomainModels$IndexedAttribute";
    type: IndexedAttributeType;
    attribute: string | null;
    ascending: boolean;
}
export declare class ValidationRule extends ModelElementBase {
    $Type: "DomainModels$ValidationRule";
    attribute: string;
    errorMessage: Texts.Text;
    ruleInfo: RuleInfo;
}
export declare abstract class RuleInfo extends ModelElementBase {
}
export declare class EqualsToRuleInfo extends RuleInfo {
    $Type: "DomainModels$EqualsToRuleInfo";
    useValue: boolean;
    equalsToValue: string;
    equalsToAttribute: string | null;
}
export declare class MaxLengthRuleInfo extends RuleInfo {
    $Type: "DomainModels$MaxLengthRuleInfo";
    maxLength: number;
}
export declare class RangeRuleInfo extends RuleInfo {
    $Type: "DomainModels$RangeRuleInfo";
    typeOfRange: RangeType;
    useMinValue: boolean;
    useMaxValue: boolean;
    minValue: string;
    maxValue: string;
    minAttribute: string | null;
    maxAttribute: string | null;
}
export declare class RegExRuleInfo extends RuleInfo {
    $Type: "DomainModels$RegExRuleInfo";
    regularExpression: string | null;
}
export declare class RequiredRuleInfo extends RuleInfo {
    $Type: "DomainModels$RequiredRuleInfo";
}
export declare class UniqueRuleInfo extends RuleInfo {
    $Type: "DomainModels$UniqueRuleInfo";
}
export declare abstract class EntityRef extends ModelElementBase {
}
export declare class DirectEntityRef extends EntityRef {
    $Type: "DomainModels$DirectEntityRef";
    entity: string;
}
export declare class IndirectEntityRef extends EntityRef {
    $Type: "DomainModels$IndirectEntityRef";
    steps: EntityRefStep[];
}
export declare class EntityRefStep extends ModelElementBase {
    $Type: "DomainModels$EntityRefStep";
    association: string;
    destinationEntity: string;
}
export declare abstract class MemberRef extends ModelElementBase {
    entityRef: IndirectEntityRef | null;
}
export declare class AttributeRef extends MemberRef {
    $Type: "DomainModels$AttributeRef";
    attribute: string;
}
export declare class AssociationRef extends MemberRef {
    $Type: "DomainModels$AssociationRef";
    association: string;
}
export type EnvironmentType = "Production" | "Sandbox" | "NonProduction" | "Unknown";
export type AssociationType = "Reference" | "ReferenceSet";
export type AssociationOwner = "Default" | "Both";
export type AssociationStorage = "Table" | "Column";
export type DeletingBehavior = "DeleteMeAndReferences" | "DeleteMeButKeepReferences" | "DeleteMeIfNoReferences";
export type Navigability = "BothDirections" | "ParentToChild";
export type MemberAccessRights = "None" | "ReadOnly" | "ReadWrite";
export type ActionMoment = "Before" | "After";
export type EventType = "Create" | "Commit" | "Delete" | "RollBack";
export type IndexedAttributeType = "Normal" | "CreatedDate" | "ChangedDate";
export type RangeType = "GreaterThanOrEqualTo" | "SmallerThanOrEqualTo" | "Between";
//# sourceMappingURL=DomainModels.d.ts.map