import { ModelElementBase } from '@mendix/model-access-publisher';
import * as DomainModels from "./DomainModels";
import * as Pages from "./Pages";
import * as Texts from "./Texts";
export interface CustomWidgetCreationOptions {
    name: string;
}
export declare class CustomWidget extends Pages.Widget {
    constructor(options?: CustomWidgetCreationOptions);
    $Type: "CustomWidgets$CustomWidget";
    type: CustomWidgetType | null;
    object: WidgetObject | null;
    labelTemplate: Pages.ClientTemplate | null;
    conditionalEditabilitySettings: Pages.ConditionalEditabilitySettings | null;
    editable: Pages.EditableEnum;
    conditionalVisibilitySettings: Pages.ConditionalVisibilitySettings | null;
}
export interface CustomWidgetTypeCreationOptions {
    name: string;
}
export declare class CustomWidgetType extends ModelElementBase {
    constructor(options?: CustomWidgetTypeCreationOptions);
    $Type: "CustomWidgets$CustomWidgetType";
    widgetId: string;
    needsEntityContext: boolean;
    pluginWidget: boolean;
    name: string;
    description: string;
    studioProCategory: string;
    studioCategory: string;
    offlineCapable: boolean;
    objectType: WidgetObjectType;
    helpUrl: string;
}
export declare class WidgetEnumerationValue extends ModelElementBase {
    $Type: "CustomWidgets$WidgetEnumerationValue";
    key: string;
    caption: string;
}
export declare class WidgetObject extends ModelElementBase {
    $Type: "CustomWidgets$WidgetObject";
    type: string | null;
    properties: WidgetProperty[];
}
export declare class WidgetObjectType extends ModelElementBase {
    $Type: "CustomWidgets$WidgetObjectType";
    propertyTypes: WidgetPropertyType[];
}
export declare class WidgetProperty extends ModelElementBase {
    $Type: "CustomWidgets$WidgetProperty";
    type: string | null;
    value: WidgetValue | null;
}
export declare class WidgetPropertyType extends ModelElementBase {
    $Type: "CustomWidgets$WidgetPropertyType";
    key: string;
    category: string;
    caption: string;
    description: string;
    isDefault: boolean;
    valueType: WidgetValueType | null;
}
export declare class WidgetReturnType extends ModelElementBase {
    $Type: "CustomWidgets$WidgetReturnType";
    type: WidgetReturnTypeEnum;
    isList: boolean;
    entityProperty: string;
    assignableTo: string;
}
export declare class WidgetTranslation extends ModelElementBase {
    $Type: "CustomWidgets$WidgetTranslation";
    languageCode: string;
    text: string;
}
export declare class WidgetActionVariable extends ModelElementBase {
    $Type: "CustomWidgets$WidgetActionVariable";
    key: string;
    type: WidgetReturnTypeEnum;
    caption: string;
}
export declare class WidgetValue extends ModelElementBase {
    $Type: "CustomWidgets$WidgetValue";
    type: string;
    primitiveValue: string;
    entityRef: DomainModels.EntityRef | null;
    attributeRef: DomainModels.AttributeRef | null;
    page: string | null;
    microflow: string | null;
    nanoflow: string | null;
    icon: Pages.Icon | null;
    image: string | null;
    translatableValue: Texts.Text | null;
    textTemplate: Pages.ClientTemplate | null;
    xPathConstraint: string | null;
    objects: WidgetObject[];
    action: Pages.ClientAction;
    expression: string | null;
    widgets: Pages.Widget[];
    dataSource: Pages.DataSource | null;
    sourceVariable: Pages.PageVariable | null;
    selection: CustomWidgetSelectionType;
}
export declare class WidgetValueType extends ModelElementBase {
    $Type: "CustomWidgets$WidgetValueType";
    type: WidgetValueTypeEnum;
    isList: boolean;
    isLinked: boolean;
    isMetaData: boolean;
    entityProperty: string;
    allowNonPersistableEntities: boolean;
    isPath: IsPath;
    pathType: PathType;
    parameterIsList: boolean;
    multiline: boolean;
    defaultValue: string;
    required: boolean;
    onChangeProperty: string;
    dataSourceProperty: string;
    selectableObjectsProperty: string;
    attributeTypes: CustomWidgetAttributeType[];
    associationTypes: CustomWidgetAssociationType[];
    selectionTypes: CustomWidgetSelectionType[];
    enumerationValues: WidgetEnumerationValue[];
    actionVariables: WidgetActionVariable[];
    objectType: WidgetObjectType | null;
    returnType: WidgetReturnType | null;
    translations: WidgetTranslation[];
    setLabel: boolean;
    defaultType: DefaultTypeEnum;
}
export declare class CustomWidgetXPathSource extends Pages.XPathSourceBase {
    $Type: "CustomWidgets$CustomWidgetXPathSource";
}
export type CustomWidgetAttributeType = "AutoNumber" | "Binary" | "Boolean" | "Currency" | "DateTime" | "Enum" | "Float" | "HashString" | "Integer" | "Long" | "String" | "Decimal";
export type CustomWidgetAssociationType = "Reference" | "ReferenceSet";
export type CustomWidgetSelectionType = "None" | "Single" | "Multi";
export type IsPath = "No" | "Optional" | "Yes";
export type PathType = "None" | "Reference" | "ReferenceSet";
export type WidgetReturnTypeEnum = "None" | "Void" | "Boolean" | "Integer" | "Float" | "DateTime" | "String" | "Object" | "Decimal";
export type WidgetValueTypeEnum = "Action" | "Attribute" | "Association" | "Boolean" | "DataSource" | "Entity" | "EntityConstraint" | "Enumeration" | "Expression" | "File" | "Form" | "Icon" | "Image" | "Integer" | "Decimal" | "Microflow" | "Nanoflow" | "Object" | "String" | "Selection" | "TranslatableString" | "TextTemplate" | "System" | "Widgets";
export type SystemPropertyEnum = "Label" | "Name" | "TabIndex" | "Editability" | "Visibility";
export type DefaultTypeEnum = "None" | "CallMicroflow" | "CallNanoflow" | "OpenPage" | "Database" | "Microflow" | "Nanoflow" | "Association";
//# sourceMappingURL=CustomWidgets.d.ts.map