import { IModelComponentApiBase } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { Pages } from '../model/gen/typings';
/**
 * API for working with snippets
 */
export interface ISnippetApi extends IModelComponentApiBase<Pages.Snippet> {
    _apiId: "mendix.SnippetApi";
    /**
     * Adds a snippet to the specified container.
     *
     * @param containerId The ID of the container where the snippet will be added. It could be a module or folder.
     * @param options Options for that will be used during the snippet initilization.
     * @returns A promise that resolves to the newly created snippet.
     */
    addSnippet(containerId: string, options?: Pages.SnippetCreationOptions): Promise<Pages.Snippet>;
}
export declare class SnippetApi extends ModelComponentApiBase<Pages.Snippet> implements ISnippetApi {
    _apiId: "mendix.SnippetApi";
    addSnippet(containerId: string, options?: Pages.SnippetCreationOptions): Promise<Pages.Snippet>;
}
//# sourceMappingURL=SnippetApi.d.ts.map