import { IComponentApi } from '@mendix/component-framework';
import { Primitives } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { Projects } from '../model/gen/typings';
/**
 * API for working with project, modules, and folders
 */
export interface IProjectApi extends IComponentApi {
    _apiId: "mendix.ProjectApi";
    /**
     * Returns the unique identifier of the current project.
     * @returns Promise resolving to the project ID as a string.
     */
    getProjectId(): Promise<string>;
    /**
     * Retrieves all modules in the project.
     * @returns Promise resolving to a readonly array of modules.
     */
    getModules(): Promise<ReadonlyArray<Readonly<Projects.Module>>>;
    /**
     * Retrieves a specific module by its name.
     * @param name The name of the module to retrieve.
     * @returns Promise resolving to the module if found, or null otherwise.
     */
    getModule(name: string): Promise<Readonly<Projects.Module> | null>;
    /**
     * Retrieves all folders within a given container (module or folder).
     * @param containerId The ID of the container to get folders from (module or folder).
     * @returns Promise resolving to a readonly array of folders.
     */
    getFolders(containerId: string): Promise<ReadonlyArray<Readonly<Projects.Folder>>>;
    /**
     * Retrieves a specific folder by name within a given container.
     * @param containerId The ID of the container to search in.
     * @param name The name of the folder to retrieve.
     * @returns Promise resolving to the folder if found, or null otherwise.
     */
    getFolder(containerId: string, name: string): Promise<Readonly<Projects.Folder> | null>;
    /**
     * Creates a new folder within a given container.
     * @param containerId The ID of the container to add the folder to.
     * @param name The name of the new folder.
     * @returns Promise resolving to the created folder.
     */
    addFolder(containerId: string, name: string): Promise<Readonly<Projects.Folder>>;
    /**
     * Deletes a folder by its ID.
     * @param folderId The ID of the folder to delete.
     * @returns Promise resolving when the folder has been deleted.
     */
    deleteFolder(folderId: string): Promise<void>;
    /**
     * Changes the name of a folder.
     * @param folderId The ID of the folder to rename.
     * @param newName The new name for the folder.
     * @returns Promise resolving when the folder name has been changed.
     */
    renameFolder(folderId: string, newName: string): Promise<void>;
    /**
     * Retrieves information about all documents within a given container.
     * @param containerId The ID of the container to get documents info from.
     * @returns Promise resolving to a readonly array of document info objects.
     */
    getDocumentsInfo(containerId: string): Promise<ReadonlyArray<Readonly<Primitives.UnitInfo>>>;
}
export declare class ProjectApi extends ModelComponentApiBase<Projects.Folder> implements IProjectApi {
    _apiId: "mendix.ProjectApi";
    getProjectId(): Promise<string>;
    getModules(): Promise<Projects.Module[]>;
    getModule(name: string): Promise<Projects.Module | null>;
    getFolders(containerId: string): Promise<Projects.Folder[]>;
    getFolder(containerId: string, name: string): Promise<Projects.Folder | null>;
    addFolder(containerId: string, name: string): Promise<Projects.Folder>;
    getDocumentsInfo(containerId: string): Promise<Primitives.UnitInfo[]>;
    renameFolder(folderId: string, newName: string): Promise<void>;
    deleteFolder(folderId: string): Promise<void>;
    private findFolder;
    private getModulesTree;
    private deleteTreeInfo;
}
//# sourceMappingURL=ProjectApi.d.ts.map