import { IModelComponentApiBase } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { Pages } from '../model/gen/typings';
/**
 * API for working with pages
 */
export interface IPageApi extends IModelComponentApiBase<Pages.Page> {
    _apiId: "mendix.PageApi";
    /**
     * Adds a blank page to the specified container.
     *
     * @param containerId The ID of the container where the page will be added. It could be a module or folder.
     * @param options Options for that will be used during the page initilization.
     * @returns A promise that resolves to the newly created page.
     */
    addBlankPage(containerId: string, options?: Pages.PageCreationOptions): Promise<Pages.Page>;
}
export declare class PageApi extends ModelComponentApiBase<Pages.Page> implements IPageApi {
    _apiId: "mendix.PageApi";
    addBlankPage(containerId: string, options?: Pages.PageCreationOptions): Promise<Pages.Page>;
}
//# sourceMappingURL=PageApi.d.ts.map