import { IModelComponentApiBase } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { Enumerations } from '../model/gen/typings';
/**
 * API for working with enumerations
 */
export interface IEnumerationApi extends IModelComponentApiBase<Enumerations.Enumeration> {
    _apiId: "mendix.EnumerationApi";
    /**
     * Adds an enumeration document to the specified container.
     *
     * @param containerId The ID of the container where the enumeration will be added. It could be a module or folder.
     * @param options Options for that will be used during the enumeration initilization.
     * @returns A promise that resolves to the newly created enumeration.
     */
    addEnumeration(containerId: string, options?: Enumerations.EnumerationCreationOptions): Promise<Enumerations.Enumeration>;
}
export declare class EnumerationApi extends ModelComponentApiBase<Enumerations.Enumeration> implements IEnumerationApi {
    _apiId: "mendix.EnumerationApi";
    addEnumeration(containerId: string, options?: Enumerations.EnumerationCreationOptions): Promise<Enumerations.Enumeration>;
}
//# sourceMappingURL=EnumerationApi.d.ts.map