import { IModelComponentApiBase } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { DomainModels } from '../model/gen/typings';
/**
 * API for working with domain models
 */
export interface IDomainModelApi extends IModelComponentApiBase<DomainModels.DomainModel> {
    _apiId: "mendix.DomainModelApi";
    /**
     * Get the Domain Model for the specified module.
     *
     * @param moduleName The name of the module.
     * @returns A promise that resolves to the Domain Model for the specified module or undefined if module not exists.
     */
    getDomainModel(moduleName: string): Promise<DomainModels.DomainModel | undefined>;
}
export declare class DomainModelApi extends ModelComponentApiBase<DomainModels.DomainModel> implements IDomainModelApi {
    _apiId: "mendix.DomainModelApi";
    getDomainModel(moduleName: string): Promise<DomainModels.DomainModel | undefined>;
}
//# sourceMappingURL=DomainModelApi.d.ts.map