import { IModelComponentApiBase } from '@mendix/model-access';
import { ModelComponentApiBase } from '@mendix/model-access-publisher';
import { Pages } from '../model/gen/typings';
/**
 * API for working with building blocks
 */
export interface IBuildingBlockApi extends IModelComponentApiBase<Pages.BuildingBlock> {
    _apiId: "mendix.BuildingBlockApi";
    /**
     * Adds a building block to the specified container.
     *
     * @param containerId The ID of the container where the building block will be added. It could be a module or folder.
     * @param options Options for that will be used during the building block initilization.
     * @returns A promise that resolves to the newly created building block.
     */
    addBuildingBlock(containerId: string, options?: Pages.BuildingBlockCreationOptions): Promise<Pages.BuildingBlock>;
}
export declare class BuildingBlockApi extends ModelComponentApiBase<Pages.BuildingBlock> implements IBuildingBlockApi {
    _apiId: "mendix.BuildingBlockApi";
    addBuildingBlock(containerId: string, options?: Pages.BuildingBlockCreationOptions): Promise<Pages.BuildingBlock>;
}
//# sourceMappingURL=BuildingBlockApi.d.ts.map