import { ComponentApiBase as Ue, componentFramework as P } from "@mendix/component-framework";
var Ye = Object.defineProperty, He = (i, a, l) => a in i ? Ye(i, a, { enumerable: !0, configurable: !0, writable: !0, value: l }) : i[a] = l, w = (i, a, l) => He(i, typeof a != "symbol" ? a + "" : a, l);
const k = /* @__PURE__ */ new Map();
class qe {
  constructor(a) {
    w(this, "schemaPropertyCache", /* @__PURE__ */ new Map()), this.schema = a;
  }
  plainToClass(a) {
    const l = this.getAllPropertiesForType(a.$Type), e = k.get(a.$Type);
    if (!e)
      throw new Error(`Model class not found for type ${a.$Type}`);
    const s = new e();
    return s.$ID = a.$ID, s.$Type = a.$Type, Object.entries(l).forEach(([t, u]) => {
      switch (u.type) {
        case "ELEMENT":
          switch (u.kind) {
            case "PART":
              u.list ? s[t] = a[t].map(
                (b) => b ? this.plainToClass(b) : null
              ) : s[t] = a[t] ? this.plainToClass(a[t]) : null;
              break;
            case "BY_ID_REFERENCE":
            case "BY_NAME_REFERENCE":
            case "LOCAL_BY_NAME_REFERENCE":
              a[t] !== void 0 && (s[t] = a[t]);
              break;
            default:
              throw new Error(`Unsupported element kind ${u.kind} (property: ${t})`);
          }
          break;
        case "PRIMITIVE":
        case "ENUMERATION":
          a[t] !== void 0 && (s[t] = a[t]);
          break;
      }
    }), s;
  }
  classToPlain(a) {
    const l = this.getAllPropertiesForType(a.$Type), e = {
      $ID: a.$ID,
      $Type: a.$Type
    };
    return Object.entries(l).forEach(([s, t]) => {
      switch (t.type) {
        case "ELEMENT":
          switch (t.kind) {
            case "PART":
              t.list ? e[s] = a[s].map(
                (u) => u ? this.classToPlain(u) : null
              ) : e[s] = a[s] ? this.classToPlain(a[s]) : null;
              break;
            case "BY_ID_REFERENCE":
            case "BY_NAME_REFERENCE":
            case "LOCAL_BY_NAME_REFERENCE":
              e[s] = a[s];
              break;
          }
          break;
        case "ENUMERATION":
        case "PRIMITIVE":
          e[s] = a[s];
          break;
      }
    }), e;
  }
  // Recursively get all properties for a given type
  getAllPropertiesForType(a) {
    var l;
    if (this.schemaPropertyCache.has(a))
      return this.schemaPropertyCache.get(a);
    const e = this.schema[a];
    if (!e)
      throw new Error(`Schema not found for type ${a}`);
    const s = { ...e.properties };
    return (l = e.baseTypes) == null || l.forEach((t) => {
      Object.assign(s, this.getAllPropertiesForType(t));
    }), this.schemaPropertyCache.set(a, s), s;
  }
}
class R extends Ue {
  constructor(a) {
    super(), w(this, "modelAccess"), w(this, "serializer"), this.schema = a, this.modelAccess = P.getApi("mendix.ModelAccessApi"), this.serializer = new qe(a);
  }
  async loadUnits(a, l) {
    return this.log(`Loading units (${a}, ${l.join(", ")})`), Promise.all(l.map((e) => this.loadUnit(a, e)));
  }
  async applyChanges(a) {
    return this.modelAccess.applyChanges(a);
  }
  async createElement(a, l) {
    const e = k.get(a);
    if (!e)
      throw new Error(`Unknown element type: ${a}`);
    const s = new e(l);
    return this.serializer.classToPlain(s);
  }
  async createUnit(a, l, e) {
    const s = k.get(a);
    if (!s)
      throw new Error(`Unknown unit type: ${a}`);
    const t = new s(e);
    return await this.modelAccess.createUnit(this.serializer.classToPlain(t), l);
  }
  async deleteUnit(a) {
    return this.modelAccess.deleteUnit(a);
  }
  async loadUnit(a, l) {
    this.log(`Loading unit (id: ${l}, type: ${a})`);
    const e = await this.modelAccess.loadUnit(l);
    if (!e)
      throw new Error(`Unit with id ${l} not found`);
    if (e.$Type !== a)
      throw new Error(`Unit with id ${l} does not have the type ${a}`);
    this.log(`Converting unit to model classes (id: ${l}, type: ${a})`);
    const s = this.serializer.plainToClass(e);
    return this.log(`Converting model classes to public model (id: ${l}, type: ${a})`), this.serializer.classToPlain(s);
  }
  log(a) {
    console.debug(`[${this._apiId}] ${a}`);
  }
  async getElementMetadata() {
    const a = {};
    for (const l in this.schema) {
      const e = {}, s = this.schema[l].properties;
      for (const t in s) {
        const u = s[t];
        if (u.list && u.type === "ELEMENT" && u.kind === "PART") {
          const b = [], I = this.schema[u.elementType];
          if (!I)
            throw new Error("Element type not found in schema: " + u.elementType);
          I.abstract || b.push(u.elementType), I.abstract && I.allCompatibleTypes && b.push(...I.allCompatibleTypes.filter((f) => f !== u.elementType)), b.forEach((f) => {
            const _ = f.substring(f.lastIndexOf("$") + 1);
            e[_] = {
              type: f,
              parentPropertyName: t
            };
          });
        }
      }
      Object.keys(e).length > 0 && (a[l] = { helpers: e });
    }
    return a;
  }
}
class X {
  constructor() {
    w(this, "$ID"), this.$ID = crypto.randomUUID();
  }
}
class c extends X {
}
class K extends X {
}
class ue extends X {
}
function r(i) {
  return function(a) {
    k.set(i, a);
  };
}
class Xe extends R {
  _apiId = "mendix.BuildingBlockApi";
  async addBuildingBlock(a, l) {
    return this.createUnit("Pages$BuildingBlock", a, l);
  }
}
class Ke extends R {
  _apiId = "mendix.DomainModelApi";
  async getDomainModel(a) {
    return P.getApi("mendix.ModelAccessApi").loadUnitByName("DomainModels$DomainModel", a);
  }
}
class Je extends R {
  _apiId = "mendix.EnumerationApi";
  async addEnumeration(a, l) {
    return this.createUnit("Enumerations$Enumeration", a, l);
  }
}
class Qe extends R {
  _apiId = "mendix.PageApi";
  async addBlankPage(a, l) {
    return this.createUnit("Pages$Page", a, l);
  }
}
class Ze extends R {
  _apiId = "mendix.ProjectApi";
  async getProjectId() {
    const a = P.getApi("mendix.ModelAccessApi"), [l] = await a.getAllUnitsInfoByType("Projects$Project");
    return l.$ID;
  }
  async getModules() {
    const a = await this.getModulesTree();
    return a.forEach(this.deleteTreeInfo), a;
  }
  async getModule(a) {
    return (await this.getModules()).find((e) => e.name === a) ?? null;
  }
  async getFolders(a) {
    const l = await this.getModulesTree(), e = this.findFolder(a, l);
    if (!e)
      throw new Error(`Container with id ${a} not found`);
    const s = e.folders ?? [];
    return s.forEach(this.deleteTreeInfo), s;
  }
  async getFolder(a, l) {
    return (await this.getFolders(a)).find((s) => s.name === l) ?? null;
  }
  async addFolder(a, l) {
    return this.createUnit("Projects$Folder", a, { name: l });
  }
  async getDocumentsInfo(a) {
    const l = await this.getModulesTree(), e = this.findFolder(a, l);
    if (!e)
      throw new Error(`Container with id ${a} not found`);
    return e.documents ?? [];
  }
  async renameFolder(a, l) {
    await P.getApi("mendix.ModelAccessApi").applyChanges([
      {
        type: "setProperty",
        unitId: a,
        targetId: a,
        propertyName: "name",
        value: l
      }
    ]);
  }
  async deleteFolder(a) {
    const l = await this.getModulesTree(), e = this.findFolder(a, l);
    if (e?.documents?.length || e?.folders?.length)
      throw new Error(`Folder with id ${a} has documents or folders. Cannot delete.`);
    return this.deleteUnit(a);
  }
  findFolder(a, l) {
    for (const e of l) {
      if (e.$ID === a)
        return e;
      const s = this.findFolder(a, e.folders ?? []);
      if (s)
        return s;
    }
    return null;
  }
  async getModulesTree() {
    const a = await fetch("/model/modules", {
      method: "GET",
      headers: { "content-type": "application/json" }
    });
    if (!a.ok)
      throw new Error(`Backend failed to handle the request. Response code: ${a.status}.`);
    return await a.json();
  }
  deleteTreeInfo(a) {
    delete a.folders, delete a.documents;
  }
}
class et extends R {
  _apiId = "mendix.SnippetApi";
  async addSnippet(a, l) {
    return this.createUnit("Pages$Snippet", a, l);
  }
}
function n(i, a, l, e, s, t) {
  function u(O) {
    if (O !== void 0 && typeof O != "function") throw new TypeError("Function expected");
    return O;
  }
  for (var b = e.kind, I = b === "getter" ? "get" : b === "setter" ? "set" : "value", f = !a && i ? e.static ? i : i.prototype : null, _ = a || (f ? Object.getOwnPropertyDescriptor(f, e.name) : {}), v, ne = !1, H = l.length - 1; H >= 0; H--) {
    var L = {};
    for (var h in e) L[h] = h === "access" ? {} : e[h];
    for (var h in e.access) L.access[h] = e.access[h];
    L.addInitializer = function(O) {
      if (ne) throw new TypeError("Cannot add initializers after decoration has completed");
      t.push(u(O || null));
    };
    var M = (0, l[H])(b === "accessor" ? { get: _.get, set: _.set } : _[I], L);
    if (b === "accessor") {
      if (M === void 0) continue;
      if (M === null || typeof M != "object") throw new TypeError("Object expected");
      (v = u(M.get)) && (_.get = v), (v = u(M.set)) && (_.set = v), (v = u(M.init)) && s.unshift(v);
    } else (v = u(M)) && (b === "field" ? s.unshift(v) : _[I] = v);
  }
  f && Object.defineProperty(f, e.name, _), ne = !0;
}
function o(i, a, l) {
  for (var e = arguments.length > 2, s = 0; s < a.length; s++)
    l = e ? a[s].call(i, l) : a[s].call(i);
  return e ? l : void 0;
}
let E = (() => {
  let i = [r("DataTypes$DataType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), J = (() => {
  let i = [r("DataTypes$UnknownType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$UnknownType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$VoidType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$VoidType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$EmptyType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$EmptyType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$BooleanType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$BooleanType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$BinaryType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$BinaryType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$DecimalType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$DecimalType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$IntegerType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$IntegerType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$FloatType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$FloatType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$DateTimeType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$DateTimeType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$StringType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$StringType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$EnumerationType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$EnumerationType";
    enumeration = "";
  }, e;
})();
let pe = (() => {
  let i = [r("DataTypes$EntityType")], a, l = [], e, s = E;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    entity = "";
  }, e;
})();
(() => {
  let i = [r("DataTypes$ObjectType")], a, l = [], e, s = pe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$ObjectType";
  }, e;
})();
(() => {
  let i = [r("DataTypes$ListType")], a, l = [], e, s = pe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DataTypes$ListType";
  }, e;
})();
(() => {
  let i = [r("Projects$Project")], a, l = [], e, s = ue;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Projects$Project";
    isSystemProject = !1;
  }, e;
})();
let tt = (() => {
  let i = [r("Projects$ProjectDocument")], a, l = [], e, s = K;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), me = (() => {
  let i = [r("Projects$FolderBase")], a, l = [], e, s = ue;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Projects$Folder")], a, l = [], e, s = me;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Projects$Folder";
    name = "";
  }, e;
})();
(() => {
  let i = [r("Projects$Module")], a, l = [], e, s = me;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Projects$Module";
    sortIndex = 0;
    name = "";
    fromAppStore = !1;
    appStoreGuid = "";
    appStoreVersionGuid = "";
    appStoreVersion = "";
    appStorePackageIdString = "";
    isThemeModule = !1;
  }, e;
})();
let Q = (() => {
  let i = [r("Projects$ModuleDocument")], a, l = [], e, s = K;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), j = (() => {
  let i = [r("Projects$Document")], a, l = [], e, s = Q;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    name = "";
    documentation = "";
    excluded = !1;
    exportLevel = "Hidden";
  }, e;
})();
(() => {
  let i = [r("Projects$OneTimeConversionMarker")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Projects$OneTimeConversionMarker";
    name = "";
  }, e;
})();
(() => {
  let i = [r("Projects$ProjectConversion")], a, l = [], e, s = K;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Projects$ProjectConversion";
    markers = [];
  }, e;
})();
(() => {
  let i = [r("Projects$JarDependency")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Projects$JarDependency";
    groupId = "";
    artifactId = "";
    version = "";
    isIncluded = !0;
    exclusions = [];
  }, e;
})();
(() => {
  let i = [r("Projects$JarDependencyExclusion")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Projects$JarDependencyExclusion";
    groupId = "";
    artifactId = "";
  }, e;
})();
(() => {
  let i = [r("Projects$ModuleSettings")], a, l = [], e, s = Q;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Projects$ModuleSettings";
    exportLevel = "Source";
    protectedModuleType = "AddOn";
    version = "1.0.0";
    solutionIdentifier = "";
    extensionName = "";
    jarDependencies = [];
    basedOnVersion = "";
  }, e;
})();
let p = (() => {
  let i = [r("Texts$Text")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), t?.text !== void 0 && this.translations.push(new at({ text: t.text, languageCode: t.languageCode }));
    }
    $Type = "Texts$Text";
    translations = [];
  }, e;
})(), at = (() => {
  let i = [r("Texts$Translation")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.languageCode = t?.languageCode ?? "en_US", this.text = t?.text ?? "";
    }
    $Type = "Texts$Translation";
    languageCode = "";
    text = "";
  }, e;
})();
(() => {
  let i = [r("Texts$SystemText")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Texts$SystemText";
    text = new p();
    key = "";
  }, e;
})();
(() => {
  let i = [r("Texts$SystemTextCollection")], a, l = [], e, s = tt;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Texts$SystemTextCollection";
    systemTexts = [];
  }, e;
})();
(() => {
  let i = [r("DomainModels$DomainModel")], a, l = [], e, s = Q;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$DomainModel";
    documentation = "";
    entities = [];
    annotations = [];
    associations = [];
    crossAssociations = [];
  }, e;
})();
(() => {
  let i = [r("DomainModels$Entity")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.attributes = t?.attributes?.map((u) => new rt(u)) ?? [];
    }
    $Type = "DomainModels$Entity";
    name = "";
    dataStorageGuid = crypto.randomUUID();
    location = { x: 0, y: 0 };
    documentation = "";
    generalization = new it();
    attributes = [];
    validationRules = [];
    eventHandlers = [];
    indexes = [];
    accessRules = [];
    image = null;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    imageData = void 0;
    source = null;
  }, e;
})();
let ye = (() => {
  let i = [r("DomainModels$EntitySource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), lt = (() => {
  let i = [r("DomainModels$RemoteEntitySource")], a, l = [], e, s = ye;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$QueryBasedRemoteEntitySource")], a, l = [], e, s = lt;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
let st = (() => {
  let i = [r("DomainModels$ViewEntitySource")], a, l = [], e, s = ye;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$OqlViewEntitySource")], a, l = [], e, s = st;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$OqlViewEntitySource";
    sourceDocument = null;
  }, e;
})();
let de = (() => {
  let i = [r("DomainModels$GeneralizationBase")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$Generalization")], a, l = [], e, s = de;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$Generalization";
    generalization = "";
  }, e;
})();
let it = (() => {
  let i = [r("DomainModels$NoGeneralization")], a, l = [], e, s = de;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$NoGeneralization";
    hasChangedDate = !1;
    hasCreatedDate = !1;
    hasOwner = !1;
    hasChangedBy = !1;
    persistable = !0;
  }, e;
})();
(() => {
  let i = [r("DomainModels$EntityKey")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$EntityKey";
    parts = [];
  }, e;
})();
(() => {
  let i = [r("DomainModels$EntityKeyPart")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "DomainModels$EntityKeyPart";
    name = "";
    type = new Te();
  }, e;
})();
(() => {
  let i = [r("DomainModels$RemoteEntitySourceDocument")], a, l = [], e, s = j;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    description = "";
    catalogUrl = "";
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    icon = void 0;
    metadata = "";
    metadataUrl = "";
    serviceName = "";
    version = "";
    endpointId = "";
    minimumMxVersion = "";
    recommendedMxVersion = "";
    applicationId = "";
    environmentType = "Unknown";
    metadataHash = "";
    validated = !1;
    validatedEntities = [];
    name = "";
    documentation = "";
  }, e;
})();
(() => {
  let i = [r("DomainModels$ViewEntitySourceDocument")], a, l = [], e, s = j;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "DomainModels$ViewEntitySourceDocument";
    // oql: Oql.OqlQuery | null = null;
    name = "";
    documentation = "";
  }, e;
})();
let rt = (() => {
  let i = [r("DomainModels$Attribute")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
      let u = "";
      switch (t?.type) {
        case "Boolean":
          this.type = new ot(), u = "false";
          break;
        case "AutoNumber":
          this.type = new bt(), u = "1";
          break;
        case "Integer":
          this.type = new dt(), u = "0";
          break;
        case "Long":
          this.type = new Te(), u = "0";
          break;
        case "Decimal":
          this.type = new yt(), u = "0";
          break;
        case "DateTime":
          this.type = new ct();
          break;
        case "Enumeration":
          this.type = new ut({ enumeration: t?.enumerationName });
          break;
        case "HashedString":
          this.type = new pt();
          break;
        case "Binary":
          this.type = new nt();
          break;
        case "String":
        default:
          this.type = new ce();
          break;
      }
      this.value = new oe({ defaultValue: u });
    }
    $Type = "DomainModels$Attribute";
    name = "";
    dataStorageGuid = crypto.randomUUID();
    type = new ce();
    documentation = "";
    value = new oe();
  }, e;
})(), B = (() => {
  let i = [r("DomainModels$ValueType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), oe = (() => {
  let i = [r("DomainModels$StoredValue")], a, l = [], e, s = B;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.defaultValue = t?.defaultValue ?? "";
    }
    $Type = "DomainModels$StoredValue";
    defaultValue = "";
  }, e;
})();
(() => {
  let i = [r("DomainModels$CalculatedValue")], a, l = [], e, s = B;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$CalculatedValue";
    microflow = null;
    passEntity = !0;
  }, e;
})();
(() => {
  let i = [r("DomainModels$OqlViewValue")], a, l = [], e, s = B;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$OqlViewValue";
    reference = "";
  }, e;
})();
(() => {
  let i = [r("DomainModels$MappedValue")], a, l = [], e, s = B;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    defaultValueDesignTime = "";
  }, e;
})();
let D = (() => {
  let i = [r("DomainModels$AttributeType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), nt = (() => {
  let i = [r("DomainModels$BinaryAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$BinaryAttributeType";
  }, e;
})(), ot = (() => {
  let i = [r("DomainModels$BooleanAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$BooleanAttributeType";
  }, e;
})(), ct = (() => {
  let i = [r("DomainModels$DateTimeAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$DateTimeAttributeType";
    localizeDate = !0;
  }, e;
})(), ut = (() => {
  let i = [r("DomainModels$EnumerationAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.enumeration = t?.enumeration ?? "";
    }
    $Type = "DomainModels$EnumerationAttributeType";
    enumeration = "";
  }, e;
})(), pt = (() => {
  let i = [r("DomainModels$HashedStringAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$HashedStringAttributeType";
  }, e;
})(), ce = (() => {
  let i = [r("DomainModels$StringAttributeType")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$StringAttributeType";
    length = 200;
  }, e;
})(), be = (() => {
  let i = [r("DomainModels$NumericAttributeTypeBase")], a, l = [], e, s = D;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), mt = (() => {
  let i = [r("DomainModels$DecimalAttributeTypeBase")], a, l = [], e, s = be;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), yt = (() => {
  let i = [r("DomainModels$DecimalAttributeType")], a, l = [], e, s = mt;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$DecimalAttributeType";
  }, e;
})(), Z = (() => {
  let i = [r("DomainModels$IntegerAttributeTypeBase")], a, l = [], e, s = be;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), dt = (() => {
  let i = [r("DomainModels$IntegerAttributeType")], a, l = [], e, s = Z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$IntegerAttributeType";
  }, e;
})(), Te = (() => {
  let i = [r("DomainModels$LongAttributeType")], a, l = [], e, s = Z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$LongAttributeType";
  }, e;
})(), bt = (() => {
  let i = [r("DomainModels$AutoNumberAttributeType")], a, l = [], e, s = Z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$AutoNumberAttributeType";
  }, e;
})(), Ee = (() => {
  let i = [r("DomainModels$AssociationBase")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    name = "";
    dataStorageGuid = crypto.randomUUID();
    type = "Reference";
    owner = "Default";
    storageFormat = "Table";
    deleteBehavior = new Tt();
    parent = "";
    documentation = "";
    source = null;
  }, e;
})();
(() => {
  let i = [r("DomainModels$Association")], a, l = [], e, s = Ee;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      switch (super(), this.name = t?.name ?? "", this.parent = t?.parentEntity?.$ID ?? "", this.child = t?.childEntity?.$ID ?? "", this.childConnection = { x: 50, y: 100 }, this.parentConnection = { x: 50, y: 0 }, t?.multiplicity) {
        case "one_to_one":
          this.type = "Reference", this.owner = "Both";
          break;
        case "many_to_many":
          this.type = "ReferenceSet", this.owner = "Both";
          break;
        case "one_to_many":
        default:
          this.type = "Reference", this.owner = "Default";
      }
    }
    $Type = "DomainModels$Association";
    child = "";
    parentConnection = { x: 0, y: 0 };
    childConnection = { x: 0, y: 0 };
  }, e;
})();
(() => {
  let i = [r("DomainModels$CrossAssociation")], a, l = [], e, s = Ee;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "DomainModels$CrossAssociation";
    child = "";
  }, e;
})();
let ge = (() => {
  let i = [r("DomainModels$AssociationSource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$RemoteAssociationSource")], a, l = [], e, s = ge;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$OqlViewAssociationSource")], a, l = [], e, s = ge;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$OqlViewAssociationSource";
    reference = "";
  }, e;
})();
let Tt = (() => {
  let i = [r("DomainModels$AssociationDeleteBehavior")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$AssociationDeleteBehavior";
    parentDeleteBehavior = "DeleteMeButKeepReferences";
    childDeleteBehavior = "DeleteMeButKeepReferences";
    parentErrorMessage = null;
    childErrorMessage = null;
  }, e;
})();
(() => {
  let i = [r("DomainModels$Annotation")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$Annotation";
    caption = "";
    location = { x: 0, y: 0 };
    width = 250;
  }, e;
})();
(() => {
  let i = [r("DomainModels$AccessRule")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$AccessRule";
    memberAccesses = [];
    moduleRoles = [];
    documentation = "";
    allowCreate = !1;
    allowDelete = !1;
    defaultMemberAccessRights = "None";
    xPathConstraintCaption = "";
    xPathConstraint = null;
  }, e;
})();
(() => {
  let i = [r("DomainModels$MemberAccess")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$MemberAccess";
    attribute = null;
    association = null;
    accessRights = "None";
  }, e;
})();
(() => {
  let i = [r("DomainModels$EventHandler")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$EventHandler";
    moment = "After";
    event = "Commit";
    microflow = null;
    raiseErrorOnFalse = !0;
    passEventObject = !0;
  }, e;
})();
(() => {
  let i = [r("DomainModels$Index")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$Index";
    dataStorageGuid = crypto.randomUUID();
    attributes = [];
    includeInOffline = !1;
  }, e;
})();
(() => {
  let i = [r("DomainModels$IndexedAttribute")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$IndexedAttribute";
    type = "Normal";
    attribute = null;
    ascending = !0;
  }, e;
})();
(() => {
  let i = [r("DomainModels$ValidationRule")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$ValidationRule";
    attribute = "";
    errorMessage = new p();
    ruleInfo = new Et();
  }, e;
})();
let A = (() => {
  let i = [r("DomainModels$RuleInfo")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$EqualsToRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$EqualsToRuleInfo";
    useValue = !0;
    equalsToValue = "";
    equalsToAttribute = null;
  }, e;
})();
(() => {
  let i = [r("DomainModels$MaxLengthRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$MaxLengthRuleInfo";
    maxLength = 0;
  }, e;
})();
(() => {
  let i = [r("DomainModels$RangeRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$RangeRuleInfo";
    typeOfRange = "Between";
    useMinValue = !0;
    useMaxValue = !0;
    minValue = "";
    maxValue = "";
    minAttribute = null;
    maxAttribute = null;
  }, e;
})();
(() => {
  let i = [r("DomainModels$RegExRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$RegExRuleInfo";
    regularExpression = null;
  }, e;
})();
let Et = (() => {
  let i = [r("DomainModels$RequiredRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$RequiredRuleInfo";
  }, e;
})();
(() => {
  let i = [r("DomainModels$UniqueRuleInfo")], a, l = [], e, s = A;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$UniqueRuleInfo";
  }, e;
})();
let fe = (() => {
  let i = [r("DomainModels$EntityRef")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("DomainModels$DirectEntityRef")], a, l = [], e, s = fe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$DirectEntityRef";
    entity = "";
  }, e;
})();
(() => {
  let i = [r("DomainModels$IndirectEntityRef")], a, l = [], e, s = fe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$IndirectEntityRef";
    steps = [];
  }, e;
})();
(() => {
  let i = [r("DomainModels$EntityRefStep")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$EntityRefStep";
    association = "";
    destinationEntity = "";
  }, e;
})();
let Pe = (() => {
  let i = [r("DomainModels$MemberRef")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    entityRef = null;
  }, e;
})(), gt = (() => {
  let i = [r("DomainModels$AttributeRef")], a, l = [], e, s = Pe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$AttributeRef";
    attribute = "";
  }, e;
})();
(() => {
  let i = [r("DomainModels$AssociationRef")], a, l = [], e, s = Pe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "DomainModels$AssociationRef";
    association = "";
  }, e;
})();
let ee = (() => {
  let i = [r("Url$UrlSegment")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Url$StaticUrlSegment")], a, l = [], e, s = ee;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Url$StaticUrlSegment";
    segment = "";
  }, e;
})();
function ft(i) {
  switch (i) {
    case "Text":
    case "Paragraph":
      return "Text";
    case "H1":
      return "Heading1";
    case "H2":
      return "Heading2";
    case "H3":
      return "Heading3";
    case "H4":
      return "Heading4";
    case "H5":
      return "Heading5";
    case "H6":
      return "Heading6";
  }
}
let V = (() => {
  let i = [r("Pages$FormBase")], a, l = [], e, s = j;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    canvasWidth = 800;
    canvasHeight = 600;
    name = "";
    documentation = "";
  }, e;
})();
(() => {
  let i = [r("Pages$Page")], a, l = [], e, s = V;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.layoutCall = new q(), this.layoutCall.arguments.push(new St());
    }
    $Type = "Pages$Page";
    parameter = "";
    parameters = [];
    layoutCall = new q();
    title = new p();
    appearance = new g();
    allowedRoles = [];
    popupCloseAction = "";
    popupWidth = 0;
    popupHeight = 0;
    popupResizable = !0;
    markAsUsed = !1;
    url = "";
    variables = [];
  }, e;
})();
(() => {
  let i = [r("Pages$ParameterAttributeUrlSegment")], a, l = [], e, s = ee;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ParameterAttributeUrlSegment";
    pageParameter = "";
    attribute = "";
  }, e;
})();
(() => {
  let i = [r("Pages$ParameterIdUrlSegment")], a, l = [], e, s = ee;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ParameterIdUrlSegment";
    pageParameter = "";
  }, e;
})();
(() => {
  let i = [r("Pages$PageParameter")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$PageParameter";
    name = "";
    parameterType = new J();
  }, e;
})();
(() => {
  let i = [r("Pages$Layout")], a, l = [], e, s = V;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Layout";
    parameters = [];
    content = new Pt();
    appearance = new g();
  }, e;
})();
let Se = (() => {
  let i = [r("Pages$LayoutContent")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), Pt = (() => {
  let i = [r("Pages$WebLayoutContent")], a, l = [], e, s = Se;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$WebLayoutContent";
    layoutType = "Responsive";
    layoutCall = null;
    widgets = [];
  }, e;
})();
(() => {
  let i = [r("Pages$NativeLayoutContent")], a, l = [], e, s = Se;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NativeLayoutContent";
    layoutType = "Default";
    widgets = [];
    rightHeaderPlaceholder = null;
    showBottomBar = !0;
    sidebar = !1;
    sidebarWidgets = [];
  }, e;
})();
let q = (() => {
  let i = [r("Pages$LayoutCall")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.layout = t?.layout ?? "Atlas_Core.Atlas_Default";
    }
    $Type = "Pages$LayoutCall";
    layout = "";
    arguments = [];
  }, e;
})(), St = (() => {
  let i = [r("Pages$LayoutCallArgument")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.parameter = t?.parameter ?? "Atlas_Core.Atlas_Default.Main";
    }
    $Type = "Pages$LayoutCallArgument";
    parameter = "";
    widgets = [];
  }, e;
})();
(() => {
  let i = [r("Pages$LayoutParameter")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$LayoutParameter";
    name = "";
  }, e;
})();
let $e = (() => {
  let i = [r("Pages$TemplateFormBase")], a, l = [], e, s = V;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    displayName = "";
    documentationUrl = "";
    templateCategory = "";
    templateCategoryWeight = 0;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    imageData = void 0;
  }, e;
})();
(() => {
  let i = [r("Pages$BuildingBlock")], a, l = [], e, s = $e;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$BuildingBlock";
    widgets = [];
    platform = "Web";
  }, e;
})();
let W = (() => {
  let i = [r("Pages$TemplateType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), $t = (() => {
  let i = [r("Pages$RegularPageTemplateType")], a, l = [], e, s = W;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$RegularPageTemplateType";
  }, e;
})();
(() => {
  let i = [r("Pages$EditPageTemplateType")], a, l = [], e, s = W;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$EditPageTemplateType";
  }, e;
})();
(() => {
  let i = [r("Pages$SelectPageTemplateType")], a, l = [], e, s = W;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SelectPageTemplateType";
  }, e;
})();
(() => {
  let i = [r("Pages$PageTemplate")], a, l = [], e, s = $e;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$PageTemplate";
    layoutCall = new q();
    appearance = new g();
    templateType = new $t();
  }, e;
})();
let y = (() => {
  let i = [r("Pages$ClientAction")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    disabledDuringExecution = !0;
  }, e;
})(), m = (() => {
  let i = [r("Pages$NoClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NoClientAction";
  }, e;
})();
(() => {
  let i = [r("Pages$PageClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$PageClientAction";
    pageSettings = new N();
    pagesForSpecializations = [];
    numberOfPagesToClose2 = null;
  }, e;
})();
(() => {
  let i = [r("Pages$MicroflowClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$MicroflowClientAction";
    microflowSettings = new te();
  }, e;
})();
(() => {
  let i = [r("Pages$CallNanoflowClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CallNanoflowClientAction";
    nanoflow = null;
    parameterMappings = [];
    progressBar = "None";
    progressMessage = null;
    confirmationInfo = null;
  }, e;
})();
(() => {
  let i = [r("Pages$SignOutClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SignOutClientAction";
  }, e;
})();
(() => {
  let i = [r("Pages$SaveChangesClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SaveChangesClientAction";
    syncAutomatically = !1;
    closePage = !0;
  }, e;
})();
(() => {
  let i = [r("Pages$CancelChangesClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CancelChangesClientAction";
    closePage = !0;
  }, e;
})();
(() => {
  let i = [r("Pages$ClosePageClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ClosePageClientAction";
    numberOfPagesToClose = null;
  }, e;
})();
(() => {
  let i = [r("Pages$SyncClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SyncClientAction";
  }, e;
})();
(() => {
  let i = [r("Pages$OpenLinkClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$OpenLinkClientAction";
    linkType = "Web";
    address = new vt();
  }, e;
})();
(() => {
  let i = [r("Pages$DeleteClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$DeleteClientAction";
    closePage = !0;
    sourceVariable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$CreateObjectClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CreateObjectClientAction";
    entityRef = null;
    pageSettings = new N();
    numberOfPagesToClose2 = null;
  }, e;
})();
let N = (() => {
  let i = [r("Pages$PageSettings")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$PageSettings";
    page = null;
    // titleOverride: Microflows.TextTemplate | null = null;
    parameterMappings = [];
  }, e;
})();
(() => {
  let i = [r("Pages$PageParameterMapping")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$PageParameterMapping";
    parameter = "";
    variable = new _e();
    argument = null;
  }, e;
})();
let te = (() => {
  let i = [r("Pages$MicroflowSettings")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$MicroflowSettings";
    microflow = null;
    parameterMappings = [];
    progressBar = "None";
    progressMessage = null;
    asynchronous = !1;
    formValidations = "All";
    confirmationInfo = null;
  }, e;
})();
(() => {
  let i = [r("Pages$MicroflowParameterMapping")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$MicroflowParameterMapping";
    parameter = "";
    expression = null;
    variable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$NanoflowParameterMapping")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NanoflowParameterMapping";
    parameter = "";
    expression = null;
    variable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$ConfirmationInfo")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ConfirmationInfo";
    question = new p();
    proceedButtonCaption = new p();
    cancelButtonCaption = new p();
  }, e;
})();
let _e = (() => {
  let i = [r("Pages$PageVariable")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$PageVariable";
    widget = null;
    pageParameter = null;
    snippetParameter = null;
    localVariable = null;
    useAllPages = !1;
    subKey = "";
  }, e;
})();
(() => {
  let i = [r("Pages$LocalVariable")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$LocalVariable";
    name = "";
    variableType = new J();
    defaultValue = null;
  }, e;
})();
let g = (() => {
  let i = [r("Pages$Appearance")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$Appearance";
    class = "";
    style = "";
    designProperties = [];
    dynamicClasses = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DesignPropertyValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$DesignPropertyValue";
    key = "";
    value = null;
  }, e;
})();
let G = (() => {
  let i = [r("Pages$AbstractDesignPropertyValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$OptionDesignPropertyValue")], a, l = [], e, s = G;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$OptionDesignPropertyValue";
    option = "";
  }, e;
})();
(() => {
  let i = [r("Pages$ToggleDesignPropertyValue")], a, l = [], e, s = G;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ToggleDesignPropertyValue";
  }, e;
})();
(() => {
  let i = [r("Pages$CustomDesignPropertyValue")], a, l = [], e, s = G;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CustomDesignPropertyValue";
    value = "";
  }, e;
})();
(() => {
  let i = [r("Pages$CompoundDesignPropertyValue")], a, l = [], e, s = G;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CompoundDesignPropertyValue";
    properties = [];
  }, e;
})();
let S = (() => {
  let i = [r("Pages$Widget")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    name = "";
    appearance = new g();
    tabIndex = 0;
  }, e;
})(), ve = (() => {
  let i = [r("Pages$LoginTextBox")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    label = null;
    labelWidth = 3;
    placeholder = new p();
  }, e;
})();
(() => {
  let i = [r("Pages$LoginIdTextBox")], a, l = [], e, s = ve;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$LoginIdTextBox";
  }, e;
})();
(() => {
  let i = [r("Pages$PasswordTextBox")], a, l = [], e, s = ve;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$PasswordTextBox";
  }, e;
})();
(() => {
  let i = [r("Pages$ValidationMessage")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ValidationMessage";
  }, e;
})();
let x = (() => {
  let i = [r("Pages$FormattingInfo")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$FormattingInfo";
    decimalPrecision = 2;
    groupDigits = !1;
    enumFormat = "Text";
    dateFormat = "Date";
    customDateFormat = "";
  }, e;
})(), Ie = (() => {
  let i = [r("Pages$WidgetValidation")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$WidgetValidation";
    expression = null;
    message = new p();
  }, e;
})(), d = (() => {
  let i = [r("Pages$ConditionallyVisibleWidget")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    conditionalVisibilitySettings = null;
  }, e;
})(), Me = (() => {
  let i = [r("Pages$ConditionalSettings")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    attribute = null;
    conditions = [];
    expression = null;
    sourceVariable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$ConditionalVisibilitySettings")], a, l = [], e, s = Me;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ConditionalVisibilitySettings";
    moduleRoles = [];
    ignoreSecurity = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$ConditionalEditabilitySettings")], a, l = [], e, s = Me;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ConditionalEditabilitySettings";
  }, e;
})();
(() => {
  let i = [r("Pages$AccessibilitySettings")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$AccessibilitySettings";
    screenReaderDescription = new T();
    screenReaderTitle = new T();
  }, e;
})();
(() => {
  let i = [r("Pages$Table")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Table";
    cells = [];
    columns = [];
    widthUnit = "Weight";
    rows = [];
  }, e;
})();
(() => {
  let i = [r("Pages$TableCell")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$TableCell";
    appearance = new g();
    isHeader = !1;
    widgets = [];
    leftColumnIndex = 0;
    topRowIndex = 0;
    width = 1;
    height = 1;
  }, e;
})();
(() => {
  let i = [r("Pages$TableColumn")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$TableColumn";
    width = 0;
  }, e;
})();
(() => {
  let i = [r("Pages$TableRow")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$TableRow";
    appearance = new g();
    conditionalVisibilitySettings = null;
  }, e;
})();
let ae = (() => {
  let i = [r("Pages$EntityWidget")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    dataSource = null;
  }, e;
})(), z = (() => {
  let i = [r("Pages$DataSource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    forceFullObjects = !1;
  }, e;
})(), F = (() => {
  let i = [r("Pages$EntityPathSource")], a, l = [], e, s = z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    entityRef = null;
    sourceVariable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$MicroflowSource")], a, l = [], e, s = z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$MicroflowSource";
    microflowSettings = new te();
  }, e;
})();
(() => {
  let i = [r("Pages$NanoflowSource")], a, l = [], e, s = z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NanoflowSource";
    nanoflow = null;
    parameterMappings = [];
  }, e;
})();
let De = (() => {
  let i = [r("Pages$ListenTargetWidget")], a, l = [], e, s = ae;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$AssociationSource")], a, l = [], e, s = F;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$AssociationSource";
  }, e;
})();
(() => {
  let i = [r("Pages$DataView")], a, l = [], e, s = ae;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.showFooter = t?.showFooter === void 0 ? !0 : t?.showFooter, this.labelWidth = t?.labelWidth ?? 3;
    }
    $Type = "Pages$DataView";
    widgets = [];
    footerWidgets = [];
    editability = "Always";
    conditionalEditabilitySettings = null;
    showFooter = !0;
    noEntityMessage = new p();
    labelWidth = 3;
    readOnlyStyle = "Control";
  }, e;
})();
(() => {
  let i = [r("Pages$DataViewSource")], a, l = [], e, s = F;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$DataViewSource";
  }, e;
})();
(() => {
  let i = [r("Pages$ListenTargetSource")], a, l = [], e, s = z;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ListenTargetSource";
    listenTarget = "";
  }, e;
})();
let Ne = (() => {
  let i = [r("Pages$ControlBar")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    items = [];
  }, e;
})(), he = (() => {
  let i = [r("Pages$ControlBarItem")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    name = "";
  }, e;
})(), _t = (() => {
  let i = [r("Pages$ControlBarButton")], a, l = [], e, s = he;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    caption = new T();
    tooltip = new p();
    icon = null;
    appearance = new g();
    conditionalVisibilitySettings = null;
    buttonStyle = "Default";
  }, e;
})();
(() => {
  let i = [r("Pages$ListView")], a, l = [], e, s = De;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ListView";
    widgets = [];
    pageSize = 10;
    clickAction = new m();
    editable = !1;
    templates = [];
    scrollDirection = "Vertical";
    numberOfColumns = 1;
    pullDownAction = new m();
  }, e;
})();
(() => {
  let i = [r("Pages$ListViewTemplate")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ListViewTemplate";
    specialization = "";
    widgets = [];
  }, e;
})();
let Re = (() => {
  let i = [r("Pages$SortableEntityPathSource")], a, l = [], e, s = F;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    sortBar = new le();
  }, e;
})(), Ae = (() => {
  let i = [r("Pages$XPathSourceBase")], a, l = [], e, s = Re;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    xPathConstraint = null;
  }, e;
})();
(() => {
  let i = [r("Pages$ListViewXPathSource")], a, l = [], e, s = Ae;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ListViewXPathSource";
    search = new At();
  }, e;
})();
let le = (() => {
  let i = [r("Pages$GridSortBar")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$GridSortBar";
    sortItems = [];
  }, e;
})();
(() => {
  let i = [r("Pages$GridSortItem")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$GridSortItem";
    attributeRef = new gt();
    sortDirection = "Ascending";
  }, e;
})();
let U = (() => {
  let i = [r("Pages$Button")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    caption = new T();
    tooltip = new p();
    icon = null;
    renderType = "Button";
    buttonStyle = "Default";
  }, e;
})(), vt = (() => {
  let i = [r("Pages$StaticOrDynamicString")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$StaticOrDynamicString";
    isDynamic = !1;
    value = "";
    attributeRef = null;
  }, e;
})();
(() => {
  let i = [r("Pages$ActionButton")], a, l = [], e, s = U;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.caption = new T(t?.caption ? { text: t.caption } : void 0), this.buttonStyle = t?.buttonStyle ?? "Default", this.renderType = t?.renderType ?? "Button", this.ariaRole = this.renderType;
    }
    $Type = "Pages$ActionButton";
    action = new m();
    ariaRole = "Button";
    nativeAccessibilitySettings = null;
  }, e;
})();
let T = (() => {
  let i = [r("Pages$ClientTemplate")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.template = new p(t?.text ? { text: t.text, languageCode: t.languageCode } : void 0), this.fallback = new p({ text: "", languageCode: t?.languageCode });
    }
    $Type = "Pages$ClientTemplate";
    template = new p();
    parameters = [];
    fallback = new p();
  }, e;
})();
(() => {
  let i = [r("Pages$ClientTemplateParameter")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ClientTemplateParameter";
    attributeRef = null;
    expression = null;
    formattingInfo = new x();
    sourceVariable = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DropDownButton")], a, l = [], e, s = U;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DropDownButton";
    items = [];
  }, e;
})();
let Ce = (() => {
  let i = [r("Pages$ActionItem")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    action = new m();
  }, e;
})();
(() => {
  let i = [r("Pages$DropDownButtonItem")], a, l = [], e, s = Ce;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$DropDownButtonItem";
    caption = new p();
    image = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DynamicImageViewer")], a, l = [], e, s = ae;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DynamicImageViewer";
    defaultImage = null;
    widthUnit = "Auto";
    heightUnit = "Auto";
    width = 0;
    height = 0;
    responsive = !0;
    showAsThumbnail = !1;
    clickAction = new m();
    onClickEnlarge = !1;
    alternativeText = new T();
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DynamicText")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.content = new T(t?.content ? { text: t.content } : void 0), this.renderMode = t?.renderMode ?? "Text", this.nativeTextStyle = ft(this.renderMode);
    }
    $Type = "Pages$DynamicText";
    content = new T();
    renderMode = "Text";
    nativeTextStyle = "Text";
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$PageForSpecialization")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$PageForSpecialization";
    entity = "";
    pageSettings = new N();
  }, e;
})();
let Oe = (() => {
  let i = [r("Pages$Grid")], a, l = [], e, s = De;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    isControlBarVisible = !0;
    showPagingBar = "YesWithTotalCount";
    selectionMode = "Single";
    selectFirst = !1;
    defaultButtonTrigger = "Double";
    refreshTime = 0;
    controlBar = new It();
  }, e;
})(), xe = (() => {
  let i = [r("Pages$GridBaseSource")], a, l = [], e, s = Re;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    searchBar = new Rt();
  }, e;
})();
(() => {
  let i = [r("Pages$GridColumn")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridColumn";
    name = "";
    caption = new p();
    attributeRef = null;
    formattingInfo = new x();
    showTooltip = !1;
    aggregateCaption = new p();
    aggregateFunction = "None";
    editable = !1;
    width = 0;
    appearance = new g();
  }, e;
})();
let It = (() => {
  let i = [r("Pages$GridControlBar")], a, l = [], e, s = Ne;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$GridControlBar";
    defaultButton = null;
  }, e;
})(), $ = (() => {
  let i = [r("Pages$GridControlBarButton")], a, l = [], e, s = _t;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$GridDeselectAllButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridDeselectAllButton";
  }, e;
})();
(() => {
  let i = [r("Pages$GridNewButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridNewButton";
    entity = null;
    editLocation = "Form";
    pageSettings = new N();
  }, e;
})();
(() => {
  let i = [r("Pages$GridSearchButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridSearchButton";
  }, e;
})();
(() => {
  let i = [r("Pages$GridSelectAllButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridSelectAllButton";
    selectionType = "SelectPage";
  }, e;
})();
(() => {
  let i = [r("Pages$GroupBox")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GroupBox";
    caption = null;
    collapsible = "YesInitiallyExpanded";
    headerMode = "H2";
    widgets = [];
  }, e;
})();
(() => {
  let i = [r("Pages$Header")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Header";
    leftWidgets = [];
    rightWidgets = [];
  }, e;
})();
let se = (() => {
  let i = [r("Pages$Icon")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$ImageIcon")], a, l = [], e, s = se;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ImageIcon";
    image = "";
  }, e;
})();
(() => {
  let i = [r("Pages$IconCollectionIcon")], a, l = [], e, s = se;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$IconCollectionIcon";
    image = "";
  }, e;
})();
(() => {
  let i = [r("Pages$ImageViewerSource")], a, l = [], e, s = F;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ImageViewerSource";
  }, e;
})();
(() => {
  let i = [r("Pages$LayoutGrid")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.width = t?.width ?? "FullWidth", this.rows.push(new Dt({ columns: t?.columns }));
    }
    $Type = "Pages$LayoutGrid";
    width = "FullWidth";
    rows = [];
  }, e;
})();
let Mt = (() => {
  let i = [r("Pages$LayoutGridColumn")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.weight = t?.weight ?? 1;
    }
    $Type = "Pages$LayoutGridColumn";
    weight = 1;
    tabletWeight = -1;
    phoneWeight = -1;
    previewWidth = -1;
    widgets = [];
    appearance = new g();
    verticalAlignment = "None";
  }, e;
})(), Dt = (() => {
  let i = [r("Pages$LayoutGridRow")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.columns = t?.columns?.map((u) => new Mt({ weight: u.weight })) ?? [];
    }
    $Type = "Pages$LayoutGridRow";
    columns = [];
    conditionalVisibilitySettings = null;
    appearance = new g();
    verticalAlignment = "None";
    horizontalAlignment = "None";
    spacingBetweenColumns = !0;
  }, e;
})(), Le = (() => {
  let i = [r("Pages$MenuSource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})(), ie = (() => {
  let i = [r("Pages$MenuWidget")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    menuSource = new Nt();
  }, e;
})();
(() => {
  let i = [r("Pages$NavigationList")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$NavigationList";
    items = [];
  }, e;
})();
(() => {
  let i = [r("Pages$NavigationListItem")], a, l = [], e, s = Ce;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NavigationListItem";
    widgets = [];
    appearance = new g();
    conditionalVisibilitySettings = null;
  }, e;
})();
let Nt = (() => {
  let i = [r("Pages$NavigationSource")], a, l = [], e, s = Le;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$NavigationSource";
    navigationProfile = "";
  }, e;
})();
(() => {
  let i = [r("Pages$NavigationTree")], a, l = [], e, s = ie;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$NavigationTree";
  }, e;
})();
(() => {
  let i = [r("Pages$ReferenceSetSource")], a, l = [], e, s = xe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ReferenceSetSource";
  }, e;
})();
(() => {
  let i = [r("Pages$ScrollContainer")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ScrollContainer";
    center = new ht();
    left = null;
    right = null;
    top = null;
    bottom = null;
    layoutMode = "Headline";
    widthMode = "Auto";
    width = 960;
    alignment = "Center";
    scrollBehavior = "PerRegion";
    nativeHideScrollbars = !1;
  }, e;
})();
let ht = (() => {
  let i = [r("Pages$ScrollContainerRegion")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ScrollContainerRegion";
    widgets = [];
    sizeMode = "Auto";
    size = 200;
    appearance = new g();
    toggleMode = "None";
  }, e;
})(), Rt = (() => {
  let i = [r("Pages$SearchBar")], a, l = [], e, s = Ne;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SearchBar";
    type = "FoldableClosed";
    waitForSearch = !1;
  }, e;
})(), At = (() => {
  let i = [r("Pages$ListViewSearch")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$ListViewSearch";
    searchRefs = [];
  }, e;
})(), we = (() => {
  let i = [r("Pages$SearchField")], a, l = [], e, s = he;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    caption = new p();
    placeholder = new p();
    customDateFormat = "";
    type = "Normal";
    defaultValue = "";
  }, e;
})();
(() => {
  let i = [r("Pages$SelectButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$SelectButton";
  }, e;
})();
let ke = (() => {
  let i = [r("Pages$SelectorSource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$SidebarToggleButton")], a, l = [], e, s = U;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$SidebarToggleButton";
  }, e;
})();
(() => {
  let i = [r("Pages$SimpleMenuBar")], a, l = [], e, s = ie;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$SimpleMenuBar";
    orientation = "Horizontal";
  }, e;
})();
let je = (() => {
  let i = [r("Pages$SingleSearchField")], a, l = [], e, s = we;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    attributeRef = null;
    operator = "Contains";
  }, e;
})();
(() => {
  let i = [r("Pages$Snippet")], a, l = [], e, s = V;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Snippet";
    widgets = [];
    type = "Web";
    parameters = [];
    variables = [];
  }, e;
})();
(() => {
  let i = [r("Pages$SnippetParameter")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$SnippetParameter";
    name = "";
    parameterType = new J();
  }, e;
})();
let Ct = (() => {
  let i = [r("Pages$SnippetCall")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SnippetCall";
    snippet = null;
    parameterMappings = [];
  }, e;
})();
(() => {
  let i = [r("Pages$SnippetParameterMapping")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SnippetParameterMapping";
    parameter = "";
    variable = new _e();
  }, e;
})();
(() => {
  let i = [r("Pages$SnippetCallWidget")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$SnippetCallWidget";
    snippetCall = new Ct();
  }, e;
})();
(() => {
  let i = [r("Pages$TabContainer")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$TabContainer";
    tabPages = [];
    defaultPage = null;
    activePageAttributeRef = null;
    activePageSourceVariable = null;
    activePageOnChangeAction = new m();
  }, e;
})();
(() => {
  let i = [r("Pages$TabPage")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$TabPage";
    name = "";
    caption = new p();
    refreshOnShow = !1;
    conditionalVisibilitySettings = null;
    widgets = [];
    badge = null;
  }, e;
})();
(() => {
  let i = [r("Pages$TemplateGrid")], a, l = [], e, s = Oe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$TemplateGrid";
    contents = new Ot();
    numberOfRows = 3;
    numberOfColumns = 2;
  }, e;
})();
let Ot = (() => {
  let i = [r("Pages$TemplateGridContents")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$TemplateGridContents";
    widgets = [];
  }, e;
})();
(() => {
  let i = [r("Pages$Title")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Title";
    nativeAccessibilitySettings = null;
  }, e;
})();
let Be = (() => {
  let i = [r("Pages$WorkflowTemplateType")], a, l = [], e, s = W;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Pages$UserTaskTemplateType")], a, l = [], e, s = Be;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$UserTaskTemplateType";
  }, e;
})();
(() => {
  let i = [r("Pages$WorkflowOverviewTemplateType")], a, l = [], e, s = Be;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$WorkflowOverviewTemplateType";
  }, e;
})();
(() => {
  let i = [r("Pages$CallWorkflowClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$CallWorkflowClientAction";
    workflow = null;
    closePage = !0;
    confirmationInfo = null;
  }, e;
})();
(() => {
  let i = [r("Pages$OpenUserTaskClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$OpenUserTaskClientAction";
    assignOnOpen = !0;
    openWhenAssigned = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$OpenWorkflowClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$OpenWorkflowClientAction";
    defaultPage = null;
  }, e;
})();
(() => {
  let i = [r("Pages$SetTaskOutcomeClientAction")], a, l = [], e, s = y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SetTaskOutcomeClientAction";
    outcomeValue = "";
    closePage = !0;
    commit = !0;
  }, e;
})();
(() => {
  let i = [r("Pages$Placeholder")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Placeholder";
  }, e;
})();
(() => {
  let i = [r("Pages$TemplatePlaceholder")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$TemplatePlaceholder";
    type = "";
  }, e;
})();
(() => {
  let i = [r("Pages$Label")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$Label";
    caption = new p();
  }, e;
})();
(() => {
  let i = [r("Pages$StaticImageViewer")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$StaticImageViewer";
    image = null;
    widthUnit = "Auto";
    heightUnit = "Auto";
    width = 0;
    height = 0;
    clickAction = new m();
    responsive = !0;
    alternativeText = new T();
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DivContainer")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.renderMode = t?.renderMode ?? "Div";
    }
    $Type = "Pages$DivContainer";
    widgets = [];
    renderMode = "Div";
    onClickAction = new m();
    screenReaderHidden = !1;
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$LoginButton")], a, l = [], e, s = U;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$LoginButton";
    validationMessageWidget = "";
  }, e;
})();
let xt = (() => {
  let i = [r("Pages$ConditionallyEditableWidget")], a, l = [], e, s = d;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    conditionalEditabilitySettings = null;
    editable = "Always";
  }, e;
})(), Ve = (() => {
  let i = [r("Pages$ColumnGrid")], a, l = [], e, s = Oe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    columns = [];
    numberOfRows = 20;
    showEmptyRows = !1;
    widthUnit = "Weight";
    tooltipPage = null;
  }, e;
})();
(() => {
  let i = [r("Pages$ComparisonSearchField")], a, l = [], e, s = je;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ComparisonSearchField";
  }, e;
})();
(() => {
  let i = [r("Pages$GridXPathSource")], a, l = [], e, s = xe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$GridXPathSource";
    xPathConstraint = null;
  }, e;
})();
(() => {
  let i = [r("Pages$DataGrid")], a, l = [], e, s = Ve;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DataGrid";
    caption = new T();
  }, e;
})();
(() => {
  let i = [r("Pages$DataGridAddButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DataGridAddButton";
    pageSettings = new N();
  }, e;
})();
(() => {
  let i = [r("Pages$DataGridExportToCSVButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DataGridExportToCSVButton";
    maxNumberOfRows = 1e3;
    decimalSeparator = ".";
    groupSeparator = ",";
    delimiter = ";";
    generateExcelHint = !1;
    useGridDateFormat = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$DataGridExportToExcelButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DataGridExportToExcelButton";
    maxNumberOfRows = 1e3;
    useExcelDateType = !0;
  }, e;
})();
(() => {
  let i = [r("Pages$DataGridRemoveButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DataGridRemoveButton";
  }, e;
})();
(() => {
  let i = [r("Pages$DropDownSearchField")], a, l = [], e, s = je;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DropDownSearchField";
    sortBar = new le();
    xPathConstraint = null;
    allowMultipleSelect = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$GlyphIcon")], a, l = [], e, s = se;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$GlyphIcon";
    code = -1;
  }, e;
})();
(() => {
  let i = [r("Pages$GridActionButton")], a, l = [], e, s = $;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$GridActionButton";
    action = new m();
    maintainSelectionAfterMicroflow = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$MenuBar")], a, l = [], e, s = ie;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$MenuBar";
  }, e;
})();
(() => {
  let i = [r("Pages$MenuDocumentSource")], a, l = [], e, s = Le;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$MenuDocumentSource";
    menu = null;
  }, e;
})();
(() => {
  let i = [r("Pages$RangeSearchField")], a, l = [], e, s = we;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$RangeSearchField";
    lowerBoundRef = null;
    upperBoundRef = null;
    includeLower = !1;
    includeUpper = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$ReferenceSetSelector")], a, l = [], e, s = Ve;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ReferenceSetSelector";
    onChangeAction = new m();
    constrainedByRefs = [];
    xPathConstraint = null;
  }, e;
})();
let Lt = (() => {
  let i = [r("Pages$SelectorXPathSource")], a, l = [], e, s = ke;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SelectorXPathSource";
    sortBar = new le();
    xPathConstraint = null;
    constrainedByRefs = [];
  }, e;
})();
(() => {
  let i = [r("Pages$SelectorMicroflowSource")], a, l = [], e, s = ke;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Pages$SelectorMicroflowSource";
    dataSourceMicroflowSettings = new te();
  }, e;
})();
let re = (() => {
  let i = [r("Pages$InputWidget")], a, l = [], e, s = xt;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.labelTemplate = new T(t?.showLabel !== !1 && t?.labelCaption ? { text: t?.labelCaption } : void 0);
    }
    labelTemplate = null;
    screenReaderLabel = null;
  }, e;
})();
(() => {
  let i = [r("Pages$FileManager")], a, l = [], e, s = re;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$FileManager";
    allowedExtensions = "";
    type = "Both";
    maxFileSize = 5;
    showFileInBrowser = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$ImageUploader")], a, l = [], e, s = re;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ImageUploader";
    allowedExtensions = "";
    thumbnailSize = "size(10075)";
    maxFileSize = 5;
  }, e;
})();
let We = (() => {
  let i = [r("Pages$MemberWidget")], a, l = [], e, s = re;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    attributeRef = null;
    readOnlyStyle = "Inherit";
  }, e;
})(), Ge = (() => {
  let i = [r("Pages$AssociationWidget")], a, l = [], e, s = We;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    selectorSource = new Lt();
    selectPageSettings = new N();
    onChangeAction = new m();
    sourceVariable = null;
  }, e;
})(), Y = (() => {
  let i = [r("Pages$AttributeWidget")], a, l = [], e, s = We;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    validation = new Ie();
    onChangeAction = new m();
    onEnterAction = new m();
    onLeaveAction = new m();
    sourceVariable = null;
    ariaRequired = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$DropDown")], a, l = [], e, s = Y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$DropDown";
    emptyOptionCaption = new p();
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$InputReferenceSetSelector")], a, l = [], e, s = Ge;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$InputReferenceSetSelector";
  }, e;
})();
(() => {
  let i = [r("Pages$ReferenceSelector")], a, l = [], e, s = Ge;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "Pages$ReferenceSelector";
    validation = new Ie();
    renderMode = "DropDown";
    gotoPageSettings = new N();
    formattingInfo = new x();
    emptyOptionCaption = new p();
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$CheckBox")], a, l = [], e, s = Y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(t), this.name = t?.name ?? "";
    }
    $Type = "Pages$CheckBox";
    labelPosition = "Default";
    nativeRenderMode = "Switch";
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$RadioButtonGroup")], a, l = [], e, s = Y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(t), this.name = t?.name ?? "", this.renderHorizontal = t?.renderHorizontal === void 0 ? !0 : t?.renderHorizontal;
    }
    $Type = "Pages$RadioButtonGroup";
    renderHorizontal = !0;
  }, e;
})();
let ze = (() => {
  let i = [r("Pages$AttributeWidgetWithPlaceholder")], a, l = [], e, s = Y;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    placeholderTemplate = new T();
  }, e;
})();
(() => {
  let i = [r("Pages$DatePicker")], a, l = [], e, s = ze;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(t), this.name = t?.name ?? "";
    }
    $Type = "Pages$DatePicker";
    formattingInfo = new x();
    nativeAccessibilitySettings = null;
  }, e;
})();
let Fe = (() => {
  let i = [r("Pages$TextWidget")], a, l = [], e, s = ze;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    maxLengthCode = -1;
    autoFocus = !1;
  }, e;
})();
(() => {
  let i = [r("Pages$TextBox")], a, l = [], e, s = Fe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(t), this.name = t?.name ?? "", this.isPasswordBox = t?.isPasswordBox ?? !1;
    }
    $Type = "Pages$TextBox";
    inputMask = "";
    formattingInfo = new x();
    isPasswordBox = !1;
    keyboardType = "Default";
    onEnterKeyPressAction = new m();
    autocomplete = !0;
    autocompletePurpose = "On";
    submitBehaviour = "OnEndEditing";
    submitOnInputDelay = 300;
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("Pages$TextArea")], a, l = [], e, s = Fe;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(t), this.name = t?.name ?? "";
    }
    $Type = "Pages$TextArea";
    numberOfLines = 5;
    counterMessage = new p();
    textTooLongMessage = new p();
    autocomplete = !0;
    submitBehaviour = "OnEndEditing";
    submitOnInputDelay = 300;
    nativeAccessibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$CustomWidget")], a, l = [], e, s = S;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "CustomWidgets$CustomWidget";
    type = null;
    object = null;
    labelTemplate = null;
    conditionalEditabilitySettings = null;
    editable = "Always";
    conditionalVisibilitySettings = null;
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$CustomWidgetType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "";
    }
    $Type = "CustomWidgets$CustomWidgetType";
    widgetId = "";
    needsEntityContext = !1;
    pluginWidget = !1;
    name = "";
    description = "";
    studioProCategory = "";
    studioCategory = "";
    // supportedPlatform: Client.SupportedPlatform = "Web";
    offlineCapable = !1;
    objectType = new wt();
    helpUrl = "";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetEnumerationValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetEnumerationValue";
    key = "";
    caption = "";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetObject")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetObject";
    type = null;
    properties = [];
  }, e;
})();
let wt = (() => {
  let i = [r("CustomWidgets$WidgetObjectType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetObjectType";
    propertyTypes = [];
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetProperty")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetProperty";
    type = null;
    value = null;
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetPropertyType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetPropertyType";
    key = "";
    category = "";
    caption = "";
    description = "";
    isDefault = !1;
    valueType = null;
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetReturnType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetReturnType";
    type = "None";
    isList = !1;
    entityProperty = "";
    assignableTo = "";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetTranslation")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetTranslation";
    languageCode = "";
    text = "";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetActionVariable")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetActionVariable";
    key = "";
    type = "None";
    caption = "";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetValue";
    type = "";
    primitiveValue = "";
    entityRef = null;
    attributeRef = null;
    page = null;
    microflow = null;
    nanoflow = null;
    icon = null;
    image = null;
    translatableValue = null;
    textTemplate = null;
    xPathConstraint = null;
    objects = [];
    action = new m();
    expression = null;
    widgets = [];
    dataSource = null;
    sourceVariable = null;
    selection = "None";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$WidgetValueType")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$WidgetValueType";
    type = "String";
    isList = !1;
    isLinked = !1;
    isMetaData = !1;
    entityProperty = "";
    allowNonPersistableEntities = !1;
    isPath = "No";
    pathType = "None";
    parameterIsList = !1;
    multiline = !1;
    defaultValue = "";
    required = !1;
    onChangeProperty = "";
    dataSourceProperty = "";
    selectableObjectsProperty = "";
    attributeTypes = [];
    associationTypes = [];
    selectionTypes = [];
    enumerationValues = [];
    actionVariables = [];
    objectType = null;
    returnType = null;
    translations = [];
    setLabel = !1;
    defaultType = "None";
  }, e;
})();
(() => {
  let i = [r("CustomWidgets$CustomWidgetXPathSource")], a, l = [], e, s = Ae;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "CustomWidgets$CustomWidgetXPathSource";
  }, e;
})();
(() => {
  let i = [r("Enumerations$Enumeration")], a, l = [], e, s = j;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.values = t?.values?.map((u) => new kt(u)) ?? [];
    }
    $Type = "Enumerations$Enumeration";
    values = [];
    remoteSource = null;
    name = "";
    documentation = "";
  }, e;
})();
let kt = (() => {
  let i = [r("Enumerations$EnumerationValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    constructor(t) {
      super(), this.name = t?.name ?? "", this.caption = new p(t?.caption ? { text: t.caption } : void 0);
    }
    $Type = "Enumerations$EnumerationValue";
    name = "";
    caption = new p();
    image = null;
    remoteValue = null;
  }, e;
})();
(() => {
  let i = [r("Enumerations$Condition")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
    $Type = "Enumerations$Condition";
    attributeValue = "";
    editableVisible = !0;
  }, e;
})();
(() => {
  let i = [r("Enumerations$RemoteEnumerationSource")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
(() => {
  let i = [r("Enumerations$RemoteEnumerationValue")], a, l = [], e, s = c;
  return class extends s {
    static {
      e = this;
    }
    static {
      const t = typeof Symbol == "function" && Symbol.metadata ? Object.create(s[Symbol.metadata] ?? null) : void 0;
      n(null, a = { value: e }, i, { kind: "class", name: e.name, metadata: t }, null, l), e = a.value, t && Object.defineProperty(e, Symbol.metadata, { enumerable: !0, configurable: !0, writable: !0, value: t }), o(e, l);
    }
  }, e;
})();
const jt = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$DomainModel"], properties: { documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, entities: { list: !0, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "PART" }, annotations: { list: !0, type: "ELEMENT", elementType: "DomainModels$Annotation", kind: "PART" }, associations: { list: !0, type: "ELEMENT", elementType: "DomainModels$Association", kind: "PART" }, crossAssociations: { list: !0, type: "ELEMENT", elementType: "DomainModels$CrossAssociation", kind: "PART" } } }, Bt = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$Entity"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, dataStorageGuid: { list: !1, type: "PRIMITIVE", primitiveType: "GUID" }, location: { list: !1, type: "PRIMITIVE", primitiveType: "POINT" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, generalization: { list: !1, type: "ELEMENT", elementType: "DomainModels$GeneralizationBase", kind: "PART" }, attributes: { list: !0, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "PART" }, validationRules: { list: !0, type: "ELEMENT", elementType: "DomainModels$ValidationRule", kind: "PART" }, eventHandlers: { list: !0, type: "ELEMENT", elementType: "DomainModels$EventHandler", kind: "PART" }, indexes: { list: !0, type: "ELEMENT", elementType: "DomainModels$Index", kind: "PART" }, accessRules: { list: !0, type: "ELEMENT", elementType: "DomainModels$AccessRule", kind: "PART" }, image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" }, imageData: { list: !1, type: "PRIMITIVE", primitiveType: "BLOB" }, source: { list: !1, type: "ELEMENT", elementType: "DomainModels$EntitySource", kind: "PART" } } }, Vt = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$OqlViewEntitySource", "DomainModels$QueryBasedRemoteEntitySource", "DomainModels$RemoteEntitySource", "DomainModels$ViewEntitySource"] }, Wt = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$EntitySource"], allCompatibleTypes: ["DomainModels$QueryBasedRemoteEntitySource"] }, Gt = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$EntitySource", "DomainModels$RemoteEntitySource"], allCompatibleTypes: [] }, zt = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$EntitySource"], allCompatibleTypes: ["DomainModels$OqlViewEntitySource"] }, Ft = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$EntitySource", "DomainModels$ViewEntitySource"], allCompatibleTypes: ["DomainModels$OqlViewEntitySource"], properties: { sourceDocument: { list: !1, type: "ELEMENT", elementType: "DomainModels$ViewEntitySourceDocument", kind: "BY_NAME_REFERENCE" } } }, Ut = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$Generalization", "DomainModels$NoGeneralization"] }, Yt = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$GeneralizationBase"], allCompatibleTypes: ["DomainModels$Generalization"], properties: { generalization: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" } } }, Ht = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$GeneralizationBase"], allCompatibleTypes: ["DomainModels$NoGeneralization"], properties: { hasChangedDate: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, hasCreatedDate: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, hasOwner: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, hasChangedBy: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, persistable: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, qt = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$EntityKey"], properties: { parts: { list: !0, type: "ELEMENT", elementType: "DomainModels$EntityKeyPart", kind: "PART" } } }, Xt = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$EntityKeyPart"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, type: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeType", kind: "PART" } } }, Kt = { type: "MODEL_UNIT", abstract: !0, baseTypes: [], allCompatibleTypes: [], properties: { description: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, catalogUrl: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, icon: { list: !1, type: "PRIMITIVE", primitiveType: "BLOB" }, metadata: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, metadataUrl: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, serviceName: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, version: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, endpointId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, minimumMxVersion: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, recommendedMxVersion: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, applicationId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, environmentType: { list: !1, type: "ENUMERATION", values: ["Production", "Sandbox", "NonProduction", "Unknown"] }, metadataHash: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, validated: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, validatedEntities: { list: !0, type: "PRIMITIVE", primitiveType: "STRING" }, name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Jt = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$ViewEntitySourceDocument"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Qt = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$Attribute"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, dataStorageGuid: { list: !1, type: "PRIMITIVE", primitiveType: "GUID" }, type: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeType", kind: "PART" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, value: { list: !1, type: "ELEMENT", elementType: "DomainModels$ValueType", kind: "PART" } } }, Zt = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$CalculatedValue", "DomainModels$MappedValue", "DomainModels$OqlViewValue", "DomainModels$StoredValue"] }, ea = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$ValueType"], allCompatibleTypes: ["DomainModels$StoredValue"], properties: { defaultValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, ta = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$ValueType"], allCompatibleTypes: ["DomainModels$CalculatedValue"], properties: { microflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Microflow", kind: "BY_NAME_REFERENCE" }, passEntity: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, aa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$ValueType"], allCompatibleTypes: ["DomainModels$OqlViewValue"], properties: { reference: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, la = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$ValueType"], allCompatibleTypes: [], properties: { defaultValueDesignTime: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, sa = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$AutoNumberAttributeType", "DomainModels$BinaryAttributeType", "DomainModels$BooleanAttributeType", "DomainModels$DateTimeAttributeType", "DomainModels$DecimalAttributeType", "DomainModels$DecimalAttributeTypeBase", "DomainModels$EnumerationAttributeType", "DomainModels$HashedStringAttributeType", "DomainModels$IntegerAttributeType", "DomainModels$IntegerAttributeTypeBase", "DomainModels$LongAttributeType", "DomainModels$NumericAttributeTypeBase", "DomainModels$StringAttributeType"] }, ia = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$BinaryAttributeType"] }, ra = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$BooleanAttributeType"] }, na = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$DateTimeAttributeType"], properties: { localizeDate: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, oa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$EnumerationAttributeType"], properties: { enumeration: { list: !1, type: "ELEMENT", elementType: "Enumerations$Enumeration", kind: "BY_NAME_REFERENCE" } } }, ca = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$HashedStringAttributeType"] }, ua = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$StringAttributeType"], properties: { length: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, pa = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$AttributeType"], allCompatibleTypes: ["DomainModels$AutoNumberAttributeType", "DomainModels$DecimalAttributeType", "DomainModels$DecimalAttributeTypeBase", "DomainModels$IntegerAttributeType", "DomainModels$IntegerAttributeTypeBase", "DomainModels$LongAttributeType"] }, ma = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$AttributeType", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$DecimalAttributeType"] }, ya = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType", "DomainModels$DecimalAttributeTypeBase", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$DecimalAttributeType"] }, da = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$AttributeType", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$AutoNumberAttributeType", "DomainModels$IntegerAttributeType", "DomainModels$LongAttributeType"] }, ba = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType", "DomainModels$IntegerAttributeTypeBase", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$IntegerAttributeType"] }, Ta = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType", "DomainModels$IntegerAttributeTypeBase", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$LongAttributeType"] }, Ea = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AttributeType", "DomainModels$IntegerAttributeTypeBase", "DomainModels$NumericAttributeTypeBase"], allCompatibleTypes: ["DomainModels$AutoNumberAttributeType"] }, ga = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$Association", "DomainModels$CrossAssociation"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, dataStorageGuid: { list: !1, type: "PRIMITIVE", primitiveType: "GUID" }, type: { list: !1, type: "ENUMERATION", values: ["Reference", "ReferenceSet"] }, owner: { list: !1, type: "ENUMERATION", values: ["Default", "Both"] }, storageFormat: { list: !1, type: "ENUMERATION", values: ["Table", "Column"] }, deleteBehavior: { list: !1, type: "ELEMENT", elementType: "DomainModels$AssociationDeleteBehavior", kind: "PART" }, parent: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_ID_REFERENCE" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, source: { list: !1, type: "ELEMENT", elementType: "DomainModels$AssociationSource", kind: "PART" } } }, fa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AssociationBase"], allCompatibleTypes: ["DomainModels$Association"], properties: { child: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_ID_REFERENCE" }, parentConnection: { list: !1, type: "PRIMITIVE", primitiveType: "POINT" }, childConnection: { list: !1, type: "PRIMITIVE", primitiveType: "POINT" } } }, Pa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AssociationBase"], allCompatibleTypes: ["DomainModels$CrossAssociation"], properties: { child: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" } } }, Sa = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$OqlViewAssociationSource", "DomainModels$RemoteAssociationSource"] }, $a = { type: "ELEMENT", abstract: !0, baseTypes: ["DomainModels$AssociationSource"], allCompatibleTypes: [] }, _a = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$AssociationSource"], allCompatibleTypes: ["DomainModels$OqlViewAssociationSource"], properties: { reference: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, va = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$AssociationDeleteBehavior"], properties: { parentDeleteBehavior: { list: !1, type: "ENUMERATION", values: ["DeleteMeAndReferences", "DeleteMeButKeepReferences", "DeleteMeIfNoReferences"] }, childDeleteBehavior: { list: !1, type: "ENUMERATION", values: ["DeleteMeAndReferences", "DeleteMeButKeepReferences", "DeleteMeIfNoReferences"] }, parentErrorMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, childErrorMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, Ia = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$Annotation"], properties: { caption: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, location: { list: !1, type: "PRIMITIVE", primitiveType: "POINT" }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, Ma = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$AccessRule"], properties: { memberAccesses: { list: !0, type: "ELEMENT", elementType: "DomainModels$MemberAccess", kind: "PART" }, moduleRoles: { list: !0, type: "ELEMENT", elementType: "Security$ModuleRole", kind: "BY_NAME_REFERENCE" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, allowCreate: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, allowDelete: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, defaultMemberAccessRights: { list: !1, type: "ENUMERATION", values: ["None", "ReadOnly", "ReadWrite"] }, xPathConstraintCaption: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Da = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$MemberAccess"], properties: { attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" }, association: { list: !1, type: "ELEMENT", elementType: "DomainModels$AssociationBase", kind: "BY_NAME_REFERENCE" }, accessRights: { list: !1, type: "ENUMERATION", values: ["None", "ReadOnly", "ReadWrite"] } } }, Na = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$EventHandler"], properties: { moment: { list: !1, type: "ENUMERATION", values: ["Before", "After"] }, event: { list: !1, type: "ENUMERATION", values: ["Create", "Commit", "Delete", "RollBack"] }, microflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Microflow", kind: "BY_NAME_REFERENCE" }, raiseErrorOnFalse: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, passEventObject: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, ha = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$Index"], properties: { dataStorageGuid: { list: !1, type: "PRIMITIVE", primitiveType: "GUID" }, attributes: { list: !0, type: "ELEMENT", elementType: "DomainModels$IndexedAttribute", kind: "PART" }, includeInOffline: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Ra = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$IndexedAttribute"], properties: { type: { list: !1, type: "ENUMERATION", values: ["Normal", "CreatedDate", "ChangedDate"] }, attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_ID_REFERENCE" }, ascending: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Aa = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$ValidationRule"], properties: { attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" }, errorMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, ruleInfo: { list: !1, type: "ELEMENT", elementType: "DomainModels$RuleInfo", kind: "PART" } } }, Ca = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$EqualsToRuleInfo", "DomainModels$MaxLengthRuleInfo", "DomainModels$RangeRuleInfo", "DomainModels$RegExRuleInfo", "DomainModels$RequiredRuleInfo", "DomainModels$UniqueRuleInfo"] }, Oa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$EqualsToRuleInfo"], properties: { useValue: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, equalsToValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, equalsToAttribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" } } }, xa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$MaxLengthRuleInfo"], properties: { maxLength: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, La = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$RangeRuleInfo"], properties: { typeOfRange: { list: !1, type: "ENUMERATION", values: ["GreaterThanOrEqualTo", "SmallerThanOrEqualTo", "Between"] }, useMinValue: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, useMaxValue: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, minValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, maxValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, minAttribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" }, maxAttribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" } } }, wa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$RegExRuleInfo"], properties: { regularExpression: { list: !1, type: "ELEMENT", elementType: "RegularExpressions$RegularExpression", kind: "BY_NAME_REFERENCE" } } }, ka = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$RequiredRuleInfo"] }, ja = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$RuleInfo"], allCompatibleTypes: ["DomainModels$UniqueRuleInfo"] }, Ba = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$DirectEntityRef", "DomainModels$IndirectEntityRef"] }, Va = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$EntityRef"], allCompatibleTypes: ["DomainModels$DirectEntityRef"], properties: { entity: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" } } }, Wa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$EntityRef"], allCompatibleTypes: ["DomainModels$IndirectEntityRef"], properties: { steps: { list: !0, type: "ELEMENT", elementType: "DomainModels$EntityRefStep", kind: "PART" } } }, Ga = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["DomainModels$EntityRefStep"], properties: { association: { list: !1, type: "ELEMENT", elementType: "DomainModels$AssociationBase", kind: "BY_NAME_REFERENCE" }, destinationEntity: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" } } }, za = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DomainModels$AssociationRef", "DomainModels$AttributeRef"], properties: { entityRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$IndirectEntityRef", kind: "PART" } } }, Fa = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$MemberRef"], allCompatibleTypes: ["DomainModels$AttributeRef"], properties: { attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" } } }, Ua = { type: "ELEMENT", abstract: !1, baseTypes: ["DomainModels$MemberRef"], allCompatibleTypes: ["DomainModels$AssociationRef"], properties: { association: { list: !1, type: "ELEMENT", elementType: "DomainModels$AssociationBase", kind: "BY_NAME_REFERENCE" } } }, Ya = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Texts$Text"], properties: { translations: { list: !0, type: "ELEMENT", elementType: "Texts$Translation", kind: "PART" } } }, Ha = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Texts$Translation"], properties: { languageCode: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, text: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, qa = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Texts$SystemText"], properties: { text: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, key: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Xa = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Texts$SystemTextCollection"], properties: { systemTexts: { list: !0, type: "ELEMENT", elementType: "Texts$SystemText", kind: "PART" } } }, Ka = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Url$StaticUrlSegment"] }, Ja = { type: "ELEMENT", abstract: !1, baseTypes: ["Url$UrlSegment"], allCompatibleTypes: ["Url$StaticUrlSegment"], properties: { segment: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Qa = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Enumerations$Enumeration"], properties: { values: { list: !0, type: "ELEMENT", elementType: "Enumerations$EnumerationValue", kind: "PART" }, remoteSource: { list: !1, type: "ELEMENT", elementType: "Enumerations$RemoteEnumerationSource", kind: "PART" }, name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Za = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Enumerations$EnumerationValue"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" }, remoteValue: { list: !1, type: "ELEMENT", elementType: "Enumerations$RemoteEnumerationValue", kind: "PART" } } }, el = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Enumerations$Condition"], properties: { attributeValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, editableVisible: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, tl = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: [] }, al = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: [] }, ll = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["DataTypes$BinaryType", "DataTypes$BooleanType", "DataTypes$DateTimeType", "DataTypes$DecimalType", "DataTypes$EmptyType", "DataTypes$EntityType", "DataTypes$EnumerationType", "DataTypes$FloatType", "DataTypes$IntegerType", "DataTypes$ListType", "DataTypes$ObjectType", "DataTypes$StringType", "DataTypes$UnknownType", "DataTypes$VoidType"] }, sl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$UnknownType"] }, il = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$VoidType"] }, rl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$EmptyType"] }, nl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$BooleanType"] }, ol = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$BinaryType"] }, cl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$DecimalType"] }, ul = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$IntegerType"] }, pl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$FloatType"] }, ml = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$DateTimeType"] }, yl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$StringType"] }, dl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$EnumerationType"], properties: { enumeration: { list: !1, type: "ELEMENT", elementType: "Enumerations$Enumeration", kind: "BY_NAME_REFERENCE" } } }, bl = { type: "ELEMENT", abstract: !0, baseTypes: ["DataTypes$DataType"], allCompatibleTypes: ["DataTypes$ListType", "DataTypes$ObjectType"], properties: { entity: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" } } }, Tl = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType", "DataTypes$EntityType"], allCompatibleTypes: ["DataTypes$ObjectType"] }, El = { type: "ELEMENT", abstract: !1, baseTypes: ["DataTypes$DataType", "DataTypes$EntityType"], allCompatibleTypes: ["DataTypes$ListType"] }, gl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["CustomWidgets$CustomWidget"], properties: { type: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$CustomWidgetType", kind: "PART" }, object: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetObject", kind: "PART" }, labelTemplate: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, conditionalEditabilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalEditabilitySettings", kind: "PART" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" } } }, fl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$CustomWidgetType"], properties: { widgetId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, needsEntityContext: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, pluginWidget: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, description: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, studioProCategory: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, studioCategory: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, offlineCapable: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, objectType: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetObjectType", kind: "PART" }, helpUrl: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Pl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetEnumerationValue"], properties: { key: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, caption: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Sl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetObject"], properties: { type: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetObjectType", kind: "BY_ID_REFERENCE" }, properties: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetProperty", kind: "PART" } } }, $l = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetObjectType"], properties: { propertyTypes: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetPropertyType", kind: "PART" } } }, _l = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetProperty"], properties: { type: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetPropertyType", kind: "BY_ID_REFERENCE" }, value: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetValue", kind: "PART" } } }, vl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetPropertyType"], properties: { key: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, category: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, caption: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, description: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, isDefault: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, valueType: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetValueType", kind: "PART" } } }, Il = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetReturnType"], properties: { type: { list: !1, type: "ENUMERATION", values: ["None", "Void", "Boolean", "Integer", "Float", "DateTime", "String", "Object", "Decimal"] }, isList: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, entityProperty: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, assignableTo: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Ml = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetTranslation"], properties: { languageCode: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, text: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Dl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetActionVariable"], properties: { key: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, type: { list: !1, type: "ENUMERATION", values: ["None", "Void", "Boolean", "Integer", "Float", "DateTime", "String", "Object", "Decimal"] }, caption: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Nl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetValue"], properties: { type: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetValueType", kind: "BY_ID_REFERENCE" }, primitiveValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, entityRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$EntityRef", kind: "PART" }, attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, page: { list: !1, type: "ELEMENT", elementType: "Pages$Page", kind: "BY_NAME_REFERENCE" }, microflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Microflow", kind: "BY_NAME_REFERENCE" }, nanoflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Nanoflow", kind: "BY_NAME_REFERENCE" }, icon: { list: !1, type: "ELEMENT", elementType: "Pages$Icon", kind: "PART" }, image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" }, translatableValue: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, textTemplate: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, objects: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetObject", kind: "PART" }, action: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, dataSource: { list: !1, type: "ELEMENT", elementType: "Pages$DataSource", kind: "PART" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" }, selection: { list: !1, type: "ENUMERATION", values: ["None", "Single", "Multi"] } } }, hl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["CustomWidgets$WidgetValueType"], properties: { type: { list: !1, type: "ENUMERATION", values: ["Action", "Attribute", "Association", "Boolean", "DataSource", "Entity", "EntityConstraint", "Enumeration", "Expression", "File", "Form", "Icon", "Image", "Integer", "Decimal", "Microflow", "Nanoflow", "Object", "String", "Selection", "TranslatableString", "TextTemplate", "System", "Widgets"] }, isList: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, isLinked: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, isMetaData: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, entityProperty: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, allowNonPersistableEntities: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, isPath: { list: !1, type: "ENUMERATION", values: ["No", "Optional", "Yes"] }, pathType: { list: !1, type: "ENUMERATION", values: ["None", "Reference", "ReferenceSet"] }, parameterIsList: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, multiline: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, defaultValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, required: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, onChangeProperty: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, dataSourceProperty: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, selectableObjectsProperty: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, attributeTypes: { list: !0, type: "ENUMERATION", values: ["AutoNumber", "Binary", "Boolean", "Currency", "DateTime", "Enum", "Float", "HashString", "Integer", "Long", "String", "Decimal"] }, associationTypes: { list: !0, type: "ENUMERATION", values: ["Reference", "ReferenceSet"] }, selectionTypes: { list: !0, type: "ENUMERATION", values: ["None", "Single", "Multi"] }, enumerationValues: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetEnumerationValue", kind: "PART" }, actionVariables: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetActionVariable", kind: "PART" }, objectType: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetObjectType", kind: "PART" }, returnType: { list: !1, type: "ELEMENT", elementType: "CustomWidgets$WidgetReturnType", kind: "PART" }, translations: { list: !0, type: "ELEMENT", elementType: "CustomWidgets$WidgetTranslation", kind: "PART" }, setLabel: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, defaultType: { list: !1, type: "ENUMERATION", values: ["None", "CallMicroflow", "CallNanoflow", "OpenPage", "Database", "Microflow", "Nanoflow", "Association"] } } }, Rl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$SortableEntityPathSource", "Pages$XPathSourceBase"], allCompatibleTypes: ["CustomWidgets$CustomWidgetXPathSource"] }, Al = { type: "MODEL_UNIT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$BuildingBlock", "Pages$Layout", "Pages$Page", "Pages$PageTemplate", "Pages$Snippet", "Pages$TemplateFormBase"], properties: { canvasWidth: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, canvasHeight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Cl = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Pages$FormBase"], allCompatibleTypes: ["Pages$Page"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" }, parameters: { list: !0, type: "ELEMENT", elementType: "Pages$PageParameter", kind: "PART" }, layoutCall: { list: !1, type: "ELEMENT", elementType: "Pages$LayoutCall", kind: "PART" }, title: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, allowedRoles: { list: !0, type: "ELEMENT", elementType: "Security$ModuleRole", kind: "BY_NAME_REFERENCE" }, popupCloseAction: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, popupWidth: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, popupHeight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, popupResizable: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, markAsUsed: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, url: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, variables: { list: !0, type: "ELEMENT", elementType: "Pages$LocalVariable", kind: "PART" } } }, Ol = { type: "ELEMENT", abstract: !1, baseTypes: ["Url$UrlSegment"], allCompatibleTypes: ["Pages$ParameterAttributeUrlSegment"], properties: { pageParameter: { list: !1, type: "ELEMENT", elementType: "Pages$PageParameter", kind: "LOCAL_BY_NAME_REFERENCE" }, attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" } } }, xl = { type: "ELEMENT", abstract: !1, baseTypes: ["Url$UrlSegment"], allCompatibleTypes: ["Pages$ParameterIdUrlSegment"], properties: { pageParameter: { list: !1, type: "ELEMENT", elementType: "Pages$PageParameter", kind: "LOCAL_BY_NAME_REFERENCE" } } }, Ll = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$PageParameter"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, parameterType: { list: !1, type: "ELEMENT", elementType: "DataTypes$DataType", kind: "PART" } } }, wl = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Pages$FormBase"], allCompatibleTypes: ["Pages$Layout"], properties: { parameters: { list: !0, type: "ELEMENT", elementType: "Pages$LayoutParameter", kind: "PART" }, content: { list: !1, type: "ELEMENT", elementType: "Pages$LayoutContent", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" } } }, kl = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$NativeLayoutContent", "Pages$WebLayoutContent"] }, jl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$LayoutContent"], allCompatibleTypes: ["Pages$WebLayoutContent"], properties: { layoutType: { list: !1, type: "ENUMERATION", values: ["Responsive", "Tablet", "Phone", "ModalPopup", "Popup", "Legacy"] }, layoutCall: { list: !1, type: "ELEMENT", elementType: "Pages$LayoutCall", kind: "PART" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, Bl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$LayoutContent"], allCompatibleTypes: ["Pages$NativeLayoutContent"], properties: { layoutType: { list: !1, type: "ENUMERATION", values: ["Default", "TopLevel", "Popup"] }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, rightHeaderPlaceholder: { list: !1, type: "ELEMENT", elementType: "Pages$Placeholder", kind: "PART" }, showBottomBar: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, sidebar: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, sidebarWidgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, Vl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LayoutCall"], properties: { layout: { list: !1, type: "ELEMENT", elementType: "Pages$Layout", kind: "BY_NAME_REFERENCE" }, arguments: { list: !0, type: "ELEMENT", elementType: "Pages$LayoutCallArgument", kind: "PART" } } }, Wl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LayoutCallArgument"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "Pages$LayoutParameter", kind: "BY_NAME_REFERENCE" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, Gl = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LayoutParameter"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, zl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$Placeholder"] }, Fl = { type: "MODEL_UNIT", abstract: !0, baseTypes: ["Pages$FormBase"], allCompatibleTypes: ["Pages$BuildingBlock", "Pages$PageTemplate"], properties: { displayName: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentationUrl: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, templateCategory: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, templateCategoryWeight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, imageData: { list: !1, type: "PRIMITIVE", primitiveType: "BLOB" } } }, Ul = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Pages$FormBase", "Pages$TemplateFormBase"], allCompatibleTypes: ["Pages$BuildingBlock"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, platform: { list: !1, type: "ENUMERATION", values: ["Web", "Native"] } } }, Yl = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$EditPageTemplateType", "Pages$RegularPageTemplateType", "Pages$SelectPageTemplateType", "Pages$UserTaskTemplateType", "Pages$WorkflowOverviewTemplateType", "Pages$WorkflowTemplateType"] }, Hl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$TemplateType"], allCompatibleTypes: ["Pages$RegularPageTemplateType"] }, ql = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$TemplateType"], allCompatibleTypes: ["Pages$EditPageTemplateType"] }, Xl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$TemplateType"], allCompatibleTypes: ["Pages$SelectPageTemplateType"] }, Kl = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Pages$FormBase", "Pages$TemplateFormBase"], allCompatibleTypes: ["Pages$PageTemplate"], properties: { layoutCall: { list: !1, type: "ELEMENT", elementType: "Pages$LayoutCall", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, templateType: { list: !1, type: "ELEMENT", elementType: "Pages$TemplateType", kind: "PART" } } }, Jl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$TemplatePlaceholder"], properties: { type: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Ql = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$CallNanoflowClientAction", "Pages$CallWorkflowClientAction", "Pages$CancelChangesClientAction", "Pages$ClosePageClientAction", "Pages$CreateObjectClientAction", "Pages$DeleteClientAction", "Pages$MicroflowClientAction", "Pages$NoClientAction", "Pages$OpenLinkClientAction", "Pages$OpenUserTaskClientAction", "Pages$OpenWorkflowClientAction", "Pages$PageClientAction", "Pages$SaveChangesClientAction", "Pages$SetTaskOutcomeClientAction", "Pages$SignOutClientAction", "Pages$SyncClientAction"], properties: { disabledDuringExecution: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Zl = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$NoClientAction"] }, es = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$PageClientAction"], properties: { pageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" }, pagesForSpecializations: { list: !0, type: "ELEMENT", elementType: "Pages$PageForSpecialization", kind: "PART" }, numberOfPagesToClose2: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, ts = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$MicroflowClientAction"], properties: { microflowSettings: { list: !1, type: "ELEMENT", elementType: "Pages$MicroflowSettings", kind: "PART" } } }, as = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$CallNanoflowClientAction"], properties: { nanoflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Nanoflow", kind: "BY_NAME_REFERENCE" }, parameterMappings: { list: !0, type: "ELEMENT", elementType: "Pages$NanoflowParameterMapping", kind: "PART" }, progressBar: { list: !1, type: "ENUMERATION", values: ["None", "NonBlocking", "Blocking"] }, progressMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, confirmationInfo: { list: !1, type: "ELEMENT", elementType: "Pages$ConfirmationInfo", kind: "PART" } } }, ls = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$SignOutClientAction"] }, ss = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$SaveChangesClientAction"], properties: { syncAutomatically: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, closePage: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, is = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$CancelChangesClientAction"], properties: { closePage: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, rs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$ClosePageClientAction"], properties: { numberOfPagesToClose: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, ns = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$SyncClientAction"] }, os = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$OpenLinkClientAction"], properties: { linkType: { list: !1, type: "ENUMERATION", values: ["Web", "Email", "Call", "Text"] }, address: { list: !1, type: "ELEMENT", elementType: "Pages$StaticOrDynamicString", kind: "PART" } } }, cs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$DeleteClientAction"], properties: { closePage: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, us = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$CreateObjectClientAction"], properties: { entityRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$EntityRef", kind: "PART" }, pageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" }, numberOfPagesToClose2: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, ps = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$PageSettings"], properties: { page: { list: !1, type: "ELEMENT", elementType: "Pages$Page", kind: "BY_NAME_REFERENCE" }, parameterMappings: { list: !0, type: "ELEMENT", elementType: "Pages$PageParameterMapping", kind: "PART" } } }, ms = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$PageParameterMapping"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "Pages$PageParameter", kind: "BY_NAME_REFERENCE" }, variable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" }, argument: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, ys = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$MicroflowSettings"], properties: { microflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Microflow", kind: "BY_NAME_REFERENCE" }, parameterMappings: { list: !0, type: "ELEMENT", elementType: "Pages$MicroflowParameterMapping", kind: "PART" }, progressBar: { list: !1, type: "ENUMERATION", values: ["None", "NonBlocking", "Blocking"] }, progressMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, asynchronous: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, formValidations: { list: !1, type: "ENUMERATION", values: ["None", "Widget", "All"] }, confirmationInfo: { list: !1, type: "ELEMENT", elementType: "Pages$ConfirmationInfo", kind: "PART" } } }, ds = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$MicroflowParameterMapping"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "Microflows$MicroflowParameter", kind: "BY_NAME_REFERENCE" }, expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, variable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, bs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$NanoflowParameterMapping"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "Microflows$NanoflowParameter", kind: "BY_NAME_REFERENCE" }, expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, variable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, Ts = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ConfirmationInfo"], properties: { question: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, proceedButtonCaption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, cancelButtonCaption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, Es = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$PageVariable"], properties: { widget: { list: !1, type: "ELEMENT", elementType: "Pages$Widget", kind: "LOCAL_BY_NAME_REFERENCE" }, pageParameter: { list: !1, type: "ELEMENT", elementType: "Pages$PageParameter", kind: "LOCAL_BY_NAME_REFERENCE" }, snippetParameter: { list: !1, type: "ELEMENT", elementType: "Pages$SnippetParameter", kind: "LOCAL_BY_NAME_REFERENCE" }, localVariable: { list: !1, type: "ELEMENT", elementType: "Pages$LocalVariable", kind: "LOCAL_BY_NAME_REFERENCE" }, useAllPages: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, subKey: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, gs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LocalVariable"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, variableType: { list: !1, type: "ELEMENT", elementType: "DataTypes$DataType", kind: "PART" }, defaultValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, fs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$Appearance"], properties: { class: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, style: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, designProperties: { list: !0, type: "ELEMENT", elementType: "Pages$DesignPropertyValue", kind: "PART" }, dynamicClasses: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Ps = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$DesignPropertyValue"], properties: { key: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, value: { list: !1, type: "ELEMENT", elementType: "Pages$AbstractDesignPropertyValue", kind: "PART" } } }, Ss = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$CompoundDesignPropertyValue", "Pages$CustomDesignPropertyValue", "Pages$OptionDesignPropertyValue", "Pages$ToggleDesignPropertyValue"] }, $s = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AbstractDesignPropertyValue"], allCompatibleTypes: ["Pages$OptionDesignPropertyValue"], properties: { option: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, _s = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AbstractDesignPropertyValue"], allCompatibleTypes: ["Pages$ToggleDesignPropertyValue"] }, vs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AbstractDesignPropertyValue"], allCompatibleTypes: ["Pages$CustomDesignPropertyValue"], properties: { value: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Is = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AbstractDesignPropertyValue"], allCompatibleTypes: ["Pages$CompoundDesignPropertyValue"], properties: { properties: { list: !0, type: "ELEMENT", elementType: "Pages$DesignPropertyValue", kind: "PART" } } }, Ms = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$ActionButton", "Pages$AssociationWidget", "Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$Button", "Pages$CheckBox", "Pages$ColumnGrid", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$DataGrid", "Pages$DataView", "Pages$DatePicker", "Pages$DivContainer", "Pages$DropDown", "Pages$DropDownButton", "Pages$DynamicImageViewer", "Pages$DynamicText", "Pages$EntityWidget", "Pages$FileManager", "Pages$Grid", "Pages$GroupBox", "Pages$Header", "Pages$ImageUploader", "Pages$InputReferenceSetSelector", "Pages$InputWidget", "Pages$Label", "Pages$LayoutGrid", "Pages$ListView", "Pages$ListenTargetWidget", "Pages$LoginButton", "Pages$LoginIdTextBox", "Pages$LoginTextBox", "Pages$MemberWidget", "Pages$MenuBar", "Pages$MenuWidget", "Pages$NavigationList", "Pages$NavigationTree", "Pages$PasswordTextBox", "Pages$Placeholder", "Pages$RadioButtonGroup", "Pages$ReferenceSelector", "Pages$ReferenceSetSelector", "Pages$ScrollContainer", "Pages$SidebarToggleButton", "Pages$SimpleMenuBar", "Pages$SnippetCallWidget", "Pages$StaticImageViewer", "Pages$TabContainer", "Pages$Table", "Pages$TemplateGrid", "Pages$TemplatePlaceholder", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget", "Pages$Title", "Pages$ValidationMessage"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, tabIndex: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, Ds = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$Label"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, Ns = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$StaticImageViewer"], properties: { image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" }, widthUnit: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, heightUnit: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, height: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, clickAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, responsive: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, alternativeText: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, hs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DivContainer"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, renderMode: { list: !1, type: "ENUMERATION", values: ["Div", "Section", "Article", "Header", "Footer", "Main", "Nav", "Aside", "Hgroup", "Address"] }, onClickAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, screenReaderHidden: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Rs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$TextWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$TextBox"], properties: { inputMask: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, formattingInfo: { list: !1, type: "ELEMENT", elementType: "Pages$FormattingInfo", kind: "PART" }, isPasswordBox: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, keyboardType: { list: !1, type: "ENUMERATION", values: ["NumberPad", "DecimalPad", "EmailAddress", "PhonePad", "URL", "Default"] }, onEnterKeyPressAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, autocomplete: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, autocompletePurpose: { list: !1, type: "ENUMERATION", values: ["On", "Off", "FullName", "HonorificPrefix", "GivenName", "AdditionalName", "FamilyName", "HonorificSuffix", "Nickname", "JobTitle", "Username", "NewPassword", "CurrentPassword", "CompanyName", "StreetAddress", "StreetAddressLine1", "StreetAddressLine2", "StreetAddressLine3", "AddressLevel4", "AddressLevel3", "AddressLevel2", "AddressLevel1", "CountryCode", "CountryName", "PostalCode", "CreditCardFullName", "CreditCardGivenName", "CreditCardAdditionalName", "CreditCardFamilyName", "CreditCardNumber", "CreditCardExpiration", "CreditCardExpirationMonth", "CreditCardExpirationYear", "CreditCardSecurityCode", "CreditCardType", "TransactionCurrency", "TransactionAmount", "Language", "Birthday", "DayOfBirth", "MonthOfBirth", "YearOfBirth", "Sex", "Url", "Photo", "TelephoneNumber", "TelephoneCountryCode", "TelephoneWithoutCountryCode", "TelephoneAreaCode", "TelephoneLocal", "TelephoneLocalPrefix", "TelephoneLocalSuffix", "TelephoneExtension", "Email", "InstantMessageProtocol"] }, submitBehaviour: { list: !1, type: "ENUMERATION", values: ["OnEndEditing", "WhileEditing"] }, submitOnInputDelay: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, As = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$TextWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$TextArea"], properties: { numberOfLines: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, counterMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, textTooLongMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, autocomplete: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, submitBehaviour: { list: !1, type: "ENUMERATION", values: ["OnEndEditing", "WhileEditing"] }, submitOnInputDelay: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Cs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$CheckBox"], properties: { labelPosition: { list: !1, type: "ENUMERATION", values: ["Default", "BeforeControl", "AfterControl"] }, nativeRenderMode: { list: !1, type: "ENUMERATION", values: ["CheckBox", "Switch"] }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Os = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$RadioButtonGroup"], properties: { renderHorizontal: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, xs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DatePicker"], properties: { formattingInfo: { list: !1, type: "ELEMENT", elementType: "Pages$FormattingInfo", kind: "PART" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Ls = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$LoginIdTextBox", "Pages$PasswordTextBox"], properties: { label: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, labelWidth: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, placeholder: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, ws = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$LoginTextBox", "Pages$Widget"], allCompatibleTypes: ["Pages$LoginIdTextBox"] }, ks = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$LoginTextBox", "Pages$Widget"], allCompatibleTypes: ["Pages$PasswordTextBox"] }, js = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Button", "Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$LoginButton"], properties: { validationMessageWidget: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Bs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$ValidationMessage"] }, Vs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$FormattingInfo"], properties: { decimalPrecision: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, groupDigits: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, enumFormat: { list: !1, type: "ENUMERATION", values: ["Text", "Image"] }, dateFormat: { list: !1, type: "ENUMERATION", values: ["Date", "Time", "DateTime", "Custom"] }, customDateFormat: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Ws = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$TextArea", "Pages$TextBox"], properties: { maxLengthCode: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, autoFocus: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Gs = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$AttributeWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DatePicker", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget"], properties: { placeholderTemplate: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" } } }, zs = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$AttributeWidgetWithPlaceholder", "Pages$CheckBox", "Pages$DatePicker", "Pages$DropDown", "Pages$RadioButtonGroup", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget"], properties: { validation: { list: !1, type: "ELEMENT", elementType: "Pages$WidgetValidation", kind: "PART" }, onChangeAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, onEnterAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, onLeaveAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" }, ariaRequired: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Fs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$WidgetValidation"], properties: { expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, message: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, Us = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$AssociationWidget", "Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$CheckBox", "Pages$DatePicker", "Pages$DropDown", "Pages$InputReferenceSetSelector", "Pages$RadioButtonGroup", "Pages$ReferenceSelector", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget"], properties: { attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, readOnlyStyle: { list: !1, type: "ENUMERATION", values: ["Inherit", "Control", "Text"] } } }, Ys = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$AssociationWidget", "Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$CheckBox", "Pages$DatePicker", "Pages$DropDown", "Pages$FileManager", "Pages$ImageUploader", "Pages$InputReferenceSetSelector", "Pages$MemberWidget", "Pages$RadioButtonGroup", "Pages$ReferenceSelector", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget"], properties: { labelTemplate: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, screenReaderLabel: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" } } }, Hs = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$AssociationWidget", "Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$CheckBox", "Pages$DatePicker", "Pages$DropDown", "Pages$FileManager", "Pages$ImageUploader", "Pages$InputReferenceSetSelector", "Pages$InputWidget", "Pages$MemberWidget", "Pages$RadioButtonGroup", "Pages$ReferenceSelector", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget"], properties: { conditionalEditabilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalEditabilitySettings", kind: "PART" }, editable: { list: !1, type: "ENUMERATION", values: ["Always", "Never", "Conditional"] } } }, qs = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$ActionButton", "Pages$AssociationWidget", "Pages$AttributeWidget", "Pages$AttributeWidgetWithPlaceholder", "Pages$Button", "Pages$CheckBox", "Pages$ColumnGrid", "Pages$ConditionallyEditableWidget", "Pages$DataGrid", "Pages$DataView", "Pages$DatePicker", "Pages$DivContainer", "Pages$DropDown", "Pages$DropDownButton", "Pages$DynamicImageViewer", "Pages$DynamicText", "Pages$EntityWidget", "Pages$FileManager", "Pages$Grid", "Pages$GroupBox", "Pages$ImageUploader", "Pages$InputReferenceSetSelector", "Pages$InputWidget", "Pages$Label", "Pages$LayoutGrid", "Pages$ListView", "Pages$ListenTargetWidget", "Pages$LoginButton", "Pages$MemberWidget", "Pages$NavigationList", "Pages$RadioButtonGroup", "Pages$ReferenceSelector", "Pages$ReferenceSetSelector", "Pages$SidebarToggleButton", "Pages$StaticImageViewer", "Pages$TabContainer", "Pages$Table", "Pages$TemplateGrid", "Pages$TextArea", "Pages$TextBox", "Pages$TextWidget", "Pages$Title"], properties: { conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" } } }, Xs = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$ConditionalEditabilitySettings", "Pages$ConditionalVisibilitySettings"], properties: { attribute: { list: !1, type: "ELEMENT", elementType: "DomainModels$Attribute", kind: "BY_NAME_REFERENCE" }, conditions: { list: !0, type: "ELEMENT", elementType: "Enumerations$Condition", kind: "PART" }, expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, Ks = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionalSettings"], allCompatibleTypes: ["Pages$ConditionalVisibilitySettings"], properties: { moduleRoles: { list: !0, type: "ELEMENT", elementType: "Security$ModuleRole", kind: "BY_NAME_REFERENCE" }, ignoreSecurity: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Js = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionalSettings"], allCompatibleTypes: ["Pages$ConditionalEditabilitySettings"] }, Qs = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$AccessibilitySettings"], properties: { screenReaderDescription: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, screenReaderTitle: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" } } }, Zs = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$Table"], properties: { cells: { list: !0, type: "ELEMENT", elementType: "Pages$TableCell", kind: "PART" }, columns: { list: !0, type: "ELEMENT", elementType: "Pages$TableColumn", kind: "PART" }, widthUnit: { list: !1, type: "ENUMERATION", values: ["Weight", "Pixels"] }, rows: { list: !0, type: "ELEMENT", elementType: "Pages$TableRow", kind: "PART" } } }, ei = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$TableCell"], properties: { appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, isHeader: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, leftColumnIndex: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, topRowIndex: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, height: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, ti = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$TableColumn"], properties: { width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, ai = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$TableRow"], properties: { appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" } } }, li = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ColumnGrid", "Pages$DataGrid", "Pages$DataView", "Pages$DynamicImageViewer", "Pages$Grid", "Pages$ListView", "Pages$ListenTargetWidget", "Pages$ReferenceSetSelector", "Pages$TemplateGrid"], properties: { dataSource: { list: !1, type: "ELEMENT", elementType: "Pages$DataSource", kind: "PART" } } }, si = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$AssociationSource", "Pages$DataViewSource", "Pages$EntityPathSource", "Pages$GridBaseSource", "Pages$GridXPathSource", "Pages$ImageViewerSource", "Pages$ListViewXPathSource", "Pages$ListenTargetSource", "Pages$MicroflowSource", "Pages$NanoflowSource", "Pages$ReferenceSetSource", "Pages$SortableEntityPathSource", "Pages$XPathSourceBase"], properties: { forceFullObjects: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, ii = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$DataSource"], allCompatibleTypes: ["Pages$AssociationSource", "Pages$DataViewSource", "Pages$GridBaseSource", "Pages$GridXPathSource", "Pages$ImageViewerSource", "Pages$ListViewXPathSource", "Pages$ReferenceSetSource", "Pages$SortableEntityPathSource", "Pages$XPathSourceBase"], properties: { entityRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$EntityRef", kind: "PART" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, ri = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource"], allCompatibleTypes: ["Pages$MicroflowSource"], properties: { microflowSettings: { list: !1, type: "ELEMENT", elementType: "Pages$MicroflowSettings", kind: "PART" } } }, ni = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource"], allCompatibleTypes: ["Pages$NanoflowSource"], properties: { nanoflow: { list: !1, type: "ELEMENT", elementType: "Microflows$Nanoflow", kind: "BY_NAME_REFERENCE" }, parameterMappings: { list: !0, type: "ELEMENT", elementType: "Pages$NanoflowParameterMapping", kind: "PART" } } }, oi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ColumnGrid", "Pages$DataGrid", "Pages$Grid", "Pages$ListView", "Pages$ReferenceSetSelector", "Pages$TemplateGrid"] }, ci = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource"], allCompatibleTypes: ["Pages$AssociationSource"] }, ui = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DataView"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, footerWidgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, editability: { list: !1, type: "ENUMERATION", values: ["Always", "Never", "Conditional"] }, conditionalEditabilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalEditabilitySettings", kind: "PART" }, showFooter: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, noEntityMessage: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, labelWidth: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, readOnlyStyle: { list: !1, type: "ENUMERATION", values: ["Control", "Text"] } } }, pi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource"], allCompatibleTypes: ["Pages$DataViewSource"] }, mi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource"], allCompatibleTypes: ["Pages$ListenTargetSource"], properties: { listenTarget: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, yi = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$GridControlBar", "Pages$SearchBar"], properties: { items: { list: !0, type: "ELEMENT", elementType: "Pages$ControlBarItem", kind: "PART" } } }, di = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$ComparisonSearchField", "Pages$ControlBarButton", "Pages$DataGridAddButton", "Pages$DataGridExportToCSVButton", "Pages$DataGridExportToExcelButton", "Pages$DataGridRemoveButton", "Pages$DropDownSearchField", "Pages$GridActionButton", "Pages$GridControlBarButton", "Pages$GridDeselectAllButton", "Pages$GridNewButton", "Pages$GridSearchButton", "Pages$GridSelectAllButton", "Pages$RangeSearchField", "Pages$SearchField", "Pages$SelectButton", "Pages$SingleSearchField"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, bi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ControlBarItem"], allCompatibleTypes: ["Pages$DataGridAddButton", "Pages$DataGridExportToCSVButton", "Pages$DataGridExportToExcelButton", "Pages$DataGridRemoveButton", "Pages$GridActionButton", "Pages$GridControlBarButton", "Pages$GridDeselectAllButton", "Pages$GridNewButton", "Pages$GridSearchButton", "Pages$GridSelectAllButton", "Pages$SelectButton"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, tooltip: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, icon: { list: !1, type: "ELEMENT", elementType: "Pages$Icon", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" }, buttonStyle: { list: !1, type: "ENUMERATION", values: ["Default", "Inverse", "Primary", "Info", "Success", "Warning", "Danger"] } } }, Ti = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ListView"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, pageSize: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, clickAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, editable: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, templates: { list: !0, type: "ELEMENT", elementType: "Pages$ListViewTemplate", kind: "PART" }, scrollDirection: { list: !1, type: "ENUMERATION", values: ["Vertical", "Horizontal"] }, numberOfColumns: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, pullDownAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" } } }, Ei = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ListViewTemplate"], properties: { specialization: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, gi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource"], allCompatibleTypes: ["Pages$GridBaseSource", "Pages$GridXPathSource", "Pages$ListViewXPathSource", "Pages$ReferenceSetSource", "Pages$XPathSourceBase"], properties: { sortBar: { list: !1, type: "ELEMENT", elementType: "Pages$GridSortBar", kind: "PART" } } }, fi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$SortableEntityPathSource"], allCompatibleTypes: ["Pages$ListViewXPathSource"], properties: { xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Pi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$SortableEntityPathSource", "Pages$XPathSourceBase"], allCompatibleTypes: ["Pages$ListViewXPathSource"], properties: { search: { list: !1, type: "ELEMENT", elementType: "Pages$ListViewSearch", kind: "PART" } } }, Si = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$GridSortBar"], properties: { sortItems: { list: !0, type: "ELEMENT", elementType: "Pages$GridSortItem", kind: "PART" } } }, $i = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$GridSortItem"], properties: { attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, sortDirection: { list: !1, type: "ENUMERATION", values: ["Ascending", "Descending"] } } }, _i = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ActionButton", "Pages$DropDownButton", "Pages$LoginButton", "Pages$SidebarToggleButton"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, tooltip: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, icon: { list: !1, type: "ELEMENT", elementType: "Pages$Icon", kind: "PART" }, renderType: { list: !1, type: "ENUMERATION", values: ["Button", "Link"] }, buttonStyle: { list: !1, type: "ENUMERATION", values: ["Default", "Inverse", "Primary", "Info", "Success", "Warning", "Danger"] } } }, vi = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$StaticOrDynamicString"], properties: { isDynamic: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, value: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" } } }, Ii = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Button", "Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ActionButton"], properties: { action: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, ariaRole: { list: !1, type: "ENUMERATION", values: ["Button", "Link", "Checkbox", "Radio", "Tab", "MenuItem", "MenuItemCheckbox", "MenuItemRadio", "Option", "Switch", "TreeItem"] }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Mi = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ClientTemplate"], properties: { template: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, parameters: { list: !0, type: "ELEMENT", elementType: "Pages$ClientTemplateParameter", kind: "PART" }, fallback: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" } } }, Di = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ClientTemplateParameter"], properties: { attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, expression: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, formattingInfo: { list: !1, type: "ELEMENT", elementType: "Pages$FormattingInfo", kind: "PART" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, Ni = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Grid", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DataGrid", "Pages$ReferenceSetSelector"], properties: { columns: { list: !0, type: "ELEMENT", elementType: "Pages$GridColumn", kind: "PART" }, numberOfRows: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, showEmptyRows: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, widthUnit: { list: !1, type: "ENUMERATION", values: ["Weight", "Pixels"] }, tooltipPage: { list: !1, type: "ELEMENT", elementType: "Pages$Page", kind: "BY_NAME_REFERENCE" } } }, hi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarItem", "Pages$SearchField", "Pages$SingleSearchField"], allCompatibleTypes: ["Pages$ComparisonSearchField"] }, Ri = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$GridBaseSource", "Pages$SortableEntityPathSource"], allCompatibleTypes: ["Pages$GridXPathSource"], properties: { xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Ai = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ColumnGrid", "Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Grid", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DataGrid"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" } } }, Ci = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$DataGridAddButton"], properties: { pageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" } } }, Oi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$DataGridExportToCSVButton"], properties: { maxNumberOfRows: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, decimalSeparator: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, groupSeparator: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, delimiter: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, generateExcelHint: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, useGridDateFormat: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, xi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$DataGridExportToExcelButton"], properties: { maxNumberOfRows: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, useExcelDateType: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Li = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$DataGridRemoveButton"] }, wi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AttributeWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DropDown"], properties: { emptyOptionCaption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, ki = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Button", "Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DropDownButton"], properties: { items: { list: !0, type: "ELEMENT", elementType: "Pages$DropDownButtonItem", kind: "PART" } } }, ji = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$DropDownButtonItem", "Pages$NavigationListItem"], properties: { action: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" } } }, Bi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ActionItem"], allCompatibleTypes: ["Pages$DropDownButtonItem"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" } } }, Vi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarItem", "Pages$SearchField", "Pages$SingleSearchField"], allCompatibleTypes: ["Pages$DropDownSearchField"], properties: { sortBar: { list: !1, type: "ELEMENT", elementType: "Pages$GridSortBar", kind: "PART" }, xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, allowMultipleSelect: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Wi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DynamicImageViewer"], properties: { defaultImage: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" }, widthUnit: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, heightUnit: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, height: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, responsive: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, showAsThumbnail: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, clickAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, onClickEnlarge: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, alternativeText: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, Gi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$DynamicText"], properties: { content: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, renderMode: { list: !1, type: "ENUMERATION", values: ["Text", "Paragraph", "H1", "H2", "H3", "H4", "H5", "H6"] }, nativeTextStyle: { list: !1, type: "ENUMERATION", values: ["Text", "Heading1", "Heading2", "Heading3", "Heading4", "Heading5", "Heading6"] }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, zi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$FileManager"], properties: { allowedExtensions: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, type: { list: !1, type: "ENUMERATION", values: ["Upload", "Download", "Both"] }, maxFileSize: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, showFileInBrowser: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Fi = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$PageForSpecialization"], properties: { entity: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" }, pageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" } } }, Ui = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Icon"], allCompatibleTypes: ["Pages$GlyphIcon"], properties: { code: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, Yi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ColumnGrid", "Pages$DataGrid", "Pages$ReferenceSetSelector", "Pages$TemplateGrid"], properties: { isControlBarVisible: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, showPagingBar: { list: !1, type: "ENUMERATION", values: ["YesWithTotalCount", "YesWithoutTotalCount", "No"] }, selectionMode: { list: !1, type: "ENUMERATION", values: ["None", "Single", "SingleAndMaintain", "Multi", "SimpleMulti"] }, selectFirst: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, defaultButtonTrigger: { list: !1, type: "ENUMERATION", values: ["Single", "Double"] }, refreshTime: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, controlBar: { list: !1, type: "ELEMENT", elementType: "Pages$GridControlBar", kind: "PART" } } }, Hi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$GridActionButton"], properties: { action: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, maintainSelectionAfterMicroflow: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, qi = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$SortableEntityPathSource"], allCompatibleTypes: ["Pages$GridXPathSource", "Pages$ReferenceSetSource"], properties: { searchBar: { list: !1, type: "ELEMENT", elementType: "Pages$SearchBar", kind: "PART" } } }, Xi = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$GridColumn"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, formattingInfo: { list: !1, type: "ELEMENT", elementType: "Pages$FormattingInfo", kind: "PART" }, showTooltip: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, aggregateCaption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, aggregateFunction: { list: !1, type: "ENUMERATION", values: ["None", "Average", "Maximum", "Minimum", "Sum", "Count"] }, editable: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" } } }, Ki = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBar"], allCompatibleTypes: ["Pages$GridControlBar"], properties: { defaultButton: { list: !1, type: "ELEMENT", elementType: "Pages$ControlBarItem", kind: "BY_ID_REFERENCE" } } }, Ji = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem"], allCompatibleTypes: ["Pages$DataGridAddButton", "Pages$DataGridExportToCSVButton", "Pages$DataGridExportToExcelButton", "Pages$DataGridRemoveButton", "Pages$GridActionButton", "Pages$GridDeselectAllButton", "Pages$GridNewButton", "Pages$GridSearchButton", "Pages$GridSelectAllButton", "Pages$SelectButton"] }, Qi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$GridDeselectAllButton"] }, Zi = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$GridNewButton"], properties: { entity: { list: !1, type: "ELEMENT", elementType: "DomainModels$Entity", kind: "BY_NAME_REFERENCE" }, editLocation: { list: !1, type: "ENUMERATION", values: ["InlineAtTop", "InlineAtBottom", "Form"] }, pageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" } } }, er = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$GridSearchButton"] }, tr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$GridSelectAllButton"], properties: { selectionType: { list: !1, type: "ENUMERATION", values: ["SelectPage", "SelectAll"] } } }, ar = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$GroupBox"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" }, collapsible: { list: !1, type: "ENUMERATION", values: ["No", "YesInitiallyExpanded", "YesInitiallyCollapsed"] }, headerMode: { list: !1, type: "ENUMERATION", values: ["Div", "H1", "H2", "H3", "H4", "H5", "H6"] }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, lr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$Header"], properties: { leftWidgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, rightWidgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, sr = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$GlyphIcon", "Pages$IconCollectionIcon", "Pages$ImageIcon"] }, ir = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Icon"], allCompatibleTypes: ["Pages$ImageIcon"], properties: { image: { list: !1, type: "ELEMENT", elementType: "Images$Image", kind: "BY_NAME_REFERENCE" } } }, rr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Icon"], allCompatibleTypes: ["Pages$IconCollectionIcon"], properties: { image: { list: !1, type: "ELEMENT", elementType: "CustomIcons$CustomIcon", kind: "BY_NAME_REFERENCE" } } }, nr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ImageUploader"], properties: { allowedExtensions: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, thumbnailSize: { list: !1, type: "PRIMITIVE", primitiveType: "SIZE" }, maxFileSize: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, or = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource"], allCompatibleTypes: ["Pages$ImageViewerSource"] }, cr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AssociationWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$InputReferenceSetSelector"] }, ur = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$LayoutGrid"], properties: { width: { list: !1, type: "ENUMERATION", values: ["FullWidth", "FixedWidth"] }, rows: { list: !0, type: "ELEMENT", elementType: "Pages$LayoutGridRow", kind: "PART" } } }, pr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LayoutGridColumn"], properties: { weight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, tabletWeight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, phoneWeight: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, previewWidth: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, verticalAlignment: { list: !1, type: "ENUMERATION", values: ["None", "Start", "Center", "End"] } } }, mr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$LayoutGridRow"], properties: { columns: { list: !0, type: "ELEMENT", elementType: "Pages$LayoutGridColumn", kind: "PART" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, verticalAlignment: { list: !1, type: "ENUMERATION", values: ["None", "Start", "Center", "End"] }, horizontalAlignment: { list: !1, type: "ENUMERATION", values: ["None", "Start", "Center", "End"] }, spacingBetweenColumns: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, yr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$MenuWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$MenuBar"] }, dr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$MenuSource"], allCompatibleTypes: ["Pages$MenuDocumentSource"], properties: { menu: { list: !1, type: "ELEMENT", elementType: "Menus$MenuDocument", kind: "BY_NAME_REFERENCE" } } }, br = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$MenuDocumentSource", "Pages$NavigationSource"] }, Tr = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$MenuBar", "Pages$NavigationTree", "Pages$SimpleMenuBar"], properties: { menuSource: { list: !1, type: "ELEMENT", elementType: "Pages$MenuSource", kind: "PART" } } }, Er = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$NavigationList"], properties: { items: { list: !0, type: "ELEMENT", elementType: "Pages$NavigationListItem", kind: "PART" } } }, gr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ActionItem"], allCompatibleTypes: ["Pages$NavigationListItem"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" } } }, fr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$MenuSource"], allCompatibleTypes: ["Pages$NavigationSource"], properties: { navigationProfile: { list: !1, type: "ELEMENT", elementType: "Navigation$NavigationProfile", kind: "BY_NAME_REFERENCE" } } }, Pr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$MenuWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$NavigationTree"] }, Sr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarItem", "Pages$SearchField"], allCompatibleTypes: ["Pages$RangeSearchField"], properties: { lowerBoundRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, upperBoundRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, includeLower: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, includeUpper: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, $r = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$AssociationWidget", "Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ReferenceSelector"], properties: { validation: { list: !1, type: "ELEMENT", elementType: "Pages$WidgetValidation", kind: "PART" }, renderMode: { list: !1, type: "ENUMERATION", values: ["Form", "DropDown"] }, gotoPageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" }, formattingInfo: { list: !1, type: "ELEMENT", elementType: "Pages$FormattingInfo", kind: "PART" }, emptyOptionCaption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, _r = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ColumnGrid", "Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Grid", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$ReferenceSetSelector"], properties: { onChangeAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, constrainedByRefs: { list: !0, type: "ELEMENT", elementType: "DomainModels$EntityRef", kind: "PART" }, xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, vr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$DataSource", "Pages$EntityPathSource", "Pages$GridBaseSource", "Pages$SortableEntityPathSource"], allCompatibleTypes: ["Pages$ReferenceSetSource"] }, Ir = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$ScrollContainer"], properties: { center: { list: !1, type: "ELEMENT", elementType: "Pages$ScrollContainerRegion", kind: "PART" }, left: { list: !1, type: "ELEMENT", elementType: "Pages$ScrollContainerRegion", kind: "PART" }, right: { list: !1, type: "ELEMENT", elementType: "Pages$ScrollContainerRegion", kind: "PART" }, top: { list: !1, type: "ELEMENT", elementType: "Pages$ScrollContainerRegion", kind: "PART" }, bottom: { list: !1, type: "ELEMENT", elementType: "Pages$ScrollContainerRegion", kind: "PART" }, layoutMode: { list: !1, type: "ENUMERATION", values: ["Headline", "Sidebar"] }, widthMode: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, width: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, alignment: { list: !1, type: "ENUMERATION", values: ["Left", "Center", "Right"] }, scrollBehavior: { list: !1, type: "ENUMERATION", values: ["PerRegion", "FullWidget"] }, nativeHideScrollbars: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Mr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ScrollContainerRegion"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, sizeMode: { list: !1, type: "ENUMERATION", values: ["Auto", "Pixels", "Percentage"] }, size: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, appearance: { list: !1, type: "ELEMENT", elementType: "Pages$Appearance", kind: "PART" }, toggleMode: { list: !1, type: "ENUMERATION", values: ["None", "PushContentAside", "SlideOverContent", "ShrinkContentInitiallyOpen", "ShrinkContentInitiallyClosed"] } } }, Dr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBar"], allCompatibleTypes: ["Pages$SearchBar"], properties: { type: { list: !1, type: "ENUMERATION", values: ["None", "FoldableOpen", "FoldableClosed", "AlwaysOpen"] }, waitForSearch: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Nr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$ListViewSearch"], properties: { searchRefs: { list: !0, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" } } }, hr = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ControlBarItem"], allCompatibleTypes: ["Pages$ComparisonSearchField", "Pages$DropDownSearchField", "Pages$RangeSearchField", "Pages$SingleSearchField"], properties: { caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, placeholder: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, customDateFormat: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, type: { list: !1, type: "ENUMERATION", values: ["Normal", "Hidden", "ReadOnly"] }, defaultValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, Rr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ControlBarButton", "Pages$ControlBarItem", "Pages$GridControlBarButton"], allCompatibleTypes: ["Pages$SelectButton"] }, Ar = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ConditionallyEditableWidget", "Pages$ConditionallyVisibleWidget", "Pages$InputWidget", "Pages$MemberWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$InputReferenceSetSelector", "Pages$ReferenceSelector"], properties: { selectorSource: { list: !1, type: "ELEMENT", elementType: "Pages$SelectorSource", kind: "PART" }, selectPageSettings: { list: !1, type: "ELEMENT", elementType: "Pages$PageSettings", kind: "PART" }, onChangeAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" }, sourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, Cr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$SelectorSource"], allCompatibleTypes: ["Pages$SelectorXPathSource"], properties: { sortBar: { list: !1, type: "ELEMENT", elementType: "Pages$GridSortBar", kind: "PART" }, xPathConstraint: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, constrainedByRefs: { list: !0, type: "ELEMENT", elementType: "DomainModels$EntityRef", kind: "PART" } } }, Or = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$SelectorSource"], allCompatibleTypes: ["Pages$SelectorMicroflowSource"], properties: { dataSourceMicroflowSettings: { list: !1, type: "ELEMENT", elementType: "Pages$MicroflowSettings", kind: "PART" } } }, xr = { type: "ELEMENT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Pages$SelectorMicroflowSource", "Pages$SelectorXPathSource"] }, Lr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Button", "Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$SidebarToggleButton"] }, wr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$MenuWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$SimpleMenuBar"], properties: { orientation: { list: !1, type: "ENUMERATION", values: ["Horizontal", "Vertical"] } } }, kr = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$ControlBarItem", "Pages$SearchField"], allCompatibleTypes: ["Pages$ComparisonSearchField", "Pages$DropDownSearchField"], properties: { attributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, operator: { list: !1, type: "ENUMERATION", values: ["Contains", "StartsWith", "Greater", "GreaterOrEqual", "Equal", "NotEqual", "SmallerOrEqual", "Smaller"] } } }, jr = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Pages$FormBase"], allCompatibleTypes: ["Pages$Snippet"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, type: { list: !1, type: "ENUMERATION", values: ["Web", "Native"] }, parameters: { list: !0, type: "ELEMENT", elementType: "Pages$SnippetParameter", kind: "PART" }, variables: { list: !0, type: "ELEMENT", elementType: "Pages$LocalVariable", kind: "PART" } } }, Br = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$SnippetParameter"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, parameterType: { list: !1, type: "ELEMENT", elementType: "DataTypes$DataType", kind: "PART" } } }, Vr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$SnippetCall"], properties: { snippet: { list: !1, type: "ELEMENT", elementType: "Pages$Snippet", kind: "BY_NAME_REFERENCE" }, parameterMappings: { list: !0, type: "ELEMENT", elementType: "Pages$SnippetParameterMapping", kind: "PART" } } }, Wr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$SnippetParameterMapping"], properties: { parameter: { list: !1, type: "ELEMENT", elementType: "Pages$SnippetParameter", kind: "BY_NAME_REFERENCE" }, variable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" } } }, Gr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$Widget"], allCompatibleTypes: ["Pages$SnippetCallWidget"], properties: { snippetCall: { list: !1, type: "ELEMENT", elementType: "Pages$SnippetCall", kind: "PART" } } }, zr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$TabContainer"], properties: { tabPages: { list: !0, type: "ELEMENT", elementType: "Pages$TabPage", kind: "PART" }, defaultPage: { list: !1, type: "ELEMENT", elementType: "Pages$TabPage", kind: "BY_ID_REFERENCE" }, activePageAttributeRef: { list: !1, type: "ELEMENT", elementType: "DomainModels$AttributeRef", kind: "PART" }, activePageSourceVariable: { list: !1, type: "ELEMENT", elementType: "Pages$PageVariable", kind: "PART" }, activePageOnChangeAction: { list: !1, type: "ELEMENT", elementType: "Pages$ClientAction", kind: "PART" } } }, Fr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$TabPage"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, caption: { list: !1, type: "ELEMENT", elementType: "Texts$Text", kind: "PART" }, refreshOnShow: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, conditionalVisibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$ConditionalVisibilitySettings", kind: "PART" }, widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" }, badge: { list: !1, type: "ELEMENT", elementType: "Pages$ClientTemplate", kind: "PART" } } }, Ur = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$EntityWidget", "Pages$Grid", "Pages$ListenTargetWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$TemplateGrid"], properties: { contents: { list: !1, type: "ELEMENT", elementType: "Pages$TemplateGridContents", kind: "PART" }, numberOfRows: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" }, numberOfColumns: { list: !1, type: "PRIMITIVE", primitiveType: "INTEGER" } } }, Yr = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Pages$TemplateGridContents"], properties: { widgets: { list: !0, type: "ELEMENT", elementType: "Pages$Widget", kind: "PART" } } }, Hr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ConditionallyVisibleWidget", "Pages$Widget"], allCompatibleTypes: ["Pages$Title"], properties: { nativeAccessibilitySettings: { list: !1, type: "ELEMENT", elementType: "Pages$AccessibilitySettings", kind: "PART" } } }, qr = { type: "ELEMENT", abstract: !0, baseTypes: ["Pages$TemplateType"], allCompatibleTypes: ["Pages$UserTaskTemplateType", "Pages$WorkflowOverviewTemplateType"] }, Xr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$TemplateType", "Pages$WorkflowTemplateType"], allCompatibleTypes: ["Pages$UserTaskTemplateType"] }, Kr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$TemplateType", "Pages$WorkflowTemplateType"], allCompatibleTypes: ["Pages$WorkflowOverviewTemplateType"] }, Jr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$CallWorkflowClientAction"], properties: { workflow: { list: !1, type: "ELEMENT", elementType: "Workflows$Workflow", kind: "BY_NAME_REFERENCE" }, closePage: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, confirmationInfo: { list: !1, type: "ELEMENT", elementType: "Pages$ConfirmationInfo", kind: "PART" } } }, Qr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$OpenUserTaskClientAction"], properties: { assignOnOpen: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, openWhenAssigned: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, Zr = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$OpenWorkflowClientAction"], properties: { defaultPage: { list: !1, type: "ELEMENT", elementType: "Pages$Page", kind: "BY_NAME_REFERENCE" } } }, en = { type: "ELEMENT", abstract: !1, baseTypes: ["Pages$ClientAction"], allCompatibleTypes: ["Pages$SetTaskOutcomeClientAction"], properties: { outcomeValue: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, closePage: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, commit: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, tn = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$Project"], properties: { isSystemProject: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, an = { type: "MODEL_UNIT", abstract: !0, baseTypes: [], allCompatibleTypes: [] }, ln = { type: "MODEL_UNIT", abstract: !0, baseTypes: [], allCompatibleTypes: [] }, sn = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$Folder"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, rn = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$Module"], properties: { sortIndex: { list: !1, type: "PRIMITIVE", primitiveType: "DOUBLE" }, name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, fromAppStore: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, appStoreGuid: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, appStoreVersionGuid: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, appStoreVersion: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, appStorePackageIdString: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, isThemeModule: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" } } }, nn = { type: "MODEL_UNIT", abstract: !1, baseTypes: ["Projects$ModuleDocument"], allCompatibleTypes: ["Projects$ModuleSettings"], properties: { exportLevel: { list: !1, type: "ENUMERATION", values: ["Source", "Protected"] }, protectedModuleType: { list: !1, type: "ENUMERATION", values: ["AddOn", "Solution"] }, version: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, solutionIdentifier: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, extensionName: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, jarDependencies: { list: !0, type: "ELEMENT", elementType: "Projects$JarDependency", kind: "PART" }, basedOnVersion: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, on = { type: "MODEL_UNIT", abstract: !0, baseTypes: [], allCompatibleTypes: ["Projects$Document", "Projects$ModuleSettings"] }, cn = { type: "MODEL_UNIT", abstract: !0, baseTypes: ["Projects$ModuleDocument"], allCompatibleTypes: [], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, documentation: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, excluded: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, exportLevel: { list: !1, type: "ENUMERATION", values: ["Hidden", "API"] } } }, un = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$OneTimeConversionMarker"], properties: { name: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, pn = { type: "MODEL_UNIT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$ProjectConversion"], properties: { markers: { list: !0, type: "ELEMENT", elementType: "Projects$OneTimeConversionMarker", kind: "PART" } } }, mn = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$JarDependency"], properties: { groupId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, artifactId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, version: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, isIncluded: { list: !1, type: "PRIMITIVE", primitiveType: "BOOLEAN" }, exclusions: { list: !0, type: "ELEMENT", elementType: "Projects$JarDependencyExclusion", kind: "PART" } } }, yn = { type: "ELEMENT", abstract: !1, baseTypes: [], allCompatibleTypes: ["Projects$JarDependencyExclusion"], properties: { groupId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" }, artifactId: { list: !1, type: "PRIMITIVE", primitiveType: "STRING" } } }, dn = {
  DomainModels$DomainModel: jt,
  DomainModels$Entity: Bt,
  DomainModels$EntitySource: Vt,
  DomainModels$RemoteEntitySource: Wt,
  DomainModels$QueryBasedRemoteEntitySource: Gt,
  DomainModels$ViewEntitySource: zt,
  DomainModels$OqlViewEntitySource: Ft,
  DomainModels$GeneralizationBase: Ut,
  DomainModels$Generalization: Yt,
  DomainModels$NoGeneralization: Ht,
  DomainModels$EntityKey: qt,
  DomainModels$EntityKeyPart: Xt,
  DomainModels$RemoteEntitySourceDocument: Kt,
  DomainModels$ViewEntitySourceDocument: Jt,
  DomainModels$Attribute: Qt,
  DomainModels$ValueType: Zt,
  DomainModels$StoredValue: ea,
  DomainModels$CalculatedValue: ta,
  DomainModels$OqlViewValue: aa,
  DomainModels$MappedValue: la,
  DomainModels$AttributeType: sa,
  DomainModels$BinaryAttributeType: ia,
  DomainModels$BooleanAttributeType: ra,
  DomainModels$DateTimeAttributeType: na,
  DomainModels$EnumerationAttributeType: oa,
  DomainModels$HashedStringAttributeType: ca,
  DomainModels$StringAttributeType: ua,
  DomainModels$NumericAttributeTypeBase: pa,
  DomainModels$DecimalAttributeTypeBase: ma,
  DomainModels$DecimalAttributeType: ya,
  DomainModels$IntegerAttributeTypeBase: da,
  DomainModels$IntegerAttributeType: ba,
  DomainModels$LongAttributeType: Ta,
  DomainModels$AutoNumberAttributeType: Ea,
  DomainModels$AssociationBase: ga,
  DomainModels$Association: fa,
  DomainModels$CrossAssociation: Pa,
  DomainModels$AssociationSource: Sa,
  DomainModels$RemoteAssociationSource: $a,
  DomainModels$OqlViewAssociationSource: _a,
  DomainModels$AssociationDeleteBehavior: va,
  DomainModels$Annotation: Ia,
  DomainModels$AccessRule: Ma,
  DomainModels$MemberAccess: Da,
  DomainModels$EventHandler: Na,
  DomainModels$Index: ha,
  DomainModels$IndexedAttribute: Ra,
  DomainModels$ValidationRule: Aa,
  DomainModels$RuleInfo: Ca,
  DomainModels$EqualsToRuleInfo: Oa,
  DomainModels$MaxLengthRuleInfo: xa,
  DomainModels$RangeRuleInfo: La,
  DomainModels$RegExRuleInfo: wa,
  DomainModels$RequiredRuleInfo: ka,
  DomainModels$UniqueRuleInfo: ja,
  DomainModels$EntityRef: Ba,
  DomainModels$DirectEntityRef: Va,
  DomainModels$IndirectEntityRef: Wa,
  DomainModels$EntityRefStep: Ga,
  DomainModels$MemberRef: za,
  DomainModels$AttributeRef: Fa,
  DomainModels$AssociationRef: Ua,
  Texts$Text: Ya,
  Texts$Translation: Ha,
  Texts$SystemText: qa,
  Texts$SystemTextCollection: Xa,
  Url$UrlSegment: Ka,
  Url$StaticUrlSegment: Ja,
  Enumerations$Enumeration: Qa,
  Enumerations$EnumerationValue: Za,
  Enumerations$Condition: el,
  Enumerations$RemoteEnumerationSource: tl,
  Enumerations$RemoteEnumerationValue: al,
  DataTypes$DataType: ll,
  DataTypes$UnknownType: sl,
  DataTypes$VoidType: il,
  DataTypes$EmptyType: rl,
  DataTypes$BooleanType: nl,
  DataTypes$BinaryType: ol,
  DataTypes$DecimalType: cl,
  DataTypes$IntegerType: ul,
  DataTypes$FloatType: pl,
  DataTypes$DateTimeType: ml,
  DataTypes$StringType: yl,
  DataTypes$EnumerationType: dl,
  DataTypes$EntityType: bl,
  DataTypes$ObjectType: Tl,
  DataTypes$ListType: El,
  CustomWidgets$CustomWidget: gl,
  CustomWidgets$CustomWidgetType: fl,
  CustomWidgets$WidgetEnumerationValue: Pl,
  CustomWidgets$WidgetObject: Sl,
  CustomWidgets$WidgetObjectType: $l,
  CustomWidgets$WidgetProperty: _l,
  CustomWidgets$WidgetPropertyType: vl,
  CustomWidgets$WidgetReturnType: Il,
  CustomWidgets$WidgetTranslation: Ml,
  CustomWidgets$WidgetActionVariable: Dl,
  CustomWidgets$WidgetValue: Nl,
  CustomWidgets$WidgetValueType: hl,
  CustomWidgets$CustomWidgetXPathSource: Rl,
  Pages$FormBase: Al,
  Pages$Page: Cl,
  Pages$ParameterAttributeUrlSegment: Ol,
  Pages$ParameterIdUrlSegment: xl,
  Pages$PageParameter: Ll,
  Pages$Layout: wl,
  Pages$LayoutContent: kl,
  Pages$WebLayoutContent: jl,
  Pages$NativeLayoutContent: Bl,
  Pages$LayoutCall: Vl,
  Pages$LayoutCallArgument: Wl,
  Pages$LayoutParameter: Gl,
  Pages$Placeholder: zl,
  Pages$TemplateFormBase: Fl,
  Pages$BuildingBlock: Ul,
  Pages$TemplateType: Yl,
  Pages$RegularPageTemplateType: Hl,
  Pages$EditPageTemplateType: ql,
  Pages$SelectPageTemplateType: Xl,
  Pages$PageTemplate: Kl,
  Pages$TemplatePlaceholder: Jl,
  Pages$ClientAction: Ql,
  Pages$NoClientAction: Zl,
  Pages$PageClientAction: es,
  Pages$MicroflowClientAction: ts,
  Pages$CallNanoflowClientAction: as,
  Pages$SignOutClientAction: ls,
  Pages$SaveChangesClientAction: ss,
  Pages$CancelChangesClientAction: is,
  Pages$ClosePageClientAction: rs,
  Pages$SyncClientAction: ns,
  Pages$OpenLinkClientAction: os,
  Pages$DeleteClientAction: cs,
  Pages$CreateObjectClientAction: us,
  Pages$PageSettings: ps,
  Pages$PageParameterMapping: ms,
  Pages$MicroflowSettings: ys,
  Pages$MicroflowParameterMapping: ds,
  Pages$NanoflowParameterMapping: bs,
  Pages$ConfirmationInfo: Ts,
  Pages$PageVariable: Es,
  Pages$LocalVariable: gs,
  Pages$Appearance: fs,
  Pages$DesignPropertyValue: Ps,
  Pages$AbstractDesignPropertyValue: Ss,
  Pages$OptionDesignPropertyValue: $s,
  Pages$ToggleDesignPropertyValue: _s,
  Pages$CustomDesignPropertyValue: vs,
  Pages$CompoundDesignPropertyValue: Is,
  Pages$Widget: Ms,
  Pages$Label: Ds,
  Pages$StaticImageViewer: Ns,
  Pages$DivContainer: hs,
  Pages$TextBox: Rs,
  Pages$TextArea: As,
  Pages$CheckBox: Cs,
  Pages$RadioButtonGroup: Os,
  Pages$DatePicker: xs,
  Pages$LoginTextBox: Ls,
  Pages$LoginIdTextBox: ws,
  Pages$PasswordTextBox: ks,
  Pages$LoginButton: js,
  Pages$ValidationMessage: Bs,
  Pages$FormattingInfo: Vs,
  Pages$TextWidget: Ws,
  Pages$AttributeWidgetWithPlaceholder: Gs,
  Pages$AttributeWidget: zs,
  Pages$WidgetValidation: Fs,
  Pages$MemberWidget: Us,
  Pages$InputWidget: Ys,
  Pages$ConditionallyEditableWidget: Hs,
  Pages$ConditionallyVisibleWidget: qs,
  Pages$ConditionalSettings: Xs,
  Pages$ConditionalVisibilitySettings: Ks,
  Pages$ConditionalEditabilitySettings: Js,
  Pages$AccessibilitySettings: Qs,
  Pages$Table: Zs,
  Pages$TableCell: ei,
  Pages$TableColumn: ti,
  Pages$TableRow: ai,
  Pages$EntityWidget: li,
  Pages$DataSource: si,
  Pages$EntityPathSource: ii,
  Pages$MicroflowSource: ri,
  Pages$NanoflowSource: ni,
  Pages$ListenTargetWidget: oi,
  Pages$AssociationSource: ci,
  Pages$DataView: ui,
  Pages$DataViewSource: pi,
  Pages$ListenTargetSource: mi,
  Pages$ControlBar: yi,
  Pages$ControlBarItem: di,
  Pages$ControlBarButton: bi,
  Pages$ListView: Ti,
  Pages$ListViewTemplate: Ei,
  Pages$SortableEntityPathSource: gi,
  Pages$XPathSourceBase: fi,
  Pages$ListViewXPathSource: Pi,
  Pages$GridSortBar: Si,
  Pages$GridSortItem: $i,
  Pages$Button: _i,
  Pages$StaticOrDynamicString: vi,
  Pages$ActionButton: Ii,
  Pages$ClientTemplate: Mi,
  Pages$ClientTemplateParameter: Di,
  Pages$ColumnGrid: Ni,
  Pages$ComparisonSearchField: hi,
  Pages$GridXPathSource: Ri,
  Pages$DataGrid: Ai,
  Pages$DataGridAddButton: Ci,
  Pages$DataGridExportToCSVButton: Oi,
  Pages$DataGridExportToExcelButton: xi,
  Pages$DataGridRemoveButton: Li,
  Pages$DropDown: wi,
  Pages$DropDownButton: ki,
  Pages$ActionItem: ji,
  Pages$DropDownButtonItem: Bi,
  Pages$DropDownSearchField: Vi,
  Pages$DynamicImageViewer: Wi,
  Pages$DynamicText: Gi,
  Pages$FileManager: zi,
  Pages$PageForSpecialization: Fi,
  Pages$GlyphIcon: Ui,
  Pages$Grid: Yi,
  Pages$GridActionButton: Hi,
  Pages$GridBaseSource: qi,
  Pages$GridColumn: Xi,
  Pages$GridControlBar: Ki,
  Pages$GridControlBarButton: Ji,
  Pages$GridDeselectAllButton: Qi,
  Pages$GridNewButton: Zi,
  Pages$GridSearchButton: er,
  Pages$GridSelectAllButton: tr,
  Pages$GroupBox: ar,
  Pages$Header: lr,
  Pages$Icon: sr,
  Pages$ImageIcon: ir,
  Pages$IconCollectionIcon: rr,
  Pages$ImageUploader: nr,
  Pages$ImageViewerSource: or,
  Pages$InputReferenceSetSelector: cr,
  Pages$LayoutGrid: ur,
  Pages$LayoutGridColumn: pr,
  Pages$LayoutGridRow: mr,
  Pages$MenuBar: yr,
  Pages$MenuDocumentSource: dr,
  Pages$MenuSource: br,
  Pages$MenuWidget: Tr,
  Pages$NavigationList: Er,
  Pages$NavigationListItem: gr,
  Pages$NavigationSource: fr,
  Pages$NavigationTree: Pr,
  Pages$RangeSearchField: Sr,
  Pages$ReferenceSelector: $r,
  Pages$ReferenceSetSelector: _r,
  Pages$ReferenceSetSource: vr,
  Pages$ScrollContainer: Ir,
  Pages$ScrollContainerRegion: Mr,
  Pages$SearchBar: Dr,
  Pages$ListViewSearch: Nr,
  Pages$SearchField: hr,
  Pages$SelectButton: Rr,
  Pages$AssociationWidget: Ar,
  Pages$SelectorXPathSource: Cr,
  Pages$SelectorMicroflowSource: Or,
  Pages$SelectorSource: xr,
  Pages$SidebarToggleButton: Lr,
  Pages$SimpleMenuBar: wr,
  Pages$SingleSearchField: kr,
  Pages$Snippet: jr,
  Pages$SnippetParameter: Br,
  Pages$SnippetCall: Vr,
  Pages$SnippetParameterMapping: Wr,
  Pages$SnippetCallWidget: Gr,
  Pages$TabContainer: zr,
  Pages$TabPage: Fr,
  Pages$TemplateGrid: Ur,
  Pages$TemplateGridContents: Yr,
  Pages$Title: Hr,
  Pages$WorkflowTemplateType: qr,
  Pages$UserTaskTemplateType: Xr,
  Pages$WorkflowOverviewTemplateType: Kr,
  Pages$CallWorkflowClientAction: Jr,
  Pages$OpenUserTaskClientAction: Qr,
  Pages$OpenWorkflowClientAction: Zr,
  Pages$SetTaskOutcomeClientAction: en,
  Projects$Project: tn,
  Projects$ProjectDocument: an,
  Projects$FolderBase: ln,
  Projects$Folder: sn,
  Projects$Module: rn,
  Projects$ModuleSettings: nn,
  Projects$ModuleDocument: on,
  Projects$Document: cn,
  Projects$OneTimeConversionMarker: un,
  Projects$ProjectConversion: pn,
  Projects$JarDependency: mn,
  Projects$JarDependencyExclusion: yn
}, C = dn;
P.registerApi("mendix.PageApi", new Qe(C));
P.registerApi("mendix.DomainModelApi", new Ke(C));
P.registerApi("mendix.EnumerationApi", new Je(C));
P.registerApi("mendix.SnippetApi", new et(C));
P.registerApi("mendix.BuildingBlockApi", new Xe(C));
P.registerApi("mendix.ProjectApi", new Ze(C));
//# sourceMappingURL=main.js.map
