export declare namespace Primitives {
    /**
     * An element is part of a Mendix model and all elements together form the logic of the model.
     * Elements may contain other elements. An element always has a container element, which is its parent.
     * The root of an element tree is always a unit.
     */
    interface ElementBase {
        /**
         * The unique id of the element.
         */
        $ID: string;
        /**
         * The type of the element.
         */
        $Type: string;
        /**
         * Options to pass during the element creation
         */
        $CreationOptions?: unknown;
    }
    /**
     * A unit is a container of elements, it can not contain other units.
     */
    interface UnitBase extends ElementBase {
    }
    /**
     * Info about a unit.
     */
    interface UnitInfo {
        /**
         * The unique id of the element.
         */
        $ID: string;
        /**
         * The type of the element.
         */
        $Type: string;
        /**
         * The name of the module containing the unit.
         */
        moduleName?: string;
        /**
         * The name of the unit.
         */
        name?: string;
    }
    /**
     * A spatial coordinate pair.
     */
    interface Location {
        /**
         * The x-coordinate.
         */
        x: number;
        /**
         * The y-coordinate.
         */
        y: number;
    }
}
//# sourceMappingURL=primitives.d.ts.map