import { Primitives } from './primitives';
interface OperationBase {
    /**
     * The type of the operation.
     */
    type: string;
}
/**
 * This operation creates an element.
 * This must be paired with a 'insertElement' operation otherwise the element will not be created.
 */
export interface CreateElementOperation<T extends Primitives.ElementBase = Primitives.ElementBase> extends OperationBase {
    type: "createElement";
    /**
     * The element to create.
     */
    element: T;
}
/**
 * This operation removes an element.
 */
export interface RemoveElementOperation extends OperationBase {
    type: "removeElement";
    /**
     * The id of the unit containing the element to remove.
     */
    unitId: string;
    /**
     * The id of the element to remove.
     */
    elementId: string;
}
/**
 * This operation insert an element into an element/unit.
 */
export interface InsertElementOperation extends OperationBase {
    type: "insertElement";
    /**
     * The id of the unit that will contain the to-be-inserted element.
     */
    unitId: string;
    /**
     * The id of the parent that will contain the to-be-inserted element.
     */
    targetId: string;
    /**
     * The property name in which the to-be-inserted element will be inserted.
     */
    propertyName: string;
    /**
     * The array index in which the to-be-inserted element will be inserted.
     */
    index: number;
    /**
     * The id of the to-be-inserted element.
     */
    elementId: string;
}
/**
 * This operation sets a property to the specified value.
 */
export interface SetPropertyOperation<T = string> extends OperationBase {
    type: "setProperty";
    /**
     * The id of the unit containing the property to set.
     */
    unitId: string;
    /**
     * The id of the parent contaning the element containing the property to set.
     */
    targetId: string;
    /**
     * The name of the property to set.
     */
    propertyName: string;
    /**
     * The value to set the property.
     */
    value: T;
}
/**
 * The operation to apply to the model.
 */
export type Operation = CreateElementOperation | RemoveElementOperation | InsertElementOperation | SetPropertyOperation;
/**
 * The result of the attempt to apply changes.
 */
export interface ApplyChangesResult {
    /**
     * The context id of the operations.
     */
    contextId: string;
}
export {};
//# sourceMappingURL=operations.d.ts.map