import { ComponentApiBase, IComponentApi } from '@mendix/component-framework';
import { ApplyChangesResult, Operation } from './model/operations';
import { Primitives } from './model/primitives';
/**
 * This API allows to access the Mendix model.
 */
export interface IModelAccessApi extends IComponentApi {
    _apiId: "mendix.ModelAccessApi";
    /**
     * It gets the units info of the specified unit type.
     * @param type The type of the units to retrieve.
     */
    getAllUnitsInfoByType<T extends Primitives.UnitBase>(type: T["$Type"]): Promise<Primitives.UnitInfo[]>;
    /**
     * It loads the specified unit into memory.
     * @param id The id of the unit to load.
     */
    loadUnit<T extends Primitives.UnitBase>(id: string): Promise<T | undefined>;
    /**
     * It loads the specified unit by its qualified name.
     * @param type The type of the unit to load.
     * @param qualifiedName The qualified name of the unit to load.
     */
    loadUnitByName<T extends Primitives.UnitBase>(type: T["$Type"], qualifiedName: string): Promise<T | undefined>;
    /**
     * It applies the specified oprations to the model.
     * @param operations The operations to apply to the model.
     */
    applyChanges(operations: Operation[]): Promise<ApplyChangesResult>;
    /**
     * Create a new unit based on the provided JSON
     * @param unitJson The default content for the newly created unit.
     * @param containerId The id of the folder or module where the new unit will be added..
     */
    createUnit(unitJson: Primitives.UnitBase, containerId: string): Promise<Primitives.UnitBase>;
    /**
     * Delete the specified unit.
     * @param id The id of the unit to delete.
     */
    deleteUnit(unitId: string): Promise<void>;
}
export declare class ModelAccessApi extends ComponentApiBase implements IModelAccessApi {
    _apiId: "mendix.ModelAccessApi";
    getAllUnitsInfoByType<T extends Primitives.UnitBase>(type: T["$Type"]): Promise<Primitives.UnitInfo[]>;
    loadUnit<T extends Primitives.UnitBase>(id: string): Promise<T | undefined>;
    loadUnitByName<T extends Primitives.UnitBase>(type: T["$Type"], qualifiedName: string): Promise<T | undefined>;
    applyChanges(operations: Operation[]): Promise<ApplyChangesResult>;
    createUnit(unitJson: Primitives.UnitBase, containerId: string): Promise<Primitives.UnitBase>;
    deleteUnit(unitId: string): Promise<void>;
    private getAllUnitsInfo;
    private backend;
    private throwIfResponseNotOk;
}
//# sourceMappingURL=ModelAccessApi.d.ts.map