import { IComponentApi } from '@mendix/component-framework';
import { Primitives, Operation, ApplyChangesResult } from './main';
export interface ElementMetadataMap {
    [elementType: string]: ElementMetadata;
}
export interface ElementMetadata {
    helpers: {
        [typeSuffix: string]: {
            type: string;
            parentPropertyName: string;
        };
    };
}
export interface IModelComponentApiBase<TUnit extends Primitives.UnitBase, TEventMap extends {} = {}> extends IComponentApi<TEventMap> {
    loadUnits(type: TUnit["$Type"], unitIds: string[]): Promise<TUnit[]>;
    applyChanges(operations: Operation[]): Promise<ApplyChangesResult>;
    createElement<TElement extends Primitives.ElementBase>(type: TElement["$Type"], options?: TElement["$CreationOptions"]): Promise<TElement>;
    createUnit(type: TUnit["$Type"], containerId: string, options?: TUnit["$CreationOptions"]): Promise<TUnit>;
    deleteUnit(unitId: string): Promise<void>;
    getElementMetadata(): Promise<ElementMetadataMap>;
}
//# sourceMappingURL=IModelComponentApiBase.d.ts.map