import { Primitives } from '@mendix/model-access';
import { ObservableObject, ProxiedModel } from './Observable';
export type ObservableEventDetails = SetPropertyEventDetail | RemoveElementEventDetail | InsertElementEventDetail;
export interface BaseEventDetail {
    unitId: string;
    type: string;
}
export interface SetPropertyEventDetail extends BaseEventDetail {
    type: "setProperty";
    element: ObservableObject;
    property: string;
    oldValue: unknown;
    newValue: unknown;
}
export interface RemoveElementEventDetail extends BaseEventDetail {
    type: "removeElement";
    element: ProxiedModel<Primitives.ElementBase>;
    container: Primitives.ElementBase;
    propertyNameInContainer: string;
    index: number;
}
export interface InsertElementEventDetail extends BaseEventDetail {
    type: "insertElement";
    element: Primitives.ElementBase;
    container: Primitives.ElementBase;
    propertyNameInContainer: string;
    index: number;
}
//# sourceMappingURL=observableEventDetails.d.ts.map