import { Primitives, ElementMetadataMap } from '@mendix/model-access';
import { ObservableEventDetails } from './observableEventDetails';
export type ObservableObject = Primitives.ElementBase | Primitives.ElementBase[] | object;
export type ProxiedModel<T extends ObservableObject> = T & {
    [IsDetachedSymbol]: boolean;
    [ContainerSymbol]?: Primitives.ElementBase;
    [ParentAttributeNameSymbol]?: string;
    getContainer(): Primitives.ElementBase | undefined;
    delete(): T;
};
export declare const OBSERVABLE_EVENT_NAME = "ModelChanged";
export declare const IsDetachedSymbol: unique symbol;
export declare const ContainerSymbol: unique symbol;
export declare const ParentAttributeNameSymbol: unique symbol;
export type ObservableHelperOptions = {
    elementMetadataMap: ElementMetadataMap;
    createElement: <TElement extends Primitives.ElementBase>(type: TElement["$Type"], creationOptions?: TElement["$CreationOptions"]) => Promise<TElement>;
};
export declare class Observable<T extends Primitives.UnitBase> extends EventTarget {
    private helperOptions;
    private proxyCache;
    protected unitId: string;
    model: ProxiedModel<T>;
    constructor(unit: T, helperOptions: ObservableHelperOptions);
    addListener(listener: EventListenerOrEventListenerObject | null | ((evt: CustomEvent<ObservableEventDetails>) => void)): void;
    getContainer<T extends ObservableObject>(obj: T): Primitives.ElementBase | undefined;
    delete<T extends Primitives.ElementBase>(obj: ProxiedModel<T>): T;
    isDetached<T extends ObservableObject>(obj: T): boolean;
    getParentPropertyName<T extends ObservableObject>(obj: T): string | undefined;
    protected dispatchObservableEvent(eventDetails: ObservableEventDetails): boolean;
    protected setContainerProperties(target: ObservableObject | ProxiedModel<ObservableObject>, isDetached: boolean, container?: Primitives.ElementBase, parentAttributeName?: string): void;
    private arrayPushUnshiftHandlerFactory;
    private arraySpliceHandlerFactory;
    private arrayPopShiftHandlerFactory;
    protected createProxy<K extends ObservableObject>(obj: K, parent: Primitives.ElementBase, propertyNameInContainer: string): ProxiedModel<K>;
    protected getElement(parentElement: Primitives.ElementBase, typeSuffix: string, elementName: string): Primitives.ElementBase | undefined;
    protected addElement(parentElement: ProxiedModel<Primitives.ElementBase>, typeSuffix: string, options?: unknown): Promise<Primitives.ElementBase>;
    private supportsAddGetHelpers;
}
//# sourceMappingURL=Observable.d.ts.map