import { IModelComponentApiBase, Primitives } from '@mendix/model-access';
export type ModelAccessWithComponent<TApi extends IModelComponentApiBase<TUnit>, TUnit extends Primitives.UnitBase> = IModelAccess<TUnit> & Omit<TApi, keyof IModelComponentApiBase<TUnit>>;
export declare function getModelAccess<TApi extends IModelComponentApiBase<TUnit>, TUnit extends Primitives.UnitBase>(apiId: TApi["_apiId"], unitType: TUnit["$Type"]): IModelAccess<TUnit>;
export declare function getModelAccessWithComponentProxy<TApi extends IModelComponentApiBase<TUnit>, TUnit extends Primitives.UnitBase>(apiId: TApi["_apiId"], unitType: TUnit["$Type"]): ModelAccessWithComponent<TApi, TUnit>;
export interface IModelAccess<TUnit extends Primitives.UnitBase> {
    /**
     * Retrieves information about all units of the specified type.
     * @returns A promise that resolves to an array of unit information objects.
     */
    getUnitsInfo(): Promise<ReadonlyArray<Readonly<Primitives.UnitInfo>>>;
    /**
     * Loads all units that match the specified filter.
     * @param filter A function to filter units.
     * @param maxUnitsToLoad The maximum number of units to load. Defaults to 10 units.
     * @returns A promise that resolves to an array of loaded units.
     */
    loadAll(filter: (u: Primitives.UnitInfo) => boolean, maxUnitsToLoad?: number): Promise<TUnit[]>;
    /**
     * Saves the specified unit.
     * @param unit The unit to save.
     * @returns A promise that resolves when the unit is saved.
     */
    save(unit: TUnit): Promise<void>;
    /**
     * Creates a new element of the specified type.
     * @param type The type of the element to create.
     * @param creationOptions Options for that will be used during the element initilization.
     * @returns A promise that resolves to the created element.
     */
    create<TElement extends Primitives.ElementBase>(type: TElement["$Type"], creationOptions?: TElement["$CreationOptions"]): Promise<TElement>;
    /**
     * Deletes the unit with the specified ID.
     * @param unitId The ID of the unit to delete.
     * @returns A promise that resolves when the unit is deleted.
     */
    deleteUnit(unitId: string): Promise<void>;
}
export declare class ModelAccess<TUnit extends Primitives.UnitBase> implements IModelAccess<TUnit> {
    private unitComponent;
    private documentType;
    private transactions;
    private observabilityLibrary;
    private modelAccessComponent;
    private elementMetadataCache;
    constructor(unitComponent: IModelComponentApiBase<TUnit>, documentType: TUnit["$Type"]);
    getUnitsInfo(): Promise<ReadonlyArray<Readonly<Primitives.UnitInfo>>>;
    loadAll(filter: (u: Primitives.UnitInfo) => boolean, maxUnitsToLoad?: number): Promise<TUnit[]>;
    save(unit: TUnit): Promise<void>;
    create<TElement extends Primitives.ElementBase>(type: TElement["$Type"], creationOptions?: TElement["$CreationOptions"]): Promise<TElement>;
    getContainer(element: Primitives.ElementBase): Primitives.ElementBase | undefined;
    delete(element: Primitives.ElementBase): void;
    deleteUnit(unitId: string): Promise<void>;
    createUnit(type: TUnit["$Type"], containerId: string, creationOptions?: TUnit["$CreationOptions"]): Promise<TUnit>;
    importUnit(unit: TUnit): Promise<TUnit>;
    private loadElementsMetadata;
    private observeUnit;
}
//# sourceMappingURL=ModelAccess.d.ts.map