export type PrimitiveType = "STRING" | "BOOLEAN" | "INTEGER" | "DOUBLE" | "COLOR" | "POINT" | "GUID" | "SIZE" | "DATE_TIME" | "BLOB";
export type ElementKind = "PART" | "BY_NAME_REFERENCE" | "BY_ID_REFERENCE" | "LOCAL_BY_NAME_REFERENCE";
export type PropertyType = "ELEMENT" | "PRIMITIVE" | "ENUMERATION";
export type ModelType = "ELEMENT" | "MODEL_UNIT";
export type PropertyDetail = {
    type: PropertyType;
    list: boolean;
};
export type ElementPropertyDetail = PropertyDetail & {
    type: "ELEMENT";
    elementType: string;
    kind: ElementKind;
};
export type PrimitivePropertyDetail = PropertyDetail & {
    type: "PRIMITIVE";
    primitiveType: PrimitiveType;
};
export type EnumerationPropertyDetail = PropertyDetail & {
    type: "ENUMERATION";
    values: string[];
};
export type ElementPropertyList = {
    [key: string]: ElementPropertyDetail | PrimitivePropertyDetail | EnumerationPropertyDetail;
};
export type PropertyDetails = ElementPropertyDetail | PrimitivePropertyDetail | EnumerationPropertyDetail;
export type ElementSchema = {
    type: ModelType;
    abstract: boolean;
    allCompatibleTypes: string[];
    baseTypes?: string[];
    properties?: ElementPropertyList;
};
export type UnitSchema = {
    [key: string]: ElementSchema;
};
//# sourceMappingURL=types.d.ts.map