import { ComponentApiBase } from '@mendix/component-framework';
import { ApplyChangesResult, ElementMetadataMap, IModelComponentApiBase, Operation, Primitives } from '@mendix/model-access';
import { UnitSchema } from '../model/types';
export declare abstract class ModelComponentApiBase<TUnit extends Primitives.UnitBase, TEventMap extends {} = {}> extends ComponentApiBase<TEventMap> implements IModelComponentApiBase<TUnit, TEventMap> {
    private schema;
    private modelAccess;
    private serializer;
    constructor(schema: UnitSchema);
    loadUnits(type: TUnit["$Type"], unitIds: string[]): Promise<TUnit[]>;
    applyChanges(operations: Operation[]): Promise<ApplyChangesResult>;
    createElement<TElement extends Primitives.ElementBase>(type: TElement["$Type"], options?: TElement["$CreationOptions"]): Promise<TElement>;
    createUnit(type: TUnit["$Type"], containerId: string, options?: TUnit["$CreationOptions"]): Promise<TUnit>;
    deleteUnit(unitId: string): Promise<void>;
    private loadUnit;
    private log;
    getElementMetadata(): Promise<ElementMetadataMap>;
}
//# sourceMappingURL=ModelComponentApiBase.d.ts.map