var u = Object.defineProperty;
var f = (a, e, s) => e in a ? u(a, e, { enumerable: !0, configurable: !0, writable: !0, value: s }) : a[e] = s;
var h = (a, e, s) => f(a, typeof e != "symbol" ? e + "" : e, s);
import { ComponentApiBase as m, componentFramework as w } from "@mendix/component-framework";
const E = /* @__PURE__ */ new Map();
class $ {
  constructor(e) {
    h(this, "schemaPropertyCache", /* @__PURE__ */ new Map());
    this.schema = e;
  }
  plainToClass(e) {
    const s = this.getAllPropertiesForType(e.$Type), n = E.get(e.$Type);
    if (!n)
      throw new Error(`Model class not found for type ${e.$Type}`);
    const t = new n();
    return t.$ID = e.$ID, t.$Type = e.$Type, Object.entries(s).forEach(([i, o]) => {
      switch (o.type) {
        case "ELEMENT":
          switch (o.kind) {
            case "PART":
              o.list ? t[i] = e[i].map(
                (c) => c ? this.plainToClass(c) : null
              ) : t[i] = e[i] ? this.plainToClass(e[i]) : null;
              break;
            case "BY_ID_REFERENCE":
            case "BY_NAME_REFERENCE":
            case "LOCAL_BY_NAME_REFERENCE":
              e[i] !== void 0 && (t[i] = e[i]);
              break;
            default:
              throw new Error(`Unsupported element kind ${o.kind} (property: ${i})`);
          }
          break;
        case "PRIMITIVE":
        case "ENUMERATION":
          e[i] !== void 0 && (t[i] = e[i]);
          break;
      }
    }), t;
  }
  classToPlain(e) {
    const s = this.getAllPropertiesForType(e.$Type), n = {
      $ID: e.$ID,
      $Type: e.$Type
    };
    return Object.entries(s).forEach(([t, i]) => {
      switch (i.type) {
        case "ELEMENT":
          switch (i.kind) {
            case "PART":
              i.list ? n[t] = e[t].map(
                (o) => o ? this.classToPlain(o) : null
              ) : n[t] = e[t] ? this.classToPlain(e[t]) : null;
              break;
            case "BY_ID_REFERENCE":
            case "BY_NAME_REFERENCE":
            case "LOCAL_BY_NAME_REFERENCE":
              n[t] = e[t];
              break;
          }
          break;
        case "ENUMERATION":
        case "PRIMITIVE":
          n[t] = e[t];
          break;
      }
    }), n;
  }
  // Recursively get all properties for a given type
  getAllPropertiesForType(e) {
    var t;
    if (this.schemaPropertyCache.has(e))
      return this.schemaPropertyCache.get(e);
    const s = this.schema[e];
    if (!s)
      throw new Error(`Schema not found for type ${e}`);
    const n = { ...s.properties };
    return (t = s.baseTypes) == null || t.forEach((i) => {
      Object.assign(n, this.getAllPropertiesForType(i));
    }), this.schemaPropertyCache.set(e, n), n;
  }
}
class C extends m {
  constructor(s) {
    super();
    h(this, "modelAccess");
    h(this, "serializer");
    this.schema = s, this.modelAccess = w.getApi("mendix.ModelAccessApi"), this.serializer = new $(s);
  }
  async loadUnits(s, n) {
    return this.log(`Loading units (${s}, ${n.join(", ")})`), Promise.all(n.map((t) => this.loadUnit(s, t)));
  }
  async applyChanges(s) {
    return this.modelAccess.applyChanges(s);
  }
  async createElement(s, n) {
    const t = E.get(s);
    if (!t)
      throw new Error(`Unknown element type: ${s}`);
    const i = new t(n);
    return this.serializer.classToPlain(i);
  }
  async createUnit(s, n, t) {
    const i = E.get(s);
    if (!i)
      throw new Error(`Unknown unit type: ${s}`);
    const o = new i(t);
    return await this.modelAccess.createUnit(this.serializer.classToPlain(o), n);
  }
  async deleteUnit(s) {
    return this.modelAccess.deleteUnit(s);
  }
  async loadUnit(s, n) {
    this.log(`Loading unit (id: ${n}, type: ${s})`);
    const t = await this.modelAccess.loadUnit(n);
    if (!t)
      throw new Error(`Unit with id ${n} not found`);
    if (t.$Type !== s)
      throw new Error(`Unit with id ${n} does not have the type ${s}`);
    this.log(`Converting unit to model classes (id: ${n}, type: ${s})`);
    const i = this.serializer.plainToClass(t);
    return this.log(`Converting model classes to public model (id: ${n}, type: ${s})`), this.serializer.classToPlain(i);
  }
  log(s) {
    console.debug(`[${this._apiId}] ${s}`);
  }
  async getElementMetadata() {
    const s = {};
    for (const n in this.schema) {
      const t = {}, i = this.schema[n].properties;
      for (const o in i) {
        const c = i[o];
        if (c.list && c.type === "ELEMENT" && c.kind === "PART") {
          const p = [], r = this.schema[c.elementType];
          if (!r)
            throw new Error("Element type not found in schema: " + c.elementType);
          r.abstract || p.push(c.elementType), r.abstract && r.allCompatibleTypes && p.push(...r.allCompatibleTypes.filter((l) => l !== c.elementType)), p.forEach((l) => {
            const T = l.substring(l.lastIndexOf("$") + 1);
            t[T] = {
              type: l,
              parentPropertyName: o
            };
          });
        }
      }
      Object.keys(t).length > 0 && (s[n] = { helpers: t });
    }
    return s;
  }
}
class d {
  constructor() {
    h(this, "$ID");
    this.$ID = crypto.randomUUID();
  }
}
class M extends d {
}
class b extends d {
}
class P extends d {
}
function y(a) {
  return function(e) {
    E.set(a, e);
  };
}
export {
  C as ModelComponentApiBase,
  M as ModelElementBase,
  b as ModelUnitBase,
  P as StructuralUnitBase,
  y as modelClass
};
