/**
 * A handle referring to a tab instance in Studio Pro.
 */
export type TabHandle = {
    /**
     * The identifier Studio Pro uses to identify the tab.
     */
    tabId: string;
};
/**
 * Information about a tab to be opened in Studio Pro.
 */
export type TabInfo = {
    /**
     * The title of the tab.
     */
    title: string;
    /**
     * The icon to be displayed in the tab.
     *
     * It is either data URL encoded image or a path relative to the
     * directory where extension is stored (similar to entry points).
     */
    icon?: string;
};
