/**
 * Represents an icon relative to the directory where component identified using
 * {@link IconRelativePath.componentName} is stored.
 */
export type IconRelativePath = {
    relativePath: string;
    componentName: string;
};
/**
 * Represents a notification popup that can be shown to the user.
 *
 * @see {@link INotificationApi.show}
 */
export type NotificationInfo = {
    /**
     * The title of the notification.
     */
    title: string;
    /**
     * The main message content of the notification.
     */
    message: string;
    /**
     * The optional duration in seconds that the popup will remain visible. If not provided, the notification will remain visible until the user closes it themselves.
     */
    displayDurationInSeconds?: number;
    /**
     * The optional icon for the notification. If specified, it is either an image encoded as data URL string,
     * or a path relative to the location where the given component is located. The component name should follow
     * the same conventions as UISpec in case of tabs and dialogs.
     */
    icon?: string | IconRelativePath;
};
