export type Menu = {
    /**
     * The display text of the menu.
     */
    caption: string;
    /**
     * This ID should be unique and not empty. When the menu gets clicked, the message 'menuItemActivated' with this menuId as data is sent back to the extension.
     */
    menuId: string;
    /**
     * If not provided, the menu is enabled by default. Its enabled state can be updated with the 'update' call.
     */
    enabled?: boolean;
    /**
     * If true, a separator will be placed under this menu in the UI.
     */
    hasSeparatorAfter?: boolean;
    /**
     * If true, a separator will be placed above this menu in the UI.
     */
    hasSeparatorBefore?: boolean;
    /**
     * The children menus of this menu. They can also be parents of other menus.
     */
    subMenus?: Menu[];
};
