/**
 * Dockable pane specific data required to register a dockable pane with Studio Pro.
 */
export type DockablePaneInfo = {
    /**
     * The title that should be displayed for your dockable pane.
     */
    title: string;
    /**
     * The initial position where your dockable pane should be hosted.
     */
    initialPosition: DockablePanePosition;
};
/**
 * A handle referring to a dockable pane instance registered with Studio Pro.
 */
export type DockablePaneHandle = {
    /**
     * The identifier Studio Pro uses to identify the dockable pane.
     */
    id: string;
};
/**
 * The initial position where a dockable pane can be hosted. Valid options are left, right and bottom.
 */
export type DockablePanePosition = "left" | "right" | "bottom";
