/**
 * Represents a dialog that can be shown to the user.
 *
 * @see {@link IDialogApi.showModal}
 */
export type DialogInfo = {
    /**
     * The title to show in the title bar of the dialog.
     */
    title: string;
    /**
     * The initial size of the dialog. This excludes the title bar and borders. Default is 640 by 480 pixels.
     */
    contentSize?: {
        width: number;
        height: number;
    };
};
/**
 * Represents state of a dialog.
 * This is used to update the dialog after it has been shown.
 *
 * @see {@link IDialogApi.update}
 */
export type DialogState = {
    /**
     * The width of the dialog. This excludes the title bar and borders.
     */
    width?: number;
    /**
     * The height of the dialog. This excludes the title bar and borders.
     */
    height?: number;
};
