/**
 * Specifies a piece of UI that can be shown in a tab, pane, dialog, etc.
 */
export type UISpec = {
    /**
     * The name of the component that contains the UI.
     */
    componentName: string;
    /**
     * The UI entry point name to look up in the component manifest.
     */
    uiEntrypoint: string;
    /**
     * An optional set of query string parameters to pass when opening the UI.
     */
    queryParams?: {
        [key: string]: string;
    };
};
