/**
 * Inspects the asset and returns it unchanged if it is data URL encoded. Else, it is considered
 * a path relative to the location where all the assets of the component are stored, and a request
 * will be made to fetch the asset and encode it in data URL format.
 * @param componentName the component for which we try to resolve the asset
 * @param asset either data URL string containg the asset or a path relative to the location of component
 * @returns data URL encoded asset, or undefined if it could not be resolved
 * (e.g. it is not found or StudioPro web server crashed)
 */
export declare function dataUrlEncodeAsset(componentName: string, asset: string): Promise<string | undefined>;
