import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
export type UserProfile = {
    userName: string;
    displayName: string;
    avatarUrl: string;
};
export type UserProfileResult = {
    result: "error";
} | {
    result: "userNotSignedIn";
} | {
    result: "success";
    profile: UserProfile;
};
export type UserAuthenticationEventMap = {
    signedIn: {};
    signedOut: {};
};
export interface IUserAuthenticationApi extends IComponentApi<UserAuthenticationEventMap> {
    readonly _apiId: "mendix.UserAuthentication";
    signIn(): Promise<boolean>;
    signOut(): Promise<void>;
    isSignedIn(): Promise<boolean>;
    getUserProfile(): Promise<UserProfileResult>;
}
export declare class UserAuthenticationApi extends BackendComponentApiBase<UserAuthenticationEventMap> implements IUserAuthenticationApi {
    get _apiId(): "mendix.UserAuthentication";
    private readonly signInHandler;
    private readonly isSignedInHandler;
    private readonly userProfileHandler;
    signIn(): Promise<boolean>;
    signOut(): Promise<void>;
    isSignedIn(): Promise<boolean>;
    getUserProfile(): Promise<UserProfileResult>;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
}
