import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { UISpec } from "../model/UISpec";
import { TabHandle, TabInfo } from "../model/tabs";
/**
 * API for working with (document) tabs in the working area of Studio Pro
 */
export interface ITabApi extends IComponentApi {
    _apiId: "mendix.TabApi";
    /**
     * Opens a new tab in the working area of Studio Pro.
     *
     * @param tabInfo Information about the tab to be opened
     * @param uiSpec UI specification of the UI to show inside the tab
     * @returns A handle to the tab that can be used to close it
     */
    open(tabInfo: TabInfo, uiSpec: UISpec): Promise<TabHandle>;
    /**
     * Closes the tab with the given handle.
     *
     * @param tabHandle The handle of the tab to be closed
     */
    close(tabHandle: TabHandle): Promise<void>;
}
export declare class TabApi extends BackendComponentApiBase implements ITabApi {
    get _apiId(): "mendix.TabApi";
    open(tabInfo: TabInfo, uiSpec: UISpec): Promise<TabHandle>;
    close(tabHandle: TabHandle): Promise<void>;
}
