import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
export interface IProjectChangesApi extends IComponentApi<ProjectApiEventMap> {
    _apiId: "mendix.ProjectChangesApi";
}
export declare class ProjectChangesApi extends BackendComponentApiBase<ProjectApiEventMap> implements IProjectChangesApi {
    get _apiId(): "mendix.ProjectChangesApi";
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
}
type WebModelSource = {
    type: "WebModel";
    contextId: string;
};
type UnspecifiedSource = {
    type: "Unspecified";
};
type UndoRedoSource = {
    type: "UndoRedo";
};
export type ChangeSource = UnspecifiedSource | UndoRedoSource | WebModelSource;
export type ProjectApiEventMap = {
    documentsChanged: {
        documentIds: string[];
        source: ChangeSource;
    };
    documentAdded: {
        documentId: string;
        documentQualifiedName?: string;
        addedByUser: boolean;
    };
    moduleAdded: {
        moduleId: string;
        moduleName: string;
    };
};
export {};
