import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { Preferences } from "../model/preferences";
/**
 * API for working with the user preferences.
 */
export interface IPreferencesApi extends IComponentApi {
    /**
     * Unique identifier for the Preferences API.
     */
    _apiId: "mendix.PreferencesApi";
    /**
     * Retrieves the preferences of Studio pro.
     *
     * @returns A promise that resolves with the retrieved preferences.
     */
    getPreferences(): Promise<Preferences>;
}
/**
 * API for showing the user preferences, e.g. theme and language.
 */
export declare class PreferencesApi extends BackendComponentApiBase implements IPreferencesApi {
    promise?: Promise<Preferences>;
    resolve?: (value: Preferences | PromiseLike<Preferences>) => void;
    get _apiId(): "mendix.PreferencesApi";
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
    getPreferences(): Promise<Preferences>;
}
