import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { NotificationInfo } from "../model/notificationInfo";
/**
 * API for showing notification popups
 */
export interface INotificationApi extends IComponentApi {
    _apiId: "mendix.NotificationApi";
    /**
     * Shows a notification popup with the given message which will disappear after the specified duration.
     *
     * @param notificationInfo A {@link NotificationInfo} object which contains the title and message of the notification.
     * It also contains an optional icon and an optional duration in seconds for how long the notification will be displayed.
     * If the duration is not provided, the notification will remain visible indefinitely.
     */
    show(notificationInfo: NotificationInfo): Promise<void>;
}
export declare class NotificationApi extends BackendComponentApiBase implements INotificationApi {
    get _apiId(): "mendix.NotificationApi";
    show(notificationInfo: NotificationInfo): Promise<void>;
    validateNotification(notificationInfo: NotificationInfo): Error | undefined;
}
