import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
/**
 * API for showing message boxes
 */
export interface IMessageBoxApi extends IComponentApi {
    _apiId: "mendix.MessageBoxApi";
    /**
     * Shows a message box with the given type, message and optional details.
     *
     * @param type The type of message box. One of "info", "warning" or "error".
     * @param message The message to show in the message box.
     * @param details The optional details to show in the message box.
     * @returns A promise that resolves when the message box is closed.
     */
    show(type: "info" | "warning" | "error", message: string, details?: string): Promise<void>;
}
export declare class MessageBoxApi extends BackendComponentApiBase implements IMessageBoxApi {
    get _apiId(): "mendix.MessageBoxApi";
    private openDialogs;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
    show(type: "info" | "warning" | "error", message: string, details?: string | undefined): Promise<void>;
}
