import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { MessageBus } from "@mendix/wef-transportation";
import { Menu } from "../model/menu";
import { ExtensionsMenuValidator } from "./utils/ExtensionsMenuValidator";
/**
 * API for working with the Extensions menu in Studio Pro.
 */
export interface IExtensionsMenuApi extends IComponentApi<ExtensionsMenuApiEventMap> {
    _apiId: "mendix.ExtensionsMenuApi";
    /**
     * Adds a menu item to the Extensions menu in the main menu bar of Studio Pro.
     *
     * @param menuItem The menu item to add.
     */
    add(menuItem: Menu): Promise<void>;
    /**
     * Updates a menu item in the Extensions menu in the main menu bar of Studio Pro.
     *
     * @param menuId The ID of the menu to be updated.
     * @param state The menu item state to update (caption and/or enabled).
     */
    update(menuId: string, state: {
        caption?: string;
        enabled?: boolean;
    }): Promise<void>;
}
/**
 * The menu api allows extensions to start listening to the events this event map provides.
 */
export type ExtensionsMenuApiEventMap = {
    /**
     * This event will trigger when a menu gets activated, passing the menu ID as data.
     */
    menuItemActivated: {
        menuId: string;
    };
};
export declare class ExtensionsMenuApi extends BackendComponentApiBase<ExtensionsMenuApiEventMap> implements IExtensionsMenuApi {
    private readonly menuValidator;
    _menuValidator: ExtensionsMenuValidator;
    get _apiId(): "mendix.ExtensionsMenuApi";
    constructor(menuValidator: ExtensionsMenuValidator, messageBus: MessageBus);
    update(menuId: string, state: {
        caption?: string;
        enabled?: boolean;
    }): Promise<void>;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
    add(menuItem: Menu): Promise<void>;
}
