import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
export type ActiveDocumentInfo = {
    /** The ID of the active document */
    documentId: string;
    /**
     * The SDK type of the active document, if applicable
     * @example Microflows$Microflow
     */
    documentType: string | null;
    /**
     * The name of the active document, if it has one.
     */
    documentName: string | null;
    /**
     * The name of the module containing the active document.
     * Can be `null` for app document editors (e.g. system texts).
     */
    moduleName: string | null;
};
export type EditorApiEventMap = {
    /**
     * Raised when the user switches to another document editor.
     *
     * The value will be `null` when the user closes the last editor inside the working area of Studio Pro.
     */
    activeDocumentChanged: {
        info: ActiveDocumentInfo | null;
    };
};
export interface IEditorApi extends IComponentApi<EditorApiEventMap> {
    _apiId: "mendix.EditorApi";
    /**
     * Gets the ID of the document the user is currently editing, or `null` if no document is currently opened.
     */
    getActiveDocument(): Promise<ActiveDocumentInfo | null>;
    /**
     * Opens the editor for the document with the given ID in the working area of Studio Pro.
     *
     * @param documentId the ID of the document that should be edited.
     */
    editDocument(documentId: string): Promise<void>;
}
export declare class EditorApi extends BackendComponentApiBase<EditorApiEventMap> implements IEditorApi {
    get _apiId(): "mendix.EditorApi";
    private cachedActiveDocumentInfo;
    private activeDocumentHandler;
    getActiveDocument(): Promise<ActiveDocumentInfo | null>;
    editDocument(documentId: string): Promise<void>;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
}
