import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { UISpec } from "../model/UISpec";
import { DockablePaneHandle, DockablePaneInfo } from "../model/dockablePane";
/**
 * API for working with dockable panes in Studio Pro.
 */
export interface IDockablePaneApi extends IComponentApi {
    _apiId: "mendix.DockablePaneApi";
    /**
     * Opens a dockable pane by passing a pane handle received from the register method.
     *
     * @param handle a handle to the pane that was registered.
     */
    open(handle: DockablePaneHandle): Promise<void>;
    /**
     * Closes a dockable pane by passing a pane handle received from the register method.
     *
     * @param handle a handle to the pane that was registered.
     */
    close(handle: DockablePaneHandle): Promise<void>;
    /**
     * Registers a new dockable pane with Studio Pro.
     *
     * @param paneInfo information like title and initial position required by Studio Pro
     * to register the pane
     * @param uiSpec UI specification of the UI to show inside the pane
     * @returns a pane handle which can be used to interact with the pane
     * via {@link IDockablePaneApi.open} and {@link IDockablePaneApi.close} methods
     */
    register(paneInfo: DockablePaneInfo, uiSpec: UISpec): Promise<DockablePaneHandle>;
}
export declare class DockablePaneApi extends BackendComponentApiBase implements IDockablePaneApi {
    get _apiId(): "mendix.DockablePaneApi";
    open(handle: DockablePaneHandle): Promise<void>;
    close(handle: DockablePaneHandle): Promise<void>;
    register(paneInfo: DockablePaneInfo, uiSpec: UISpec): Promise<DockablePaneHandle>;
}
